Program SConcat;

{ Version: V3.2
  File:[22,310]SCONSAT.PAS
  Author: Jim Bostwick 29-Aug-83

  Last Edit:  23-JUN-1988 22:24:48 

  History: 
	 23-JUN-1988 21:58:35  - JMB PA3UTL upgrade.
  	 23-Nov-83 JMB -- back to null fill
	 21-Nov-83 JMB -- convert to blank fill, fix up for type "1" output

Component module of the Pascal-3 String Package. 

        ***NOTE***
 This software is in part copyrighted by OMSI. Distribution 
only to lisenced OMSI Pascal sites. 

}
 {$NOMAIN}
 {[A+,B+,L-,K+,R+] Pasmat Directive }

 %INCLUDE 'PAS$EXT:SLEN.EXT';

  PROCEDURE SConcat(VAR t: PACKED ARRAY [tlow..thigh: integer] OF CHAR;
                      s: packed array [slow..shigh: integer] OF CHAR
  	);External;
  	
{*USER*
  	-- String Package Module --
 Concatenate s and t. String S is appended to string T, with the result
in T, truncated if necessary to the max size of T. 
}

  Procedure Sconcat;

  var
    i, sl, tl: INTEGER;


  BEGIN {concatenate}
      sl := slen(s);
      tl := slen(t);
      if sl + tl > thigh then sl := thigh - tl;
      if sl > 0 then
        begin
        if tlow = 0 then t[0] := chr(sl + tl);
        for i := 1 to sl do t[i + tl] := s[i];
        end
  end {concatenate} ;

