PROGRAM CKDTAD;
{$nomain}
{$nowalkback}

{ File: [22,310]CKDTAD.PAS       Last Edit: 8-DEC-1988 16:04:04 

  History:  8-Dec-88.  Philip Hannay.  Created.
}


%include lb:[22,320]general3.typ;
%include ex:[22,320]c2date.ext;

Procedure CKDTAD( K_date: clunk_type;      { 64bit clunk date/time }
                  var A_date:PACKED ARRAY[Lo..Hi:integer] OF char
		                 { 9 char DEC style date DD-MMM-YY }
                ); external;


{*USER*

.hl 2 CNDTAD - Convert Clunk Date To Ascii Date/Time stamp

The CNDTAD routine will convert a numeric (3 integer) date into a DEC
format ascii date/time (DD-MMM-YYYYbHH:MM:SS).  
The date/time stamp will be appended to the A_DATE string.

}

{*TECH*

The MMM (month) portion of the ascii date will consist of a capitalized
first letter and a lower case second and third letter (ie. May, Feb).  This
conforms to the DEC practice in RSX and DTR.

Single digit days will be preceded with a zero (ie. 06-May-87).  DEC
date conversion routines suppress the zero and shift the date string left
one character, however the DTR date conversion routines
like the leading zero.  So we went with the
DTR convention.

Years will be the four digit year.

The ascii date variable A_date will conform to either type 0 or type 1
Cargill/Pascal-2 string conventions depending on how it was specified in 
the calling routine.  If the date is valid, all 9 characters will be
non-null.  If the date is invalid, all 9 characters will be null.

}

PROCEDURE CKDTAD;

Var
 ascii_date: DEC_date;
 ascii_time: DEC_time;
 status: integer; 

Begin
c2date(C_date,ascii_date,ascii_time,status);
sappend(A_date,ascii_date);
schconcat(A_date,' ');
sappend(A_date,ascii_time);
end;

