PROGRAM CBCTWO;
 {$nomain}

{ 
  File:[22,310]CBCTWO.PAS
  Author: Jim Bostwick 19-Oct-83 P2 

  Last Edit: 23-JUN-1988 22:10:46 

  History: JMB 16-Nov-83 -- correct digit order
	 23-JUN-1988 21:55:53  - JMB PA3UTL upgrade.

}

 {$NOLIST}
 {[a+,b+,l-,k+,r+] Pasmat }
 %INCLUDE 'PAS$EXT:General.typ';
%INCLUDE  'PAS$EXT:BCD.TYP';
 %INCLUDE 'PAS$EXT:Error.ext';
 {$LIST}

{----------------- Convert BCD to word ------------------------------}

  PROCEDURE CBCTWO(VAR B: PACKED ARRAY [lo..hi: integer] OF BCD_Digit;
                   VAR Bin: Word
    );EXTERNAL;

{*USER*
 Pascal-3 procedure which converts an input string of BCD digits
to an unsigned binary word. Converted word must fit in a 16-bit
word, or a run-time error will be declared, and zero returned. 
}


  PROCEDURE CBCTWO;

    LABEL
      999; { used for premature exit on error }

    const
      Debug = false;
      Maxmult = 10000; 

    VAR
      Index: integer;
      Dig, Mult: Word;

    BEGIN
      {Initialize some stuff.}
      Bin := 0;

      {do the conversion}
      mult := 1;
      index := lo;
      WHILE (Index <= hi) DO
        BEGIN
        DIG := mult * b[index];
  	index := index + 1;
        mult := mult * 10;
        if debug then
	  writeln('next index =',index,' next mult =', mult, ' this digit=',
	  	dig, ' bin=', bin);
        IF ((index < lo) and  (mult > maxmult)) 
  	    OR ((65535 - DIG) < BIN) THEN
          BEGIN
          error(5, warning_err, 'CBCTWO -- Conversion Overflow', dig);
          GOTO 999 {force termination rather than overflow}
          END;
        Bin := Bin + DIG;
        END;
    999:
    END;
