.;  File: BUILDTSK.CMD      Last Edit: 7-AUG-1989 14:18:47 
.;
.;  History:
.;
.;     5-May-86.  Philip Hannay.  Created.
.;
.;     22-Sep-86.  Philip Hannay.  Added code to run under DCL.
.;
.;     24-Jan-87.  Philip Hannay.  Modified so that if no MOD file found,
.;       just build main object module and leave object behind.  This will
.;       permit us to to build a program that uses another programs library.
.;
.;     11-Mar-87.  Philip Hannay.  Enhanced to handle compilation and
.;       building of CRISP logic programs.
.;
.;     21-Jul-87.  Philip Hannay.  Fixed EPT/MNT numbers in LBR command
.;       (they had been reversed), changed defaults to multiples of
.;       64 (we said 50, but they were being rounded up), and added
.;       help function.
.;
.;     20-Aug-87.  Philip Hannay.  Fixed purging of source files when 
.;       compiling single source file and compile is successful - source
.;       file is now purged.  Also purge of TKB after successful or warning
.;       taskbuild.
.;
.;     21-Aug-87.  Philip Hannay.  Added test for assembler command file
.;       srcfilename.ASM when doing a macro assembly.  If found, we use
.;       the ASM file to do the assembly.  Added ONERR processing to make
.;       sure log file closed (so not locked) and CLI restored.
.;
.;     30-Nov-87.  Philip Hannay.  Fixed bug caused by CRP enhancement when
.;       building multimodule (library) program, also detect of log file
.;       open failure.  (8-Apr-87 Bergen mods)
.;
.;     16-May-87.  Philip Hannay.  Fixed bug where we tried to alter value
.;       of <exstat> special symbol.  RSX V3.0 ignored .setn, V4.0 gave
.;       syntax error.  Also BUILDTSK no longer purges source files 
.;       include TKB and ODL files, leaving it up to programmer to 
.;       purge sources when appropriate.  PA3 default changed from LIST
.;       to ERROR to shorten listing to minimum.
.;
.;     9-Nov-88. Bob Thomas. Provided for a /DEBUG switch to be applied 
.;       to the file name which results in a fortran compile with the
.;	 /DE switch on.
.; 
.;    20-Jun-89.  Philip Hannay.  Made all PASCAL 2.1 (PA3) builds to
.;       use the DOUBLE switch for double precision reals.  And fixed
.;       CRISP (CRP) build to search for, and if found, build all
.;       CRP sources from xxxx00 thru xxxx07.
.;
.;     7-Aug-89.  Philip Hannay.  Added check for xxxxOV.TKB file, skips
.;       the TKB if file not found.

.enable substitution

.; See if HELP is being solicited

.if p1 eq "?" .goto help
.if p1 eq "/HE" .goto help

.; normal run
.goto nohelp

.help:
;
;
;  @BUILDTSK is a generic task build command file that will rebuild a task
;  from scratch.  It will delete any existing object library for the 
;  task and create an empty object file library, and populate
;  that library using BUILDLBR command file, and then task build the task
;  against the newly populated library.  The library build is controlled
;  by a modulator file taskname.MOD that states the name of the library
;  and the modules that make up that library.  (For info on MOD file
;  syntax, see @BUILDLBR ? help).  
;
;  IF A MOD FILE IS NOT SPECIFIED, this implies that there is ONLY ONE 
;  module, and thus a library is not needed.  In this case, a search of
;  the default directory is made for a source file that matches the 
;  task name (jobnam) supplied.  It is then compiled, and the OBJ file
;  left behind for the taskbuild to use.
;
;  The following source files are recognized.  When no MOD file is
;  specified, the search of the default directory for the specified source
;  file occurs in the order that the source files are listed.
;
;  .SRC - Pascal-1
;  .PAS - Pascal-2
;  .FTN - current FORTRAN compiler invoked by MCR command FOR
;  .MAC - Macro-11
;  .CRP - CRISP-11
;
;  If all source files compile successfully (no errors or warnings), then a 
;  taskbuild will be attempted.  BUILDTSK will first look for a taskbuild 
;  command file called taskname.TKB, and if not found, tasknameOV.TKB.  The 
;  TKB file will then be given to TKB for the taskbuild.  The tasknameOV.TKB
;  taskbuild file is our conventional name (adding the OV suffix) for
;  a taskbuild command file that will invoke an overlay (ODL) file, while
;  the taskname.TKB file does not use an ODL file.
;
;  In all cases, a log file taskname.LOG is kept showing starting and
;  ending times, module compilation status, library insertion status,
;  and task build status.  If a log file already exists, the log info will
;  be appended to that existing log file.
;
;  Automatic cleanup and purging will be done as successful compilation and
;  taskbuilding is done.  Anytime an error occurs, the purging will not be
;  done, and the listing files needed for diagnosing the error will be
;  left behind.
;
;  The command file will accept parameters, or if none, will prompt for
;  the parameters.  The following parameters will be used.  They are 
;  normal command file parameters - so they are separated by a space 
;  AND NOT separated by commas.
;
;  <jobnam>  = Name of task to build.  Command file will look for one of the
;              following files: <jobnam>.MOD, <jobnam>.SRC, <jobnam>.PAS,
;              <jobnam>.FTN, <jobnam>.MAC, <jobnam>.CRP, to control compilation
;              and creation of library (OLB) or single object module (OBJ)
;              It will then look for one of the following files:  <jobnam>.TKB
;              or <jobnam>OV.TKB, to control the task building.
;
;	       The task name can be followed with a /DEBUG switch which 
; 	       results in Fortran compiles with the /DE switch added.
;	       ( <jobnam>/DEBUG )
;
;  <libsiz>  = Number of decimal blocks to allocate for the object
;              library.  The default will be 30.
;
;  <modnum>  = Number of object modules that will be placed in the 
;              library.  The defualt will be 64.  This number will also
;              determine the number of entry points allowed, which will
;              be twice <modnum>.
;
;
;  The command file can be invoked with the command line
;    @BUILDTSK <jobnam> <libsiz> <modnum>.
;  
;  If no parameters are present, the user will be prompted for the
;  values.  If <jobnam> is the only parameter specified, the defaults
;  of 30. and 64. will be used for <libsiz> and <modnum>.
;
;  HELP is available by using the parameter "?" or "/HE".  The above is
;  the HELP text.  Remember that invoking the command file without parameters
;  will ask you for each option with explanations.
;
.goto 990

.nohelp:

.; See if we are running in DCL
.;
.sets curcli <cli>
.if curcli ne "MCR" mcr set /cli=ti:mcr
.;

.setf badend
.; Badend will signal if an error occurred so that we can exit with the
.; appropriate error status, in case we are being called by another
.; indirect command file.
.;
.setf fatend
.; Fatend will signal if a fatal error (detected by .onerr) has occurred.
.;
.onerr 910
.; If a fatal indirect error detected, go to 910 for cleanup


.; check for parameter 1
.;
.test p1
.if <strlen> eq 0 .goto norem
.;
.; parameter 1 supplied, it is the task name to build.
.sets jobnam p1
.;
.; check for parameter 2
.;
.test p2
.if <strlen> eq 0 .goto nop2
.; 
.; parameter 2 supplied, use it for library block size (decimal)
.;
.setn libsiz 'p2'.
.goto donep2
.;
.nop2:
.;
.; parameter 2 not supplied, use defualt of 30.
.;
.setn libsiz 30.
.;
.donep2:
.;
.; check for parameter 3 which is number of modules allowed in library
.;   and half the number of entry points (calls) allowed.
.;
.test p3
.if <strlen> eq 0 .goto nop3
.;
.; parameter 3 supplied, use it for module number and entry point number
.;
.setn modnum 'p3'.
.setn entnum modnum*2
.goto donep3
.;
.nop3:
.;
.; parameter 3 not supplied, use default of 64.
.;
.setn modnum 64.
.setn entnum modnum*2
.;
.donep3:
.;
.;
.; All variables initialized, onward to actual processing
.;
.goto dolib
.;
.;
.norem:
.;
.; No parameters supplied.  Prompt operator for particulars.
.;
; 
; This command file will create a new object library, compile all modules
;   and place the resulting objects in the library, and then task build the
;   job.  You may abort this command file at any time.  It is restartable.
;
; You need to specify the name of the task to build.  This name will also
;   determine the name of the MOD file used by BUILDLBR to compile the
;   the tasks and the name of the TKB file used by TKB to task build the
;   task.  Enter just the name if you are running in the UFD where the
;   modules and control files are, or the disk and UFD prefixes if you
;   are not.  Like "BOOKGW" or "[115,305]BOOKGW" or "TB:[115,305]BOOKGW".
;
;
.asks jobnam name of task to build 
.;
; 
; Now you need to specify the size of the library where the object 
; modules will be placed.  It is the decimal size.  If you are not sure
; use the default.
;
.askn [::30.] libsiz size of object library
.;
;
; Now you need to specify the maximum number of object modules that will
; be placed in that library.  It is the decimal number.  If you are not
; sure, use the default.  This number will also determine the maximum
; number of entry points allowed.  That number will be twice the max
; number of object module.  (Entry points are "procedure" or "subroutine"
; headings - ususally only one per module, but sometimes more.)
;
.askn [::64.] modnum maximum number of object modules in library
.setn entnum modnum*2
.;
.; 
.dolib:
.;
.; parameters are in, ready to build library
.;
.; First parse any switches from the end of the file name
.Parse jobnam "/" jobnam switch
.;
.; Define a variable "DEBUG" and set it true if the /DEBUG switch is present
.setf debug
.if switch eq "DEBUG" .sett debug
.if switch eq "Debug" .sett debug
.if switch eq "debug" .sett debug
.;
.setf badend
.; Badend will signal if an error occurred so that we can exit with the
.; appropriate error status, in case we are being called by another
.; indirect command file.
.;
.; We log all notes of success and errors to a log file bearing the
.; name <jobnam>.  Note we use append so that others may use it before
.; us and their notes will be preserved.  It will be up to the operator
.; to decide when to delete the accumulated log notes.  Log will also be
.; used by BUILDLBR command file for its notes.
.;
.opena 'jobnam'.log
.if <filerr> ne 1 .goto 920
.;
.;
.data           
.data 'jobnam' compile and build execution starting '<date>' '<time>'
.data    
;
; 'jobnam' compile and build execution starting '<date>' '<time>'
;
.sets ext ""
.sets crpnam ""
.; See if a MOD file exists
.testfile 'jobnam'.mod
.if <filerr> eq 1 .goto dobld
.; No MOD file, no need to build libary, just compile main program and
.; task build.  Look for source file in this order: SRC PAS FTN MAC CRP.
.;
.;
.sets fnam jobnam
.sets ext "SRC"
.testfile 'fnam'.'ext'
.if <filerr> eq 1 .goto mainok
.sets ext "PAS"
.testfile 'fnam'.'ext'
.if <filerr> eq 1 .goto mainok
.sets ext "FTN"
.testfile 'fnam'.'ext'
.if <filerr> eq 1 .goto mainok
.sets ext "MAC"
.testfile 'fnam'.'ext'
.if <filerr> eq 1 .goto mainok
.sets ext "CRP"
.testfile 'fnam'.'ext'
.if <filerr> eq 1 .goto mainok
;
; Error - could not find source file for main routine 'jobnam'
; Looked under 'jobnam'.SRC,'jobnam'.PAS,'jobnam'.FTN,'jobnam'.MAC
;   and 'jobnam'.CRP
;
.data  
.data Error - could not find source file for main routine 'jobnam'
.data Looked under 'jobnam'.SRC,'jobnam'.PAS,'jobnam'.FTN,'jobnam'.MAC,
.data   and 'jobnam'.CRP
.data  
.sett badend
.goto tkdone
.;
.;
.mainok:
.; Main source file found, now compile or assemble it
.;
.sets fspec fnam+"."+ext
.if ext eq "MAC" .goto domac
.if ext eq "SRC" .goto doslp
.if ext eq "PAS" .goto dopas
.if ext eq "FTN" .goto dofor
.if ext eq "CRP" .goto docrp
; logic error 1
.stop
.;
.doslp:
.openr #2 'fspec'
.read #2 outfil
.sets curjob "SRC output name"
.ift <eof> .goto fubar
.close #2
.parse outfil "." tst tst1
.sets ext tst1[1:3]
.if ext eq "PAS" .goto slpgo
.if ext eq "MAC" .goto slpgo
.if ext eq "pas" .goto slpgo
.if ext eq "mac" .goto slpgo
.data        <Illegal Filespec in SLP file <'tst'.'ext'> -- skipped.>
;Illegal Filespec in SLP file <'tst'.'ext'> -- skipped.
.goto fubar
.;
.slpgo:
slp @'fspec'
.sets curjob "SLP utility"
.if <exstat> ne 1 .goto fubar
.if ext eq "PAS" .goto dopa1
.if ext eq "MAC" .goto domac
.if ext eq "pas" .goto dopa1
.if ext eq "mac" .goto domac
.;
.dopa1:
.sets curjob "PA1 compiler"
pa1 'fnam','fnam'='fnam'/s
.if <exstat> ne 1 .goto fubar
.sets curjob "MAC assemblor"
pip 'fnam'.pas;*,.lst;*/de
mac 'fnam','fnam'/-sp='fnam'
.if <exstat> ne 1 .goto fubar
pip 'fnam'.mac;*/de
.goto cmdone
.;
.dopas:
pa3 'fnam'/error/nowalkback/double
.sets curjob "PA3 compiler"
.if <exstat> eq 1 .goto cmdone
.goto fubar
.;
.docrp:
.test jobnam
.setn len <strlen>
.dec len 
.dec len
.if len gt 0 .goto crpok
;
; Bad name 'jobnam', cannot do CRP (CRISP) task build 
;
.goto fubar
.crpok:
.sets crpnam jobnam[1:'len']
.;
crp 'fnam'='fnam'.crp
.sets curjob "CRP (CRISP) compiler"
.if <exstat> ne 1 .goto fubar
.;
.testfile 'crpnam'01.crp
.if <filerr> eq 1 crp 'crpnam'01='crpnam'01.crp
.if <exstat> ne 1 .goto fubar
.;
.testfile 'crpnam'02.crp
.if <filerr> eq 1 crp 'crpnam'02='crpnam'02.crp
.if <exstat> ne 1 .goto fubar
.;
.testfile 'crpnam'03.crp
.if <filerr> eq 1 crp 'crpnam'03='crpnam'03.crp
.if <exstat> ne 1 .goto fubar
.;
.testfile 'crpnam'04.crp
.if <filerr> eq 1 crp 'crpnam'04='crpnam'04.crp
.if <exstat> ne 1 .goto fubar
.;
.testfile 'crpnam'05.crp
.if <filerr> eq 1 crp 'crpnam'05='crpnam'05.crp
.if <exstat> ne 1 .goto fubar
.;
.testfile 'crpnam'06.crp
.if <filerr> eq 1 crp 'crpnam'06='crpnam'06.crp
.if <exstat> ne 1 .goto fubar
.;
.testfile 'crpnam'07.crp
.if <filerr> eq 1 crp 'crpnam'07='crpnam'07.crp
.if <exstat> eq 1 .goto cmdone
.goto fubar
.;
.dofor:
.iff debug for 'fnam','fnam'/-sp='fnam'
.ift debug for 'fnam','fnam'/-sp='fnam'/DE
.sets curjob "FOR compiler"
.if <exstat> eq 1 .goto cmdone
.if <exstat> eq 0 .goto warn
.goto fubar

.domac:
.;
.; Determine what device/ufd prefix to use.  Since we may need Pasmac from
.; the library to precede the marco source, we must explicitly state
.; the device and ufd.  The question is whether it has already been 
.; stated in the input file (FNAM) or whether we must create it here.
.sets dum1 ""
.sets dum2 ""
.sets dum3 ""
.sets dum4 ""
.sets prefix ""
.parse fnam "]" dum1 dum2
.parse fnam ":" dum3 dum4
.if dum2 eq "" .goto 30
.if dum4 eq "" .sets prefix "SY:"
.goto 31
.30:
.; 
.; The default UIC is either in <DIRECT> (named) or <UIC> (nonamed).
.; We must first check <DIRECT> and if null ([]), then use <UIC>.
.sets defuic <DIRECT>
.if defuic eq "[]" .sets defuic <UIC>
.if dum4 eq "" .sets prefix "SY:"+defuic
.if dum4 eq "" .goto 31
.sets fnam dum3+":"+defuic+dum4
.31:
.;
.; First off, see if a 'FNAM'.ASM file exists.  The ASM file will have
.; special macro assembly instructions if need be.
.testfile 'fnam'.asm
.if <filerr> ne 1 .goto 33
.sets curjob "MAC assembler using 'FNAM'.ASM"
mac @'fnam'.asm
.if <exstat> eq 1 .goto cmdone
.goto fubar
.;
.33:
.; See if PASMAC macro defn file exists on system.
.sets prefil ""
.testfile LB:[22,310]PASMAC.MAC
.if <filerr> ne 1 .goto 32
.sets prefil "lb:[22,310]pasmac,"
.32:
.;
mac 'fnam','fnam'/-sp='prefil''prefix''fnam'
.sets curjob "MAC assembler"
.if <exstat> eq 1 .goto cmdone
.goto fubar
.;
.warn:
.; Warning encountered, log it and continue on.
.;
.data     <'FNAM'.'EXT' note  -- warning in 'CURJOB'>
; Warning -- <'FSPEC'> (in 'CURJOB') -- object still created.
.goto cmdone
.;
.cmdone:
.; compile or assemble was okay
.data     <'FNAM'.OBJ created from 'FSPEC' using 'CURJOB'>
;  <'FNAM'.OBJ created from 'FSPEC' using 'CURJOB'>
.if ext ne "CRP" pip 'fnam'.lst;*/de
.if ext eq "CRP" pip 'fnam'.lst/pu
.if ext eq "CRP" pip 'crpnam'01.lst/pu/nm
.if ext eq "CRP" pip 'crpnam'02.lst/pu/nm
.if ext eq "CRP" pip 'crpnam'03.lst/pu/nm
.if ext eq "CRP" pip 'crpnam'04.lst/pu/nm
.if ext eq "CRP" pip 'crpnam'05.lst/pu/nm
.if ext eq "CRP" pip 'crpnam'06.lst/pu/nm
.if ext eq "CRP" pip 'crpnam'07.lst/pu/nm
pip 'fnam'.obj/pu
.if ext eq "CRP" pip 'fnam'.sym,.seg/pu
.if ext eq "CRP" pip 'crpnam'01.sym,.seg,.obj/pu/nm
.if ext eq "CRP" pip 'crpnam'02.sym,.seg,.obj/pu/nm
.if ext eq "CRP" pip 'crpnam'03.sym,.seg,.obj/pu/nm
.if ext eq "CRP" pip 'crpnam'04.sym,.seg,.obj/pu/nm
.if ext eq "CRP" pip 'crpnam'05.sym,.seg,.obj/pu/nm
.if ext eq "CRP" pip 'crpnam'06.sym,.seg,.obj/pu/nm
.if ext eq "CRP" pip 'crpnam'07.sym,.seg,.obj/pu/nm
.goto dotkb
.;
.fubar:
.; Error encountered, set ERRFND true to signal that we had some trouble.  We
.; continue on though.  If we are not in remote or no input mode, then we can
.; ask directly for what to do.
.;
.sett errfnd
pip 'fnam'.obj;*/de/nm
.data        <'FSPEC' skipped -- error in 'CURJOB'>
; Error in <'FSPEC'> (in 'CURJOB') -- module not updated.
.sett badend
.goto notkb
.;
.dobld:
.; MOD file present, build a new library
.; 
.; delete the existing library, replace it with an empty one
.;
pip 'jobnam'.olb;*/de/nm
lbr 'jobnam'.olb/cr:'libsiz'.:'entnum'.:'modnum'.:obj
.if <exstat> ne 1 .goto badlib
.;
.; library created okay
.data   'jobnam' empty library created with 'libsiz' blocks and 
.data      'modnum' max object modules and 'entnum' max entry points
;
;   'jobnam' empty library created with 'libsiz' blocks and 
;      'modnum' max object modules and 'entnum' max entry points
;
.goto lbdone
.;
.badlib:
.;
.; We failed to create an empty library.  Can't do anything else but 
.;  end.
.;
.data   Failed to create 'jobnam' library, cannot go on
;
;   Failed to create 'jobnam' library, cannot go on
;
.sett badend
.goto tkdone
.;
.;
.lbdone:
.;
.close
.;
.; Now we compile the modules listed in <jobnam>.MOD and put the object
.;   files in the library.  Note that we closed the log file since it
.;   will be used by Buildlbr.  We specify that the build attempt is to
.;   end if we encounter 5 or more errors.
.;
@buildlbr 'jobnam''switch' x5
.;
.; Reopen the log file.  Buildlbr will have an exit status of 1 if all
.;   compiles went okay.  It will be 2 or 4 if they did not.  If all compiles
.;   went okay, then we can taskbuild.  Otherwise, skip the task build.
.;
.opena 'jobnam'.log
.if <filerr> ne 1 .goto 920
.if <exstat> ne 1 .goto notkb
.;
.dotkb:
.; Compiles were okay, we can taskbuild.  We look first for a normal 
.;   TKB file <jobnam>.TKB.  If it is not found we then use the overlay
.;   TKB file <jobnam>OV.TKB.  If EXT is "CRP", we use invoke @xxxx.cmd
.;   where xxxx is everything in JOBNAM minus trailing two digits.
.;
.if ext ne "CRP" .goto normtk
.;
.; CRISP task build
.;
.; close log file while in @crpnam command file
.close
@'crpnam'
.opena 'jobnam'.log
.if <filerr> ne 1 .goto 920
.goto endtkb
.;
.normtk:
.testfile 'jobnam'.TKB
.if <filerr> eq 1 .goto noovr
.;
.; check for overlaid task build file
.testfile 'jobnam'OV.TKB
.if <filerr> eq	1 .goto doovr
.;
.; No TKB file found, try a vanilla taskbuild
.data   Task build using vanilla taskbuild '<date>' '<time>'
;
;   Task build using vanilla taskbuild '<date>' '<time>'
;
tkb 'jobnam'/cp,'jobnam'/-sp='jobnam'
.goto endtkb
.;
.;
.doovr:
.data   Task build using 'jobnam'OV.TKB '<date>' '<time>'
;
;   Task build using 'jobnam'OV.TKB '<date>' '<time>'
;
tkb @'jobnam'ov.tkb
.goto endtkb
.;
.noovr:
.;
.; Normal task build.
.;
.data   Task build using 'jobnam'.TKB '<date>' '<time>'
;
;   Task build using 'jobnam'.TKB '<date>' '<time>'
;
tkb @'jobnam'.tkb
.;

.endtkb:
.if <exstat> gt 2 .goto tkbbad
.;
.; Task build was successful (1) or just had warnings (2).  If there were
.; warnings, its up to the operator to determine if they are acceptable.
.; In any case, we have a new task image and map, and can get rid of the
.; old ones.
.;
.if <exstat> eq 1 .goto tkokay
.;
.; Warning during TKB, log it.
.;
.data   Task build complete, issued warnings '<date>' '<time>'
;
;  Task build complete, issued warnings '<date>' '<time>'
;
pip 'jobnam'.tsk,.map/pu/nm
.goto tkdone
.;
.tkokay:
.;
.; no warnings issued
.;
.data   Task build complete, no errors  '<date>' '<time>'
;
;  Task build complete, no errors '<date>' '<time>'
;
pip 'jobnam'.tsk,.map/pu/nm
.;
.goto tkdone
.;
.;
.tkbbad:
.; The task build failed.  Note this in log and on screen.
.;
.data   Task build failed, fatal errors '<date>' '<time>' 
;
;   Task build failed, fatal errors '<date>' '<time>'
;
.sett badend
.goto tkdone
.;
.;
.notkb:
.;  One or more of the modules failed, so we will not do the taskbuild.
.;
.data   Task build not done due to previous errors '<date>' '<time>'
;
;   Task build not done due to previous errors '<date>' '<time>'
;
.sett badend
.goto tkdone
.;
.;
.tkdone:
.;
.; Done with the compile and build.  Note this and close the log file.
.;
.data           
.data End 'jobnam' compile and build '<date>' '<time>'
.data     
;
;  End 'jobnam' compile and build '<date>' '<time>'
;
.close
.;
.goto 950

.910:
.; fatal error trap - attempt to close log file if open (to prevent it
.; from being locked, and reset CLI
;
; exiting abnormally - fatal indirect error - to see message, comment
; out ".onerr 910" line
;
.onerr 950
.sett fatend
.close
.goto 950

.920:
;
; 
; Cannot open log file 'jobnam'.LOG.  Cannot continue.
;
.sett badend
.goto 950

.950:
.; If BADEND is true, we had some sort of non-fatal error, we exit 
.; with a 2, indicating a partial failure (warning).  If we had a 
.; fatal error, FATEND will be true, and we will exit with a 4, 
.; indicating a fatal error.
.;
.; Set back CLI to starting CLI if it was not MCR
.;
.if curcli ne "MCR" set /cli=ti:'curcli'
.;
.ift fatend .exit 4
.ift badend .exit 2
.990:
.exit 1
