#ifdef DOCUMENTATION

title	stdnet	network io vector
index	stdnet	network io vector

synopsis
	.s.nf
	  _#include <stdnet.h>
	.s.f
description

	Network IO vector for use with network task to task
	functions using the nututl functions.
	.s
	It is defined as:
	.s.nf
	    typedef struct niov {
	    	int iosb[2];		/* io status block */
	    	int lun;		/* lun for this link */
	    	int efn;		/* efn for this link */
	    	char rem_nam[8];	/* remote node name */
	    	char rem_task[18];	/* remote task name */
	    	int type;		/* remote object type */
	    	int status;		/* status of link */
	    } NIOV;
	.s.f
	The iosb is first so that ast routines can assume
	the iosb address popped of the stack is the niov
	address.
	.s
	The rem_nam and rem_task arguments are filled in by
	the acc_net() or con_net() functions. For objects types
	other than 0, the rem_task argument is left empty.
	.s
	Also defined are:

	Connect blocks for use by con_net() and acc_net(). The 
	structure definitions are only required if you need to
	setup or read access information, etc.

	Structure definitions used by the AP remote file access
	routines.
bugs

author
	Hans J. Jung - March 1, 1985

#endif

/*
 * flag bits defined in status 
 */

#define LINKUP	0000001		/* connected to remote task */
#define RMTDSC	0000002		/* remote task disconnected */
#define NETREJ	0000004		/* network rejected link */

typedef struct niov {
	int iosb[2];		/* io status block */
	int lun;		/* lun for this link */
	int efn;		/* efn for this link */
	char rem_nam[8];	/* remote node name */
	char rem_task[18];	/* remote task name */
	int type;		/* remote object type */
	int status;		/* status of link */
} NIOV;

/* 
  Structures used by AP remote file access system.
*/

typedef struct r_fiov {		/* remote file iov */
  	struct r_fiov *lp;	/* link pointer */
  	NIOV *np;		/* logical link iov */
  	int $$ferr;		/* current error state */
  	int opn_flags;		/* flags for open file */
} NFILE;

typedef struct fatrb$ {		/* remote file attribute block */
	char f_rtyp;		/* file type (from FDB) */
	char f_ratt;		/* file attributes (from FDB) */
	int f_rsiz;		/* file record size (from FDB) */
	int f_hibk[2];		/* file high block (from FDB) */
	int f_efbk[2];		/* file end of file block (from FDB) */
	int f_ffby;		/* file first free byte (from FDB) */
} FATRB;

typedef struct r_opsts {	/* fopen status reply packet */
	int $$ferr;		/* success code */
	char filnam[32];	/* full file name */
	FATRB att;		/* file attributes structure */
} OPNSTS;

/*
  Special network status return value definitions
*/

#define IS_SUC	1		/* success return */
#define IE_ABO	0361		/* abort during rcv */
#define IE_ALN	0366		/* LUN already established */
#define IE_NLN	0333		/* no link established on LUN */

#define IE_NDA	-78		/* no data on net queue */
#define IE_NBF	-39		/* no buffer space left */
#define IE_ILU	-96		/* invalid lun (non left) */

/* network mailbox message codes */

#define NT_CON	1	/* connect */
#define NT_INT	2	/* interrupt */
#define NT_DSC	3	/* disconnect */
#define NT_ABT	4	/* user abort message */
#define NT_ABO	5	/* network abort message */

/*
  connect and accept data blocks is C format. variable names
  correspond to the DECnet documnetation.
*/

struct c_conblk {	/* connt connect block */
  byte n_rnd[6];
  byte n_rfm;
  byte n_rot;
  word n_rdec;
  byte n_rde[16];
  word n_ridc;
  byte n_rid[16];
  word n_rpsc;
  byte n_rps[8];
  word n_racc;
  byte n_rac[16];
  } ;

struct a_conblk {	/* accnt connect block */
  word n_ctl;
  word n_segz;
  byte n_dfm;
  byte n_dot;
  word n_ddec;
  byte n_dde[16];
  byte n_snd[6];
  byte n_sfm;
  byte n_sot;
  word n_sdec;
  byte n_sde[16];
  word n_sidc;
  byte n_sid[16];
  word n_spsc;
  byte n_sps[8];
  word n_sacc;
  byte n_sac[16];
  word n_cdev;
  byte n_cuni;
  byte n_xxx;
  word n_cuic;
  byte n_xxz[40];
  word n_cdac;
  byte n_cda[16];
  };

