/*
 * P$DPACK - Pack dynamic single choice menu
 */

#ifdef DOCUMENTATION

title    p$dpack     Pack Dynamic Single-choice Menu
index                Pack Dynamic Single-choice Menu

synopsis

	 char *fid;           /* Field ID */
	 char *buf;           /* Field 'value' buffer */
	 char *keyw;          /* "DFLT" or "KEYWnn" */
	 int p1, p2;          /* Parameter(s) for above */
	 int clear;           /* TRUE = clear dynamic buffer */
	 int stat[2];         /* 2-word status */

	 p$dpack(fid, buf, keyw, p1, p2, clear, stat)

desciption

	The p$dpack directive has restricted access: it handles only
	one field, thus requires multiple calls.  It doesn't support
	both 'DFLT' and 'KEYWnn' fields in the same call.
	.s
	The field ID, a string of six(max) uppercase characters, specifies
	one of the following field identifiers:

 	 FID	        nn          Menu Field
	 ---            --          ----------
	 'TITL'			    title
	 'TEXTnn'     01,02,03      explanatory text
	 'GHLP'		            global help frame identifier
	 'PRMT'			    prompt text for line 21
	 'OPTNnn'     01 - 12       option text for option nn
	 'ACTNnn'     01 - 12       action string for option nn
	 'OHLPnn'     01 - 12       help frame ID for option nn

diagnostics

	No error code will be returned if option help frame identifier
	is specified with an invalid number.

author

	 Bob Denny

#endif

extern dpack();

p$dpack(fid, buf, keyw, p1, p2, clear, stat)
char *fid;                             /* Field ID */
char *buf;                             /* Field 'value' buffer */
char *keyw;                            /* "DFLT" or "KEYWnn" */
int p1, p2;                            /* Parameter(s) for above */
int clear;                             /* TRUE = clear dynamic buffer */
int stat[2];                           /* 2-word status */
   {
   int fidl, keyl, bufl;

   fidl = strlen(fid);
   bufl = strlen(buf);
   keyl = strlen(keyw);
   call(dpack, (clear) ? 10 : 9, stat, fid, &fidl, buf, &bufl,
      keyw, &keyl, &p1, &p2, "CLRB");
   return(stat[0]);
   }

