/*
 *	*********************
 *	*  M A K B I N . C  *
 *	*********************
 * 
 * Copyright (c) 1983,1984 Compu-Tome, Inc., Pasadena, CA
 *
 * Compiles P/OS font files (xxx.FNT) into the binary format
 * accepted by the font loaders LFNT.TSK and CTLFNT.TSK.
 *
 * Bob Denny	11-Jan-84
 *
 * Edits:
 */

#define DEBUGoff

#include <rmstdio.h>
#include <cx.h>


extern int $dsw;
extern int $$ferr;


main(argc, argv)
int argc;
char *argv[];
   {
   char *cp;
   word i, j;
   word fntnum, nbpr, nbpc, nbits, bits;
   word charset, chcode, idxval;
   char ibuf[64];
   char obuf[64];
   byte *bp;
   word *wp;
   FILE *ifp;
   FILE *ofp;

   /*
    * Open the input and output files
    */
   concat(ibuf, argv[1], ".FNT", 0);
   concat(obuf, argv[1], ".DAT", 0);
   if((ifp = fopen(ibuf, "r")) == NULL)
      my_err("Can't open .FNT file. Code = %d", $$ferr);
   if((ofp = fopen(obuf, "wun")) == NULL)
      my_err("Can't create .DAT file.  Code = %d", $$ferr);

   /*
    * Load the font/character set.  THERE IS NO ERROR CHECKING, THE
    * FILE'd BETTER DAMN WELL BE CORRECT!!
    */
   while(!feof(ifp))			/* Read till EOF */
      {
      if(fget(ibuf, 64, ifp) == EOF)	/* Quit if EOF encountered here */
         break;

      if(ibuf[0] == '[')			/* If is font header line */
         {
         sscanf(ibuf, "[%d %d %d", &fntnum, &nbpr, &nbpc); /* Get info */
         wp = obuf;
         *wp++ = fntnum;
         *wp++ = nbpr;
         *wp++ = nbpc;
         fput(obuf, 6, ofp);			/* Write out header record */
         continue;
         }
      if(ibuf[0] != '<')			/* Read lines till start-cell */
         continue;
      if(fntnum == -1)			/* NO FONT HEADER??? */
         my_err("Missing font header", 0);
      sscanf(ibuf, "<%d %d %d", &charset, &chcode, &idxval);

#ifdef DEBUG
      printf("Code %d  Character set %d  Index %d\n",
         chcode, charset, idxval);
#endif


      if(chcode > 95 || idxval > 221)		/* Check values */
         {
         printf("Code %h  Character set %d  Index %h:\n",
            chcode, charset, idxval);
         my_err("Illegal cell map in PXL file", 0);
         }

      wp = obuf;				/* Load binary char header */
      *wp++ = charset;
      *wp++ = chcode;
      *wp++ = idxval;

      bp = (char *)wp;				/* bp=wp -> data in bin rec */

      if(idxval == 0)				/* If undefined character */
         {
         fput(obuf, 6, ofp);			/* Write the binary record */
         continue;				/* Finished, ignore noise */
         }

      /*
       * Read in pixel rows & convert to binary.
       */
      nbits = nbpr << 3;
      for(i=0; i<nbpc/nbpr; i++)
         {
         if(fget(ibuf, 64, ifp) == EOF)	/* Read a pixel row */
            my_err("Unexpected EOF", 0);
         bits = 0;
         cp = ibuf + nbits;			/* Decode row data to bin */
         for(j=0; j<(nbits-1); j++)
            {
            if(*(--cp) == '*')
               bits |= 1;
            bits <<= 1;
            }
         if(*(--cp) == '*')
            bits |= 1;

#ifdef DEBUG
         printf("Bits: %06o\n", bits);
#endif

         if(nbpr == 2)
            {
            *wp++ = bits;
            bp += 2;
            }
         else
            *bp++ = bits & 0377;
         }
      fput(obuf, (bp - obuf), ofp);
      }
   fclose(ofp);
   printf("Complete\n"); 
   }

/*
 * MY_ERR - Handle error conditions
 */
my_err(fmt, val)
char *fmt;
int val;
   {
   fprintf(stderr, fmt, val);
   exits(1);
   }
