$! VCARCH.COM
$!	Write all files to the C archive.
$!	This command then runs AR on all files in a directory tree.
$!
$!		@VCARCH source_parent output_directory
$!
$!	If no parameters are supplied, VCARCH will prompt for the
$!	root of the source directory and the output disk/directory.
$!	The default for source is C:
$!	The default for output is CARCHIVE:
$!
$!	Written by Martin Minow
$!
$	on control_y then goto fatal_exit
$	was_verify = 'f$verify(0)'
$	if "''ar'" .eqs. "" then ar := $bin:ar
$	home_dir	:= 'f$logical("SYS$DISK")''f$directory()'
$	in_dir		:= "C:"
$	if p1 .eqs. "" then inquire p1 "Enter input directory <''in_dir'>"
$	if p1 .nes. "" then indir := 'p1'
$	set default 'in_dir'
$	in_disk		:= 'f$logical("SYS$DISK")'
$	if p2 .eqs. "" then inquire p2 "Enter output directory <CARCHIVE:>"
$	if p2 .eqs. "" then p2 := "CARCHIVE:"
$	temp_name	:= 'in_dir'direct.tmp
$!
$! ** Generalized directory structure transversal algorithm.  This
$! ** section uses the directory utility to walk the directory structure,
$! ** writing each directory specification to a temporary file, defined
$! ** previously as local symbol "temp_name".
$!
$	directory/versions=1/columns=1/nodate/nosize/noheading -
		/notrailing/output='temp_name' *.dir
$	open/read dir_file 'temp_name'
$!
$! Read VAXBCK.TMP and write BACKUP and RESTOR command files.
$!
$	return := "loop1a"				! For get_next return
$ loop1:						! For all entries ...
$	goto get_next					! Get next file name
$ loop1a:						! Return from get_next
$	if "''dir_name'" .eqs. "" then goto loop1e	! Loop exit if no more
$!
$! Archive parameters are "create new, insert, verbose"
$! Note that AR doesn't handle vms path names very well.
$!
$ set verify
$	set default 'in_disk''dir_name'
$	ar "-civ" 'p2''dir_itself'.arc *.*;
$ set noverify
$	goto loop1					! Continue loop
$ loop1e:
$	goto finis
$
$ fatal_exit:
$	write sys$error "CTRL/Y typed"
$ finis:
$!!	delete/error=finis1 'dir_file'
$ finis1:
$	set default 'home_dir'
$	if .not. 'was_verify' then set noverify
$	exit
$!
$! ** Subroutine get_name reads a line from the temporary file, parsing
$! ** it and assigning the directory name indicated to "dir_name'.  At end
$! ** of file or error (or a null directory), it closes the temporary file
$! ** and sets "dir_name" to the null string.
$! ** Get_name returns the following symbols:
$! **	dir_disk	DISK:[PARENT]CHILD.DIR;1
$! **	dir_name	[PARENT.CHILD]
$! **	name_itself	CHILD
$! ** Usage:
$! **
$! **		Open/read temp_name [file created by directory utility]
$! **		return := sub_ret
$! **	loop:					! For all entries, ...
$! **		goto get_name			!   Get next entry
$! **	sub_ret:				!
$! **		if "''file_name'" .eqs."" then	!   Exit if no more
$! **			goto finished		!
$! **		[Process this entry]		!   Process this one and
$! **		goto loop			!   ... continue.
$! **	finished:				! Loop exit
$!
$ get_next:
$	read/end=get_done/error=get_done dir_file dir_disk
$	dir_beg		=	'f$locate("[", dir_disk)'
$	if dir_beg .eq. 'f$length(dir_disk)' then goto get_done
$	dir_end		=	'f$locate("]", dir_disk)'
$	dir_size	=	dir_end - dir_beg
$	dir		:=	"''f$extract(dir_beg, dir_size, dir_disk)'"
$	name_beg	=	dir_end + 1
$	name_size	=	'f$locate(".DIR;", dir_disk)' - name_beg
$	dir_itself	:=	"''f$extract(name_beg, name_size, dir_disk)'"
$	dir_name	:= 	"''dir'.''dir_itself']"
$	goto 'return'
$ get_done:
$	close dir_file
$	dir_name := ""
$	goto 'return'
$!
