/*	nxtword

Usage:

    char *
    nxtword (string)

    char	*string;


    char *
    skip_white (string)

    char *
    skip_n_white (string)


Description:

nxtword -

Starting at the current location:
    skip whitespace, then skip non-whitespace, then skip whitespace.

The function returns a pointer to the beginning of the next word of the user's
string, or, if no next word is found before the end of the user's string,
the pointer returned points to the end-of-string null.

skip_white -

The function returns a pointer to the next non-whitespace character (not in
the white_space string) in the user's string, or the end-of-string null.

skip_n_white -

The function returns a pointer to the next whitespace character (any character
in the white_space string) in the user's string, or the end-of-string null.

NOTE:  This module defines the external variable white_space, which is a
string pointer to a string containing the white space characters that are
tested for in the functions.  The user may assign this variable to any other
string to redefine the white space characters.  The default whitespace
characters are the space (' ') and tab ('\t').

******************************************************************************/

#include	<std.h>

STRING	white_space = " \t";

STRING
nxtword (string)

STRING	string;
{
extern STRING	skip_white(), skip_n_white();

return (skip_white (skip_n_white (skip_white (string))));
}


STRING
skip_white (string)

STRING	string;
{
REGISTER STRING	white;

while (*string)
    {
    white = white_space;
    while (*white)
	if (*string == *white++)
	    goto next_character;
    return (string);
next_character:
    string++;
    }
return (string);
}


STRING
skip_n_white (string)

STRING	string;
{
REGISTER STRING	white;

while (*string)
    {
    white = white_space;
    while (*white)
	if (*string == *white++)
	    return (string);
    string++;
    }
return (string);
}
