/*	ioerrmsg

Usage:

	STRING
	ioerrmsg (error_code)

	int	error_code;	RSX I/O error code value

Description:

The function accepts a standard RSX I/O error code value and returns
a pointer to a static string which describes the meaning of the code.
If the code value is 0 or out of range, a null string is returned.

******************************************************************************/

#include	<std.h>
#include	<stdio.h>
#include	<qioret.h>

#define	MSG_FILE	"US0:[1,2]QIOSYM.MSG"


STRING
ioerrmsg (error_code)

int	error_code;
{
static char	msg[64];
int		code;
FILE		*msg_file;

*msg = '\0';
code = IO_ERROR;
if (error_code == NULL)
	error_code = code;
if (error_code < 0)
	{
	if (msg_file = fopen (MSG_FILE, "r"))
		{
		if (fseek (msg_file, (long)(-(error_code + 1) * 64), 0) == 0)
			fgetss (msg, 64, msg_file);
		fclose (msg_file);
		}
	}
IO_ERROR = code;
return (msg);
}
