/*	do_args

Command line argument handling.

Usage:

    do_args (count, arguments)

    int		count		Number of arguments in the argument list
    char	arguments[]	Argument list

>>> NOTE <<< This function calls arg_check.

Description:

The strings in the argument list are individually checked.

The first character of each argument string is checked for the "@"
character. If found, the remaining portion of the string is taken as an
indirect command file name. It is passed, along with the name of this
function, to the indirect function for processing. The default 
filename extension, if none is supplied, is in a global string:

    def_indirect = "ARG";

All other argument strings are passed to arg_check for user specific 
processing. If arg_check returns a FALSE value, the message

    "Invalid argument: <argument string>"

is printed and argument processing continues.

The arguments to this function are identical to the arguments that may 
be taken the the main function. Usually (though not required) the first 
argument (the name of the running task) is removed from the list and the
argument count decremented before calling this function:

    do_args (--count, ++argument);

This function does not return a meaningful value.
*/

#include	<std.h>
#include	<stdio.h>
#include	<qioret.h>

STRING	def_indirect = "ARG";


VOID
do_args (count, argument)

INTEGER	count;
STRING	argument[];
{
TEXT	filename[32];

while (count--)
    {
#ifdef DEBUG
printf ("do_args: %s\n", *argument);
#endif
    if (*argument[0] == '@')
	{
	strcpy (filename, *argument + 1);
	if (! search (filename, '.'))
	    file_extension (filename, def_indirect);
#ifdef DEBUG
printf ("\tIndirect file %s\n", filename);
#endif
	if (indirect (filename, do_args))
	    fprintf (stderr, "\nIndirect command file %s\n%s\n\n",
		filename, ioerrmsg (IO_ERROR));
	}
    else if (! arg_check (*argument))
	fprintf (stderr, "Invalid argument: %s\n", *argument);

    argument++;
    }
}
