/*	ascii.h

ASCII Control Characters Code Chart

*/

    			/* (^@) Null, tape feed, CONTROL/SHIFT/P */
#define	NUL	'\000'
    			/* (^A) Start of heading; also SOM, start of message */
#define	SOH	'\001'
#define	SOM	'\001'
    			/* (^B) Start of text; also EOA, end of address */
#define	STX	'\002'
#define	EOA	'\002'
    			/* (^C) End of text; also EOM, end of message */
#define	ETX	'\003'
#define	EOM	'\003'
    			/* (^D) End of transmission (END); shuts off TWX  */
#define	EOT	'\004'
#define	END	'\004'
    			/* (^E) Enquiry (ENQRY); also WRU */
#define	ENQ	'\005'
#define	ENQRY	'\005'
#define	WRU	'\005'
    			/* (^F) Acknowledge; also RU */
#define	ACK	'\006'
#define	RU	'\006'
    			/* (^G) Rings the bell */
#define	BELL	'\007'
    			/* (^H) Backspace; also FEO, format effector */
#define	BS	'\010'
#define	FEO	'\010'
    			/* (^I) Horizontal tab */
#define	HT	'\011'
    			/* (^J) Line feed or line space (new line) */
#define	LF	'\012'
    			/* (^K) Vertical tab (VTAB) */
#define	VT	'\013'
#define	VTAB	'\013'
    			/* (^L) Form feed to top of next page (PAGE) */
#define	FF	'\014'
#define	PAGE	'\014'
    			/* (^M) Carriage return to beginning of line */
#define	CR	'\015'
    			/* (^N) Shift out; select character set G0 */
#define	SO	'\016'
#define	G0	'\016'
    			/* (^O) Shift in; select character set G1 */
#define	SI	'\017'
#define	G1	'\017'
    			/* (^P) Data link escape (DC0) */
#define	DLE	'\020'
#define	DC0	'\020'
    			/* (^Q) Device control 1; turns trans on (X-ON) */
#define	DC1	'\021'
#define	XON	'\021'
    			/* (^R) Device control 2; turns aux on (AUX-ON) */
#define	DC2	'\022'
#define	AUXON	'\022'
    			/* (^S) Device control 3; turns trans off (X-OFF) */
#define	DC3	'\023'
#define	XOFF	'\023'
    			/* (^T) Device control 4; turns aux off (AUX-OFF) */
#define	DC4	'\024'
#define	AUXOFF	'\024'
    			/* (^U) Negative acknowledge; also ERR, ERROR */
#define	NAK	'\025'
#define	ERR	'\025'
#define	ERROR	'\025'
    			/* (^V) Synchronous file (SYNC) */
#define	SYN	'\026'
#define	SYNC	'\026'
    			/* (^W) End of transmission block */
#define	ETB	'\027'
    			/* (^X) Cancel (CANCL) */
#define	CAN	'\030'
#define	CANCL	'\030'
    			/* (^Y) End of medium */
#define	EM	'\031'
    			/* (^Z) Substitute */
#define	SUB	'\032'
    			/* Escape, CONTROL/SHIFT/K */
#define	ESC	'\033'
    			/* File separator, CONTROL/SHIFT/L */
#define	FS	'\034'
    			/* Group separator, CONTROL/SHIFT/M */
#define	GS	'\035'
    			/* Record separator, CONTROL/SHIFT/N */
#define	RS	'\036'
    			/* Unit separator, CONTROL/SHIFT/O */
#define	US	'\037'
    			/* Delete, rubout */
#define	DEL	'\0177'
