/*	argtrace.h

Argument handler template.
*/
GLOBAL	arg_arg ();
GLOBAL	val_arg ();

ARG_HANDLE	user_arguments [] =
    {
    "ARG",	arg_arg,
    "STR",	val_arg,
    "INT",	val_arg,
    "LON",	val_arg,
    "FLO",	val_arg,
    0,		0
    };

/*
The argument handler functions:
*/

INTEGER
arg_arg (argument)

STRING	argument;
{
printf ("arg_arg: %s\n", argument);
return (SUCCESS);
}


#include	<stdio.h>
#include	<qioret.h>
#include	<argvalues.h>

#define	MAX_ARGUMENTS	20

INTEGER
val_arg (argument)

STRING	argument;
{
COUNT	count;
STRING	string;
STRING	val_mem;
union
    {
    STRING	*are_strings;
    INTEGER	*are_ints;
    LONG	*are_longs;
    FLOAT	*are_floats;
    }
    values;

printf ("val_arg: %s\n", argument);

if (! (val_mem = values.are_strings =
    (STRING) malloc (MAX_ARGUMENTS * sizeof (FLOAT))) ||
    ! (string = (STRING) malloc (strlen (argument) + 1)))
    {
    printf ("\tUnable to allocate dynmaic memory!\n");
    return (FAILURE);
    }

strcpy (string, argument);

switch (toupper (*string))
    {
    case 'S':
	if (count = arg_values (STRING_VALUE,
	    string, values.are_strings, MAX_ARGUMENTS))
	    {
	    printf ("val_arg: List of %d strings:\n", count);
	    while (count--)
		printf ("\t%s\n", *values.are_strings++);
	    }
	break;
    case 'I':
	if (count = arg_values (INTEGER_VALUE,
	    string, values.are_ints, MAX_ARGUMENTS))
	    {
	    printf ("val_arg: List of %d integers:\n", count);
	    while (count--)
		printf ("\t%d\n", *values.are_ints++);
	    }
	break;
    case 'L':
	if (count = arg_values (LONG_VALUE,
	    string, values.are_longs, MAX_ARGUMENTS))
	    {
	    printf ("val_arg: List of %d longs:\n", count);
	    while (count--)
		printf ("\t%ld\n", *values.are_longs++);
	    }
	break;
    case 'F':
	if (count = arg_values (FLOAT_VALUE,
	    string, values.are_floats, MAX_ARGUMENTS))
	    {
	    printf ("val_arg: List of %d floats:\n", count);
	    for (;count--; values.are_floats++)
		printf ("\t%g\n", *values.are_floats);
	    }
	break;
    }
mfree (val_mem);
if (IO_ERROR)
    {
    if (IO_ERROR == IE_BAD)
	printf ("Check syntax of %s\n%s\n%*c\n",
	    arg_string, argument, arg_index + 1, '^');
    else
	printf ("Insufficient dynamic memory!\n");
    count = FAILURE;
    }
else
    count = SUCCESS;

mfree (string);
return (count);
}
