/*	arg_parse

Usage:

    #include	<qioret.h>	For RSX I/O error codes

    int
    arg_parse (string, arguments, maximum)

    char	*string;	The text string of arguments to be parsed
    char	*arguments[];	String pointer array for argument pointers
    int		maximum;	Maximum number of arguments to parse


Description:

A text string is scanned to produce an argument vector of the form:

    arg_count - Number of arguments encountered (function return value).
    arguments[arg_count] - String pointers to the respective arguments.

No more than maximum arguments will be parsed into the arguments array.

An argument is a contiguous string of characters separated by whitespace.
The whitespace characters may be redefined from the default space and tab
characters by changing the external white_space string pointer to refer to
the string containing the characters to be considered as whitespace.

An argument may be quoted, in which case the argument is the enitre string
between the quotes (exclusive of the quotes). The initial quote character may 
be either a single (') or double (") quote.  The argument string is closed by 
the same character, or the end of string.

Characters between, and including, '/''*' and '*''/' pairs are ignored
as comments (except when they occur within quoted strings).

The argument vector is produced from pointers to the location of arguments
in the text string.  Each argument in the string is null terminated.

******************************************************************************/

#include	<std.h>


INTEGER
arg_parse (string, arguments, maximum)

STRING	string;
STRING	arguments[];
INTEGER	maximum;
{
INTEGER	arg_count;

#ifdef DEBUG
printf ("arg_parse: %s\n", string);
#endif

arg_count = 0;

while (*(string = skip_white (string)))		/* Skip whitespace */
    {
    if (*string == '/' && *(string + 1) == '*')
	/*
	Comment string - skip it.
	*/
	{
#ifdef DEBUG
printf ("\tSkipping comment ...\n");
#endif
	string += 2;
	while ((string = search (string, '*')) && *++string != '/');
	}
    else
	{
	if (*string == '"' || *string == '\'')
	    {
#ifdef DEBUG
printf ("\tQuoted argument ...\n");
#endif
	    /*
	    Quoted argument
	    */
	    arguments[arg_count++] = ++string;	/* New argument pointer */
	    string = search (string, *(string - 1));	/* Find end of quote */
	    }
	else
	    {
	    /*
	    Simple argument
	    */
#ifdef DEBUG
printf ("\tSimple argument ...\n");
#endif
	    arguments[arg_count++] = string;	/* New argument pointer */
	    string = skip_n_white (string);	/* Skip over argument */
	    }
	}
    if (string && *string)
	{
	*string++ = '\0';			/* Mark argument EOS */
#ifdef DEBUG
if (arg_count)
printf ("\t\t%s\n", arguments[arg_count - 1]);
#endif
	}
    else
	{
#ifdef DEBUG
if (arg_count)
printf ("\t\t%s\n", arguments[arg_count - 1]);
#endif
	break;					/* Argument string exhausted */
	}
    if (arg_count == maximum)
	break;					/* Argument limit reached */
    }
return (arg_count);
}
