/*
 *				u p t o . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	upto	Pattern Match -- Match Up to Characters
index		Pattern match -- match up to characters

synopsis

	 #ifdef vms
	 #include "c:cset.h"
	 #else
	 #include <cset.h>
	 #endif

	 char *
	 upto(s,cs)
	 char s[];
	 CSET *cs;

description

	upto() skips over characters in s until it reaches a member of cs,
	and returns a pointer to the matched character.  If no matching
	character can be found, upto() returns NULL.

	upto() will accept the null string (returning s) if the first
	character of s is a member of cs.

	The null that terminates s is never considered to be a member of the
	cset, and thus upto() can never match through the end of s.

	Note:  The effect of a upto() that will match all the way to the
	end of the string, if necessary, can be achieved by using:

		ospan(s,cscomp(cs));

	Those familiar with SNOBOL will recognize upto() as the SNOBOL BREAK()
	function.  Unfortunately, "break" is a reserved word in C.

bugs

author

	Jerry Leichter

#endif

/*
)EDITLEVEL=03
 * Edit history
 * 0.0 19-Jul-82 JSL	Invention
 */

#ifdef vms
#include "c:cset.h"
#else
#include <cset.h>
#endif

#define NULL 0

char *
upto(s,cs)
register char *s;
register CSET *cs;
{
	while (*s && !csmember(cs,*s))
		s++;
	return(*s ? s : NULL);
}
