/*
 *				f x a d d . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	fxadd	Add an Item To a Flex
index		Add an item to a flex

synopsis

	 #ifdef	vms
	 #include "c:flex.h"
	 #else
	 #include <flex.h>
	 #endif

	 FLEX *
	 fxadd(fx,itm)
	 register FLEX *fx;
	 char *itm;

description

	fxadd() adds an item to a flex.  It returns NULL if the flex would
	have had to grow but couldn't because of insufficient memory or a zero
	extension quantity. In this case, the data in the flex is lost and the
	flex itself cannot be used again; further attempts always return NULL.
	If all went well, the flex pointer passed is returned.

	Note that an item is defined entirely by its length; fxadd() will try
	to copy exactly fx->fxisz bytes, regardless of null bytes, etc.

bugs

author

	Jerry Leichter

#endif

/*
 * )EDITLEVEL=05
 * Edit history
 * 0.0  4-May-81 JSL	Invention
 * 0.1  5-May-81 JSL	Cleanup
 * 0.2  7-May-81 JSL	Split flex.c into separate files; this is one
 * 0.3 23-Jun-81 JSL	Conversion to new documentation convention
 */

#ifdef	vms
#include "c:flex.h"
#else
#include <flex.h>
#endif
#define NULL 0

extern char *realloc();

FLEX *
fxadd(fx,itm)
register FLEX *fx;
char *itm;
{
	if (fx != NULL)
	{	if (fx->fxdim <= fx->fxused)
		{	fx->fxdim += fx->fxext;
			if (fx->fxdim <= fx->fxused
			||  fx->fxdata == NULL
			||  (fx->fxdata =
				realloc(fx->fxdata,fx->fxdim*fx->fxisz))
					 == NULL
			   )
			{	fx->fxdim = 0;
				return(fx->fxdata = NULL);
			}
		}
		copy(fx->fxdata + fx->fxisz*fx->fxused++,itm,fx->fxisz);
	}
	return(fx);
}
