/*
 *				a f t e r . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	after	Point After a Matching String
index		Point after a matching string

synopsis

	 char *
	 after(s,p)
	 char s[];	/* Subject string	*/
	 char p[];	/* Pattern string	*/

description

	after(s,p) searches s for the first occurence of p.  If p occurs as
	a substring of s, after() returns a pointer to the next memory
	location beyond the matching instance.  If p is not a substring of p,
	after() returns NULL.  Thus, after("abcde","bcd") returns a pointer to
	the "e" in the first argument; after("abcde","acd") returns NULL.
	
	If strlen(p) == 0, after() returns s.

	See also instr().

bugs

author

	Jerry Leichter

#endif

/*
 * )EDITLEVEL=13
 * Edit history
 * 0.0 19-Jul-82 JSL	Invention - converted from instr().
 */

#define NULL 0
#define EOS '\0'

extern char *match();

after(s,p)
register char *s;			/* Subject		*/
register char p[];			/* Pattern		*/
{	register char *ss;

	if (p[0] == EOS)		/* Null pattern...	*/
		return(s);		/*   matches at start	*/

	ss = s;

	while ((ss = strchr(ss,p[0])) != NULL)
		if ((s = match(++ss,&p[1])) != NULL)
			return(s);

	return(NULL);
}
