/*
 *    *************
 *    *  C S . H  *
 *    *************
 *
 * Standard header file for user programs
 * which use the CS library.
 *
 * Bob Denny   24-Feb-82
 * Bob Denny   03-Mar-82   Change fs_nrc to a long
 */

typedef char *address;
typedef char byte;
typedef unsigned word;
typedef unsigned rad50;

#define EOF -1
#define NULL 0

/*
 * External definition of I/O status block and DSW
 */
extern int $dsw;
extern int f_iosb[2];

/*
 * File specification block
 */
struct fsb     {
               char  fs_fsp[40];       /* ASCII file specification (null trm) */
               word  fs_pro;           /* Static file protection */
               word  fs_ext;           /* Extent increment, blocks */
               byte  fs_fmt;           /* File format */
               byte  fs_rec;           /* Recording mode */
               long  fs_bsz;           /* # blocks in file (SEQ) */
               word  fs_rsz;           /* Data rec len, bytes (REL,ISAM) */
               long  fs_nrc;           /* Record capacity (REL,ISAM) */
               byte  fs_ndf;           /* Number of data files (ISAM) */
               byte  fs_nky;           /* Number of keys (ISAM) */
               struct kdb
                  {
                  byte  kd_ksz;        /* Length of key, bytes (ISAM) */
                  byte  kd_kfl;        /* Key flags (ISAM) */
                  word  kd_kof;        /* Offset to key in data rec (ISAM) */
                  }  fs_kys[10];
               };

/*
 * Recording mode values - mutually exclusive
 * NOTE: Must match attribute codes!!
 */
#define  RM_ANO   0                    /* ASCII - No carriage control */
#define  RM_AFT   1                    /* ASCII - FORTRAN carriage control */
#define  RM_ACR   2                    /* ASCII - Normal carriage control */
#define  RM_BIN   0200                 /* Binary */

/*
 * File format values - mutually exclusive
 * NOTE: Must match attribute codes!!
 */
#define  FF_BLK   0                    /* Block */
#define  FF_REL   1                    /* Relative (R.FIX) */
#define  FF_SEQ   2                    /* Sequential (R.VAR) */
#define  FF_IDX   0100                 /* Indexed (R.ISAM) */

/*
 * Key flags - KF.DUP may be specified together with ONE of the
 *             other KF values.
 */
#define  KF_ASC   0                    /* ASCII - code order */
#define  KF_DIC   1                    /* ASCII - dictionary order */
#define  KF_BIN   2                    /* 16 bit unsigned integer key */
#define  KF_DUP   0200                 /* Duplicates allowed this key */
