/*)LIBRARY
*/

#include	<rsts.h>
 

#ifdef rt11
#define	RT_RMON		054	/* Work area starting address		*/
#define	RT_LOGTBL	014	/* Logical name table			*/
#define RT_MODE		004	/* Mode word for opens			*/
#endif

rs_open(channel, name, omode)
int		channel;	/* Channel number for open		*/
char		*name;		/* File name string			*/
char		*omode;		/* Mode "r", "a", or "w" only		*/
/*
 * Open a file, return error code -- zero for success.
 * Sorry, you must supply the channel.
 */
{
	register	char	*p;
	register	int	errcode;

retry:	clrfqx();
	xrb.xrlen	= strlen(name);	/* Length of the file name	*/
	xrb.xrbc	= xrb.xrlen;	/* Another copy of the length	*/
	xrb.xrloc	= name;		/* Name starting address	*/
	xrb.xrblk	= 44;		/* 44 byte logical name table	*/
#ifdef rt11
	p = *(char **)RT_RMON;		/* p -> resident monitor	*/
	xrb.xrtime	= p + RT_LOGTBL; /* Save start of logical table	*/
#endif
	if ((errcode = rstsys(_FSS)) != 0)
		return(-1);
	firqb.fqfil	= channel * 2;
	firqb.fqfun	= (*omode == 'w') ? CREFQ : OPNFQ;
	/*
	 * Force clustersize to zero (bug somewhere in RSTS)
	 */
	firqb.fqclus	= 0;		/* ?? Bug ??			*/
	errcode = rstsys(CALFIP);
	if (*omode == 'a' && errcode == 5) {
		omode = "w";
		goto retry;
	}
	return(errcode);
}
