/*	xvar.h

This file should be included in .h files for application programs where
data areas need to be allocated in a main program module and then declared
in other subprogram modules.

Usage:

Include this file before data areas are referenced (and initialized).

Preceed each type name with the symbol XVAR.
Data should be initialized with the macro XINIT.
Array sizes should be defined with the macro ARRAY.
In the module where data areas area defined (i.e. space is allocated),
define the symbol MAIN before the program's header file which contains
this file is included.

Example:

#include	<xvar.h>

XVAR int	number		XINIT(1);
XVAR char	*string		XINIT("A string of characters.");
XVAR long	table ARRAY(13);
#define	OF_NUMBERS	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}
XVAR int	array ARRAY()	XINIT(OF_NUMBERS);

In the module with the symbol MAIN previously defined this produces:

int	number		= 1;
char	*string		= "A string of characters.";
long	table [13]	;
int	array []	= {0, 1, 2, 3, 4, 5, 6, 7, 8, 9};

>>> NOTE <<< The array initialization values must be symbolically defined
	to provide a single argument to the XINIT macro.

For all other modules this produces:

extern int	number		;
extern char	*string		;
extern long	table []	;
extern int	array []	;

*/


#ifdef	MAIN
/* Causes allocation and initialization of storage  ***************************
*/
#define	XVAR
#define	XINIT(x)	= x
#define	ARRAY(x)	[x]

#else
/* Causes declaration of storage allocated in main  ***************************
*/
#define	XVAR extern
#define	XINIT(x)
#define	ARRAY(x)	[]

#endif
