/*	time_date

Usage:

    char *
    time_date (string)

    char	*string;	String to receive the converted time

Description:

The current time and date is obtained from the operating system
and converted to an ascii string representation in the user buffer.
The converted string is up to 29 characters plus a terminating null:

    hh:mm xm.  dd M...M, yyyy

	hh - 12 hr clock value
	mm - minute of the hour (zero padded)
	xm. - either "am." or "pm." as appropriate
	dd - day of the month
	M...M - month name spelled out
	yyyy - year value

The function returns a pointer to the null at the end of the string.

*/

#include	<std.h>
#include	<timbuf.h>

static STRING	month[] =
	{
	"January",
	"February",
	"March",
	"April",
	"May",
	"June",
	"July",
	"August",
	"September",
	"October",
	"November",
	"December"
	};
static STRING	xm = "am.";


char *
time_date (string)

char	*string;
{
struct timbuf	time;

gtim (&time);
if (time.g_tihr > 12)
    {
    time.g_tihr = time.g_tihr - 12;
    *xm = 'p';
    }
return (sprintf (string, "%d:%02d %s  %d %s, %d",
    time.g_tihr, time.g_timi, xm,
    time.g_tida, month[time.g_timo - 1], 1900 + time.g_tiyr));
}
