/*	recqueue.h - Record queue file control
*/

#define	MAX_ATTEMPTS	5
#define	PAUSE_TIME	2
#define	Q_BUF_SIZE	512

#ifdef	IE_EOF
#define	EOQ		IE_EOF
#define	QUEUE_BUSY	IE_LCK
#else
#define	EOQ		-10
#define	QUEUE_BUSY	-27
#endif

typedef struct
    {
    LONG	head;		/* Location of first record */
    LONG	tail;		/* Location of last record */
    LONG	empty;		/* Location of next empty record in the file */
    INTEGER	record_size;	/* Record size */
    UCOUNT	total_records;	/* Total number of records in the queue */
    }
    QUEUE_HEADER;

typedef struct
    {
    LONG	previous;		/* Location of previous record */
    LONG	following;		/* Location of following record */
    }
    RECORD_HEADER;

typedef struct
    {
    FILE		*file;		/* The file of queued records */
    LONG		location;	/* Current buffer location in file */
    LONG		end;		/* EOF location */
    QUEUE_HEADER	control;	/* Queue control header */
    RECORD_HEADER	*record;	/* Current record pointer */
    UCOUNT		record_number;	/* Sequential queue record number */
    BOOLEAN		update;		/* Flag for buffer update */
    BYTE		buffer[Q_BUF_SIZE];
    }
    QUEUE;

#ifndef	$$RQ
GLOBAL QUEUE	*RQ_open ();
GLOBAL INTEGER	RQ_close ();
GLOBAL INTEGER	RQ_size ();
GLOBAL UCOUNT	RQ_total_records ();
GLOBAL STRING	RQ_get ();
GLOBAL INTEGER	RQ_update ();
GLOBAL INTEGER	RQ_enqueue ();
GLOBAL INTEGER	RQ_dequeue ();
GLOBAL INTEGER	RQ_delete ();
#endif
