/*	power

Usage:

	float
	power (base, exponent)

	float	base;		Value of base
	float	exponent;	Value of exponent applied to base

Description:

A given base is raised to the specified power.
Only positive base values are allowed.

>>> Notice <<<
This routine relies on a call to the FORTRAN routine FOREXP which actually
performs the exponentiation.

When building a task under RSX that uses this routine be sure to include
the /FP switch applied to the task name.

******************************************************************************/

float
power (base, exponent)

float	base;
float	exponent;
{
extern	float forexp();		/* FORTRAN exponentiation routine */
float	result;			/* Result of the exponentiation */

if (base > 0.0)
	{
	call (forexp, 3, &base, &exponent, &result);
	return (result);
	}
else
	return (0.0);
}
