/*
 *			f l e x . h
 */

#ifdef	DOCUMENTATION

title	flex	Header File For Flexes
index		Header file for flexes

synopsis

	 #ifdef vms
	 #include "c:flex.h"
	 #else
	 #include <flex.h>
	 #endif

description

	This header file is used to allow programs to access flexes.  See
	flex.c for additional details.

	This file defines the structure of a flex.  The fields are as follows:
	.lm+8

 char *fxdata

	Pointer to the actual data.  This will always be the first element, so
	that a flex can be considered to be of type char ** (or whatever) if
	you only want to read it.  fxdata will be NULL if the flex has been
	damaged.

 unsigned fxused

	Number of items used in the flex.

 unsigned fxdim

	Number of items the flex can hold; 0 if the flex has been damaged.

 unsigned fxisz

	Size of one item, in bytes.

 unsigned fxext

	Number of items to grow by; if 0, the flex won't grow.  
	.lm -8

	The only fields generally directly accessed by programs are fxdata
	and fxlen.  Note that fxdata may change over time as items are added
	to and removed from the flex.

	The only field you should normally change is fxext, the extension
	quantity. The value current the next time the flex must grow will
	determine how much it grows by.

	flex.h also contains extern declarations describing the datatypes of
	all the flex-handling routines.

bugs

author

	Jerry Leichter
#endif

/*
)EDITLEVEL=10
 *
 * Edit history
 * 0.0  4-May-81 JSL	Invention
 * 0.1  7-May-81 JSL	Various cleanups; added FXDODEFS
 * 0.2 13-May-81 JSL	Added _FLEX_
 * 0.3 22-Jun-81 JSL	Conversion to new documentation conventions
 * 0.4 14-Jul-82 JSL	FSDODEFS is obsolete; new compiler is more clever
 */

#ifndef _FLEX_				/* Don't do this twice */
#define _FLEX_

typedef struct fxheader
	{ char *fxdata;
	  unsigned fxused;
	  unsigned fxdim;
	  unsigned fxisz;
	  unsigned fxext;
	} FLEX;

	extern FLEX	*flex();	/* make a new flex */
	extern FLEX	*fxadd();	/* add an item to the end */
	extern FLEX	*fxaddo();	/* add an item, ordered */
	extern unsigned	fxladd;		/* where fxaddo() added an item */
	extern FLEX	*fxeject();	/* eject (delete) an item */
	extern		fxfree();	/* free all space used by a flex */
	extern FLEX	*fxinject();	/* inject (insert) an item */
	extern char	*fxitem();	/* return pointer to an item */
	extern FLEX	*fxneed();	/* explicitly alter a flex's size */
	extern FLEX	*fxset();	/* set a value into an item */
#endif
