/*
 *				c s w i t h . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	cswith	Add an Element To a Cset
index		Add an element to a cset

synopsis

	 #ifdef vms
	 #include "c:cset.h"
	 #else
	 #include <cset.h>
	 #endif

	 CSET *
	 cswith(cs,c)
	 CSET *cs;
	 int c;

description

	The element c, which is generally a character, is added to the cset
	cs. This call modifies the actual cset cs, whatever the value of
	csunique.

	cs itself is returned.

	Note:  c is not validated; c < 0 or c >= cssize may cause cswith()
	to set an arbitrary bit in memory.  However, csmask is used to control
	unwanted sign extension; see cset().

bugs

author

	Jerry Leichter

#endif

/*
)EDITLEVEL=00
 * Edit history
 * 0.0 16-Jul-82 JSL	Invention
 */

#ifdef vms
#include "c:cset.h"
#else
#include <cset.h>
#endif

CSET *
cswith(cs,c)
register CSET *cs;
int c;
{
	if ((int)cs & 1)			/* Complemented cset	*/
		return(cscomp(csless(cscomp(cs),c)));
						/* Use DeMorgan's law	*/
	cs->table[c & csmask] |= cs->mask;	/* Add it in		*/
	return(cs);
}
