#include <stdio.h>
#include <rsts.h>
#include <rserr.h>

getcw()
/*
 * Get the next character typed at the keyboard.  Wait only one second.
 * return:
 *	<  0	-value is a (fatal) error
 *	== 0	Nothing was typed
 *	>  0	The returned character
 */
{
	char		buf[2];
	register int	errcode;

	rstsys(_TTDDT);			/* Enter single character mode	*/
	clrxrb();
	xrb.xrlen = 1;			/* One character only		*/
	xrb.xrloc = &buf[0];		/* Into this buffer		*/
	xrb.xrtime = 1;			/* One second wait time		*/
	errcode = rstsys(_READ);	/* Do the read			*/
	if (errcode == 0)
		return(buf[0] & 0377);
	else if (errcode == HNGTTY)
		return(0);
	else return (-errcode);
}
