/*
 * P$MMENU - Show multiple choice menu frame
 */

#ifdef DOCUMENTATION

title p$mmenu     Show Multiple Choice Menu Frame
index             Show Multiple Choice Menu Frame

synopsis

	 char *optstr; /* Array of fixed-length option strs */
	 int optlen;   /* Fixed length of option strings */
	 int nopts;    /* Number of options */
	 int lim;      /* Limit to number of selections */
	 int *sels;    /* Returned array of selected options */
	 int addopt;   /* TRUE = enable additional opt's */
	 char *msg1;   /* Message for line 23 or NULL */
	 char *msg2;   /* Message for line 24 or NULL */
	 int *stat;    /* --> 2 word status block */

	 p$mmenu(optstr, optlen, nopts, lim, sels, addopt, msg1,
		 msg2, stat)

description

	The p$mmenu directive displays a multiple-choice menu. To display the
	Additional Options flag and return control to the user if he selects
	the Additional Options key, pass a non-zero character in the addopt
	variable.

author

	 Bob Denny

#endif

extern mmenu();

p$mmenu(optstr, optlen, nopts, lim, sels, addopt, msg1, msg2, stat)
char *optstr;                          /* Array of fixed-length option strs */
int optlen;                            /* Fixed length of option strings */
int nopts;                             /* Number of options */
int lim;                               /* Limit to number of selections */
int *sels;                             /* Returned array of selected options */
int addopt;                            /* TRUE = enable additional opt's */
char *msg1;                            /* Message for line 23 or NULL */
char *msg2;                            /* Message for line 24 or NULL */
int *stat;                             /* --> 2 word status block */
   {
   int i, nsel, m1len, m2len;

   m1len = strlen(msg1);
   m2len = strlen(msg2);
   for(i=0; i<lim; i++)
      sels[i] = -1;

   call(mmenu, 12, stat, optstr, &optlen, &nopts, &lim, &nsel, sels, &addopt,
         msg1, &m1len, msg2, &m2len);
   return(stat[0]);
   }
