/*
 * HFILE - Open help file
 */

#ifdef DOCUMENTATION

title p$hfile     Open help file
index             Open help file

synopsis

	 char *file;             /* Help file name */
	 char *frame;            /* Default frame ID */
	 int *stat;              /* 2-word status block */

	 p$hfile(file, frame, stat)

description

	The p$hfile directive opens the specified help definition file and
 	sets the default help frame. Only one file can be open at any time.
	If another help file is open, p$hfile closes it before opening the
	requested file.

diagnostics

	A default help frame must be supplied.  Failure to do so will result in
	a fatal error.

author

	 Bob Denny

#endif


extern hfile();

p$hfile(file, frame, stat)
char *file;                             /* Help file name */
char *frame;                            /* Default frame ID */
int *stat;                              /* 2-word status block */
   {
   int flen, frlen;

   flen = strlen(file);
   frlen = strlen(frame);
   call(hfile, 5, stat, file, &flen, frame, &frlen);
   return(stat[0]);
   }
