/*)BUILD	$(PROGRAM)	=	ftest3
		$(INCLUDE)	=	pml.h
		$(DTOA)		=	1
		$(UTLIB)	=	C:PML
		$(TKBOPTIONS)	= {
			STACK	=	2000
			TASK	=	...FT3
		}
*/

#include <stdio.h>
#include "c:pmluse.h"
#include "pml.h"

#define cdiv_table cdvtb
#define cmult_table cmltt
#define cadd_table caddtb
#define csubt_table csbtt

double csubt_table[] = {
     1.122999995946884155e00,  2.340000003576278686e00,
     3.560000002384185791e00,  4.100000023841857910e00,
    -2.437000006437301635e00, -1.760000020265579223e00,
    -1.345669999718666076e00,  2.234566986560821533e00,
     3.348675012588500976e00, -4.122219979763031005e00,
    -4.694344997406005859e00,  6.356786966323852539e00,
     3.857562988996505737e-01,  1.000030040740966796e-01,
     3.333939403295516967e00,  4.349979996681213378e00,
    -2.948183119297027587e00, -4.249976992607116699e00,
     1.575757563114166259e00,  0.000000000000000000e00,
     3.378574609756469726e00,  0.000000000000000000e00,
    -1.802817046642303466e00,  0.000000000000000000e00,
    -1.233999997377395629e00, -2.334455549716949462e00,
    -3.000000000000000000e00, -4.000000000000000000e00,
     1.766000002622604370e00,  1.665544450283050537e00,
     1.227000000000000000e04,  1.300000000000000000e03,
     0.000000000000000000e00,  3.452000021934509277e-02,
     1.227000000000000000e04,  1.299965484619140625e03
};

double cadd_table[] = {
     1.122999995946884155e00,  2.340000003576278686e00,
     3.560000002384185791e00,  4.100000023841857910e00,
     4.683000028133392334e00,  6.440000057220458984e00,
    -1.345669999718666076e00,  2.234566986560821533e00,
     3.348675012588500976e00, -4.122219979763031005e00,
     2.003005027770996093e00, -1.887652993202209472e00,
     3.857562988996505737e-01,  1.000030040740966796e-01,
     3.333939403295516967e00,  4.349979996681213378e00,
     3.719695717096328735e00,  4.449983000755310058e00,
     1.575757563114166259e00,  0.000000000000000000e00,
     3.378574609756469726e00,  0.000000000000000000e00,
     4.954332172870635986e00,  0.000000000000000000e00,
    -1.233999997377395629e00, -2.334455549716949462e00,
    -3.000000000000000000e00, -4.000000000000000000e00,
    -4.234000027179718017e00, -6.334455549716949462e00,
     1.227000000000000000e04,  1.300000000000000000e03,
     0.000000000000000000e00,  3.452000021934509277e-02,
     1.227000000000000000e04,  1.300034515380859375e03
};

double cmult_table[] = {
     1.122999995946884155e00,  2.340000003576278686e00,
     3.560000002384185791e00,  4.100000023841857910e00,
    -5.596120119094848632e00,  1.293470001220703125e01,
    -1.345669999718666076e00,  2.234566986560821533e00,
     3.348675012588500976e00, -4.122219979763031005e00,
     4.705165147781372070e00,  1.302998638153076171e01,
     3.857562988996505737e-01,  1.000030040740966796e-01,
     3.333939403295516967e00,  4.349979996681213378e00,
     8.510770574212074279e-01,  2.011436134576797485e00,
     1.575757563114166259e00,  0.000000000000000000e00,
     3.378574609756469726e00,  0.000000000000000000e00,
     5.323814511299133300e00,  0.000000000000000000e00,
    -1.233999997377395629e00, -2.334455549716949462e00,
    -3.000000000000000000e00, -4.000000000000000000e00,
    -5.635822236537933349e00,  1.193936669826507568e01,
     1.227000000000000000e04,  1.300000000000000000e03,
     0.000000000000000000e00,  3.452000021934509277e-02,
    -4.487600040435791015e01,  4.235604019165039062e02
};

double cdiv_table[] = {
     1.122999995946884155e00,  2.340000003576278686e00,
     3.560000002384185791e00,  4.100000023841857910e00,
     4.609979800879955291e-01,  1.263787318021059036e-01,
    -1.345669999718666076e00,  2.234566986560821533e00,
     3.348675012588500976e00, -4.122219979763031005e00,
    -4.863302707672119140e-01,  6.862613558769226074e-02,
     3.857562988996505737e-01,  1.000030040740966796e-01,
     3.333939403295516967e00,  4.349979996681213378e00,
     5.729839205741882324e-02, -4.476501746103167533e-02,
     1.575757563114166259e00,  0.000000000000000000e00,
     3.378574609756469726e00,  0.000000000000000000e00,
     4.663971476256847381e-01,  0.000000000000000000e00,
    -1.233999997377395629e00, -2.334455549716949462e00,
    -3.000000000000000000e00, -4.000000000000000000e00,
     5.215928852558135986e-01,  8.269466646015644073e-02,
     1.227000000000000000e04,  1.300000000000000000e03,
     0.000000000000000000e00,  3.452000021934509277e-02,
     3.765932763671875000e04, -3.554461171875000000e05
};

struct test {
    double (*func)();
    double *table;
    int entries;
    char *name;
};

eval(fpntr)
register struct test *fpntr;
{
    double dabs();
    COMPLEX val1, val2, ref, err, aerr, amax, v1;
    register double *tblpntr;
    register int idx;

    amax.real = amax.imag = 0.0;
    tblpntr = fpntr->table;
    for (idx = 0; idx < fpntr->entries; idx++ ) {
	val1.real = *tblpntr++;
	val1.imag = *tblpntr++;
	val2.real = *tblpntr++;
	val2.imag = *tblpntr++;
	ref.real = *tblpntr++;
	ref.imag = *tblpntr++;
	v1.real = val1.real;
	v1.imag = val1.imag;
	(*fpntr->func)(&val1,&val2);
	err.real = (val1.real-ref.real)/ref.real;
	err.imag = (val1.imag-ref.imag)/ref.imag;
	aerr.real = dabs(err.real);
	aerr.imag = dabs(err.imag);
	if (aerr.real > 1.0e-4 || aerr.imag > 1.0e-4) {
#ifdef PDP10
	    printf ("%s error for %f + j %f and %f + j %f\n",
		fpntr->name,v1.real,v1.imag,val2.real,val2.imag);
	    printf ("\tComputed value = %f + j %f\n",val1.real,val1.imag);
	    printf ("\tReference value = %f + j %f\n",ref.real,ref.imag);
	    printf ("\tRelative error = %f + j %f\n",err.real,err.imag);
#else
	    printf ("%s error for %le + j %le and %le + j %le\n",
		fpntr->name,v1.real,v1.imag,val2.real,val2.imag);
	    printf ("\tComputed value = %le + j %le\n",val1.real,val1.imag);
	    printf ("\tReference value = %le + j %le\n",ref.real,ref.imag);
	    printf ("\tRelative error = %le + j %le\n",err.real,err.imag);
#endif
	}
	if (aerr.real > amax.real) {
	    amax.real = aerr.real;
	}
	if (aerr.imag > amax.imag) {
	    amax.imag = aerr.imag;
	}
    }
#ifdef PDP10
    printf ("\t%s:\terrmax = %f real %f imag\n",fpntr->name,amax.real,amax.imag);
#else
    printf ("\t%s:\terrmax = %le real %le imag\n",fpntr->name,amax.real,amax.imag);
#endif
}

struct test tests[] = {
    &cadd,&cadd_table,6,"CADD",
    &csubt,&csubt_table,6,"CSUBT",
    &cmult,&cmult_table,6,"CMULT",
    &cdiv,&cdiv_table,6,"CDIV",
    0,0,0,0
};


main()
{
    register struct test *tp;

    tp = &tests[0];
    while (tp->func) {
	eval(tp);
	tp++;
    }
}

