/*
 *			f p u t s . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION


title	fputs	Output a string to a file
index		fputs - Output a string to a file
index		puts - Output a string to stdout

synopsis
	.s.nf
	puts(buffer);
	char		*buffer;

	fputs(buffer, iop);
	char		*buffer;
	FILE		*iop;

	fputss(buffer, iop);
	char		*buffer;
	FILE		*iop;
	.s.f
Description

	puts() writes a string to the standard output.  It appends
	a newline after the string.

	fputs() writes a string to the indicated file.  No newline
	is appended.

	fputss() writes a string to the indicated file.  A newline
	is appended.

Bugs

#endif

#include	<stdio.h>
#define	EOS	'\0'			/* native stdio.h doesn't define EOS */

fputs(buffer, iop)
register char	*buffer;
register FILE	*iop;
/*
 * Output a string
 */
{
	register int	c;
	while ((c = *buffer++) != EOS)
	    putc(c, iop);
}

fputss(buffer, iop)
char		*buffer;
FILE		*iop;
/*
 * Output a string, followed by a newline
 */
{
	fputs(buffer, iop);
	putc('\n', iop);
}

puts(buffer)
char		*buffer;
/*
 * Output a string to stdout
 */
{
	fputss(buffer, stdout);
}
