.;
.; This is the BRUTK50 command file which allows users and the system manager
.; to use the BRU utility for backing up and restoring files to/from a TK50
.; magnetic tape drive.  Note that this procedure is based on a paper in the
.; January 1988, page 70, issue of the DEC Professional.
.;
.; Although the original procedure was developed for an RSX system, it is easily
.; modifiable to suit your own purposes (RSX-11M+, other devices, etc.)
.; 
.; Command files called from BRUTK50 are:
.;
.;	None
.;
.; Programs or utilities this routine is dependent on:
.;
.;	BRU, SRD
.;
.; Data files this routine is dependent on:
.;
.;	[1,54]CLEAR.DAT	(Homes cursor and clears screen.)
.;	[1,54]BELL.DAT  (Rings bell on terminal when operation done.)
.;	[3,54]BACKUP.LOG (Log of incremental backup sets, date, time, etc.)
.;
.; National Food Laboratory (NFL)
.; a.k.a. National Food Processors Association
.; 6363 Clark Avenue
.; Dublin, CA 94568
.; (415)828-1440
.;
.; Created by Doug Sasseen on  5-10-88.
.; Revised by Doug Sasseen on  6-24-88 from RSX-11M to RSX-11M-Plus.
.; Last edited by Doug Sasseen on 9-29-88.
.;
.top:
	.enable quiet
	.enable substitution
	.disable lowercase
	.enable control-z
	.;
	.SETS	UFD	"'<UIC>'"
	.SETS	DEV	"'<SYDISK>''<SYUNIT>':"
	.sets	time	<TIME>
	.sets	date	<DATE>
	.setf	hold
	.;
	ALLOCATE MU0:
	.; Tell user what he is running.
	.;
	.disable quiet
	;
	; BRUTK50 --- TK50 Tape Backup and Restore Facility
	;             Now running at 'time' on 'date'
	;
	.enable quiet
	;
	;	This is BRUWORK.CMD.  Please insure that a tape is installed on
	;	the system tape drive.  If a tape is not installed, and you run
	;	this command file, the system may lock up.  If the system locks
	;	up, it will have to be crashed and rebooted.
	;
	.ASK	NULL	Is a tape installed on the tape drive...
	.IFF	NULL	.GOTO 999
	.;
	.;	Mount the tape drive as foreign.
	mount mu0:/foreign
	.;
.001:
	.; Home cursor, clear screen.
	type [1,54]clear.dat
.002:
	.disable quiet
	;
;			THIS IS THE MAIN MENU
;		CHOOSE ONE OF THE FOLLOWING OPTIONS:
;
;	L   (LIST)	LIST THE CONTENTS OF A BRU CREATED TAPE
;	B   (BACKUP)    BACKUP FILES FROM DISK TO TAPE
;	R   (RECOVER)   RECOVER FILES FROM TAPE TO DISK
;	S   (SUPERUSER) SYSTEM MANAGER OPTIONS
;	E   (EXIT)      EXIT FROM THIS COMMAND FILE
;
	.enable quiet
	.;
	.ASKS	OPTION	ENTER YOU CHOICE...
	.IF	OPTION = "E"  .GOTO 999
	.IF	OPTION <> "L"  .GOTO 200
.100:
	.; Home cursor, clear screen.
	type [1,54]clear.dat
.101:
	.; If 'hold' is TRUE, pause to let user read screen.
	.iff	hold	.goto 101A
		type [1,54]bell.dat
		.asks [:::60m] gonow Press RETURN key when done reading:
.101A:	.setf	hold
	.disable quiet
;
;			THIS IS THE LISTING SUB-MENU
;      	     CHOOSE ONE OF THE FOLLOWING OPTIONS:
;
;	B    (BACKUP SETS) LIST THE BACKUP SET NAMES ON YOUR TAPE
;	F    (FILES)       LIST THE FILES FOR YOUR TAPE AND BACKUP SET
;	E    (EXIT)        RETURN TO THE MAIN MENU
;
	.enable quiet
	.;
	.ASKS	LISOPT  ENTER YOUR CHOICE...
	.IF	LISOPT = "E"   .GOTO 001
	.IF	LISOPT <> "B"  .GOTO 120
	.; Home cursor, clear screen.
	type [1,54]clear.dat
	BRU /REW/DIR MU0:
	.sett	hold
	.GOTO 101
.120:
	.IF	LISOPT <> "F"  .GOTO 130
	.GOSUB 802
	.; Home cursor, clear screen.
	type [1,54]clear.dat
	BRU /REW/BAC:'BNAME'/DIR   MU0:
	.sett	hold
	.GOTO 101
.130:
	.GOSUB 800
	.GOTO 101
.200:
	.IF	OPTION <> "B"   .GOTO 300
	.; If 'hold' is TRUE, pause to let user read screen.
	.iff	hold	.goto 200A
		type [1,54]bell.dat
		.asks [:::60m] gonow Press RETURN key when done reading:
.200A:	.setf	hold
	.; Home cursor, clear screen.
	type [1,54]clear.dat
.201:
	.disable quiet
;
;			THIS IS THE BACKUP SUB-MENU
;		   CHOOSE ONE OF THE FOLLOWING OPTIONS:
;
;	D   (DIRECTORY) BACKUP YOUR ENTIRE DIRECTORY TO TAPE
;	F   (FILES)     BACKUP SPECIFIED FILES TO TAPE
;	E   (EXIT)      RETURN TO THE MAIN MENU
;
	.enable quiet
	.;
	.ASKS	BACOPT   ENTER YOUR CHOICE...
	.IF	BACOPT = "E"   .GOTO 001
	.IF	BACOPT <> "D"  .GOTO 220
	.GOSUB 807
	BRU 'QUAL'/TAP:'TNAME'/BAC:'BNAME' 'DEV''UFD' MU0:
	.sett	hold
	.GOTO 200
.220:
	.IF	BACOPT <> "F"   .GOTO 230
	.GOSUB 807				! GETS TNAME,BNAME,QUAL
	.GOSUB 803				! GETS SPEC
	BRU 'QUAL'/TAP:'TNAME'/BAC:'BNAME' 'DEV''UFD''SPEC' MU0:
	.sett	hold
	.GOTO 200
.230:
	.GOSUB 800
	.GOTO 201
.300:
	.IF	OPTION <> "R"   .GOTO 400
	.; If 'hold' is TRUE, pause to let user read screen.
	.iff	hold	.goto 300A
		type [1,54]bell.dat
		.asks [:::60m] gonow Press RETURN key when done reading:
.300A:	.setf	hold
	.; Home cursor, clear screen.
	type [1,54]clear.dat
.301:
	.disable quiet
;
;			THIS IS THE RECOVER SUB-MENU
;		    CHOOSE ONE OF THE FOLLOWING OPTIONS:
;
;	B   (BACKUP SET) RECOVER ALL FILES FROM A BACKUP SET
;	F   (FILES)      RECOVER SPECIFIED FILES FROM A BACKUP SET
;	E   (EXIT)       RETURN TO THE MAIN MENU
;
	.enable quiet
	.;
	.ASKS	RECOPT   ENTER YOUR CHOICE...
	.IF	RECOPT = "E"   .GOTO 001
	.IF	RECOPT <> "B"  .GOTO 320
	.GOSUB 808				! GETS TNAME,BNAME,QUAL
	BRU 'QUAL'/TAP:'TNAME'/BAC:'BNAME' MU0: 'DEV''UFD'
	.sett	hold
	.GOTO 300
.320:
	.IF	RECOPT <> "F"   .GOTO 330
	.GOSUB 808				! GETS TNAME,BNAME,QUAL
	.GOSUB 803				! GETS SPEC
	BRU 'QUAL'/TAP:'TNAME'/BAC:'BNAME' MU0: 'DEV''UFD''SPEC'
	.sett	hold
	.GOTO 300
.330:
	.GOSUB 800				! DOES MISTAKE MSG
	.GOTO 301
.400:
	.IF	OPTION <> "S"   .GOTO 500
	.; If 'hold' is TRUE, pause to let user read screen.
	.iff	hold	.goto 400A
		type [1,54]bell.dat
		.asks [:::60m] gonow Press RETURN key when done reading:
.400A:	.setf	hold
	.; Home cursor, clear screen.
	type [1,54]clear.dat
.401:
	.disable quiet
;
;			THIS IS THE SUPERUSER SUB-MENU
;	 	      CHOOSE ONE OF THE FOLLOWING OPTIONS
;
;	A   EXIT TO THE MAIN MENU
;	B   BACKUP AN ENTIRE DISK TO TAPE
;	C   BACKUP ACCORDING TO CREATION DATE SPECIFICATION
;	D   BACKUP ACCORDING TO DIRECTORY SPECIFICATION
;	E   BACKUP ACCORDING TO FILE SPECIFICATION
;	F   RECOVER AN ENTIRE BACKUP SET
;	G   RECOVER ACCORDING TO DIRECTORY SPECIFICATION
;	H   RECOVER ACCORDING TO FILE SPECIFICATION
;	I   BATCH BACKUP ENTIRE DISK TO TAPE
;	J   BATCH BACKUP ACCORDING TO CREATION DATE
;	K   EXAMINE BACKUP LOG FILE
;
	.enable quiet
	.;
	.ASKS	SUPOPT   ENTER YOUR CHOICE...
	.IF	SUPOPT = "A"   .GOTO 001
	.IF	SUPOPT <> "B"  .GOTO 420
	.GOSUB 807				! GETS TNAME,BNAME,QUAL
	.GOSUB 804				! GETS SDEV
	BRU 'QUAL'/TAP:'TNAME'/BAC:'BNAME' 'SDEV' MU0:
	.sett	hold
	.GOTO 400
.420:
	.IF	SUPOPT <> "C"   .GOTO 430
	.GOSUB 807				! GETS TNAME,BNAME,QUAL
	.GOSUB 806				! GETS DATE,TEMP
	.GOSUB 804				! GETS SDEV
	.; NFL code added here to assist with daily incremental backups.
	.;
	.; See if user wants to print two copies of SRD directory of all files 
	.; created since day before last incremental backup.
		.ask direct Would you like a directory printout for the backup
		.iff direct .goto 420A
		srd incr.dat=[*,*]*.*;*/mi/af:'date'/tb
		.;Create a header to put at top of directory file.
		.open #1 head.dat
		.data #1
		.data #1 Backup Set:  'bname'                    '<DATE>'
		.data #1 All system disk files created since 'date'
		.data #1
		.close #1
		.;Now, merge the header and directory files.
		pip daily.dir=head.dat,incr.dat/me
		print/queue:tt7/delete/noj/co:2 daily.dir
		delete incr.dat;*
		delete head.dat;*
.420A:
	.;
	.; Second, put an entry into the [3,54]backup.log file to show when this
	.; backup was made, the tape label, backup set name, and the reference
	.; date (files copied since reference date).
		.opena #1 [3,54]backup.log
		.data #1 *'bname'*'<DATE>'*'<TIME>'*'date'*'tname'*
		.close #1
	BRU 'QUAL'/TAP:'TNAME'/BAC:'BNAME'/CRE:'TEMP''DATE' 'SDEV' MU0:
	.sett	hold
	.GOTO 400
.430:
	.IF	SUPOPT <> "D"   .GOTO 440
	.GOSUB 807				! GETS TNAME,BNAME,QUAL
	.GOSUB 804				! GETS SDEV
	.GOSUB 805				! GETS SUFD
	BRU 'QUAL'/TAP:'TNAME'/BAC:'BNAME' 'SDEV''SUFD' MU0:
	.sett	hold
	.GOTO 400
.440:
	.IF	SUPOPT <> "E"   .GOTO 450
	.GOSUB 807				! GETS TNAME,BNAME,QUAL
	.GOSUB 804				! GETS SDEV
	.GOSUB 805				! GETS SUFD
	.GOSUB 803				! GETS SPEC
	BRU 'QUAL'/TAP:'TNAME'/BAC:'BNAME' 'SDEV''SUFD''SPEC' MU0:
	.sett	hold
	.GOTO 400
.450:
	.IF	SUPOPT <> "F"   .GOTO 460
	.GOSUB 808				! GETS TNAME,BNAME,QUAL
	.GOSUB 804				! GETS SDEV
	BRU 'QUAL'/TAP:'TNAME'/BAC:'BNAME' MU0: 'SDEV'
	.sett	hold
	.GOTO 400
.460:
	.IF	SUPOPT <> "G"   .GOTO 470
	.GOSUB 808				! GETS TNAME,BNAME,QUAL
	.GOSUB 804				! GETS SDEV
	.GOSUB 805				! GETS SUFD
	BRU 'QUAL'/TAP:'TNAME'/BAC:'BNAME' MU0: 'SDEV''SUFD'
	.sett	hold
	.GOTO 400
.470:
	.IF	SUPOPT <> "H"   .GOTO 472
	.GOSUB 808				! GETS TNAME,BNAME,QUAL
	.GOSUB 804				! GETS SDEV
	.GOSUB 805				! GETS SUFD
	.GOSUB 803				! GETS SPEC
	BRU 'QUAL'/TAP:'TNAME'/BAC:'BNAME' MU0: 'SDEV''SUFD''SPEC'
	.sett	hold
	.GOTO 400
.472:
	.if	supopt <> "I"	.goto 474
	.gosub 807				! Gets TNAME,BNAME,QUAL
	.gosub 804				! Gets SDEV
	;Before doing Batch backup, deallocate and dismount tape drive.
	dismount mu0:
	deallocate mu0:
	.open system.bat			! Create batch file
		.data $job/time:(2:00) [7,227]
		.data $on warning then goto reset
		.data $on error then goto reset
		.data $! Batch file to backup system disk to TK50 tape
		.data $set terminal/mcr
		.data $set /colog=off
		.data $eli /nolog
		.data $allocate mu0:
		.data $mount mu0:/for
		.data $bru 'qual'/tap:'tname'/bac:'bname' 'sdev' mu0:
		.data $dmo mu0:
		.data $deallocate mu0:
		.data $reset:
		.data $set /colog=on
		.data $set /colog/nocoterm
		.data $eli /log
		.data $set /dcl=ti:
		.data $eoj
	.close
	purge system.bat
	submit system.bat
	.exit
.474:
	.if	supopt <> "J"	.goto 476
	.gosub 807				! Gets TNAME,BNAME,QUAL
	.gosub 806				! Gets DATE,TEMP
	.gosub 804				! Gets SDEV
	;Before doing Batch backup, deallocate and dismount tape drive.
	dismount mu0:
	deallocate mu0:
	.open credate.bat			! Create batch file
		.data $job/time:(2:00) [7,227]
		.data $on warning then goto reset
		.data $on error then goto reset
		.data $! Batch file to backup system disk by creation date
		.data $set terminal/mcr
		.data $set /colog=off
		.data $eli /nolog
		.data $allocate mu0:
		.data $mount mu0:/for
	.data $bru 'qual'/tap:'tname'/bac:'bname'/cre:'temp''date' 'sdev' mu0:
		.data $dmo mu0:
		.data $deallocate mu0:
		.data $reset:
		.data $set /colog=on
		.data $set /colog/nocoterm
		.data $eli /log
		.data $set /dcl=ti:
		.data $eoj
	.close
	purge credate.bat
	submit credate.bat
	.exit
.476:
	.if	supopt <> "K"	.goto 478
	type [3,54]backup.log
	.sett	hold
	.goto 400
.478:
	.gosub 800				! Does mistake message
	.goto 400
.480:
	.GOSUB 800				! DOES MISTAKE MSG
	.GOTO 401
.500:
	.GOSUB 800				! DOES MISTAKE MSG
	.GOTO 002
.800:
	.; Home cursor, clear screen.
	type [1,54]clear.dat
	.;
	.disable quiet
	;
	;	YOU HAVE MADE AN INVALID CHOICE, TRY AGAIN.
	;
	.enable quiet
	.;
	.RETURN
.801:
	.disable quiet
	;
	;	What is the TAPE LABEL of your tape?
	;	(The TAPE LABEL is limited to 6 characters)
	;
	.enable quiet
	.;
	.ASKS	TNAME   Enter the TAPE LABEL...
	.RETURN
.802:
	.disable quiet
	;
	;	What is the BACKUP SET name you want to use?
	;	(The BACKUP SET is limited to 12 characters)
	;
	.enable quiet
	.;
	.ASKS	BNAME   Enter the BACKUP SET name...
	.RETURN
.803:
	.; Home cursor, clear screen.
	type [1,54]clear.dat
	.;
	.disable quiet
	;
	;	What FILE SPECIFICATION do you want to use?
	;
	;	A FILE SPEC has the form:	NAME.EXT;VER.
	;
	;	An '*' can be used as a WILDCARD to replace WHOLE WORDS.
	;	Examples:  NAME.FTN;* or NAME.*;* or *.FTN;*
	;
	;	You may leave off parts of the FILE SPEC starting from
	;	the right.  BRU treats any OMITTED part as a WILDCARD.
	;
	;	Thus NAME.FTN = NAME.FTN;* and NAME = NAME.*;*
	;	and NO FILE SPEC AT ALL is the same as *.*;*
	;
	.enable quiet
	.;
	.ASKS	SPEC   Enter the FILE SPECIFICATION
	.RETURN
.804:
	.disable quiet
	;
	;	What DISK are you transferring TO/FROM?
	;	The DISK DEVICE CODE has the form:  DU#:
	;
	.enable quiet
	.;
	.ASKS	SDEV   Enter the DISK DEVICE CODE...
	.RETURN
.805:
	.disable quiet
	;
	;	What USER DIRECTORY are you transferring TO/FROM?
	;	The DIRECTORY must be entered in the form:  [#,#]
	;	The "*" can be used as a WILDCARD to replace a "#"
	;
	.enable quiet
	.;
	.ASKS	SUFD   Enter the DIRECTORY...
	.RETURN
.806:
	.disable quiet
	;
	;	What REFERENCE DATE do you want to use?
	;	The DATE must be entered in the form   DD-MMM-YY
	;
	.enable quiet
	.;
	.ASKS	DATE   Enter the DATE...
	.SETS	TEMP     "BEFORE:"
	.;
	.disable quiet
	;
	;	Are you transferring files created BEFORE or AFTER the
	;	REFERENCE DATE?  This command file assumes you mean
	;	files created BEFORE the REFERENCE DATE, unless you
	;	answer "Y" for YES below.
	;
	.enable quiet
	.;
	.ASK	BORA	Backup files created AFTER the REFERENCE DATE...
	.IFT	BORA	.SETS   TEMP	"AFTER:"
	.RETURN
.807:
	.GOSUB 801				! GETS TNAME
	.GOSUB 802				! GETS BNAME
	.SETS	QUAL	"/REW/MOU/APP"
	.;
	.disable quiet
	;
	;	Are you APPENDING to a tape or INITIALIZING it?
	;	This command file assumes you are APPENDING
	;	unless you answer "Y" for YES below.
	;
	.enable quiet
	.;
	.ASK	NEW	INITIALIZE the tape...
	.iff	new	.return
	.;
	.;Be sure that user really wants to initialize tape.
	.setf	ver
	.ask ver Do you wish to ABORT tape INITIALIZATION?
	.ift	ver   .goto 002
	.;	
	.IFT	NEW   .SETS	QUAL	"/REW/MOU"
	.RETURN
.808:
	.GOSUB 801				! GETS TNAME
	.GOSUB 802				! GETS BNAME
	.SETS	QUAL	"/REW/NOI/UFD"
	.RETURN
.999:
	dismount mu0:
	deallocate mu0:
	.ask rep Would you like to run another tape
	.ift	rep	.goto top
	.exit 
