* AUTOMATIC TEST FOR HEX FILE EDITOR
* ==================================
* This test should run to all but the very last line, or exit at the last if
* you make no edits.
HELP
.
*
* First clean up after any previous runs. You must issue the commands
* indicated manually if your system, or this HEX build, does not support
* parent/offspring tasking.
*
.PIP TEMP.*;*/SD/NM
$PIP HEXTEST.OBJ;*/NM/DE
.MAC HEXTEST
INIT
OFFSET 0000
FORMAT INTEL
* DEC object format -- sets bytes 0-1000 with their addresses mod $FF
FORMAT OBJECT
READ FILE HEXTEST
DISPLAY FROM 0000 THRU 0100
DISPLAY ASCII FROM 0400 THRU 0500
*
NAME
NAME TESTHEX
TRANSFER
TRANSFER 1234
WRITE FROM 0000 THRU 0500 FILE TEMP
COMPARE FILE TEMP
*
* Try other formats and address ranges
*
format intel
format
write from 0001 thru 0500 file temp
compare file temp
*
FORMAT MOTOROLA
NAME HEXTEST
NAME
TRANSFER
WRITE FROM 0010 THRU 04FF FILE TEMP
NOECHO
COMPARE FILE TEMP
ECHO
*
FORMAT ROCKWELL
WRITE FROM 0100 THRU 0500 FILE TEMP
NOECHO
COMPARE FILE TEMP
ECHO
*
FORMAT RCA
WRITE FROM 0005 THRU 0500 FILE TEMP
NOECHO
COMPARE FILE TEMP
ECHO
*
FORMAT TEKHEX
WRITE FROM 0000 THRU 0500 FILE TEMP
NOECHO
COMPARE FILE TEMP
ECHO
*
OFFSET 030000
FORMAT INTEL
WRITE FROM 030000 THRU 030500 FILE TEMP
NOECHO
COMPARE FILE TEMP
ECHO
*
OFFSET C00000
FORMAT EXTENDED
WRITE FROM C00000 THRU C00500 FILE TEMP
FORMAT EXTENDED TEKHEX
NOECHO
COMPARE FILE TEMP
ECHO
*
OFFSET 0000
FORMAT TEXAS
WRITE FROM 0000 THRU 04FF PLUS 4321 FILE TEMP
COMPARE FROM 0000 THRU 04FF MINUS 4321 FILE TEMP
*
OFFSET 80000000
FORMAT MOSTEK
WRITE FROM 80000000 THRU 80000500 FILE TEMP
NOECHO
COMPARE FILE TEMP
ECHO
*
OFFSET 010000
FORMAT WHITESMITHS
WRITE FROM 010000 THRU 010500 FILE TEMP
NOECHO
COMPARE FILE TEMP
ECHO
*
OFFSET 0000
FORMAT HEX
WRITE EVEN FROM 0000 THRU 0500 FILE TEMP
NOECHO
COMPARE FROM 0000 THRU 0501 STEP 02 FILE TEMP
ECHO
*
FORMAT HEX SMS
WRITE FROM 0000 THRU 0500 FILE TEMP
NOECHO
COMPARE FILE TEMP
ECHO
*
FORMAT OCTAL '
WRITE FROM 0011 THRU 0500 STEP 02 FILE TEMP
NOECHO
COMPARE ODD FROM 0010 THRU 0500 FILE TEMP
ECHO
*
FORMAT TCI
WRITE FROM 0200 THRU 0500 MINUS 0123 FILE TEMP
COMPARE PLUS 0123 FILE TEMP
*
FORMAT FAIRCHILD
WRITE FROM 0000 THRU 0500 FILE TEMP
NOECHO
COMPARE FILE TEMP
ECHO
*
FORMAT SIRA
WRITE FROM LOW THRU HIGH FILE TEMP
NOECHO
COMPARE FROM LOW THRU HIGH FILE TEMP
ECHO
*
FORMAT ABSOLUTE
WRITE FROM 0000 THRU 0500 FILE TEMP
NOECHO
COMPARE FILE TEMP
ECHO
*
FORMAT TASK
WRITE FROM 0000 THRU 0500 FILE TEMP
NOECHO
COMPARE FILE TEMP
ECHO
*
* Test USE FOR READ, and memory-to-memory compares
*
COPY FROM 0000 THRU 04FF STEP 02 TO 2000
USE 01 OF 02 FOR READ
COMPARE PLUS 2000 FILE TEMP
COMPARE FROM 2000 THRU 2200 WITH 0000
USE 02 OF 02 FOR READ
COMPARE FROM 2001 THRU 2200 WITH 0001
USE 01 OF 01 FOR READ
*
* Try a few complementary arithmetic operations.
*
ROTATE LEFT FROM 0000 THRU 0500 BY 02
ROTATE RIGHT FROM 0000 THRU 0500
ROTATE RIGHT FROM 0000 THRU 0500 BY 01
COMPARE FILE TEMP
COPY FROM 0000 THRU 0500 TO 3000
INCREMENT FROM 0000 THRU 0500
DECREMENT FROM 0000 THRU 0500
COMPARE FROM 0000 THRU 0500 WITH 3000
COMPLEMENT FROM 0000 THRU 0500
COMPLEMENT FROM 0000 THRU 0500
COMPARE FROM 0000 THRU 0500 WITH 3000
; Negate is complement and add 1
NEGATE FROM 0000 THRU 0500
COMPLEMENT FROM 0000 THRU 0500
INCREMENT FROM 0000 THRU 0500
COMPARE FROM 0000 THRU 0500 WITH 3000
*
; As memory is loaded with a count, REVERSE has the same effect as COMPLEMENT.
COMPLEMENT FROM 0000 THRU 04FF
REVERSE FROM 0000 THRU 04FF
COMPARE FROM 0000 THRU 0500 WITH 3000
*
* Clear hi nybble of every even address for 12-bit formats in several
* different ways.
REMAINDER EVEN FROM 0000 THRU 00FF WITH 10
SHIFT LEFT FROM 0100 THRU 01FF STEP 02 BY 04
DIVIDE FROM 0100 THRU 01FF STEP 02 BY 10
AND EVEN FROM 0200 THRU 0500 WITH 0F
*
FORMAT RIM
WRITE FROM 0000 THRU 0500 FILE TEMP
NOECHO
COMPARE FILE TEMP
ECHO
*
FORMAT BIN
; Note that we can read RIM files in BIN format and vice-versa
NOECHO
COMPARE FILE TEMP.RIM
ECHO
WRITE FROM 0000 THRU 0500 FILE TEMP
NOECHO
COMPARE FILE TEMP
ECHO
FORMAT RIM
NOECHO
COMPARE FILE TEMP.BIN
ECHO
*
* SEARCH should find 0005 matches at addresses xxx1
*
SEARCH FROM 0000 THRU 0500 FOR ^A
*
* SUM should report 518F, and put the result at address 2000
*
SUM FROM 0000 THRU 0500 TO %50
MOVE WORD FROM %50 TO 2000
DISPLAY FROM 2000 THRU 2001
*
* CSUM should report 0E0F, and form a CSUM block at 0501 containing:
*	00 01 0F 0E
*
CSUM FROM 0100 THRU 0500
DISPLAY FROM 0501 THRU 0501
*
* CRC should report 28DB
*
CRC FROM 0000 THRU 0500
*
* Inspect or edit a byte and make sure compare finds any edits.
* Editing should cause the command file to abort.
*
* This command file has created several TEMP.*;* output files.
* You may wish to delete them, and HEXTEST.OBJ, when you exit.
*
EDIT 0300
COMPARE FILE TEMP
*
* If you changed anything in the file, you should not have reached here.
* If you made no changes, the command file will now exit.
EXIT
