.; Magtape operations.
.;   Adapted from Ira A Caplan, "The Multi-tasker", V15 No7 pp44-54 (Feb 1982).
.;
	.GOSUB INIT
	;
	; If you wish to delete or replace files on the tape, your scratch scratch
	; directory on SP: must be empty, or contain only files to be copied to tape.
	;
	; Answer the next question with ctrl/Z to exit if not.
	; 
.2:	.ASKS [::"ANSI"] P1 ANSI or DOS
	.SETS P1 P1[1:1]
	.IF P1 <> A .AND .IF P1 <> D .GOTO 2
	.IF P1 = A .SETT ANSI
	.IF P1 = D .SETF ANSI
.; Get tape number and allocate tape.
	.IFF ANSI .GOTO 5
	.GOSUB ANSTAP
	.GOTO 7
.5:	;
	; WARNING: It is assumed that filetypes determine DOS copy mode.
	;
	.ASK YN Load tape, set online, press enter
.7:	'MCR'ALL MM:
	.IF <EXSTAT> <> 1 .EXIT 2
	;
	; Start operations entry.
	;
.10:	.ASK NUTAPE Creating new tape only
	.SETN OPNO 1.
	.GOSUB OPRGET
.20:	.GOSUB OPRSHO
	.GOSUB VERIFY
	.IFF SOPOK .GOTO 20
	.IFF AOPOK .GOTO 10
	;
	; End operations entry.
	;
	.ASK DIREC Do you want a magtape directory listing
	;
	; Start operations at '<TIME>'.
	;
	.ASK LOGOFF Log off when finished
	.IFT LOGOFF SET /SLAVE=TI:
	.IFT DCL SET CLI MCR
.;
.; Direct copying can be done if there are no delete or replace operations.
	.SETF SORT
	.SETF REWRIT
	.SETF OVERWR
	.IFT NUTAPE .GOTO 30
	.SETN OPNO 0.
.21:	.INC OPNO
	.IFNDF $OP'OPNO' .GOTO 40
	.SETS OPER $OP'OPNO'
	.IF OPER <> R .AND .IF OPER <> D .GOTO 21
	.SETT REWRIT
	.ASK OVERWR Overwrite this tape
	.ASK SORT Order files by name on new tape
.23:	;
	; Clear scratch directory on SP:
	;
	PIP SP:*.*;*/SD/NM
	.IFT LOGOFF .AND .IFT OVERWR ; ** All further operations are automatic. **
	MOU MM:'TAPE'
	.IFF ANSI .GOTO 25
	PIP SP:=MM:*.*;*
	.IFT OVERWR .GOTO 41
	DMO MM:/LOCK=NO
	.GOSUB ANSTAP
	.IFT LOGOFF ; ** All further operations are automatic. **
	.GOTO 30
.25:	FLX SP:/RS=MM:[*,*]*.*/DO
	.IFF OVERWR .ASK YN Load new tape, press return
	.IFT LOGOFF .AND .IFT OVERWR ; ** All further operations are automatic. **
	.GOTO 40
.30:	MOU MM:/FOREIGN
	.IFF ANSI FLX MM:/DO/ZE/DNS:'DENS'
	.IFT ANSI INI MM:'TAPE'/DENS='DENS'
	DMO MM:/LOCK=NO
.40:	.IFT LOGOFF .AND .IFF OVERWR ; ** All further operations are automatic. **
	MOU MM:'TAPE'
.41:	.SETN OPNO 1.
.50:	.IFNDF $OP'OPNO' .GOTO ALLDUN
	.GOSUB XEQ
	.INC OPNO
	.GOTO 50
.ALLDUN: .IFT SORT SRD SP:/WB
	.IFF ANSI .GOTO 55
	.IFT REWRIT PIP MM:/RW=SP:*.*;*
	.IFT DIREC PIP DIR.LST=MM:*.*;*/LI
	.GOTO 57
.55:	.IFT REWRIT FLX MM:/DO=SP:*.*/RS
	.IFT DIREC FLX DIR.LST=MM:[*,*]/DO/DI
	REW MM:
.57:	DMO MM:
	DEA MM:
	.IFT DIREC PRI DIR.LST
	.IFT REWRIT PIP SP:*.*;*/DE
	;
	; Operation finished at '<TIME>'.
	.IFF LOGOFF ;
	.IFT DCL SET /CLI=TI:DCL
	.IFT LOGOFF BYE
	.ENABLE QUIET
	.EXIT
.;
.; Get list of required operations.
.OPRGET: 
	.SETF NEEDD
	.IFT NUTAPE .SETT NEEDD
	.IFT NUTAPE ; Enter files to add to tape, blank line to end.
	.SETS OPER A
	.IFT NUTAPE .GOTO 71
	.ENABLE ESCAPE
.72:	; Mode	Action
	;  A	Add file(s) to tape
	;  D	Delete file(s) from existing tape
	;  R	Replace file(s) with latest version
	;  T	Transfer file(s) to SY:'<UIC>'
	;  N	No more operations
.75:
	.IFT NUTAPE .GOTO 71
	.ASKS OPER Enter operation [A/D/R/T/N], escape for options
	.IFT <ESCAPE> .GOTO 72
	.SETS OPER OPER[1:1]
.90:	.IF OPER <> N .AND .IF OPER <> "" .GOTO 70
	.DISABLE ESCAPE
	.GOTO 76
.70:	.IF OPER = A .OR .IF OPER = D .OR .IF OPER = R .OR .IF OPER = T .GOTO 71
	; Invalid operation.
	.GOTO 75
.71:	.IF OPER = D .OR .IF OPER = R .SETT NEEDD
	.ASKS FILE Enter file name
	.IFT NUTAPE .AND .IF FILE = "" .GOTO 76
	.IF OPER = D .GOTO 74
.; Do a .TESTFILE to make sure FILE exists, unless wildcards given.
	.TEST FILE "*"
	.IF <STRLEN> = 0 .TEST FILE "%"
	.IF <STRLEN> <> 0 .GOTO 74
	.TESTFILE 'FILE'
	.IF <FILERR> = 1 .GOTO 74
	Error #'<FILERR>'/IND! with '<FILSPC>':
	.GOTO 75
.74:	.SETS $OP'OPNO' OPER
	.SETS $FI'OPNO' FILE
	.INC OPNO
	.GOTO 75
.; Set up tape density if NUTAPE or any D or R operations.
.76:	.IFF NEEDD .RETURN
.77:	.ASKN [::1600.] DENS Recording density, 800 or 1600
	.IF DENS = 1600. .OR .IF DENS = 800. .RETURN
	.GOTO 77
.;
.; Show operation.
.OPRSHO:
	.ENABLE LOWERCASE
	;
	.IFT NUTAPE ; Creating new tape 'TAPE' at 'DENS' bpi
	.SETN OPNO 1.
	.SETN NUM 0.
.115:
	.IFNDF $OP'OPNO' .GOTO SHODUN
	.SETS FILE $FI'OPNO'
	.SETS OPER $OP'OPNO'
	.INC OPNO
	.INC NUM
	.IF OPER = A .SETS OPSHO "Add"
	.IF OPER = D .SETS OPSHO "Delete"
	.IF OPER = R .SETS OPSHO "Replace"
	.IF OPER = T .SETS OPSHO "Transfer"
; 'NUM'.	'OPSHO' 'FILE'
	.GOTO 115
.SHODUN:
	;
	.DISABLE LOWERCASE
	.RETURN
.;
.; Verify required operations.
.VERIFY:
	.SETT AOPOK
	.SETT SOPOK
	.IF OPNO = 0 .RETURN
	.ENABLE ESCAPE
.130:
	; Type return when all entries correct, escape to change all.
	.ASKN [1.:'OPNO'-1:1] OPFIX Number of entry to change
	.DISABLE ESCAPE
	.IFT <DEFAUL> .RETURN
	.IFF <ESCAPE> .GOTO 140
	  .SETF AOPOK
	  .; The only global symbols are $OPn and $FIn. ERASing GLOBAL therefore
	  .; clears the table.
	  .ERASE GLOBAL
	  .RETURN
.140:	.SETF SOPOK
	.SETS NUOP "A"
	.IFT NUTAPE .GOTO 141
	.ASKS NUOP Enter operation [A/D/R/T]
	.IF OPER = A .OR .IF OPER = D .OR .IF OPER = R .OR .IF OPER = T .GOTO 141
	; Invalid operation.
	.GOTO 140
.141:	.ASKS NUFIL Enter file
	.SETS $OP'OPFIX' NUOP
	.SETS $FI'OPFIX' NUFIL
	.GOTO 130
.;
.; Execute commands.
.XEQ:	.SETS FILE $FI'OPNO'
	.SETS OPER $OP'OPNO'
	.IF OPER <> A .GOTO XEQD
	  .IFT REWRIT PIP SP:/NV='FILE'
	  .IFT REWRIT .GOTO XEQDUN
	  .IFT ANSI PIP MM:='FILE'
	  .IFF ANSI FLX MM:/DO'RW'='FILE'/RS
	  .SETS RW "/-RW"
	  .GOTO XEQDUN
.XEQD:
	.IF OPER = D PIP SP:'FILE';*/DE/LD/NM
	.IF OPER <> R .GOTO XEQT
	  PIP SP:'FILE';*/DE/NM
	  PIP SP:='FILE'
	  .GOTO XEQDUN
.XEQT:
	.IF OPER <> T .GOTO XEQDUN
	  .IFT REWRIT PIP /NV=SP:'FILE'
	  .IFT REWRIT .GOTO XEQDUN
	  .IFT ANSI PIP /NV=MM:'FILE'
	  .IFF ANSI FLX /RS=MM:'FILE'/DO
	  .SETS RW "/RW"
.XEQDUN:
	.RETURN
.;
.; Get ANSI magtape volume number when tape ready.
.ANSTAP: .ASKN [1.:999.] NUM Load tape, set online, enter number
	.SETS TAPE "SIR'NUM%ZDR3'"
	.RETURN
.;
.INIT:	.SETS RW ""
	.SETS TAPE "/FOREIGN"
	.SETS A "A"
	.SETS R "R"
	.SETS D "D"
	.SETS T "T"
	.SETS N "N"
	.SETN DENS 1600.
	.SETF DCL
	.IF <CLI> = "DCL" .SETT DCL
	.SETS MCR ""
	.IFT DCL .SETS MCR "MCR "
	.ENABLE SUBSTITUTION,GLOBAL
	.DISABLE LOWERCASE
	.IF P1 <> "HELP" .AND .IF P1 <> "?" .RETURN
	; This file allows you to add files to a tape, delete files from a tape,
	; replace tape files with their  latest versions, or transfer files from
	; tape to disk. You can specify as many operations as you want, and they
	; will then be carried out in the order you enter them.
	.RETURN
