	.TITLE	.MAIN
	.ENABL	LC
;
; Author: C J Doran, Sira Ltd., South Hill, Chislehurst, Kent, BR7 5EH, England.
;
; Patch to _main for RT-11 V5. Under this version of RT-11, command lines
; passed from a .COM file (as used by the C compiler system) get converted to
; upper case, so switches are rejected by C, and NOTHING works!! This patch
; converts the line read back to (all) lower-case. It should be considered as
; in RT-11, which should recognise the setting of bit 14 in the JSW to suppress
; the case conversion. Until DEC correct this bug, any C programs which expect
; lower-case command lines should include the patched _main instead of that in
; the library.
;
; Create a new module, LCMAIN.OBJ (say), as:
;
;	.LIBRARY/EXTRACT CLIB MAIN
;	Global? .MAIN
;	Global?			; Blank line reply to get back to monitor
;	.
;	.MACRO/OBJECT:MAIN.POB MAIN.PAT
;	.PAT LCMAIN.OBJ=MAIN.OBJ/C:114025,MAIN.POB/C:12647
;
; Then rebuild the C compiler modules, and any other affected tasks, as:
;
;	.LINK/BOT:5000/STA:5000/EXEC:C CHDR,LCMAIN,C,CLIB	etc.

	.PSECT	C$TEXT,RW,I,LCL,REL,CON
$$$=.
.=.+64
	JSR	PC,PATCH	; Call patch code

	.PSECT	PAT,RW,I,LCL,REL,CON

PATCH:	MOV	%3,%2		; Adress fetched command line
10$:	CMPB	@%2,#'A		; UC letter?
	BLO	20$		; No, test again
	CMPB	@%2,#'Z		; Check top of range
	BHI	20$		; Not letter if not in A-Z
	BISB	#40,@%2		; Letter, change it to lower-case
20$:	TSTB	(%2)+		; Null?
	BNE	10$		; Test next char if not
	MOV	@SP,12(SP)	; Copy up return address
	ADD	#12,SP		; Purge stack after .GTLIN call (replaced instr)
	RTS	PC		; Done

	.END
