!! uniform : float function (Seeds: in out array [1..2] of integer)
!! Version 1.1

!! Purpose:
!! Generate a uniform random number using a combined generator.  The
!! combined generator uses two 32-bit integer values (and updates them
!! each time a new number is generated) stored in global integer
!! variables (SEEDS).
!!
!! This generator has a period approximately equal to 2.305_84e18.
!!
!! This generator will never return either 0.0 or 1.0, as long as the
!! FLOAT (or REAL) variables have at least 23 bits for the fraction
!! part (commonly, but erroneously, called the mantissa).

!!######################################################################
!!#                                                                    #
!!# The procedure Initialize_Uniform initializes the values of the     #
!!# global variables and must be called before Uniform is called.      #
!!#                                                                    #
!!######################################################################

!! Source:
!!     Pierre L'Ecuyer, Efficient and Portable Combined Random Number
!!     Generators, Communications of the ACM, Vol. 31, No. 6 (June 1988),
!!     742-749, 774.

!! Author(s):  James J. Fullerton
!! Creation Date:  22 JUN 88
!! Date Last Approved:  22 JUN 88
!! Revisions (Date, Name, and summary of revision(s)):

!! Pierre L'Ecuyer's Pascal code:
!!
!! s1, s2 : integer {# 32-bit integers #}
!!
!! . . .
!!
!! function Uniform : real
!!   ;var z, k : integer  {# 32-bit integers #}
!! ;begin
!!    k := s1 div 53_668
!!   ;s1 := 40_014 * (s1 - k * 53_668) - k * 12_211
!!   ;if s1 < 0 then s1 := s1 + 2_147_483_563
!!
!!   ;k := s2 div 52_774
!!   ;s2 := 40_692 * (s2 - k * 52_774) - k * 3_791
!!   ;if s2 < 0 then s2 := s2 + 2_147_483_399
!!
!!   ;z := s1 - s2
!!   ;if z < 1 then z := z + 2_147_483_562
!!
!!   ;Uniform := z * 4.656_613e-10
!!
!! end { Uniform }

      real*4 function Uniform (Seeds)

      implicit character*255 (a-z)

      !!----------------------------------------------------------------------
      !! Parameters.
      !!----------------------------------------------------------------------

      !! IN OUT:

      integer*4 Seeds (1:2)	!! List of seed values to use (and update)
				!! to generate the next random variate.

      !!----------------------------------------------------------------------
      !! Local variables.
      !!----------------------------------------------------------------------

      integer*4 z
      integer*4 k

!! begin

      k= Seeds(1) / 53668
      Seeds(1)= 40014 * (Seeds(1) - k * 53668) - k * 12211
      if (Seeds(1) .lt. 0) Seeds(1)= Seeds(1) + 2147483563

      k= Seeds(2) / 52774
      Seeds(2)= 40692 * (Seeds(2) - k * 52774) - k * 3791
      if (Seeds(2) .lt. 0) Seeds(2)= Seeds(2) + 2147483399

      z= Seeds(1) - Seeds(2)
      if (z .lt. 1) z= z + 2147483562

      Uniform= z * 4.656613e-10

      return

      end !! Uniform
