$ !!
$ !! Symbols.com
$ !!
$ !!############################################################################
$ !! This file provides definitions of symbols for terminal escape sequences
$ !! for controlling cursor position, video attributes, erasing, and reading
$ !! keypad and function keys that transmit escape sequences.
$ !!
$ !! This file originated as a VAX/VMS command file at Farm Credit Services, in
$ !! Wichita, KS.  That served as a base to try the same thing on a PDP-11 RSX
$ !! system at the Institute of Logopedics, in Wichita, KS.  The PDP-11 version
$ !! has a large number of new symbols added, and some changes made to existing
$ !! symbols.  VT220 and later model terminals are targeted; VT1xx models can be
$ !! supported by making minor editing changes, as noted below, but not all
$ !! symbols defined herein are recognizable by VT1xx terminals.
$ !!
$ !! For VT1xx terminals, see notes at definitions of SS3 and CSI characters.
$ !!############################################################################
$ !!
$ !!
$ !! Special ASCII character definitions.
$ !!
$	bel[0,7]==	%x07
$	so[0,7]==	%x0E	!! lock G1 graphic set in GL
$	si[0,7]==	%x0F	!! lock G0 graphic set in GL
$	esc[0,7]==	%x1B
$ !!
$ !!	############################################################
$ !!	# For a VT1xx terminal, replace the next line with:
$ !!	#
$ !!	#	$ ss3== "'esc'["
$ !!	############################################################
$ !!
$	ss3[0,7]==	%x8F
$	dcs[0,7]==	%x90
$ !!
$ !!	############################################################
$ !!	# For a VT1xx terminal, replace the next line with:
$ !!	#
$ !!	#	$ csi== "'esc'["
$ !!	############################################################
$ !!
$	csi[0,7]==	%x9B
$	st[0,7]==	%x9C
$ !!
$ !! Keyboard key symbol definitions (8-bit definitions).
$ !!
$ !!
$ !!	Keypad keys:
$ !!
$	PF1==	"'ss3'P"
$	PF2==	"'ss3'Q"
$	PF3==	"'ss3'R"
$	PF4==	"'ss3'S"
$ !!
$	KP0==	"'ss3'p"
$	KP1==	"'ss3'q"
$	KP2==	"'ss3'r"
$	KP3==	"'ss3's"
$	KP4==	"'ss3't"
$	KP5==	"'ss3'u"
$	KP6==	"'ss3'v"
$	KP7==	"'ss3'w"
$	KP8==	"'ss3'x"
$	KP9==	"'ss3'y"
$ !!
$	minus==		"'ss3'm"
$	comma==		"'ss3'l"
$	period==	"'ss3'n"
$	enter==		"'ss3'M"
$ !!
$ !!	Arrow keys:
$ !!
$	up==	"'ss3'A"
$	down==	"'ss3'B"
$	left==	"'ss3'C"
$	right==	"'ss3'D"
$ !!
$ !!	LK201 keys:
$ !!
$	f6==	"'csi'17~"
$	f7==	"'csi'18~"
$	f8==	"'csi'19~"
$	f9==	"'csi'20~"
$	f10==	"'csi'21~"
$ !!
$	f11==	"'csi'23~"
$	f12==	"'csi'24~"
$	f13==	"'csi'25~"
$	f14==	"'csi'26~"
$ !!
$	Help==	"'csi'28~"
$	f15==	"'csi'28~"
$	Do==	"'csi'29~"
$	f16==	"'csi'29~"
$ !!
$	f17==	"'csi'31~"
$	f18==	"'csi'32~"
$	f19==	"'csi'33~"
$	f20==	"'csi'34~"
$ !!
$	find==		"'csi'1"
$	insert==	"'csi'2"
$	remove==	"'csi'3"
$	select==	"'csi'4"
$	prev==		"'csi'5"
$	next==		"'csi'6"
$ !!
$ !! Row positioning symbols (8-bit codes).
$ !!
$	r1==	"'csi'1;1H"
$	r2==	"'csi'2;1H"
$	r3==	"'csi'3;1H"
$	r4==	"'csi'4;1H"
$	r5==	"'csi'5;1H"
$	r6==	"'csi'6;1H"
$	r7==	"'csi'7;1H"
$	r8==	"'csi'8;1H"
$	r9==	"'csi'9;1H"
$	r10==	"'csi'10;1H"
$	r11==	"'csi'11;1H"
$	r12==	"'csi'12;1H"
$	r13==	"'csi'13;1H"
$	r14==	"'csi'14;1H"
$	r15==	"'csi'15;1H"
$	r16==	"'csi'16;1H"
$	r17==	"'csi'17;1H"
$	r18==	"'csi'18;1H"
$	r19==	"'csi'19;1H"
$	r20==	"'csi'20;1H"
$	r21==	"'csi'21;1H"
$	r22==	"'csi'22;1H"
$	r23==	"'csi'23;1H"
$	r24==	"'csi'24;1H"
$ !!
$ !! Column-positioning symbols (8-bit codes).
$ !!
$	c1==	""
$	c2==	"'csi'1C"
$	c3==	"'csi'2C"
$	c4==	"'csi'3C"
$	c5==	"'csi'4C"
$	c6==	"'csi'5C"
$	c7==	"'csi'6C"
$	c8==	"'csi'7C"
$	c9==	"'csi'8C"
$	c10==	"'csi'9C"
$	c11==	"'csi'10C"
$	c12==	"'csi'11C"
$	c13==	"'csi'12C"
$	c14==	"'csi'13C"
$	c15==	"'csi'14C"
$	c16==	"'csi'15C"
$	c17==	"'csi'16C"
$	c18==	"'csi'17C"
$	c19==	"'csi'18C"
$	c20==	"'csi'19C"
$	c21==	"'csi'20C"
$	c22==	"'csi'21C"
$	c23==	"'csi'22C"
$	c24==	"'csi'23C"
$	c25==	"'csi'24C"
$	c26==	"'csi'25C"
$	c27==	"'csi'26C"
$	c28==	"'csi'27C"
$	c29==	"'csi'28C"
$	c30==	"'csi'29C"
$	c31==	"'csi'30C"
$	c32==	"'csi'31C"
$	c33==	"'csi'32C"
$	c34==	"'csi'33C"
$	c35==	"'csi'34C"
$	c36==	"'csi'35C"
$	c37==	"'csi'36C"
$	c38==	"'csi'37C"
$	c39==	"'csi'38C"
$	c40==	"'csi'39C"
$	c41==	"'csi'40C"
$	c42==	"'csi'41C"
$	c43==	"'csi'42C"
$	c44==	"'csi'43C"
$	c45==	"'csi'44C"
$	c46==	"'csi'45C"
$	c47==	"'csi'46C"
$	c48==	"'csi'47C"
$	c49==	"'csi'48C"
$	c50==	"'csi'49C"
$	c51==	"'csi'50C"
$	c52==	"'csi'51C"
$	c53==	"'csi'52C"
$	c54==	"'csi'53C"
$	c55==	"'csi'54C"
$	c56==	"'csi'55C"
$	c57==	"'csi'56C"
$	c58==	"'csi'57C"
$	c59==	"'csi'58C"
$	c60==	"'csi'59C"
$	c61==	"'csi'60C"
$	c62==	"'csi'61C"
$	c63==	"'csi'62C"
$	c64==	"'csi'63C"
$	c65==	"'csi'64C"
$	c66==	"'csi'65C"
$	c67==	"'csi'66C"
$	c68==	"'csi'67C"
$	c69==	"'csi'68C"
$	c70==	"'csi'69C"
$	c71==	"'csi'70C"
$	c72==	"'csi'71C"
$	c73==	"'csi'72C"
$	c74==	"'csi'73C"
$	c75==	"'csi'74C"
$	c76==	"'csi'75C"
$	c77==	"'csi'76C"
$	c78==	"'csi'77C"
$	c79==	"'csi'78C"
$	c80==	"'csi'79C"
$ !!
$ !! Screen control symbol definitions (8-bit definitions).
$ !!
$	Home==		"'csi'H"	!! move cursor to home position
$ !!
$	Big_Top==	"'esc'#3"	!! top half large characters
$	Big_Bot==	"'esc'#4"	!! bottom half large characters
$ !!
$	Erase_Line==	"'csi'2K"	!! erase entire line
$ !!
$	Erase_Screen==	"'csi'2J"	!! erase entire screen
$	Erase_Top==	"'csi'1J"	!! erase top to cursor
$	Erase_Bot==	"'csi'0J"	!! erase cursor to bottom
$ !!
$	Erase_Off==	"'csi'1""q"	!! Set non-erasable attribute
$	Erase_On==	"'csi'1""q"	!! Set erasable attribute
$ !!
$	Select_Line==	"'csi'?2K"	!! selective erase entire line
$ !!
$	Select_Screen==	"'csi'?2J	!! selective erase entire screen
$	Select_Top==	"'csi'?1J	!! selective erase top to cursor
$	Select_Bot==	"'csi'?0J	!! selective erase cursor to bottom
$ !!
$	normal==	"'csi'0m"	!! turn character attributes off
$	bold==		"'csi'1m"	!! set character bold on
$	underline==	"'csi'4m"	!! set character underline on
$	blink==		"'csi'5m"	!! blinking video
$	reverse==	"'csi'7m"	!! set character reverse video on
$ !!
$	transmit_7_bits==	"'esc' F"	!! Terminal transmits 7-bit C1 codes
$	transmit_8_bits==	"'esc' G"	!! Terminal transmits 8-bit C1 codes
$ !!
$	g1_graphics==	"'esc')0"	!! Designate G1 as DEC special graphics
$ !!
$	Application_Pad==	"'esc'="	!! Application Keypad
$	Numeric_Pad==		"'esc'>"	!! Numeric Keypad
$ !!
$	col_80==	"'csi'?3l"	!! 80-column screen width
$	col_132==	"'csi'?3h"	!! 132-column screen width
$ !!
$ !!############################################################################
$ Normal:	subroutine
$ !!
$ !!----------------------------------------------------------------------
$ !! Set the character attributes to normal video.
$ !!
$ !! Call as:  call Normal
$ !!
$ !! Example:  call Normal
$ !!----------------------------------------------------------------------
$ !!
$ write sys$output "''normal'"
$ !!
$ endsubroutine
$ !!############################################################################
$ Down:	subroutine
$ !!
$ !!----------------------------------------------------------------------
$ !! Move the cursor down an indicated number of lines.
$ !!
$ !! Call as:  call Down number_of_lines
$ !!
$ !! Example:  call Down 2
$ !!----------------------------------------------------------------------
$ !!
$ write sys$output "''csi'''p1'B"
$ !!
$ endsubroutine
$ !!############################################################################
$ Up:	subroutine
$ !!
$ !!----------------------------------------------------------------------
$ !! Move the cursor up an indicated number of lines.
$ !!
$ !! Call as:  call Up number_of_lines
$ !!
$ !! Example:  call Up 2
$ !!----------------------------------------------------------------------
$ !!
$ write sys$output "''csi'''p1'A"
$ !!
$ endsubroutine
$ !!############################################################################
$ Scroll:	subroutine
$ !!
$ !!------------------------------------------------------------
$ !! Set the scrolling region, given top and bottom margins.
$ !!
$ !! Call as:  call Scroll top_row_number bottom_row_number
$ !!
$ !! Example:  call Scroll 4 20
$ !!------------------------------------------------------------
$ !!
$ write sys$output "''csi'''p1';''p2'r"
$ !!
$ endsubroutine
$ !!
$ return
