	.disable display
	.enable quiet, lowercase, escape-seq, substitution, control-z

.;##############################################################################
.; This file originated as a VAX/VMS command file at Farm Credit Services, in
.; Wichita, KS.  That served as a base to try the same thing on a PDP-11 RSX
.; system at the Institute of Logopedics, in Wichita, KS.  The PDP-11 version
.; has a large number of new symbols added, and some changes made to existing
.; symbols.  VT220 and later model terminals are targeted; VT1xx models can be
.; supported by making minor editing changes, as noted below, but not all
.; symbols defined herein are recognizable by VT1xx terminals.
.;
.; For VT1xx terminals, see notes at definitions of SS3 and CSI characters.
.;##############################################################################

	.sets dcl "DCL"
	.if dcl = <cli> .sets dcl ""

.;##############################################################################
.; Start of symbol definitions.
.;##############################################################################

.;
.; Special ASCII character definitions.
.;

	.setd $bel
	.setn $bel	7.
	.sets bel	"'$bel%v'"
	.erase symbol $bel

	.setd $so
	.setn $so	14.	;; lock G1 graphic set in GL
	.sets so	"'$so%v'"
	.erase symbol $so

	.setd $si
	.setn $si	15.	;; lock G0 graphic set in GL
	.sets si	"'$si%v'"
	.erase symbol $si

	.setd $esc
	.setn $esc	27.
	.sets esc	"'$esc%v'"
	.erase symbol $esc

	.;############################################################
	.; For a VT1xx terminal, replace the next four lines with:
	.;
	.;	.sets ss3	"'esc'["
	.;############################################################

	.setd $ss3
	.setn $ss3	143.
	.sets ss3	"'$ss3%v'"
	.erase symbol $ss3

	.setd $dcs
	.setn $dcs	144.
	.sets dcs	"'$dcs%v'"
	.erase symbol $dcs

	.;############################################################
	.; For a VT1xx terminal, replace the next four lines with:
	.;
	.;	.sets csi	"'esc'["
	.;############################################################

	.setd $csi
	.setn $csi	155.
	.sets csi	"'$csi%v'"
	.erase symbol $csi

	.setd $st
	.setn $st	156.
	.sets st	"'$st%v'"
	.erase symbol $st

.;
.; Keyboard key symbol definitions (8-bit definitions).
.;

	.;
	.; Keypad keys:
	.;

	.sets PF1	"'ss3'P"
	.sets PF2	"'ss3'Q"
	.sets PF3	"'ss3'R"
	.sets PF4	"'ss3'S"

	.sets KP0	"'ss3'p"
	.sets KP1	"'ss3'q"
	.sets KP2	"'ss3'r"
	.sets KP3	"'ss3's"
	.sets KP4	"'ss3't"
	.sets KP5	"'ss3'u"
	.sets KP6	"'ss3'v"
	.sets KP7	"'ss3'w"
	.sets KP8	"'ss3'x"
	.sets KP9	"'ss3'y"

	.sets minus	"'ss3'm"
	.sets comma	"'ss3'l"
	.sets period	"'ss3'n"
	.sets enter	"'ss3'M"

	.;
	.; Arrow keys:
	.;

	.sets up	"'ss3'A"
	.sets down	"'ss3'B"
	.sets left	"'ss3'C"
	.sets right	"'ss3'D"

	.;
	.; LK201 keys:
	.;

	.sets f6	"'csi'17~"
	.sets f7	"'csi'18~"
	.sets f8	"'csi'19~"
	.sets f9	"'csi'20~"
	.sets f10	"'csi'21~"

	.sets f11	"'csi'23~"
	.sets f12	"'csi'24~"
	.sets f13	"'csi'25~"
	.sets f14	"'csi'26~"

	.sets Help	"'csi'28~"
	.sets f15	"'csi'28~"
	.sets Do	"'csi'29~"
	.sets f16	"'csi'29~"

	.sets f17	"'csi'31~"
	.sets f18	"'csi'32~"
	.sets f19	"'csi'33~"
	.sets f20	"'csi'34~"

	.sets find	"'csi'1"
	.sets insert	"'csi'2"
	.sets remove	"'csi'3"
	.sets select	"'csi'4"
	.sets prev	"'csi'5"
	.sets next	"'csi'6"

.;
.; Row positioning symbols (8-bit codes).
.;

	.sets r1	"'csi'1;1H"
	.sets r2	"'csi'2;1H"
	.sets r3	"'csi'3;1H"
	.sets r4	"'csi'4;1H"
	.sets r5	"'csi'5;1H"
	.sets r6	"'csi'6;1H"
	.sets r7	"'csi'7;1H"
	.sets r8	"'csi'8;1H"
	.sets r9	"'csi'9;1H"
	.sets r10	"'csi'10;1H"
	.sets r11	"'csi'11;1H"
	.sets r12	"'csi'12;1H"
	.sets r13	"'csi'13;1H"
	.sets r14	"'csi'14;1H"
	.sets r15	"'csi'15;1H"
	.sets r16	"'csi'16;1H"
	.sets r17	"'csi'17;1H"
	.sets r18	"'csi'18;1H"
	.sets r19	"'csi'19;1H"
	.sets r20	"'csi'20;1H"
	.sets r21	"'csi'21;1H"
	.sets r22	"'csi'22;1H"
	.sets r23	"'csi'23;1H"
	.sets r24	"'csi'24;1H"

.;
.; Column-positioning symbols (8-bit codes).
.;

	.sets c1	""
	.sets c2	"'csi'1C"
	.sets c3	"'csi'2C"
	.sets c4	"'csi'3C"
	.sets c5	"'csi'4C"
	.sets c6	"'csi'5C"
	.sets c7	"'csi'6C"
	.sets c8	"'csi'7C"
	.sets c9	"'csi'8C"
	.sets c10	"'csi'9C"
	.sets c11	"'csi'10C"
	.sets c12	"'csi'11C"
	.sets c13	"'csi'12C"
	.sets c14	"'csi'13C"
	.sets c15	"'csi'14C"
	.sets c16	"'csi'15C"
	.sets c17	"'csi'16C"
	.sets c18	"'csi'17C"
	.sets c19	"'csi'18C"
	.sets c20	"'csi'19C"
	.sets c21	"'csi'20C"
	.sets c22	"'csi'21C"
	.sets c23	"'csi'22C"
	.sets c24	"'csi'23C"
	.sets c25	"'csi'24C"
	.sets c26	"'csi'25C"
	.sets c27	"'csi'26C"
	.sets c28	"'csi'27C"
	.sets c29	"'csi'28C"
	.sets c30	"'csi'29C"
	.sets c31	"'csi'30C"
	.sets c32	"'csi'31C"
	.sets c33	"'csi'32C"
	.sets c34	"'csi'33C"
	.sets c35	"'csi'34C"
	.sets c36	"'csi'35C"
	.sets c37	"'csi'36C"
	.sets c38	"'csi'37C"
	.sets c39	"'csi'38C"
	.sets c40	"'csi'39C"
	.sets c41	"'csi'40C"
	.sets c42	"'csi'41C"
	.sets c43	"'csi'42C"
	.sets c44	"'csi'43C"
	.sets c45	"'csi'44C"
	.sets c46	"'csi'45C"
	.sets c47	"'csi'46C"
	.sets c48	"'csi'47C"
	.sets c49	"'csi'48C"
	.sets c50	"'csi'49C"
	.sets c51	"'csi'50C"
	.sets c52	"'csi'51C"
	.sets c53	"'csi'52C"
	.sets c54	"'csi'53C"
	.sets c55	"'csi'54C"
	.sets c56	"'csi'55C"
	.sets c57	"'csi'56C"
	.sets c58	"'csi'57C"
	.sets c59	"'csi'58C"
	.sets c60	"'csi'59C"
	.sets c61	"'csi'60C"
	.sets c62	"'csi'61C"
	.sets c63	"'csi'62C"
	.sets c64	"'csi'63C"
	.sets c65	"'csi'64C"
	.sets c66	"'csi'65C"
	.sets c67	"'csi'66C"
	.sets c68	"'csi'67C"
	.sets c69	"'csi'68C"
	.sets c70	"'csi'69C"
	.sets c71	"'csi'70C"
	.sets c72	"'csi'71C"
	.sets c73	"'csi'72C"
	.sets c74	"'csi'73C"
	.sets c75	"'csi'74C"
	.sets c76	"'csi'75C"
	.sets c77	"'csi'76C"
	.sets c78	"'csi'77C"
	.sets c79	"'csi'78C"
	.sets c80	"'csi'79C"

.;
.; Screen control symbol definitions (8-bit definitions).
.;

	.sets home	"'csi'H"	;; move cursor to home position

	.sets BigTop	"'esc'#3"	;; top half large characters
	.sets BigBot	"'esc'#4"	;; bottom half large characters

	.sets EraLin	"'csi'2K"	;; erase entire line

	.sets Erase	"'csi'2J"	;; erase entire screen
	.sets EraTop	"'csi'1J"	;; erase top to cursor
	.sets EraBot	"'csi'0J"	;; erase cursor to bottom

	.sets EraOff	#'csi'1"q#	;; Set non-erasable attribute
	.sets EraOn	#'csi'1"q#	;; Set erasable attribute

	.sets SelLin	"'csi'?2K"	;; selective erase entire line

	.sets SelEra	"'csi'?2J	;; selective erase entire screen
	.sets SelTop	"'csi'?1J	;; selective erase top to cursor
	.sets SelBot	"'csi'?0J	;; selective erase cursor to bottom

	.sets normal	"'csi'0m"	;; turn character attributes off
	.sets bold	"'csi'1m"	;; set character bold on
	.sets under	"'csi'4m"	;; set character underline on
	.sets blink	"'csi'5m"	;; blinking video
	.sets revers	"'csi'7m"	;; set character reverse video on

	.sets tran7	"'esc' F"	;; Terminal transmits 7-bit C1 codes
	.sets tran8	"'esc' G"	;; Terminal transmits 8-bit C1 codes

	.sets g1graf	"'esc')0"	;; Designate G1 as DEC special graphics

	.sets AppPad	"'esc'="	;; Application Keypad
	.sets NumPad	"'esc'>"	;; Numeric Keypad

	.sets col80	"'csi'?3l"	;; 80-column screen width
	.sets col132	"'csi'?3h"	;; 132-column screen width

.;##############################################################################
.; End of symbol definitions.
.;##############################################################################

	.exit

.;##############################################################################
.; Subroutines.
.;##############################################################################

.;----------------------------------------------------------------------
.; Normal:  set the character attributes to normal video.
.;
.; call as:  .gosub Normal
.;----------------------------------------------------------------------

.Normal:

	.disable quiet
;'normal'
	.enable quiet

	.return

.;----------------------------------------------------------------------
.; Down:  move down an indicated number of lines.
.;
.; call as:  .gosub Down NLines
.;----------------------------------------------------------------------

.Down:

	.disable quiet
;'csi''comman%c'B
	.enable quiet

	.return

.;----------------------------------------------------------------------
.; Up:  move up an indicated number of lines.
.;
.; call as:  .gosub Up NLines
.;----------------------------------------------------------------------

.Up:

	.disable quiet
;'csi''comman%c'A
	.enable quiet

	.return

.;----------------------------------------------------------------------
.; Scroll:  set the scroll region, given top and bottom margins.
.;
.; call as:  .gosub Scroll TopRow,BotRow
.;----------------------------------------------------------------------

.Scroll:

	.parse comman "," top bot

	.disable quiet
;'csi''top%c';'bot%c'r
	.enable quiet

	.return
