!! Initialize_Uniform : procedure (value_1, value_2 : integer
!!                                ;seeds : out array [1..2] of integer
!!                                ;success : out boolean)
!! Version 1.1

!! Purpose:
!! Initialize the global integer variables (SEEDS) for use by the
!! random number generator function "Uniform".
!!
!! Initial values range limitations are as follows:
!!		1 <= s1 <= 2_147_483_562
!!		1 <= s2 <= 2_147_483_398
!!
!! This procedure will NOT assign values to the SEEDS array unless
!! both range conditions are satisfied.
!!
!! This procedure will return the value TRUE in SUCCESS if the range
!! conditions are met (initialization is successful), and FALSE otherwise
!! (initialization failed).

!!######################################################################
!!#                                                                    #
!!# This procedure must be called before Uniform is called.            #
!!#                                                                    #
!!######################################################################

!! Source:
!!     Pierre L'Ecuyer, Efficient and Portable Combined Random Number
!!     Generators, Communications of the ACM, Vol. 31, No. 6 (June 1988),
!!     742-749, 774.

!! Author(s):  James J. Fullerton
!! Creation Date:  22 JUN 88
!! Date Last Approved:  08 JUL 88
!! Revisions (Date, Name, and summary of revision(s)):

      subroutine Initialize_Uniform (Value_1, Value_2, Seeds, Success)

      implicit character*255 (a-z)

      !!----------------------------------------------------------------------
      !! Constants.
      !!----------------------------------------------------------------------

      logical TRUE
        parameter (TRUE= .true.)

      logical FALSE
        parameter (FALSE= .false.)

      !!----------------------------------------------------------------------
      !! Parameters.
      !!----------------------------------------------------------------------

      !! IN:

      integer*4 Value_1		!! Values to initialize
      integer*4 Value_2		!! the generator with.

      !! OUT:

      integer*4 Seeds (1:2)	!! List of seed values for use by the
				!! generator function each time a new
				!! random number is requested.

      logical Success		!! Indicates whether initialization was
				!! successful.

      !!----------------------------------------------------------------------
      !! Local variables.
      !!----------------------------------------------------------------------

      logical range_1		!! Indicates whether the range condition for
				!! Value_1 is satisfied.

      logical range_2		!! Indicates whether the range condition for
				!! Value_2 is satisfied.

!! begin

      range_1= (1 .le. Value_1) .and. (Value_1 .le. 2147483562)
      range_2= (1 .le. Value_2) .and. (Value_2 .le. 2147483398)

      if (range_1 .and. range_2) then
        Seeds(1)= Value_1
        Seeds(2)= Value_2
        Success= TRUE

      else
        Success= FALSE

      end if

      return

      end !! Initialize_Uniform
