.;
.; MCEBLD.CMD -- Commandfile to build the MCE commandline editor
.;
.;
.;      Copyright (c) 1987,1988
.;
.;      J.H. Hamakers, 
.;      ASEA Brown Boveri b.v.
.;      P.O.Box 301  3000 AH  Rotterdam, The Netherlands
.;      Phone : +31 - 10 - 4078631
.;      
.;      All rights reserved
.;
.;      This software may be copied and distributed ONLY 
.;      on a non profit basis and with the inclusion of
.;      the above copyright statement.
.;
.;
.;      PLEASE CONTACT ME FOR PROBLEMS OR SUGGESTIONS
.;
.;       +---------------------------------------------------+
.;       | See MCEREL.DOC for information about this release |
.;       +---------------------------------------------------+
.;
.;
.;
        .ENABLE SUBSTITUTION
        .DISABLE DISPLAY
.;
        .SETF  A$SV    ! Conditional for CRW/ASV  Erasmus university Rotterdam
        .IF P1 EQ "ASV" .SETT A$SV
.;
        .SETS VERS "V4.2d"              ! Version
        .SETS HLPUIC "[1,2]"            ! Helpfile UIC
        .SETS SYSUIC <LIBUIC>           ! Task uic
        .SETS INIUIC "[1,2]"            ! Change mce.mac to change uic
        .IFT A$SV .SETS INIUIC "[2,2]"  ! Change mce.mac to change uic
;
;************************
;* M C E B L D . C M D  *
;************************
;
;MCEBLD.CMD -- Commandfile to build the MCE commandline editor
;
.;Version: 'VERS'
.;
.;
        .PARSE  <FILSPC> "]."  DUM PRNAME DUM
.;
.;Test if correct CLI
.;
        .IF <CLI> = "DCL" .SETS CLI "MCR"
        .IF <CLI> = "MCR" .SETS CLI ""
        .IFDF CLI .GOTO 10$
        .DISABLE QUIET
 ;
 ;'PRNAME' -- CLI '<cli>' not supported
 ;
        .EXIT <SEVERE>
.10$:
        .SETF HLP
        .SETF COP
        .SETF INS
        .SETF PRI
        .IF P1 = "MAC" .GOTO MAC
        .IF P1 = "LINK" .GOTO LINK
        .DISABLE QUIET
;
;*****
;
; When your system uses not only MCR as a CLI, include multiple CLI
; support in MCE
;
        .ASK CLS 'PRNAME' -- Want the multiple CLI support [ D:N ] ? 
;
;*****
;
; When init file support is included MCE reads initialisation files which
; can contain Command definitions and CLI commands
; Files are searched in this order:

        .IFF CLS .GOTO 20$

;    LB:'INIUIC'MCEINI.xxx, followed by SY:<current directory>MCEINI.xxx,
; where "xxx" is the name of the CLI defined for the terminal invoking MCE
; and "current directory" is the default directory at the startup of MCE.

        .GOTO 30$
.20$:

;    LB:'INIUIC'MCEINI.CMD, followed by SY:<current directory>MCEINI.CMD
; where "current directory" is the default directory at the startup of MCE.

.30$:

; This algorithm divides command-definitions into 2 groups:
; A system-wide set in LB:'INIUIC', followed by a users privat set in SY:<uic>
;
        .ASK INI 'PRNAME' -- Want the MCEINI file support [D:N] ? 
;
;*****
;
; MCE allows for the definitions of compound commands; Using the ampersand
; (&) sign one can define an MCE command as a sequence of multiple CLI-
; commands: E.g. STAT := TIM & DIR & ACT /ALL ...etc.
;
        .ASK CMP 'PRNAME' -- Want compound command definition support [ D:N ] ? 
;
;*****
;
; It is possible to include statusline support. Line 24 can be used for
; status information.
; The statusline can be switched on/off with MCE STATus on/off
;
        .ASK STA 'PRNAME' -- Want Statusline/Statusmessage support [ D:N ] ? 
;
;*****
;
; The startup and end messages like :
;
;     "MCE -- CLI-commandline-Editor 'VERS'/VT2"   and   "MCE -- Exit"
;
; are optional.
;
        .ASK SIL 'PRNAME' -- Want Startup and exit messages [D:N] ? 
;
;*****
;
; It is possible to define VT2xx and VT3xx functionkeys like :
;
;     "F6 := TIM"
;
        .ASK VT2 'PRNAME' -- Want the VT2xx, VT3xx function key support [D:N] ? 
;
;*****
;
; Also the keys of a TANDBERG TDV2230 can be defined.
;
        .ASK TD2 'PRNAME' -- Want the TANDBERG TDV2230 function key support [D:N] ? 
;
;*****
;
; Some edit functions can be performed on the VT1xx/VT2xx/VT3xx keypad,
; simular to KED and EDT.
;
        .ASK EDT 'PRNAME' -- Want the EDT-Keypad support [D:N] ? 
;
;*****
;
; When terminal time-out support is included the terminal is logged out
; after a given time-out time ( TT0: only exits MCE )
;
        .SETF TMO
        .SETN TMON 4.
        .ASK TMO 'PRNAME' -- Want the terminal time-out support [D:N] ? 
        .IFT TMO .ASKN [2.:120.:4.] TMON 'PRNAME' -- Enter number of time-out minutes [2..120 D:4] : 
;
;*****
;
; Only commandlines with a length greater or equal to a given length
; are saved in the command FIFO
;
        .ASKN [1.:10.:1.] MINCHR 'PRNAME' -- Enter minimal commandline length to be saved [1..10 D:1] : 
;
;*****
;
        .ASKN [1.:99.:23.] MAXFIF 'PRNAME' -- Enter maximal number of entries in FIFO [1..99 D:23.] : 
        .SETF MU
;
;*****
;
        .IF <SYSTEM> EQ 6 .ASK MU  'PRNAME' -- Build MCE as a multi-user task [D:N] ? 
        .IF P1 <> "ALL" .GOTO 40$
        .SETT HLP
        .SETT COP
        .SETF INS
        .SETF PRI
        .GOTO 50$
.40$:
;
;*****
;
; A helpfile customized to your selections is created dynamicly if you
; answer "Y" to the following question.
;
        .ASK HLP 'PRNAME' -- Create helpfile on LB: [D:N] ? 
	.SETF HLPNEW
        .IFT A$SV  .OR	.IFF HLP   .GOTO 45$
        .ASKS [::HLPUIC] HLPUIC 'PRNAME' -- What is your helpfile UIC [ D:'HLPUIC' ] : 
;
;*****
;
; The helpfile can be created in two different versions
;
; Version 1 :  You can access this one by typing HELP MCE [topic...]
;              But you have to include a reference like 
;                    1 MCE
;                    @MCE
;              in  MCR.HLP and DCL.HLP
;
; Version 2 :  You can access this one by typing HELP /MCE [topic...]
;              This version does not need any editing of MCR.HLP and DCL.HLP
;
        .ASK HLPNEW 'PRNAME' -- Do you want Version 2 [D:N] ? 
.45$:
        .SETF INS
;
;*****
;
        .ASK COP 'PRNAME' -- When ready and successfull copy to LB: device [D:N] ? 
        .IFT COP .ASKS [::SYSUIC] SYSUIC 'PRNAME' -- What is your task UIC [ D:'SYSUIC' ] : 
        .IFT COP .ASK INS 'PRNAME' -- Install task [D:N] ? 
        .ASK PRI 'PRNAME' -- Print listings [D:N] ? 
.50$:
        .IFF HLP .GOTO 80$
;'PRNAME' -- Creating help .....
        .OPEN LB:'HLPUIC'MCE.HLP
.DATA MCE 'VERS' - Commandline Editor Utility Commands
.DATA MCE supports all Line Editing Functions of VMS V4.0
.DATA
.DATA  <CTRL/A>               - Switch between Overstrike and Insert mode
.DATA                           Current mode is shown by first prompt character.
.DATA                                 "+" insert mode.    "-" overstrike mode.
.DATA  <CTRL/B> or UP-ARROW   - Retrieve previous Command
.DATA            DOWN-ARROW   - Reverse of UP-ARROW (next command)
.DATA  <CTRL/D> or LEFT-ARROW - Move Cursor Left
.DATA  <CTRL/E>               - Move Cursor to End of Line
.DATA  <CTRL/F> or RIGHT-ARR  - Move Cursor Right
.DATA  <CTRL/H> or BACKSPACE  - Move Cursor to Begin of Line
.DATA  <DELETE>               - Delete Character Left of Cursor
.DATA  <CTRL/J> or LINEFEED   - Delete Word Left of Cursor
.DATA  <CTRL/R>               - Rewrite Line
.DATA  <CTRL/U>               - Delete from Cursor to Begin of Line
.DATA Additional Features:
.DATA  <CTRL/C>               - Delete whole line
.DATA  <CTRL/K>               - Delete from Cursor to End of Line
.DATA  <CTRL/N>               - Save Command without executing
.DATA  <CTRL/T>               - Enable output from other tasks:
.DATA                           Detach TI:, Wait 10 seconds and Prompt again
.DATA  <CTRL/V>               - Delete Character at Cursor
.DATA  <CTRL/W>               - Delete Word Right at Cursor
.DATA  <TAB>                  - Move word to the right or move from EOL to BOL
.IFT VT2 .DATA  <ESC><ESC> or  <DO>    - Execute Command without waiting
.IFF VT2 .DATA  <ESC><ESC>             - Execute Command without waiting
.IFF A$SV .IFT VT2 .DATA  <HELP> or <CTRL/?>     - Gives HELP MCE
.IFF A$SV .IFF VT2 .DATA  <CTRL/?>               - Gives HELP MCE
.IFT A$SV .IFT VT2 .DATA  <HELP> or <CTRL/?>     - Gives HELP ASV MCE
.IFT A$SV .IFF VT2 .DATA  <CTRL/?>               - Gives HELP ASV MCE
.DATA  <PF1>                  - Translate Command without execution
.IFF VT2 .DATA  <PF2>                  - Recall Command previously requested.
.IFT VT2 .DATA  <PF2> or <FIND>        - Recall Command previously requested.
.DATA  <PF3>                  - Show Command Translation Buffer
.DATA  <PF4>                  - Display previously requested Commands
.IF MINCHR > 1 .DATA Default only Commands which contain 'MINCHR%D' or more characters are saved.
.DATA Default the savebuffer can contain up to 'MAXFIF%D' commandlines.
.IFT TMO  .DATA Terminal time-out time support included ('TMON%D' minutes)
.IFT EDT  .DATA EDT-Keypad support included
.IFT STA  .DATA Statusline support included
.IFT CMP  .DATA Compound statement support included
.IFF EDT .DATA  More help : TRANS  RECALL  START  EXIT  INTERNAL  FUNC
.IFT EDT .DATA  More help : TRANS  RECALL  START  EXIT  INTERNAL  FUNC  KEYPAD
.IFF A$SV .IFT HLPNEW .DATA 1 TRANS
.IFF A$SV .IFF HLPNEW .DATA 2 TRANS
.IFT A$SV .DATA 3 TRANS
.DATA  A Command may be defined by:
.DATA         +>CNAM := <TRANSLATION_OF_COMMAND>
.IFT CMP  .DATA    or   +>CNAM := <TRANSLATION_OF_COMMAND> & <TRANSLATION_OF_COMMAND> & ...
.DATA  where CNAM is the commandname which will be substituted by the
.DATA  text at the right side of the ":=". 
.DATA  NOTE: The ":=" must be prececed and followed by a single space.
.IFF A$SV .DATA  e.g.:  +>HE := HELP MCE        ! Followed by space, to append further text
.IFT A$SV .DATA  e.g.:  +>HE := HELP ASV MCE    ! Followed by space, to append further text
.IFF A$SV .DATA         +>HE                    ! Will request "HELP MCE"
.IFT A$SV .DATA         +>HE                    ! Will request "HELP ASV MCE"
.DATA  
.DATA  The translation may be performed without execution by <PF1> (only
.DATA  displayed on terminal)
.DATA  
.DATA  If you enter a predefined command followed by additional text,
.DATA  this additional text will normally be appended as a whole.
.IFF A$SV .DATA  e.g.:  +>HE TRAN               ! Will request "HELP MCE TRAN"
.IFT A$SV .DATA  e.g.:  +>HE TRAN               ! Will request "HELP ASV MCE TRAN"
.DATA  or:    +>HE TRAN<PF1>          ! Will be translated and displayed
.IFF A$SV .DATA  result +>HELP MCE TRAN
.IFT A$SV .DATA  result +>HELP ASV MCE TRAN
.DATA  
.DATA  You may delete a command translation entry by redefining it to null.
.DATA  e.g.:  +>HE :=                 ! Delete above definition
.DATA  
.DATA  It is also possible to allow abbreviatons of commands (as in DCL)
.DATA  by seperating the optional part by "*"
.IFF A$SV .DATA  e.g.:  +>HM*CE := HELP MCE
.IFT A$SV .DATA  e.g.:  +>HM*CE := HELP ASV MCE
.DATA  This command may now be requested with:
.DATA         +>HM or HMC or HMCE or HMCEXXX ect.
.DATA
.DATA  More sophisticated substitution is possible by the Parameter-Substitution,
.DATA  similar to the indirect commandfile processor.
.DATA  e.g.:  +>DIR*ECTORY := PIP ''P1''/LI
.DATA         +>COP*Y := PIP ''P2''/NV/CD=''P1''
.DATA         +>DIR                   ! Will be translated into "PIP /LI"
.DATA         +>DIREC FIL             ! Will be translated into "PIP FIL/LI"
.DATA         +>COPY A.CMD [200,200]  ! Will simulate DCL COPY command
.IFT INI .DATA  Note that Command Definitions may be performed from the commandfile
.IFT INI .IFF CLS .DATA         LB:'INIUIC'MCEINI.CMD  and  SY:[cur_dir]MCEINI.CMD
.IFT INI .IFT CLS .DATA         LB:'INIUIC'MCEINI.xxx  and  SY:[cur_dir]MCEINI.xxx

.IFT INI .DATA  which will always be read when MCE is started.
.IFT INI .DATA  [cur_dir] is the default directory at the startup of MCE.
.IFT INI .IFT CLS .DATA         "xxx" = CLI name
.IFT INI .DATA  Files are read in order they are mentioned above.
.DATA  
.IFF A$SV .IFT HLPNEW .DATA 1 FUNC
.IFF A$SV .IFF HLPNEW .DATA 2 FUNC
.IFT A$SV .DATA 3 FUNC
.DATA  You may request a command with function keys <PF1>, <PF2>, <PF3> or <PF4>
.DATA  It is also possible to request commands with control keys. (e.g. <CTRL/X>)
.IFT VT2 .DATA  On a VT2xx you can also define the function keys <F6> .. <F20> and <FIND>
.IFT VT2 .DATA  <INSERT HERE> ect.
.IFT TD2 .DATA  On a TDV2230 you can also define the function keys <F1> ... <F7>
.DATA  Define the command translation as "''key'' := command".
.DATA  e.g.   +>PF2 := TIM            ! Redefine <PF2> function key
.DATA         <PF2>                   !  to display the current time
.IFT VT2 .OR .IFT TD2 .DATA         +>F6 := ACT             ! Define F6 function key
.IFT VT2 .OR .IFT TD2 .DATA         <F6>                    !  to display the active tasks
.IFT VT2 .DATA  On a VT2XX the keys <FIND> ect. must be entered as F$a  where "a" is the
.IFT VT2 .DATA  first char. of the key function.  e.g.  "F$P" for <PREV SCREEN> 
.DATA  Define a control key as follows:
.DATA  e.g.   +>^X := SET /UIC        ! Define <CTRL/X> key
.DATA         <CTRL/X>                !  to display the current UIC
.DATA  Note that the following control-keys CANNOT be defined:
.DATA  <CTRL/M> = <RETURN>,  <CTRL/O>,  <CTRL/Q>,  <CTRL/S>,  <CTRL/[> = <ESC> 
.DATA  Next to the rest of the Alphabetic characters the following keys can
.DATA  be defined : <CTRL/\>,  <CTRL/]>,  <CTRL/^>,  <CTRL/?>  
.IFF A$SV .IFT HLPNEW .DATA 1 START
.IFF A$SV .IFF HLPNEW .DATA 2 START
.IFT A$SV .DATA 3 START
.DATA  Invoke MCE with command "MCE" (at best in your LOGIN file by ".XQT MCE").
.DATA  A File of Command Definitions will be executed at MCE start time,
.DATA  the file may be specified in the form "MCE startup_file".
.DATA  If no startup file is specified in the commandline (the normal case),
.DATA  files are searched for are in this order:
.IFT CLS .DATA     LB:'INIUIC'MCEINI.xxx,        followed by
.IFT CLS .DATA     SY:[cur_dir]MCEINI.xxx,
.IFT CLS .DATA  Where "xxx" is the name of the CLI defined for the terminal invoking MCE
.IFT CLS .DATA  and current directory is the default directory at the startup of MCE.
.IFF CLS .DATA     LB:'INIUIC'MCEINI.CMD,        followed by
.IFF CLS .DATA     SY:[cur_dir]MCEINI.CMD,
.IFf CLS .DATA  [cur_dir] is the default directory at the startup of MCE.
.DATA  This algorithm divides command-definitions into 2 groups:
.DATA  A system-wide set in LB:'INIUIC', followed by a users privat set in SY:<uic>.
.DATA  Overriding the default file name in the commandline invoking MCE offers
.DATA  the possibility to tailor an application specific command set.
.IFF A$SV .IFT HLPNEW .DATA 1 EXIT
.IFF A$SV .IFF HLPNEW .DATA 2 EXIT
.IFT A$SV .DATA 3 EXIT
.DATA   To exit MCE operations, use the "MCE EXIT" internal command.
.DATA   or <CTRL/Y>
.DATA   More about internal commands see help MCE INTERNAL.
.IFF A$SV .IFT HLPNEW .DATA 1 INTERNAL
.IFF A$SV .IFF HLPNEW .DATA 2 INTERNAL
.IFT A$SV .DATA 3 INTERNAL
.DATA   Two command verbs are specially handled by MCE: "BYE" and "MCE".
.DATA   "BYE" is sent to the CLI and MCE exits immediately.
.DATA   (Note,that you may define any other string (e.g. LOGOFF) to result
.DATA   in BYE.)
.DATA   Commands starting with "MCE" are treated as internal commands and
.DATA   not passed to the CLI. Following the verb "MCE " a 4 character action
.DATA   specifier defines the action wanted.
.DATA   Actions defined so far are:
.IFT INI .DATA    CHAI file: Chain from one INIT-file to another. (synonym for READ)
         .DATA    CLEA     : Delete all commands in command Fifo
         .DATA    CMSZ n   : Changes Minimal commandlinelength to be saved to "n"
         .DATA    EXIT     : MCE task exit (return to the normal command environment.)
         .DATA    FISZ n   : Changes Fifosize to "n" ( if enough memory )
         .DATA    FREE     : Display MCE Pool info (largest_block:Total_free_blocks:fragments)
.IFT EDT .DATA    KEYP xx  : Set Keypad editing on/off     ( xx = on / off )
         .DATA    LIST     : FIFO is a list       : UP- and DOWN-ARROW stop at the end
         .DATA    PURG     : Delete all commands in translation table
.IFT INI .DATA    READ file: Read new command translations from file specified
.IFT INI .DATA    REPL file: Combines PURGe and READ.
.IFT STA .DATA    STAT xx  : Statusline on/off/show        ( xx = on / off / "blank" )
         .DATA    SVIN xx  : Save internal commands on/off ( xx = on / off )
         .DATA    SVOL xx  : Save "old" commands on/off    ( xx = on / off )
         .DATA    RING     : FIFO is a ringbuffer : UP- and DOWN-ARROW roll through the FIFO
         .DATA    VERS     : Show MCE Version
.IFF INI .GOTO 60$
.DATA   The read and replace options, if no file is specified, follow the
.DATA   the same file name convention as at startup: the file(s) according
.DATA   to the current CLI is read in, i.e. the command "MCE REPLace"
.DATA   effects in an MCE restart (but the FIFO buffer is kept), usefull
.DATA   after a SET TERMINAL new_cli command.
.DATA   When a space is given as filename, only SY:[cur_dir]MCEINI.xxx is read.
.DATA   [cur_dir] is the default directory at the startup of MCE.
.60$:
.IFF A$SV .IFT HLPNEW .DATA 1 RECAL
.IFF A$SV .IFF HLPNEW .DATA 2 RECAL
.IFT A$SV .DATA 3 RECALL
.DATA  Recalling a command is done by entering the first part of a command
.DATA  which was previously executed, termimated by the function key <PF2>,
.DATA  or if VT2xx support is included <FIND>.
.DATA  This will find the last command already executed starting with the
.DATA  string entered.  The command may be edited or executed by pressing
.DATA  the return key. A second <PF2> keystroke searches further back in the
.DATA  FIFO. When no string is entered, the last defined string is taken.
.DATA  Note that the function key <PF2> may not have any superimposed
.DATA  translation defined (by defining "PF2 := ...").
.DATA  Example:
.DATA     +>DIR X.DAT        ! Previously entered commands
.DATA     +>DMP X.DAT
.DATA     +>..
.DATA     +>D<PF2>           ! Will recall the last command starting with "D":
.DATA     +>DMP X.DAT
.DATA     +><PF2>            ! Will recall the for last command:
.DATA     +>DIR X.DAT
.DATA     +>DI<PF2>          ! Will recall the command:
.DATA     +>DIR X.DAT
.IFF EDT .GOTO 70$
.IFF A$SV .IFT HLPNEW .DATA 1 KEYPAD
.IFF A$SV .IFF HLPNEW .DATA 2 KEYPAD
.IFT A$SV .DATA 3 KEYPAD
.DATA
.DATA MCE-'VERS'  VT10x  / VT2xx  / VT3xx Keypad :
.DATA   +--------+-----------------+    +--------+--------+--------+--------+
.DATA   |        |                 |    |\\\\\\\\|        |        |        |
.DATA   |  HELP  |  EXECUTE NOWAIT |    |\\GOLD\\| KPHELP | RECALL | DELLIN |
.DATA   |        |                 |    |\\\\\\\\|        |        |        |
.DATA   +--------+--------+--------+    +--------+--------+--------+--------+ 
.DATA   |        |        |        |    |        | SHOCMD | SHOFIF |        |
.DATA   | RECALL |        |        |    | TRANSL | ------ | ------ | DELWRD |
.DATA   |        |        |        |    |        |\\VERS\\|\\FREE\\|        |
.DATA   +--------+--------+--------+    +--------+--------+--------+--------+
.DATA   |        |        |        |    |        |        |        |        |
.DATA   |        |        |        |    |        |        |        | DELCHR |
.DATA   |        |        |        |    |        |        |        |        |
.DATA   +--------+--------+--------+    +--------+--------+--------+--------+
.DATA            |        |             |        |  EOL   |        |        |
.DATA            |    ^   |             |  WORD  | ------ |        |        |
.DATA            |    |   |             |        |\DELLIN\|        |        |
.DATA   +--------+--------+--------+    +--------+--------+--------+  ENTER |
.DATA   |        |        |        |    |    BEGLINE      |        |        |
.DATA   |  <-    |    |   |   ->   |    | --------------- |        |        |
.DATA   |        |    V   |        |    |\\\\CLRLINE\\\\\\|        |        |
.DATA   +--------+--------+--------+    +-----------------+--------+--------+
.70$:
        .close
        'cli' PIP LB:'HLPUIC'MCE.HLP/PU/NM
.80$:
;'PRNAME' -- Creating build files .....
        .open MCEASM.CMD
        .data ;
        .data ; MCE Macro buildfile
        .data ; Created on '<date>' '<time>' by 'PRNAME'.CMD Version: 'VERS'
        .data ;
        .data MCE,MCE/-SP=MCEPRE,MCE
        .CLOSE
        .OPEN MCEPRE.MAC
        .data   .SBTTL MCE - Configuration prefixfile MCEPRE.MAC
        .data ;
        .data ; MCE Macro Prefixfile
        .data ; Created on '<date>' '<time>' by 'PRNAME'.CMD Version: 'VERS'
        .IFT VT2    .DATA VT2XX    = 1     ; VT2xx support included
        .IFT TD2    .DATA TDV2XX   = 1     ; TDV2230 support included
        .IFT EDT    .DATA EDT      = 1     ; EDT-Keypad support included
        .IFT INI    .DATA FILE     = 1     ; MCEINI file support included
        .IFT CLS    .DATA CLISUP   = 1     ; Multiple cli supp
        .IFT CMP    .DATA COMPND   = 1     ; Compound command (&) support
        .IFT STA    .DATA STATUS   = 1     ; Statusline support
        .IFF SIL    .DATA SILENT   = 1     ; No Startup and exit messages
        .IFT TMO    .DATA TMOTIM   = 'TMON'.       ; Time-out support
        .IFT A$SV   .DATA A$SV     = 1     ; EUR - CRW/ASV support
	.IFT HLPNEW .DATA HLPNEW   = 1     ; HELP / support
        .DATA MINCHR    = 'MINCHR'.     ; Minimal cmd-line length to be saved
        .DATA MAXFIF    = 'MAXFIF'.     ; Maximal number of entries in FIFO
        .CLOSE
.;
        .OPEN MCETKB.CMD
        .SETS LIBR "SUPLIB=FCSFSL:SV"   ; Assume FCSFSL
        .TESTFILE LB:[1,1]FCSFSL.TSK
        .IF <FILERR> EQ 1 .GOTO LINK2
        .SETS LIBR "LIBR=FCSRES:RO"     ; Assume FCSRES
        .TESTFILE LB:[1,1]FCSRES.TSK
        .IF <FILERR> EQ 1 .GOTO LINK2
        .SETS LIBR ";"
.LINK2:
.ENABLE DATA
;
; MCE Link buildfile
; Created on '<date>' '<time>' by 'PRNAME'.CMD Version: 'VERS'
; 
MCE/CP,MCE/-SP=MCE
LB:[1,1]VMLIB/LB:INIDM:EXTSK
/
UNITS=2
ASG=TI:1
ASG=SY:2
PRI=150
TASK=...MCE
'LIBR'
EXTTSK=400
/
.DISABLE DATA
        .CLOSE

    'cli' PIP MCEASM.CMD/PU/NM,MCEASM.CMD
.MAC:
;'PRNAME' -- Assembling .....
        .;
    'cli' MAC @MCEASM
        .IF <EXSTAT> NE <succes> .GOTO 200$
        .;
    'cli' PIP MCE.OBJ/PU/NM,MCE.LST
    'cli' PIP MCEPRE.MAC/PU/NM
.LINK:
;'PRNAME' -- Building MCE .....
    'cli' PIP MCETKB.CMD/PU/NM
    'cli' TKB @MCETKB
        .IF <EXSTAT> NE 1 .GOTO 200$
.;
    'cli' PIP MCE.TSK/PU/NM,MCE.MAP
.;
        .IFF COP .GOTO 100$
    'cli' PIP LB:'SYSUIC'/NV/FO/CO=MCE.TSK
        .IFF INS .GOTO 100$
        .IFINS ...MCE           'cli' REM ...MCE
    'cli' INS LB:'SYSUIC'MCE
.;
.100$:
        .IFT PRI 'cli' PRI MCE/FLA=MCE.LST,MCE.MAP
;'PRNAME' -- Procedure done
        .EXIT   <SUCCES>
.200$:
;
;'PRNAME' -- Something wrong !!!
;
        .EXIT   <WARNIN>
