N /* Version 0.8(35) - Jim Noble at Planning Research Corporation, June 1987. */4 /* Ported to Megamax native Macintosh C compiler. */ /* From: DPVC@UORDBV.BITNET */J /* DPVC at U of R, Oct 1, add blinking cursor and mouse cursor movement */N /* DPVC at U of R, Sept. 26, fixed book-keeping for scrolling and inserting */ /*  characters and lines */ M /* DPVC at U of R, Sept. 25, to fix cursor positioning off the screen, and */ 1 /*  a few other, minor VT100 incompatibilities */ K /* DPVC at the University of Rochester, Sept. 9, to add Block Cursor and */ . /*  ability to do VT100 graphics characters */@ /* By CAM2 and DPVC at the University of Rochester on Sept 6, */O /*  changed bolding from using TextStyle attributes to using a separate bold */  /*  font */ K /* By Frank on June 20 - Add parity to all outbound chars using software */ 3 /*  Also, ignore DEL (0177) characters on input. */ 1 /* By Bill on May 29 - Add Key set translation */ I /* By WBC3 on Apr 24 - Add ^^, ^@ and ^_.  Also use Pascal strings for */ & /*  output in the terminal emulator */I /* By WBC3 on Apr 23 - Add query terminal and be more fastidious about */ - /*  ignoring sequences we don't know about */ L /* By WBC3 on Apr 22 - Fix tab stops to conform to the rest of the world! */6 /* By Bill on Apr 21 - Fix immediate echo problems. */. /*  do less cursor_erase, cursor_draw stuff */   /*  * FILE ckmcon.c  *A  * Module of mackermit: contains code for the terminal simulation   * routine.   */   ; #include "ckcsym.h"			/* Conditional compilation symbols */  #include "ckcdeb.h"    #if MEGAMAX  overlay "ckmcon"   #include <event.h> #include <file.h>  #include <qdvars.h>  #include <toolbox.h> #include <win.h> #endif  
 #ifdef SUMACC 7 #include "mac/quickdraw.h"		/* Macintosh C interface */  #include "mac/osintf.h"  #include "mac/toolintf.h"  #endif  9 #include "ckmsys.h"			/* Compiler specific definitions */  #include "ckmdef.h" 5 #include "ckmkkc.h"			/* common key configure defs */   + #define KC_CMD	55			/* scan code for cmd */ ) #define KC_OPT	58			/* code for option */    #define MAXLIN      24 #define MAXCOL      80 #define LINEHEIGHT  12 #define CHARWIDTH    6H #define TOPMARGIN    3                  /* Terminal display constants */6 #define BOTTOMMARGIN (LINEHEIGHT * MAXLIN + TOPMARGIN) #define LEFTMARGIN   36 #define RIGHTMARGIN  (CHARWIDTH * MAXCOL + LEFTMARGIN)L #define LINEADJ      3                  /* Amount of char below base line */  4 /* Font Numbers (UoR Mod) to fix bolding problems */C /* These should be placed in the RESOURCE FORK of the executable */   L #define VT100FONT  128                  /* VT100 Terminal Font (not-bold) */= #define VT100BOLD  129                  /* VT100 Bold Font */    /* output character handling */   G unsigned char obuf[2] = {1,0};          /* single char output buffer */    /* Tab settings */   /* #define NUMTABS 9 6 short tabstops[NUMTABS] = {8,16,24,32,40,48,56,64,72};: */              /* (UoR) remove old method of tab stops */  P /* (UoR) do tapstops via an array: 0 means no tab, 1 means tab at that column */N short tabstops[MAXCOL+1] = {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,C    0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1, 2    0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1};  P #define USA_SET  0                      /*  (UoR) VT100 character set numbers */ #define UK_SET   1 #define GRAF_SET 2  M int invert=FALSE,                       /* Flag for inverted terminal mode */      insert=FALSE, H     topmargin=TOPMARGIN,                /* Edges of adjustable window */     bottommargin=BOTTOMMARGIN,     textstyle=0,I     currentfont=VT100FONT,              /* (UoR) currently active font */ L     newline=FALSE,                      /* (UoR) linefeed mode by default */D     autowrap=TRUE,                      /* Autowrap on by default */G     relorigin=FALSE,                    /* (UoR) relative origin off */ H     screeninvert=FALSE,                 /* (UoR) inverted screen flag */D     autorepeat=TRUE,                    /* (UoR) auto repeat flag */J     graphicsinset[2]={USA_SET,USA_SET}, /* (UoR) current character sets */F     current_set=0;                      /* (UoR) current chosen set */    L char *querystring="\033[?1;2c";         /* Answer we are a VT100 with AVO */D                                         /* (UoR) used to be VT102 */H char *reportstring="\033[0n";           /* (UoR) report that we're OK */E char *noprinter="\033[?13n";            /* (UoR) report no printer */    Rect ScreenRect;/         /* (UoR) don't need scrollrect any more N            (use scroll_up and scroll_down), use ScreenRect for mouse check  */  M RgnHandle dumptr;                       /* Dummy ptr to satisfy scrollbits */   # /* Screen book keeping variables */   F char scr[MAXLIN][MAXCOL+1];             /* Characters on the screen */B short nxtlin[MAXLIN], toplin, botlin;   /* Linked list of lines */= int curlin, curcol, abslin;             /* Cursor position */ C int savcol, savlin;                     /* Cursor save variables */  int savsty, savfnt, savgrf, I     savmod, savset[2];                  /* (UoR) cursor save variables */ N int scrtop, scrbot;                     /* Absolute scrolling region bounds */G int cursor_invert=FALSE,                /* (UoR) for flashing cursor */      cur_drawn=FALSE; long last_flash=0;K int oldlin= -1, oldcol=0;               /* (UoR) for last mouse position */   N CursHandle mousecursor;                 /* (UoR) the mouse movement pointer */L int theMouse = 128;                     /* (UoR) the mouse pointer res ID */  I # define CARETTIME 20                   /* (UoR) ticks between flashes */   + /* Stuff for escape character processing */   B #define CF_OUTC 0                       /* Just output the char */I #define CF_SESC 1                       /* In a single char escape seq */ L #define CF_MESC 2                       /* In a multi char '[' escape seq */< #define CF_TOSS 3                       /* Toss this char */K #define CF_GRF0 4                       /* (UoR) for graphics sequence 0 */ K #define CF_GRF1 5                       /* (UoR) for graphics sequence 1 */   + char prvchr, numone[6], numtwo[6], *numptr;   int num1, num2, charflg=CF_OUTC; /* extern CSParam controlparam; */ extern unsigned char dopar();    typedef int (*PFI) ();  % /* Terminal function declarations. */   N int tab(), back_space(), carriage_return(), line_feed(), bell(), escape_seq(),O     text_mode(), clear_line(), erase_display(), cursor_position(), cursor_up(), @     cursor_down(), cursor_right(), cursor_left(), cursor_save(),H     cursor_restore(), set_scroll_region(), reverse_line_feed(), dummy(),C     delete_char(), insert_mode(), end_insert_mode(), insert_line(), ?     delete_line(), query_terminal(), multi_char(), toss_char(),   /     /* (UoR) for VT100 graphic character set */   9     graphic_G0(), graphic_G1(), control_N(), control_O(),   )     /* (UoR) for other VT100 functions */   9     new_line(), request_report(), set_tab(), clear_tab();       L /* (UoR) constansts that point to the function definitions for arrow keys */0 /*  Used by mouse cursor positioning function */   # define UPARROW    100  # define DOWNARROW  101  # define LEFTARROW  102  # define RIGHTARROW 103                   8 /* Terminal control character function command table. */   #define MINSINGCMDS 000  #define MAXSINGCMDS 037   - PFI controltable[MAXSINGCMDS-MINSINGCMDS+1] =  { 0     dummy,                              /*  0 */0     dummy,                              /*  1 */0     dummy,                              /*  2 */0     dummy,                              /*  3 */0     dummy,                              /*  4 */0     dummy,                              /*  5 */0     dummy,                              /*  6 */0     bell,                               /*  7 */0     back_space,                         /* 10 */0     tab,                                /* 11 */0     line_feed,                          /* 12 */?     line_feed,                          /* 13 (Vertical tab) */ <     line_feed,                          /* 14 (Form feed) */0     carriage_return,                    /* 15 */N     control_N,                          /* 16 (graphic set 1) */   /* (UoR) */N     control_O,                          /* 17 (graphic set 0) */   /* (UoR) */0     dummy,                              /* 20 */0     dummy,                              /* 21 */0     dummy,                              /* 22 */0     dummy,                              /* 23 */0     dummy,                              /* 24 */0     dummy,                              /* 25 */0     dummy,                              /* 26 */0     dummy,                              /* 27 */0     dummy,                              /* 30 */0     dummy,                              /* 31 */0     dummy,                              /* 32 */9     escape_seq,                         /* 33 (Escape) */ 0     dummy,                              /* 34 */0     dummy,                              /* 35 */0     dummy,                              /* 36 */0     dummy                               /* 37 */ };                   #define MINSINGESCS 0040 #define MAXSINGESCS 0137  0 PFI singescapetable[MAXSINGESCS-MINSINGESCS+1] = { 1     dummy,                              /*  40 */ 1     dummy,                              /*  41 */ 1     dummy,                              /*  42 */ 5     toss_char,                          /*  43 '#' */ 1     dummy,                              /*  44 */ 1     dummy,                              /*  45 */ 1     dummy,                              /*  46 */ 1     dummy,                              /*  47 */ .     graphic_G0,				/*  50 '(' */   /* (UoR) */.     graphic_G1,				/*  51 ')' */   /* (UoR) */1     dummy,                              /*  52 */ 1     dummy,                              /*  53 */ 1     dummy,                              /*  54 */ 1     dummy,                              /*  55 */ 1     dummy,                              /*  56 */ 1     dummy,                              /*  57 */ 1     dummy,                              /*  60 */ 1     dummy,                              /*  61 */ 1     dummy,                              /*  62 */ 1     dummy,                              /*  63 */ 1     dummy,                              /*  64 */ 1     dummy,                              /*  65 */ 1     dummy,                              /*  66 */ 5     cursor_save,                        /*  67 '7' */ 5     cursor_restore,                     /*  70 '8' */ 1     dummy,                              /*  71 */ 1     dummy,                              /*  72 */ 1     dummy,                              /*  73 */ 5     dummy,                              /*  74 '<' */ 5     dummy,                              /*  75 '=' */ 5     dummy,                              /*  76 '>' */ 1     dummy,                              /*  77 */ 1     dummy,                              /* 100 */ 1     dummy,                              /* 101 */ 1     dummy,                              /* 102 */ 1     dummy,                              /* 103 */ 5     line_feed,                          /* 104 'D' */ C     new_line,                           /* 105 'E' */   /* (UoR) */ 1     dummy,                              /* 106 */ 1     dummy,                              /* 107 */ C     set_tab,                            /* 110 'H' */   /* (UoR) */ 1     dummy,                              /* 111 */ 1     dummy,                              /* 112 */ 1     dummy,                              /* 113 */ 1     dummy,                              /* 114 */ 5     reverse_line_feed,                  /* 115 'M' */ 1     dummy,                              /* 116 */ P     toss_char,                          /* 117 'O' */   /* (UoR) ignore these */1     dummy,                              /* 120 */ 1     dummy,                              /* 121 */ 1     dummy,                              /* 122 */ 1     dummy,                              /* 123 */ 1     dummy,                              /* 124 */ 1     dummy,                              /* 125 */ 1     dummy,                              /* 126 */ 1     dummy,                              /* 127 */ 1     dummy,                              /* 130 */ 1     dummy,                              /* 131 */ 5     query_terminal,                     /* 132 'Z' */ 5     multi_char,                         /* 133 '[' */ 1     dummy,                              /* 134 */ 1     dummy,                              /* 135 */ 1     dummy,                              /* 136 */ 1     dummy                               /* 137 */  };                  5 /* Terminal escape sequence function command table */    #define MINMULTESCS 0100 #define MAXMULTESCS 0177  , PFI escapetable[MAXMULTESCS-MINMULTESCS+1] = { 1     dummy,                              /* 100 */ 5     cursor_up,                          /* 101 'A' */ 5     cursor_down,                        /* 102 'B' */ 5     cursor_right,                       /* 103 'C' */ 5     cursor_left,                        /* 104 'D' */ 1     dummy,                              /* 105 */ 1     dummy,                              /* 106 */ 1     dummy,                              /* 107 */ 5     cursor_position,                    /* 110 'H' */ 1     dummy,                              /* 111 */ 5     erase_display,                      /* 112 'J' */ 5     clear_line,                         /* 113 'K' */ 5     insert_line,                        /* 114 'L' */ 5     delete_line,                        /* 115 'M' */ 1     dummy,                              /* 116 */ 1     dummy,                              /* 117 */ 5     delete_char,                        /* 120 'P' */ 1     dummy,                              /* 121 */ 1     dummy,                              /* 122 */ 1     dummy,                              /* 123 */ 1     dummy,                              /* 124 */ 1     dummy,                              /* 125 */ 1     dummy,                              /* 126 */ 1     dummy,                              /* 127 */ 1     dummy,                              /* 130 */ 1     dummy,                              /* 131 */ 1     dummy,                              /* 132 */ 1     dummy,                              /* 133 */ 1     dummy,                              /* 134 */ 1     dummy,                              /* 135 */ 1     dummy,                              /* 136 */ 1     dummy,                              /* 137 */ 1     dummy,                              /* 140 */ 1     dummy,                              /* 141 */ 1     dummy,                              /* 142 */ 5     query_terminal,                     /* 143 'c' */ 1     dummy,                              /* 144 */ 1     dummy,                              /* 145 */ 5     cursor_position,                    /* 146 'f' */ C     clear_tab,                          /* 147 'g' */   /* (UoR) */ 5     insert_mode,                        /* 150 'h' */ 1     dummy,                              /* 151 */ 1     dummy,                              /* 152 */ 1     dummy,                              /* 153 */ 5     end_insert_mode,                    /* 154 'l' */ 5     text_mode,                          /* 155 'm' */ C     request_report,                     /* 156 'n' */   /* (UoR) */ 1     dummy,                              /* 157 */ 1     dummy,                              /* 160 */ 1     dummy,                              /* 161 */ 4     set_scroll_region,                  /* 162 'r'*/1     dummy,                              /* 163 */ 1     dummy,                              /* 164 */ 1     dummy,                              /* 165 */ 1     dummy,                              /* 166 */ 1     dummy,                              /* 167 */ 1     dummy,                              /* 170 */ 1     dummy,                              /* 171 */ 1     dummy,                              /* 172 */ 1     dummy,                              /* 173 */ 1     dummy,                              /* 174 */ 1     dummy,                              /* 175 */ 1     dummy,                              /* 176 */ 1     dummy                               /* 177 */  };                   /* Connect support routines */  
 consetup() {        dumptr = NewRgn();     PenMode(patXor);E     mousecursor = GetCursor(theMouse);  /* (UoR) mouse-move cursor */ K     flushio();                          /* Get rid of pending characters */   L     init_term();                        /* Set up some terminal variables */M     TextFont(VT100FONT);                /* (UoR) Set initial font to VT100 */ N     TextMode(srcXor);                   /* (UoR) use XOR mode (for inverse) */>     clear_screen();                     /* Clear the screen */B     home_cursor();                      /* Go to the upper left */@     cursor_save();                      /* Save this position */F     cursor_draw();                      /* (UoR) be sure to draw it */ }   B /* Input and process all the characters pending on the tty line */  
 inpchars() {      int rdcnt;  M     if ((rdcnt = ttchk()) == 0) return; /* How many chars there?  Ret if 0 */ G     cursor_erase();                     /* remove cursor from screen */ L     while (rdcnt-- > 0) printit(ttinc(0)); /* Output all those characters */L     flushbuf();                         /* Flush any remaining characters */9     cursor_draw();                      /* put it back */  }                     ; /* writeps - write a pascal form string to the serial port.   *  */   
 writeps(s) char *s; {    LONGINT wcnt, w2;    int err; char *s2;  7   w2 = wcnt = *s++;                     /* get count */ 8   for (s2 = s; w2 > 0; w2--,s2++)       /* add parity */     *s2 = dopar(*s2); B   err = FSWrite(outnum,&wcnt,s);        /* write the characters */   if (err != noErr) -     printerr("Bad FSWrite in writeps: ",err); 	   return;    SYM(WRITEPS);  }    /*  * (UoR)  *G  * Print a string to the screen (used to echo function and meta strings   * in duplex mode).   *  */   
 printps(s) char *s; {     LONGINT w2;    char *s2;      cursor_erase();  '    w2 = *s++;           /* get count */ #    for (s2 = s; w2 > 0; w2--, s2++) I        printit(*s2);    /* print it out, and perform special functions */       cursor_draw(); 
    return;    SYM(PRINTPS); }                   F /* getindstr - given an indirect (or is it indexed) string and integer:  *             n, return the pointer to the Nth substring.  *F  * Indirect strings have the count of substrings in the first byte and5  * each string follows with a length byte and a body.   *$  * Substrings are referenced by 1..N  *  */    char *getindstr(indstr,n) 
 char *indstr;  {    register char *ip = indstr;    int i;  8   if (n > *ip++)                        /* too large? */M    return("");                          /* yes, return empty pascal string */   G   for (i=1; i < n; i++)                 /* scan until we hit the Nth */ D    ip += (*ip)+1;                       /* move to next substring */  >   return(ip);                           /* return ptr to it */   SYM(GETINDSTR);  }                   4 /* Process a character received from the keyboard */   handle_char(evt) EventRecord *evt;  {      int code,mods,cidx;      register KSET *ks;     unsigned char c;  @                         /* (UoR) check for auto repeated keys */@     if ((autorepeat == FALSE) && (evt->what == autoKey)) return;  -     code = (evt->message & keyCodeMask) >> 8; '     mods = (evt->modifiers & MOD_MASK);   B     cidx = (mods & shiftKey) ?          /* decide if shifted or */<             UC_IDX : LC_IDX;            /*  unshifted map */  F     ks = *kshdl;                        /* de-reference KSET handle */  6     if (mods & ks->ctrlmods)            /* control? */D       c = ks->ctrlmap[cidx][code];      /* yes... use control map */     else=       if (mods & ks->caplmods)          /* else caps lock? */ ?         c = ks->caplmap[cidx][code];    /* yes, use that map */ 	      else F        c = ks->normmap[cidx][code];     /* otherwise use normal map */  E     if (c & FKEYBIT) {                  /* is this a function key? */ @       c &= ~FKEYBIT;                    /* clear function bit */N       if (evt->what == autoKey) return; /* (UoR) don't repeat function keys */F       switch (c) {                      /* handle special functions */;         case SPFLBRK:                   /* do long break */ C           sendbreak(70);                /* 70*50MS = 3.5 seconds */            break;<         case SPFSBRK:                   /* do short break */C           sendbreak(5);                 /* 5*50MS = 0.25 seconds */            break;F         default:                        /* do user defined function */6          writeps(getindstr(*(ks->fcnshdl),(int) c+1));F          if (duplex != 0)               /* (UoR) echo function keys */9             printps(getindstr(*(ks->fcnshdl),(int) c+1));           break;        } 6       return;                           /* all done */     }   >     if (mods & ks->metamods)            /* want to do meta? */     { J       if (evt->what == autoKey) return; /* (UoR) don't autorepeat metas */A       if (ks->meta8bit)                 /* yes, want 8 bit on? */ <         c |= METABIT;                   /* so, turn it on */
       else       { >         writeps(*(ks->metahdl));        /* else send prefix */>         if (duplex != 0)                /* (UoR) echo metas */$             printps(*(ks->metahdl));       }      }   @                 /* (UoR) don't auto repeat control characters */4     if ((c < ' ') && (evt->what == autoKey)) return;  =     obuf[1] = c;                        /* store character */ >     writeps(obuf);                      /* and write it out */       if (duplex != 0)     { @       cursor_erase();                   /* remove from screen */I       printit((char) c);                /* Echo the char to the screen */ A       flushbuf();                       /* flush the character */ 9       cursor_draw();                    /* put it back */      }      return;      SYM(HANDLE_CHAR);  }                    char outbuf[MAXCOL+1]; int outcnt=0, outcol;   
 flushbuf() {      Rect r;   >     if (outcnt == 0) return;            /* Nothing to flush */  0 /* Erase a hole large enough for outcnt chars */  (     makerect(&r,abslin,outcol,1,outcnt);  N     EraseRect(&r);              /* (UoR) Use InvertRect instead of fillRect */     if (invert) InvertRect(&r);   B     outbuf[outcnt] = '\0';              /* Terminate the string */?     DrawString(outbuf);                 /* Output the string */ I     outcnt = 0;                         /* Say no more chars to output */  }    buf_char(c)  char c;  { M     if (outcnt == 0) outcol = curcol;   /* No chars in buffer, init column */ O     outbuf[outcnt++] = c;               /* Put in the buffer to output later */  }                    /*  *  Printit:*  *      Draws character and updates buffer  */   
 printit(c) char c;  {      PFI funp, lookup();      LONGINT lnum1, lnum2;        c &= 0177;  K     if (c != 0)                          /* (UoR) ignore null characters */      {           switch (charflg)         {B           case CF_OUTC:                 /* Just output the char */             MDrawChar(c);              break;  I           case CF_SESC:                 /* In a single char escape seq */ M             charflg = CF_OUTC;          /* Reset flag to simple outputting */ F             if(funp=lookup(c,singescapetable,MINSINGESCS,MAXSINGESCS))I                 (*funp)();              /* Do escape sequence function */              break;  N           case CF_GRF0:                 /* (UoR) process graphic characters */           case CF_GRF1:              switch (c)
             {                 case 'A'::                   graphicsinset[charflg-CF_GRF0] = UK_SET;                   break;                case 'B':                case '1':;                   graphicsinset[charflg-CF_GRF0] = USA_SET;                    break;                  case '0':                case '2':<                   graphicsinset[charflg-CF_GRF0] = GRAF_SET;                   break;
             } K             charflg = CF_OUTC;          /* Reset flag for next character */              break;  G           case CF_MESC:                 /* Multichar escape sequence */ E             if (c >= 0x20 && c < 0x40)  /* Deal with the modifiers */ 
             { N                 if (c >= '<' && c <= '?') prvchr = c;   /* Handle priv char */H                 else if ((c >= '0' && c <= '9') || c == '-' || c == '+')                 { E                     *numptr++ = c;      /* Add the char to the num */ B                     *numptr = '\0';     /* Terminate the string */                 } O                 else if (c == ';') numptr = numtwo;     /* Go to next number */ C                 else charflg = CF_OUTC;                 /* (UoR) */ 
             } =             else                        /* End of sequence */ 
             { G                 if (funp=lookup(c,escapetable,MINMULTESCS,MAXMULTESCS))                  { K                     StringToNum(numone,&lnum1); /* Translate the numbers */ /                     StringToNum(numtwo,&lnum2);  		    num1 = (int) lnum1;  		    num2 = (int) lnum2; M                     (*funp)();          /* Do the escape sequence function */                  } G                 charflg = CF_OUTC;      /* Back to simple outputting */ 
             }              break;  >           case CF_TOSS:                 /* Ignore this char */8             charflg = CF_OUTC;          /* Reset flag */             break;	         }      }  }                    /*  * Routine makerect   *F  * Make a rectangle in r starting on line lin and column col extending&  * numlin lines and numcol characters.  *  */   ! makerect(r,lin,col,numlin,numcol)  Rect *r; int lin, col, numlin, numcol;  { *     r->TOP = lin * LINEHEIGHT + TOPMARGIN;+     r->LEFT = col * CHARWIDTH + LEFTMARGIN; -     r->BOTTOM = r->TOP + numlin * LINEHEIGHT; ,     r->RIGHT = r->LEFT + numcol * CHARWIDTH; }    /*  *   Lookup:G  *      Lookup a given character in the apropriate character table, and C  *      return a pointer to the appropriate function, if it exists.   */    PFI  lookup(index,table,min,max)  char index;  PFI table[];
 int min, max;  { #     if (index > max || index < min) F         return((PFI) NULL);             /* Don't index out of range */     return(table[index-min]);  }      /*
  *   Flushio: F  *      Initialize some communications constants, and clear screen and  *      character buffers.  */   	 flushio()  {      int err;       err = KillIO(-6); -     if (err) printerr("Bad input clear",err);      err = KillIO(-7); -     if (err) printerr("Bad ouput clear",err);  }                     ; /* sendbreak - sends a break across the communictions line.   *@  * The argument is in units of approximately 0.05 seconds (or 50C  * milliseconds).  To send a break of duration 250 milliseconds the F  * argument would be 5; a break of duration 3.5 seconds would be (umm,  * lets see now) 70.  *  */    sendbreak(msunit)  {      LONGINT finalticks;   E /* delay wants 1/60th units.  We have 3/60 (50 ms.) units, convert */        msunit = msunit*3;  
 #ifdef SUMACC ;     Control(outnum,12,&controlparam);   /* Start marking */  #else <     SerSetBrk(outnum);                  /* start breaking */ #endif3     Delay((LONGINT) msunit,&finalticks);/* delay */ 
 #ifdef SUMACC :     Control(outnum,11,&controlparam);   /* Stop marking */ #else ;     SerClrBrk(outnum);                  /* stop breaking */  #endif   }                    MDrawChar(chr)	 char chr;  { 
     PFI funp;   9 /* If it's a control char, do the apropriate function. */   G     if (chr < ' ')                      /* Is it a control character */      {          flushbuf(); M         if (funp=lookup(chr,controltable,MINSINGCMDS,MAXSINGCMDS)) (*funp)();      } M     else if (chr < 0177)                /* Don't do Mac graphic characters */      { +         switch (graphicsinset[current_set]) 	         { P             case GRAF_SET:              /* Do VT100 graphics (offset to characte r in VT100 font) */ =                 if ((chr >= '_') && (chr <= '~'))  chr +=128;                  break;  N             case UK_SET:                /* Use pound symbol from VT100 font */L                 if (chr == '#') chr = 0375;  /* VT100 pound symbol = 0375 */                 break;	         } J         if (curcol >= MAXCOL)           /* Are we about to wrap around? */	         { H             if (autowrap)               /* If autowrap indicated wrap */
             {                  flushbuf(); 8                 if (newline == FALSE) carriage_return();                 line_feed();
             }              else
             { P                 flushbuf();             /* (UoR) make sure last char is shown */F                 back_space();           /* Otherwise just overwrite */J /*              outcnt--; */ /*(UoR) */ /* Overwrite buffered chars too */
             } 	         } :         if (insert)                     /* Insert mode? */	         { M             insert_char();              /* Open hole for char if requested */ @             erase_char();               /* Erase the old char */             DrawChar(chr);	         } L         else buf_char(chr);             /* Otherwise just buffer the char */$         scr[curlin][curcol++] = chr;     }  }                      /*$  *      Control character functions:?  *              Each of the following allow the mac to simulate @  *              the behavior of a terminal when given the proper"  *              control character.  */    back_space() { "     if (curcol > 0) relmove(-1,0); }    erase_char() {      Rect r;   C     scr[curlin][curcol] = ' ';          /* Erase char for update */ B     makerect(&r,abslin,curcol,1,1);     /* One char by one line */  N     EraseRect(&r);              /* (UoR) use InvertRect instead of FillRect */     if (invert) InvertRect(&r);  }    tab()  { 
     int i;   /*    for (i=0; i<NUMTABS; i++)      { !         if (tabstops[i] > curcol) 	         { (             absmove(tabstops[i],abslin);             return; 	         } 2     }*/   /* (UoR) remove old method of tabbing */  '           /* (UoR) find next tabstop */ ;      for (i=curcol+1; (i<MAXCOL) && (tabstops[i]==0); i++);       absmove(i,abslin);  }    line_feed()  { M /*    int tbot, ttop, tlout; */         /* (UoR) don't need these any more */   L     if (newline) absmove(0,abslin);     /* (UoR) perform newline function */       if (curlin == scrbot) C         scroll_up(scrtop,curlin);       /* (UoR) scroll lines up */    /*    { =         ScrollRect((Rect *) scrollrect,0,-LINEHEIGHT,dumptr);          zeroline(scrtop);          tbot = scrbot;         ttop = scrtop;         tlout = nxtlin[scrbot];           nxtlin[scrbot] = scrtop;         scrbot = scrtop;          scrtop = nxtlin[scrtop];,         if (ttop == toplin) toplin = scrtop;/             else nxtlin[fndprv(ttop)] = scrtop;          if (tbot == botlin) 	         {              botlin = scrbot;              nxtlin[botlin] = -1;	         } $         else nxtlin[scrbot] = tlout;         curlin = scrbot;I     } */                                /* (UoR) use Scroll_Up instead */      else relmove(0,1); }    reverse_line_feed()  { G /*    int tbot, ttop, tlout; */         /* don't need these any more */        if (curlin == scrtop) I        scroll_down(curlin,scrbot);      /* (UoR) scroll down in region */    /*    { <         ScrollRect((Rect *) scrollrect,0,LINEHEIGHT,dumptr);         zeroline(scrbot);          tbot = scrbot;         ttop = scrtop;         tlout = nxtlin[scrbot];           nxtlin[scrbot] = scrtop;         scrtop = scrbot;          scrbot = fndprv(scrbot);,         if (ttop == toplin) toplin = scrtop;/             else nxtlin[fndprv(ttop)] = scrtop;          if (tbot == botlin) 	         {              botlin = scrbot;              nxtlin[botlin] = -1;	         } $         else nxtlin[scrbot] = tlout;         curlin = scrtop;C     } */                        /* (UoR) use scroll_down instead */      else relmove(0,-1);  }    carriage_return()  { D     if (newline) line_feed();   /* (UoR) perform newline function */        else absmove(0,abslin); }   
 new_line() {      carriage_return();     line_feed(); }  clear_screen() {      register int i;      Rect r;   >     makerect(&r,0,0,MAXLIN,MAXCOL);     /* The whole screen */     EraseRect(&r);  M     for (i=0; i<MAXLIN; i++) zeroline(i);   /* Clear up the update records */  }   
 home_cursor()  { -     if (relorigin) absmove(0,fndabs(scrtop)); G        else absmove(0,0);       /* (UoR) correct for relative origin */  }    bell() {      SysBeep(3);  }    escape_seq() { N     charflg = CF_SESC;                  /* Say we are in an escape sequence */ }   7 graphic_G0()				/* (UoR) do VT100 graphic characters */  {      charflg = CF_GRF0; }  graphic_G1() {      charflg = CF_GRF1; }  control_N()  { 3     current_set = 1;    /* set to graphics set 1 */  }  control_O()  { 3     current_set = 0;    /* set to graphics set 0 */  }    clear_line() { 
     int i;     Rect r;        switch (num1)      { G         case 0:                         /* Clear:  here to the right */ 7             makerect(&r,abslin,curcol,1,MAXCOL-curcol); ?             for (i=curcol; i<MAXCOL; i++) scr[curlin][i] = ' ';              break;  B         case 1:                         /* Clear:  left to here */-             makerect(&r,abslin,0,1,curcol+1); ;             for (i=0; i<=curcol; i++) scr[curlin][i] = ' ';              break;  A         case 2:                         /* Clear:  entire line */ +             makerect(&r,abslin,0,1,MAXCOL);              zeroline(curlin);              break;     }      EraseRect(&r); }    erase_display()  { 
     int i;     Rect r;        switch (num1)      {          case 0: L             clear_line();               /* Same num1 causes correct clear */P             makerect(&r,abslin+1,0,MAXLIN-abslin-1,MAXCOL); /* (UoR) -1 added */             EraseRect(&r);@             for (i=abslin+1; i<MAXLIN; i++) zeroline(fndrel(i));             break;           case 1: L             clear_line();               /* Same num1 causes correct clear */+             makerect(&r,0,0,abslin,MAXCOL);              EraseRect(&r);9             for (i=0; i<abslin; i++) zeroline(fndrel(i));              break;           case 2:              clear_screen();              break;     }  }   M /**** All cursor moves need to check that they don't go beyond the margins */    cursor_right() {      if (num1 == 0) num1 = 1;     relmove(num1,0); }   
 cursor_left()  {      if (num1 == 0) num1 = 1;     relmove(-num1,0);  }    cursor_up()  { C     int abstop;         /* (UoR) check that we don't pass scrtop */        abstop = fndabs(scrtop);     if (num1 == 0) num1 = 1;I     if ((abslin>=abstop) && (abslin-num1<abstop)) absmove(curcol,abstop);         else relmove(0,-num1);  }   
 cursor_down()  { C     int absbot;         /* (UoR) check that we don't pass scrbot */        absbot = fndabs(scrbot);     if (num1 == 0) num1 = 1;I     if ((abslin<=absbot) && (abslin+num1>absbot)) absmove(curcol,absbot);         else relmove(0,num1); }    cursor_position()  {  /*    if (--num1 < 0) num1 = 0; N       if (--num2 < 0) num2 = 0;  */     /* This is taken care of by absmove */  K       if (relorigin) absmove(--num2,fndabs(scrtop)+num1-1);     /* (UoR) */ P           else absmove(--num2,--num1);  /* (UoR) moved "--" here from prev lines  */  }   
 cursor_save()  { N     savcol = curcol;                    /* Save the current line and column */     savlin = abslin;  =     savsty = textstyle;                 /* (UoR) additions */      savfnt = currentfont;      savmod = invert;     savgrf = current_set; !     savset[0] = graphicsinset[0]; !     savset[1] = graphicsinset[1];  }    cursor_restore() { M     absmove(savcol,savlin);             /* Move to the old cursor position */   =     textstyle = savsty;                 /* (UoR) additions */      currentfont = savfnt;      invert = savmod;     TextFont(currentfont);     TextFace(textstyle);     current_set = savgrf; !     graphicsinset[0] = savset[0]; !     graphicsinset[1] = savset[1];  }   
 cursor_draw()  { A /*    Line(CHARWIDTH,0);*/                      /* Draw cursor */        Rect r;        if (cursor_invert == FALSE)      { M         makerect(&r,abslin,curcol,1,1);         /* (UoR) Make Solid Cursor */ K         r.LEFT--;                               /* make r a little wider */          r.TOP--;         InvertRect(&r);      } H     if (oldlin >= 0)                    /* (UoR) replace mouse cursor */     { '         makerect(&r,oldlin,oldcol,1,1);          r.LEFT--;          r.TOP--;         PenMode(patXor);         FrameRect(&r);         PenMode(patCopy);      }      cursor_invert = TRUE;      cur_drawn = TRUE;  }    cursor_erase() { B /*    Line(-CHARWIDTH,0);*/                     /* Erase cursor */       Rect r;        if (cursor_invert)     { N         makerect(&r,abslin,curcol,1,1);         /* (UoR) Erase Solid Cursor */K         r.LEFT--;                               /* make r a little wider */          r.TOP--;         InvertRect(&r);      } G     if (oldlin >= 0)                    /* (UoR) remove mouse cursor */      { &        makerect(&r,oldlin,oldcol,1,1);        r.LEFT--;        r.TOP--;         PenMode(patXor);         FrameRect(&r);         PenMode(patCopy);     }      cursor_invert = FALSE;     cur_drawn = FALSE; }    flash_cursor(theWindow)  WindowPtr theWindow; {      Rect r;   #     if (FrontWindow() != theWindow)      { !         last_flash = TickCount();          return;      } 3     if (((TickCount() - last_flash) > CARETTIME) || (          (TickCount() - last_flash) < 0)     { '         makerect(&r,abslin,curcol,1,1);          r.TOP--;         r.LEFT--; !         last_flash = TickCount();          if (cur_drawn)	         {              InvertRect(&r); 5             if (cursor_invert) cursor_invert = FALSE; *                 else cursor_invert = TRUE;	         }      }  }    /*L  * Bittest returns the setting of an element in a Pascal PACKED ARRAY [0..n]A  * OF BOOLEAN such as the KeyMap argument returned by GetKeys().    */    BOOLEAN  bittest (bitmap, bitnum)   char	bitmap[];
   int	bitnum;  { 3   return (0x01 & (bitmap[bitnum/8] >> (bitnum%8)));  }    check_pointer(theWindow) WindowPtr theWindow; { 9     int mouse_in_window, options_pressed, newlin, newcol;      Point MousePt;O     INTEGER keyMask[8];	/* Used as KeyMap (PACKED ARRAY [0..127] of BOOLEAN) */      Rect r;        GetMouse(&MousePt); 5     mouse_in_window = PtInRect(&MousePt,&ScreenRect);      GetKeys(keyMask); M     options_pressed = bittest (keyMask, KC_CMD) && bittest (keyMask, KC_OPT);   2     newlin = (MousePt.V - TOPMARGIN) / LINEHEIGHT;2     newcol = (MousePt.H - LEFTMARGIN) / CHARWIDTH;  1     PenMode(patXor);    /* For FrameRect calls */   '     if ((FrontWindow() == theWindow) &&          (mouse_in_window) &&         (options_pressed) &&         (cur_drawn))     { 5         if ((oldlin != newlin) || (oldcol != newcol)) 	         {              if (oldlin >= 0)
             { /                 makerect(&r,oldlin,oldcol,1,1);                  r.TOP--;                 r.LEFT--;                  FrameRect(&r);
             } F /*          else HideCursor; */  /* Do this when we find HideCursor */  +             makerect(&r,newlin,newcol,1,1);              r.TOP--;             r.LEFT--;              FrameRect(&r);               oldlin = newlin;             oldcol = newcol;	         } P         SetCursor(*mousecursor); /* Use blank cursor until we find HideCursor */     }   '     if ((FrontWindow() != theWindow) || $         (mouse_in_window != TRUE) ||$         (options_pressed != TRUE) ||         (cur_drawn != TRUE))     {          if (oldlin >= 0)	         { +             makerect(&r,oldlin,oldcol,1,1);              r.TOP--;             r.LEFT--;              FrameRect(&r);               oldlin = -1;J /*          ShowCursor;*/       /* when we find out where ShowCursor is */	         }          SetCursor(ARROW);      }   >     PenMode(patCopy);           /* reset to normal pen mode */ }    mouse_cursor_move(evt) EventRecord *evt;  { 6     int code, mouselin, mousecol, tempcol, templin, i;     Point MousePt;     register KSET *KS;       code = evt->modifiers;     code &= cmdKey + optionKey;        KS = *kshdl;  #     if (code == cmdKey + optionKey)      {          MousePt = evt->where;           GlobalToLocal(&MousePt);8         mouselin = (MousePt.V - TOPMARGIN) / LINEHEIGHT;8         mousecol = (MousePt.H - LEFTMARGIN) / CHARWIDTH;         tempcol = curcol;          templin = abslin;            if (mousecol < tempcol) ,             for (i=tempcol; i>mousecol; i--)
             { @                 writeps(getindstr(*(KS->fcnshdl), LEFTARROW+1));                 waitasec(); N                         /* If tabs are used, we may go too far, so end loop */5                 if (curcol <= mousecol) i = mousecol; 
             }          if (mouselin < templin) ,             for (i=templin; i>mouselin; i--)
             { =                writeps(getindstr(*(KS->fcnshdl), UPARROW+1));                 waitasec();
             } $         else if (mouselin > templin),             for (i=templin; i<mouselin; i++)
             { ?                writeps(getindstr(*(KS->fcnshdl), DOWNARROW+1));                 waitasec();
             } M         if (abslin == mouselin) tempcol = curcol;       /* for short lines */          if (tempcol < mousecol) ,             for (i=tempcol; i<mousecol; i++)
             { A                 writeps(getindstr(*(KS->fcnshdl), RIGHTARROW+1));                  waitasec(); N                         /* If tabs are used, we may go too far, so end loop */5                 if (curcol >= mousecol) i = mousecol; 
             }        }  }   E waitasec()      /* (UoR) get any characters, and pause for a while */  {      long end_time;  E     end_time = TickCount() + 2;         /* pause for 1/30th second */ $     while (TickCount() < end_time) ;     inpchars();  }                    set_scroll_region()  { J     if (--num1 < 0) num1 = 0;           /* Make top of line (prev line) */F     if (num2 == 0) num2 = 24;           /* Zero means entire screen */  E     if (num1 < num2-1)          /* (UoR) make sure region is legal */      { G            /* (UoR) remove scrollrect, since it is not used any more */ G        topmargin = /*scrollrect[0] =*/ (num1 * LINEHEIGHT) + TOPMARGIN; J        bottommargin = /*scrollrect[2] =*/ (num2 * LINEHEIGHT) + TOPMARGIN;          scrtop = fndrel(num1);         scrbot = fndrel(num2-1);   H        home_cursor();                   /* We're supposed to home it! */     }  }     0 text_mode()                             /**** */ {      switch(num1)     {          case 0:              invert=FALSE; J             TextFont(VT100FONT);                /* (Uor) Use plain font */$             currentfont = VT100FONT;             textstyle=0;             TextFace(0);J /*          TextMode(srcOr);*/                  /* (UoR) always use XOR */             break;           case 1: " /*          textstyle +=boldStyle;L             TextFace(textstyle);  */   /* remove old bold algorithm (UoR) */C             TextFont(VT100BOLD);        /* use bold font instead */ $             currentfont = VT100BOLD;             break;           case 4: J /*          textstyle+=underline; */  /* use = not += (avoid roll-over) */1             textstyle = underline;    /* (UoR) */               TextFace(textstyle);             break;  L         case 5:                                 /* (UoR) blink is inverse */         case 7:              invert=TRUE;J /*          TextMode(srcBic);*/                 /* (UoR) always use XOR */             break;           case 21:         case 22:% /*        if (textstyle >= boldStyle) 
             { .                 TextFace(textstyle-boldStyle);'                 textstyle -= boldStyle; L             } */                       /* remove old bold algorithm (UoR) */D                 TextFont(VT100FONT);       /* reset to plain font */(                 currentfont = VT100FONT;             break;           case 24:' /*          if (textstyle >= underline) 
             { .                 TextFace(textstyle-underline);'                 textstyle -= underline; J             } */                /* remove old method of underline (Uor) */?             TextFace(0);        /* just reset to plain style */ O                                 /* since bolding is done via a separate font */              textstyle = 0;             break;           case 25:         case 27:             invert = FALSE; J /*          TextMode(srcOr);*/                  /* (UoR) always use XOR */             break;     }  }                    /*  * (UoR)  *B  * Insert and Delete lines (replacements for originals, which have  *   which have been deleted)   *  */   
 insert_line()  {      int i,absbot;        absbot = fndabs(scrbot);  5     if ((abslin>=fndabs(scrtop)) && (abslin<=absbot))      {           if (num1 == 0) num1 = 1;?         if (num1 > absbot-abslin+1) num1 = absbot - abslin + 1;   :         for (i=0; i<num1; i++) scroll_down(curlin,scrbot);     }  }   
 delete_line()  {      int i,absbot;        absbot = fndabs(scrbot);  5     if ((abslin>=fndabs(scrtop)) && (abslin<=absbot))      {           if (num1 == 0) num1 = 1;?         if (num1 > absbot-abslin+1) num1 = absbot - abslin + 1;   8         for (i=0; i<num1; i++) scroll_up(curlin,scrbot);     }  }                   
 delete_char()  { 
     int i;     Rect r;        if (num1 == 0) num1 = 1;  /     makerect(&r,abslin,curcol,1,MAXCOL-curcol);   >     if(num1 > MAXCOL - curcol - 1) num1 = MAXCOL - curcol - 1;  A     ScrollRect(&r,-CHARWIDTH*num1,0,dumptr);  /* Scroll em out */   ? /* Shift em down */     /* (UoR) used to assign using abscol */   L     for (i=curcol; i<MAXCOL-num1; i++) scr[curlin][i] = scr[curlin][i+num1];O     while (i < MAXCOL) scr[curlin][i++] = ' ';  /* Fill in holes with spaces */  }   
 insert_char()  { 
     int i;     Rect r;   /     makerect(&r,abslin,curcol,1,MAXCOL-curcol);   &     ScrollRect(&r,CHARWIDTH,0,dumptr);  B /* Shift em up */       /* (UoR) used to assign ...[i-1]=...[i] */?                         /* (UoR) used to assign using abscol */   F     for (i=MAXCOL-1; i>curcol; i--) scr[curlin][i] = scr[curlin][i-1];     scr[curlin][curcol] = ' '; }   
 insert_mode()  { J     if (prvchr == '?') set_mode();      /* (UoR) do some of these calls */       switch(num1)     {          case 20:             newline = TRUE;              break;           case 4:              insert = TRUE;             break;     }  }    end_insert_mode()  { J     if (prvchr == '?') reset_mode();    /* (UoR) do some of these calls */       switch(num1)     {          case 20:             newline = FALSE;             break;           case 4:              insert = FALSE;              break;     }  }   
 set_mode() {      Rect r;        switch(num1)     {          case 5: &             if (screeninvert == FALSE)
             { C                BackPat(BLACK);     /* (UoR) use black background */ .                makerect(&r,0,0,MAXLIN,MAXCOL);                InvertRect(&r);#                screeninvert = TRUE; 
             }              break;           case 6:              relorigin = TRUE;              home_cursor();             break;           case 7:              autowrap = TRUE;             break;           case 8:              autorepeat = TRUE;             break;     }  }    reset_mode() {      Rect r;        switch(num1)     {          case 5:              if (screeninvert) 
             {                 BackPat(WHITE);.                makerect(&r,0,0,MAXLIN,MAXCOL);                InvertRect(&r);$                screeninvert = FALSE;
             }              break;           case 6:              relorigin = FALSE;             home_cursor();             break;           case 7:              autowrap = FALSE;              break;           case 8:              autorepeat = FALSE;              break;     }  }   	 set_tab()  {      tabstops[curcol] = 1;  }    clear_tab()  { 
     int i;       switch(num1)     {          case 0: !             tabstops[curcol] = 0;              break;           case 3: 5             for (i=0; i<MAXCOL; i++) tabstops[i] = 0;              break;     }  }                   M writereply(s)           /* (UoR) use for respoding to information requests */  char *s; {      LONGINT wrcnt, w2;     int err; char *s2;  =     w2 = wrcnt = strlen(s);     /* How long is the string? */ 4     for (s2 = s; w2 > 0; w2--,s2++) /* add parity */       *s2 = dopar(*s2); B     err = FSWrite(outnum,&wrcnt,s);     /* Respond to the query */+     if (err) printerr("Bad Writeout:",err);  }    query_terminal() {      writereply(querystring); }   3 request_report()                /* (UoR) reports */  {      switch(num1)     { 8        case 5:          /* (UoR) report that we're OK */"          writereply(reportstring);          break;   =        case 6:          /* (UoR) reprt the cursor position */           position_report();           break;   9        case 15:         /* (UoR) report printer status */ 2          if (prvchr == '?') writereply(noprinter);          break;      }  }    position_report()  { 
     int i;     char buf[9];     char *report;   
     i = 0;     buf[i++] = '\033';     buf[i++] = '['; 4     if (abslin>9) buf[i++] = '0' + (abslin +1) / 10;'     buf[i++] = '0' + (abslin + 1) % 10;      buf[i++] = ';'; 3     if (curcol>9) buf[i++] = '0' + (curcol + 1)/10; '     buf[i++] = '0' + (curcol + 1) % 10;      buf[i++] = 'R';      buf[i] = '\0';     report = buf;      writereply(report);  }    dummy()  {  }    multi_char() { L     numone[0] = numtwo[0] = '0';        /* Initialize the numbers to zero */!     numone[1] = numtwo[1] = '\0'; J     numptr = numone;                    /* Place to put the next number */>     prvchr = '\0';                      /* No priv char yet */M     charflg = CF_MESC;                  /* Say we are in a ESC [ swequence */  }    toss_char()  {      charflg = CF_TOSS; }                    /*  * Routine zeroline   *?  * Zero (set to space) all the characters in relative line lin.   *  */   
 zeroline(lin)  int lin; {      register int i;   /     for (i=0; i<MAXCOL; i++) scr[lin][i] = ' ';  }    /*D  * Move a relative number of lines and chars.  Both can be negative.  *  */    relmove(hor,ver) { ) /*    Move(hor*CHARWIDTH,ver*LINEHEIGHT);      curcol += hor;     abslin += ver;?     curlin = fndrel(abslin);*/  /* (UoR) remove old function */   M     absmove(curcol+hor,abslin+ver);     /* (UoR) use absmove, which checks */ J                                         /* for cursor moving off screen */ }    /*3  * Move to absolute position hor char and ver line.   *  */    absmove(hor,ver) { O     if (hor>MAXCOL-1) hor = MAXCOL-1;   /* (UoR) make sure its on the screen */      if (hor<0) hor = 0; %     if (ver>MAXLIN-1) ver = MAXLIN-1;      if (ver<0) ver = 0;      if (relorigin)     { 5         if (ver<fndabs(scrtop)) ver = fndabs(scrtop); 5         if (ver>fndabs(scrbot)) ver = fndabs(scrbot);      }   J     MoveTo(hor*CHARWIDTH+LEFTMARGIN,(ver+1)*LINEHEIGHT+TOPMARGIN-LINEADJ);     curcol = hor;      abslin = ver;      curlin = fndrel(ver);  }                    /*  * (UoR)  *?  * Scroll lines within the scroll region upwards from line tlin 7  * to line blin (lines are assumed to be in the region)   *  */    scroll_up(tlin,blin) int tlin,blin; {     int newtop,abstop; 
    Rect r;      abstop = fndabs(tlin); :    makerect(&r,abstop,0,fndabs(blin) - abstop + 1,MAXCOL);'    ScrollRect(&r,0,-LINEHEIGHT,dumptr);   E    if (tlin == blin)            /* if only one line, just clear it */     {        zeroline(blin);        return;    }  B    newtop = nxtlin[tlin];                       /* new top line */  M    if (tlin == scrtop) scrtop = newtop;         /* reset scrtop, if needed */ M    if (tlin == toplin) toplin = newtop;         /* reset toplin, if needed */ L      else nxtlin[fndprv(tlin)] = newtop;        /* else de-link tlin line */  M    nxtlin[tlin] = nxtlin[blin];                 /* link tlin in after blin */     nxtlin[blin] = tlin;   I    if (blin == scrbot)          /* reset pointers to bottom of regions */     {(       if (blin == botlin) botlin = tlin;       scrbot = tlin;    }  4    zeroline(tlin);              /* clear the line */    curlin = fndrel(abslin);  }    /*  * (UoR)  *A  * Scroll lines in scroll region down from line tlin to line blin 5  * (lines are assumed to be within the scroll region)   *  */     scroll_down(tlin,blin)   int tlin,blin;   {      int abstop,newbot;       Rect r;        abstop = fndabs(tlin); 8      makerect(&r,abstop,0,fndabs(blin)-abstop+1,MAXCOL);(      ScrollRect(&r,0,LINEHEIGHT,dumptr);  E      if (tlin == blin)          /* if only one line, just clear it */       {         zeroline(tlin);          return;       }  E      newbot = fndprv(blin);                     /* new bottom line */   M      if (tlin == scrtop) scrtop = blin;         /* reset scrtop, if needed */ M      if (tlin == toplin) toplin = blin;         /* reset toplin, if needed */ K         else nxtlin[fndprv(tlin)] = blin;       /* else de-link top line */   J      nxtlin[newbot] = nxtlin[blin];             /* link blin above tlin */      nxtlin[blin] = tlin;   E      if (blin == scrbot)        /* reset bottom of region pointers */       {,         if (blin == botlin) botlin = newbot;         scrbot = newbot;      }        zeroline(blin);      curlin = fndrel(abslin);  }                    /*8  * Find the relative line number given the absolute one.  *  */   
 fndrel(linum) 
 int linum; {      register int i, lin;       lin = toplin; .     for (i=0; i<linum; i++) lin = nxtlin[lin];     return(lin); }    /*8  * Find the absolute line number given the relative one.  *  */   
 fndabs(linum) 
 int linum; {      int i, lin;        lin = toplin; 
     i = 0;     while (lin != linum)     {          i++;         lin = nxtlin[lin];     }      return(i); }    /*C  * Find the previous relative line number from relative line linum.   *  */   
 fndprv(linum) 
 int linum; {      int lin;       lin = toplin; 3     while (nxtlin[lin] != linum) lin = nxtlin[lin];      return(lin); }                   
 term_redraw()  {      int i, lin;      Rect r;        lin = toplin;      for (i=0; i<MAXLIN; i++)     { >         MoveTo(LEFTMARGIN,(i+1)*LINEHEIGHT+TOPMARGIN-LINEADJ);I         if (screeninvert)       /* (UoR) refresh screen in invert mode */ 	         { %            makerect(&r,i,0,1,MAXCOL);             EraseRect(&r); 	         }          DrawString(scr[lin]);          lin = nxtlin[lin];     } '     MoveTo(curcol*CHARWIDTH+LEFTMARGIN, 1         (abslin+1)*LINEHEIGHT+TOPMARGIN-LINEADJ); J     if (cur_drawn && cursor_invert)  /* (UoR) only if cursor is showing */     { H         cursor_invert = FALSE;          /* (UoR) make sure we draw it */;         cursor_draw();                  /* redraw cursor */ ?         last_flash = TickCount();       /* (UoR) reset timer */      }  }    init_term()  { 
     int i;       for (i=0; i<MAXLIN; i++)     { J         nxtlin[i] = i + 1;              /* Tie together the linked list */L         scr[i][MAXCOL] = '\0';          /* Terminate the lines as strings */     } O     toplin = 0;                         /* Initialize the top and bottom ptr */      botlin = MAXLIN - 1;I     scrtop = toplin;                    /* Scrolling region equals all */      scrbot = botlin;F     nxtlin[botlin] = -1;                /* Indicate this is the end */-     makerect (&ScreenRect,0,0,MAXLIN,MAXCOL); I                                         /* (UoR) full screen rectangle */  } 