 @part(VMSMIT,root="KER:KUSER") @string{-vmsversion="@q<3.3>"} @Chapter<VAX/VMS KERMIT>
 @label<-vmsk>  @Index[VAX/VMS] 6 @begin<description,leftmargin +12,indent -12,spread 0>K @i(Authors:)@\Robert C. McQueen, Nick Bush, Stevens Institute of Technology    @i(Language:)@\BLISS-32   ! @i(Version:)@\@value(-vmsversion)    @i(Date:)@\April 2, 1986 @end<description>   8 @subheading<VAX/VMS Kermit-32 Capabilities At a Glance:>, @begin<format,leftmargin +2,above 1,below 1>' @tabclear()@tabset(3.5inches,4.0inches)  Local operation:@\Yes  Remote operation:@\Yes Transfers text files:@\Yes Transfers binary files:@\Yes Wildcard send:@\Yes  @q<^X/^Y> interruption:@\Yes" Filename collision avoidance:@\Yes Timeouts:@\Yes   8th-bit prefixing:@\Yes " Repeat character compression:@\Yes! Alternate block check types:@\Yes  Communication settings:@\Yes Transmit BREAK:@\No ! IBM mainframe communication:@\Yes  Transaction logging:@\Yes # Session logging (raw capture):@\Yes  Debug logging:@\Yes  Raw transmit:@\Yes Login scripts:@\No Act as server:@\Yes  Talk to server:@\Yes# Advanced commands for servers:@\Yes  Local file management:@\Yes  Command/init files:@\Yes Attribute packets:@\No @end<format>  L Kermit-32 is a program that implements the Kermit file transfer protocol forH the Digital Equipment Corporation VAX series computers under the VAX/VMSJ operating system. It is written in BLISS-32 and MACRO-32, with sources forK all BLISS modules also available as MACRO-32 sources.  Kermit-32 should run G on any VAX/VMS system from version 4.0 on (Version 3@q<.>1 of Kermit-32 = is the last version that runs under pre-4.0 releases of VMS).   K The first section of this chapter will describe the things you need to know L about the VAX/VMS file system and how Kermit-32 uses it.  The second sectionH describes the special features of Kermit-32.  The final section containsK information of interest to those who need to install Kermit-32 on a system.   ! @Section<The VAX/VMS File System>   O The two main items of interest of the VAX/VMS file system (for the Kermit user) K are the format of file specifications and the types of files and file data.   ( @Subheading<VAX/VMS File Specifications>  + VAX/VMS file specifications are of the form 3 @example(NODE::DEVICE:[DIRECTORY]NAME.TYPE;VERSION) K Under version 3.x of VMS, NAME may be up to 9 characters, TYPE may be up to L 3 characters and each item in DIRECTORY may be up to 9 character long.  Only@ alphanumeric characters may be used in DIRECTORY, NAME and TYPE.  K Under version 4.0 (and later) of VMS, NAME, TYPE and each item in DIRECTORY M may be up to 39 characters long, and may contain alphanumeric characters plus  underscore.   L VERSION is a decimal number indicating the version of the file (generation).K DEVICE may be either a physical or logical device name.  If it is a logical E name, it may be up to 63 characters long and may contain alphanumeric K characters plus dollar signs and underscores.  NODE may be either a logical K name which translates to a DECnet node name or a physical DECnet node name. M In either case, access information can be included (see the DECnet-VMS User's  guide for more information).K The node name is not normally present, since most files are accessed on the E same node where the user's job is running.  The version number is not K normally given (in fact, should not normally be given).  When device and/or M directory are not supplied, they default to the user's current default device J and directory.  Therefore, @q<NAME.TYPE> is normally all that is needed to: specify a file on the user's default device and directory.G This is also all the Kermit-32 will normally send as the name of a file  being transferred.  I The node field specifies the name (and access information) for the DECnet K node where the file is located.  Kermit-32 does not transmit the node field K to the target system, but will attempt to honor a node field in an incoming 
 file name.  M The device field specifies a physical or "logical" device upon which the file G is resident.  The directory field indicates the area on the device, for I instance the area belonging to the owner of the file.  Kermit-32 does not O normally transmit the device or directory fields to the target system, but will L attempt to honor device or directory fields that may appear in incoming fileI names. It will not create new directories, however, so any directory must  already exist.  K The name is the primary identifier for the file.  The type, also called the M "extension", is an indicator which, by convention, tells what kind of file we M have.  For instance @q<FOO.FOR> is the source of a Fortran program named FOO; H @q<FOO.OBJ> might be the relocatable object module produced by compilingH @q<FOO.FOR>; @q<FOO.EXE> could an executable program produced by LINKing @q<FOO.REL>, and so forth.   @index<Wildcard>@ VAX/VMS allows a group of files to be specified in a single fileI specification by including the special "wildcard" characters, "@q<*>" and M "@q<%>".  A "@q<*>" matches any string of characters, including no characters H at all; a "@q<%>" matches any single character.  Here are some examples:7 @Begin(Description,spread 0.5,leftmargin +8, indent -8) F @q<*.FOR>@\All files of type @q<FOR> (all Fortran source files) in the default directory. 	 0 @q<FOO.*>@\Files of all types with name @q<FOO>. 	 - @q<F*.*>@\All files whose names start with F.   J @q<F*X*.*>@\All files whose names start with F and contain at least one X.  > @q<%.*>@\All files whose names are exactly one character long.  B @q<*.%%*>@\All files whose types are at least two characters long. @End(Description) M Wildcard notation is used on many computer systems in similar ways, and it is M the mechanism most commonly used to instruct Kermit to send a group of files.   % @heading<Text Files and Binary Files>   L The file system used by VAX/VMS provides for a large number of attributes toJ be associated with each file.  These attributes provide some indication ofH whether the file is a text file, or is some other type of non-text data.G The two major attributes that affect Pro/Kermit are the record type and K record attribute.  The record type describes how logical records are stored G in the file.  Records may be of some fixed length (specified by another H attribute), or variable length (specified within each record), or streamD (implying no real record divisions).  The record attributes describeH how the breaks between records are to be treated.  For example, a recordG attribute of implied carriage return means that any program reading the I file with intentions of printing it out should add a carriage return/line D feed sequence between each record.  Other attributes include FORTRAN' carriage control and print file format.   I The "standard" method of storing text in a file under VAX/VMS is to store 6 one line of text per record (variable length records),) with a carriage return/line feed sequence ; implied by the end of the record (implied carriage return). A This is the method Kermit-32 uses to store files it receives when J using FILE TYPE TEXT.  Note that there are other formats which are used toL store text under VAX/VMS, however, the one used be Kermit-32 is the only oneN which is handled correctly by all known utility programs under VAX/VMS.  Also,L most programs which work with text files (the editor EDT, for example) placeK some limit on the length of the lines which can be handled.  Typically this N is 255.  Kermit-32 can write files with up to 4095 characters on a line, whichM means a text file from another system may be transferred and stored correctly D by Kermit-32, but may still be unusable by certain VAX/VMS programs.  L There is no standard format for storing binary files.  Basically, any recordK format with no record attributes are used for binary files.  Since programs H which work with binary files under VAX/VMS expect to see some particularH format, more information is needed for transfer of binary files than forK transfer of text files.  The current version of Kermit-32 is not capable of M transferring all types of binary files which were created on a VAX/VMS system O to another system and retrieving them intact, nor is it capable of transferring O all of types binary files created on a VAX/VMS system to another VAX/VMS, P/OS, M or RSX-11M/M+ system intact.  However, certain formats of binary files can be M transferred, and binary files from some other systems may be transferred to a  VAX and recovered intact.   C Binary files which are created on a VAX (or other Files-11 systems) G with fixed 512 byte records (a fairly common format) can be transferred B using Kermit-32.  The only required action is to set the file type& to "fixed" in the receiving Kermit-32.  = Using two programs supplied with Kermit-32, it is possible to = transfer almost any type of sequential file between VAXen, or 9 between a VAX and a P/OS or RSX-11M/M+ system.  These two B programs (VMSHEX and VMSDEH) will convert the binary files to textA (using a variation on Intel hex format).  The resulting text file G can be transferred like any other, and finally "dehexified" reproducing D the original file, with the major attributes intact.  Unfortunately,E the text files tend to be about twice the size of the original binary B files, so the transfers take a bit longer than regular text files. On the plus side, the ; text versions of the files can be transferred to any system G with a Kermit and still retrieved intact.  They can also be transferred + over 7-bit data paths without any problems. I The bootstrap procedure (described below), makes use of hexified versions , of the binary file which makes up Kermit-32.  6 @heading<Using the VAX to Archive Microcomputer Files>  J You can use Kermit to send textual files from a microcomputer or any 8-bitM system to a VAX/VMS system with no special provisions, since Kermit-32 stores K incoming files as text files (variable length records with implied carriage 0 returns) unless it is explicitly told otherwise.@ But Kermit-32 has no automatic way of distinguishing an incoming' binary file from an incoming text file. J It turns out that because of the method used by Kermit-32 for storing textJ files, a binary file can be stored like a text file so long as it does notK contain a string of more than 4095 characters between carriage return, line M feed sequences, and ends with a carriage return line feed.  Since most binary N files do not have these characteristics, you must inform Kermit-32 that a file8 it is about to receive is to be stored as a binary file.N This is done using the SET FILE TYPE BINARY command.  This instructs Kermit-32O to store the data it receives in the file without checking for carriage return, N line feed sequences.  The file it creates will be variable record length, withM no record attributes.  Each record will contain 510 bytes of data, except the L last, which will contain whatever amount is left before the end of the file.K This allows Kermit-32 to correctly return exactly the data it was sent when , the file is returned to the original system.  L Note that because of the need to use a different file type for binary files,6 it is not possible to use a "wildcard send" command toM send a mixture of text and binary files to a VAX system unless the text files $ are not intended for use on the VAX;C rather, you must send all text files with Kermit-32's file type set ? to text, and all binary files with the file type set to binary.   J Once you get the foreign file into the VAX system, stored with the correct file type, you need take no J special measures to send it back to its system of origin.  This is becauseK Kermit-32 honors the record type and attributes of the file as it is stored M on the VAX.  In fact, SET FILE TYPE BINARY or TEXT only affects how Kermit-32 B receives files - it does not affect how Kermit-32 transmits files.  ' @heading<Files Kermit-32 Cannot Handle>   J The Kermit protocol can only accommodate transfer of @i<sequential> files,6 files which are a linear sequence of bytes (or words).  2 Some files on a VAX/VMS system are not sequential," and cannot be successfully sent orI received by Kermit-32.  These are mainly indexed data files, but can also K include other files which require more than just the data in the file to be  completely reconstructed.  External control information( and file attributes are not transmitted.   @Section<Program Operation>   0 Kermit-32's prompt is normally "@q(Kermit-32>)".I If a foreign command is defined to run Kermit-32 (eg. KERMIT := $KERMIT), F Kermit-32 will accept a single command on the command line, like this: @begin[example]  $  $ @ux[Kermit send foo.bar]     @i(the file is sent)   $  $ @ux[MCR Kermit send foo.bar]     @i(the file is sent)   $ 
 @End(Example) K You can run the program interactively to issue several commands, like this:  @Begin(Example)  $  $ @ux[Run SYS$SYSTEM:Kermit]) VMS Kermit-32 version @value(-vmsversion) ) Default terminal for transfers is: _TTA1:    Kermit-32>@ux[send foo.*]      @i(files are sent)   Kermit-32>@ux[statistics]   (   @i(performance statistics are printed)   Kermit-32>@ux[receive]     @i(files are received)   Kermit-32>@ux[exit]  $ 
 @end[example]   K Command keywords may be abbreviated to their shortest prefix that sets them 1 apart from any other keyword valid in that field.   O Kermit-32 provides most of the commands possible for an "ideal" Kermit program, J as described in the main part of the @i(Kermit User Guide).  The followingE sections will concentrate on system-@|dependent aspects of Kermit-32.   * @section<Conditioning Your Job for Kermit>   @index<Interference> @index<Message Interference>J Kermit-32 does as much as it can to condition your line for file transfer.A It saves all your terminal settings, and restores them after use. H However, there are some sources of interference over which Kermit-32 hasF no control.  In particular, messages issued by other processes in your	 job could N become mingled with Kermit packets and slow things down or stop them entirely.L This is a fairly rare occurence and can be easily avoided by not running anyH other process which wishes to perform I/O to your terminal while you are running Kermit-32.  M Normally, when Kermit-32 is run, it assumes you wish to use it in remote mode J and perform file transfers over the terminal line which controls your job.L This can be overridden, however, by defining a logical name which equates toM some other terminal line in the system.  The default terminal line to be used L for file transfers is determined by the first of the following logical namesF which translates to a terminal line which is available for use by yourL process: KER$COMM, SYS$INPUT, SYS$OUTPUT, and SYS$COMMAND.  If none of theseJ logical names translate to an available terminal line, there is no defaultM terminal line and a SET LINE command must be used before any transfer command A is performed.  Note that this is the typical case in a batch job.   N Kermit-32 will also default the type of parity to be used on the communicationJ line to that which is set on its default terminal line when it is started.J This means that if all communication at a site is normally done using even: parity (for example), Kermit-32 will also use even parity.  N There are two things to keep in mind when using Kermit-32 in local mode (whereN the file transfers are done over a different terminal line from where commands are typed):  @begin(itemize,spread 0.5)G Under VAX/VMS, every terminal line has an owner UIC and protection code I associated with it.  This UIC and protection is used to determine who can J allocate (and therefore use) the terminal line when they are not logged inF on that line.  Therefore, in order for Kermit-32 to be able to performG file transfers over a terminal line other than the one on which you are J logged in, the field of the protection code for the terminal which appliesL to your job (based on your UIC and the owner UIC of the terminal) must allowM your job access to the terminal.  You may need to request your system manager H to change the protection for a terminal line to allow you to use it with Kermit-32 in local mode.  L Terminal lines which have been declared as modem control lines will have theL phone "hung up" whenever the terminal line becomes free (deallocated).  ThisN means that if you do not use the DCL ALLOCATE command to allocate the terminalL line to your job before entering Kermit-32, exiting Kermit-32 will cause theI terminal line to "hang up" the modem.  If you do wish to get to DCL after K having used Kermit-32 to connect a modem control line which you do not have J allocated, you can use the PUSH command to spawn a subprocess running DCL.
 @end<itemize>    @Section<Kermit-32 Commands>  L This section describes the Kermit-32 commands -- in detail where they differH from the "ideal" Kermit, briefly where they coincide.  Kermit-32 has the following commands:  @Begin(Format,spread 0)  @tabclear()@tabset(1.25inches) @>@@@\  synonym for "take".  @>BYE@\  to remote server.* @>CONNECT@\  as terminal to remote system. @>EXIT@\  from Kermit-32. $ @>FINISH@\  Shut down remote server." @>GET@\  remote files from server. @>HELP@\  with Kermit-32. 5 @>LOCAL@\  prefix for local file management commands. ! @>LOG@\  remote terminal session.  @>LOGOUT@\  remote server. @>PUSH@\  to DCL command level.  @>QUIT@\  from Kermit-32. & @>RECEIVE@\  files from remote Kermit.7 @>REMOTE@\  prefix for remote file management commands. ! @>SEND@\  files to remote Kermit. % @>SERVER@\  mode of remote operation.  @>SET@\  various parameters. @>SHOW@\  various parameters. , @>STATUS@\  about most recent file transfer.> @>TRANSMIT@\  Transmit (upload) a file with no error checking.) @>TAKE@\  Kermit-32 commands from a file.  @End(format)  ' @subsection<Commands for File Transfer>   C Kermit-32 provides the standard SEND, RECEIVE, and GET commands for - transferring files using the Kermit protocol.    @Heading<The SEND Command>$ @Index[Initial Filespec]@Index[SEND] Syntax:    Sending a file or files:   @display(@q<SEND @i{filespec}>)  K The SEND command causes a file or file group to be sent from the VAX to the 
 other system. L If @i{filespec} contains wildcard characters then all matching files will beJ sent, in alphabetical order (according to the ASCII collating sequence) by name. N If @i{filespec} does not contain any wildcard characters, then the single file' specified by @i{filespec} will be sent.   0 @Subheading<@ @ SEND Command General Operation:>  " @Index<Normal Form for File Names>A Files will be sent with at least their VAX/VMS file name and type N (for instance @q<FOO.BAR>).  If a SET FILE NAMING FULL command has been given,K Kermit-32 will also send the device name, directory name and version number C (for instance @q<USER$DISK:[JOE]FOO.BAR;25>).  If a SET FILE NAMING L UNTRANSLATED command has been given, Kermit-32 will send the file name, typeG and version number (for instance @q<FOO.BAR;25>).  If a SET FILE NAMING K NORMAL_FORM command has been given (this is the initial default), Kermit-32 & will only send the file name and type.  K Each file will be sent according to the record type and attributes recorded G in its file descriptor.  Kermit-32 attempts to translate all formats of G text file (including those with FORTRAN or print carriage control) to a C format usable on any system.  Note that there is no need to set the F FILE TYPE parameter for sending files, since Kermit-32 always uses theG information from the file descriptor to determine how to send the file.   ; @Index<Parity>@Index<Eighth-Bit Prefix>@Index<Binary Files> K If communication line parity is being used (see SET PARITY), Kermit-32 will J request that the other Kermit accept a special kind of prefix notation forO binary files.  This is an advanced feature, and not all Kermits have it; if the L other Kermit does not agree to use this feature, binary files cannot be sentH correctly.  This includes executable programs (like @q<.EXE> files, CP/ML @q<.COM> files), relocatable object modules (@q<.OBJ> files), as well as any7 text file containing characters with the eighth bit on.   & @Index<Repeated Character Compression>O Kermit-32 will also ask the other Kermit whether it can handle a special prefix M encoding for repeated characters.  If it can, then files with long strings of I repeated characters will be transmitted very efficiently.  Columnar data, J highly indented text, and binary files are the major beneficiaries of this
 technique.  H If you're running Kermit-32 locally, for instance dialing out from a VAXL to another system using an autodialer, you should have already run Kermit onB the remote system and issued either a RECEIVE or a SERVER command.G Once you give Kermit-32 the SEND command, the name of each file will be 0 displayed on your screen as the transfer begins.1 If the file is successfully transferred, you will 9 see "@q<[OK]>", otherwise there will be an error message.   L During local operation, you can type Control-A@Index<Control-A> at any point1 during the transfer to get a brief status report. L @index<Control-X>@index<Control-Z>@Index<Cancelling a File Transfer> You mayM also type Control-X or Control-Z to interrupt the current file or file group.    @Heading<The RECEIVE Command>  @Index[RECEIVE] # Syntax:  @q<RECEIVE [@i{filespec}]>   L The RECEIVE command tells Kermit-32 to receive a file or file group from theO other system.  If only one file is being received, you may include the optional N @i{filespec} as the name to store the incoming file under; otherwise, the nameI is taken from the incoming file header.  If the name in the header is not F a legal VAX/VMS file name, Kermit-32 will normally replace the illegal6 characters with "X" (see SET FILE NAMING NORMAL_FORM).  - @index<DELETE>@index<UNDELETE>@index<Version> + If an incoming file has the same name as an H existing file, Kermit-32 just creates a new version of the same name and, type, for instance @q<FOO.BAR;3, FOO.BAR;4>.  @ Incoming files will all be stored with the prevailing file type, ASCII by default, L which is appropriate for text files.  @Index<Binary Files> If you are askingM Kermit-32 to receive binary files from a microcomputer or other 8-bit system, H you must first type SET FILE TYPE BINARY.  Otherwise, an error may occurI when receiving the file, or a carriage return, line feed will be added to M the end of the file and the file will be useless when sent back to the system 
 of origin.  ' @Index<Parity>@Index<Eighth-Bit Prefix> 3 If parity is being used on the communications line, 7 then 8th-bit prefixing will be requested.  If the other B side cannot do this, binary files cannot be transferred correctly.  L If an incoming file does not arrive in its entirety, Kermit-32 will normallyO discard it; it will not appear in your directory.  You may change this behavior # @Index<Incomplete File Disposition> N by using the command SET INCOMPLETE KEEP, which will cause as much of the file* as arrived to be saved in your directory.   F If you are running Kermit-32 locally, you should already have issued aN SEND command @foot(@i<not> SERVER -- use the GET command to receive files fromK a Kermit server.) to the remote Kermit, and then escaped back to Kermit-32. > As files arrive, their names will be displayed on your screen.E You can type Control-A during the transfer for a brief status report.   D @Index<Control-X>@Index<Control-Z>@Index<Cancelling a File Transfer>J If a file arrives that you don't really want, you can attempt to cancel it= by typing Control-X; this sends a cancellation request to the F remote Kermit.  If the remote Kermit understands this request (not all@ implementations of Kermit support this feature), it will comply;K otherwise it will continue to send.  If a file group is being sent, you can : request the entire group be cancelled by typing Control-Z.   @Heading<The GET Command>   % Syntax: @q<GET [@i{remote-filespec}]>   N The GET command requests a remote Kermit server to send the file or file groupO specified by @i<remote-filespec>.  This command can be used only when Kermit-32 L is local, with a Kermit server on the other end of the line specified by SETN LINE.  This means that you must have CONNECTed to the other system, logged in,I run Kermit there, issued the SERVER command, and escaped back to the VAX.   L The remote filespec is any string that can be a legal file specification forM the remote system; it is not parsed or validated locally.  Any leading spaces M before the remote filespec are stripped, and lower case characters are raised  to upper case.  I As files arrive, their names will be displayed on your screen.  As in the K RECEIVE command, you may type Control-A to get a brief status report, ^X to K request that the current incoming file be cancelled, ^Z to request that the # entire incoming batch be cancelled.   O If the remote Kermit is not capable of server functions, then you will probably L get an error message back from it like "Illegal packet type".  In this case,K you must connect to the other Kermit, give a SEND command, escape back, and  give a RECEIVE command.    @Heading<The STATUS Command>4 Give statistics about the most recent file transfer.   @Heading<The PUSH Command>   Syntax: @q<TAKE>  H Invoke an inferior DCL command processor, to which you may issue any DCL. commands.  Type LOGOUT to return to Kermit-32.   @Heading<The TAKE Command>  + Syntax: @q<TAKE @i<file-spec> [ /DISPLAY ]>   N Where 'file-spec' is any normal VAX/VMS file specification.  If file-spec doesM not specify a file-type Kermit-32 will supply a default of .COM. The /DISPLAY K option causes the commands read from the file to be displayed on the user's 
 terminal.   I The TAKE command tells Kermit-32 to execute commands from the  specified  M file. You may also use the VAX/VMS notation "@@" instead of Take to specify a  command file.    @subsection<Server Operation>    @Heading<The SERVER Command> @Index<Server>  G The SERVER command puts a remote Kermit-32 in "server mode", so that it N receives all further commands in packets from the local Kermit.  The Kermit-32O server is capable (as of this writing) of executing the following remote server @ commands:  SEND, GET, FINISH, BYE, REMOTE DIRECTORY, REMOTE CWD,C REMOTE SPACE, REMOTE DELETE, REMOTE TYPE, REMOTE HELP, REMOTE COPY, @ REMOTE RENAME, REMOTE SEND_MESSAGE, REMOTE WHO, and REMOTE HOST.  N Any nonstandard parameters should be selected with SET commands before puttingF Kermit-32 into server mode, in particular the file type. The Kermit-32> server can send all files in the correct manner automatically.% However, if you need to ask Kermit-32 ? to receive binary files you must issue the SET FILE TYPE BINARY G command before putting it into server mode, and then you must only send M binary files.  You cannot send a mixture of text files and 8-bit binary files B to a Kermit-32 server unless the files are not for use on the VAX.   @Heading<Commands for Servers>  H When running in local mode, Kermit-32 allows you to give a wide range ofI commands to a remote Kermit server, with no guarantee the that the remote N server can process them, since they are all optional features of the protocol.E Commands for servers include the standard @q<SEND>, @q<GET>, @q<BYE>, F @q<LOGOUT> and @q<FINISH> commands, as well as the @q<REMOTE> command.   Syntax: @q<REMOTE @i{command}>  H Send the specified command to the remote server.  If the server does notJ understand the command (all of these commands are optional features of theJ Kermit protocol), it will reply with a message like "Unknown Kermit serverN command".  If does understand, it will send the results back, and they will be2 displayed on the screen.  The REMOTE commands are: @begin<description> H COPY @i<filespec>@\Copy file.  The server is asked to make a copy of theJ specified file.  Kermit-32 will prompt for the new file name on a separateJ line.  Both filespecs must be in the correct format for the remote system.J Kermit-32 does not parse or validate the file specifications.  Any leadingJ spaces will be stripped and lower case characters converted to upper case.M Note that this command simply provides for copying a file within the server's 4 system - it does not cause a file to be transferred.  G CWD [@i<directory>]@\Change Working Directory.  If no directory name is N provided, the server will change to the default or home directory.  Otherwise,M you will be prompted for a password, and the server will attempt to change to N the specified directory.  The password is entered on a separate line, and doesM not echo as you type it.  If access is not granted, the server will provide a G message to that effect.  Note that while not all server Kermits require M (or accept) a password to change the working directory, Kermit-32 will always . ask for one when a directory name is provided.  J DELETE @i<filespec>@\Delete the specified file or files.  The names of the2 files that are deleted will appear on your screen.  E DIRECTORY [@i<filespec>]@\The names of the files that match the given L file specification will be displayed on your screen, perhaps along with size= and date information for each file.  If no file specification > is given, all files from the current directory will be listed.  G DISK_USAGE [@i<directory>]@\Display information about disk usage in the E given directory (or by the given user).  If no directory is provided, O disk usage information is provided for the current working directory (or user). - This is the same as the REMOTE SPACE command.    EXIT@\Requests theM server to leave Kermit, allowing the terminal to be used for normal commands.   O FINISH@\Requests the server to return to the Kermit prompt, allowing statistics # to be obtained about the transfers.   L HELP [@i<topic>]@\Provide information about the given topic.  If no topic is> given, provide a list of the functions that are available fromJ the server.  Some servers may ignore the topic and always display the same information.  G HOST [@i<command>]@\Pass the given command to the server's host command ; processor, and display the resulting output on your screen.   K LOGIN @i<user-id>@\Supply information to the server Kermit to indicate what H user-id, account and password are to be used.  The server Kermit may useG this to validate the user's access to the system as well as for billing J purposes. It may also use this information to provide the user with access to files on its system.   J LOGOUT@\Request the server to exit Kermit and logout its job (or process).0 This command is identical to the LOGOUT command.  F RENAME @i<filespec>@\Change the name on the specified file (or files).F Kermit-32 will prompt for the new file specification on the next line.? Both file specifications must be valid for the server's system.   I SEND_MESSAGE @i<destination-address>@\Request the server to send a single C line message to the specified destination address (which might be a K user-id, terminal designator, or some other item, depending upon the server M Kermit).  Kermit-32 will prompt for the single line message on the next line.   B SPACE [@i<directory>]@\Display information about disk usage in theE given directory (or by the given user).  If no directory is provided, O disk usage information is provided for the current working directory (or user). 2 This is the same as the REMOTE DISK_USAGE command.  ; STATUS@\Display information about the status of the server.   M TYPE @i<filespec>@\Display the contents of the specified file on your screen.   K WHO [@i<user-id>]@\Display information about the given user.  If no user-id J is given, display information about the currently active users.  Kermit-32H will prompt for options for selecting what information to display and/orF formatting parameters.  The format of both the user-id and the options% are dependent upon the server Kermit.  @end<description>   / @Subsection<Commands for Local File Management>    Syntax: @q<LOCAL [@i{command}]>   J Execute the specified command on the local system -- on the VAX/VMS systemN where Kermit-32 is running.  These commands provide some local file management9 capability without having to leave the Kermit-32 program. N These commands are very similar to the REMOTE commands in function and syntax.I They are all executed locally, and are available when Kermit-32 is either E local or remote.  The arguments to these commands are the same as the F arguments expected from the user Kermit when Kermit-32 is processing a command in server mode.  @begin<description> G COPY @i<filespec>@\Make a copy of the given file (or files).  Kermit-32 D will prompt for the new file specification.  The command is actuallyM performed by using the DCL COPY command (COPY/LOG @i<old-file> @i<new-file>), H and any options which are valid on the DCL COPY command may be included.  J CWD [@i<directory>]@\Change working directory, or, in VAX/VMS terminology,K change the default device/directory.  This command takes the same arguments D as the DCL SET DEFAULT command (i.e., a device and directory, only aC directory, or only a device).  If no argument is given, the default H device and directory are reset to that in effect when Kermit-32 was run.7 The new default device and directory will be typed out.   F DELETE @i<filespec>@\Delete the specified file or files.  This commandG is performed by using the DCL DELETE command (DELETE/LOG @i<filespec>). @ Therefore, any options which are valid on the DCL DELETE command may be included.  M DIRECTORY [@i<filespec>]@\Provide a directory listing of the specified files. < This command is performed by using the DCL DIRECTORY commandL (DIRECTORY @i<filespec>), so any options valid for the DCL DIRECTORY command may be included.  K DISK_USAGE [@i<uic>]@\Display disk usage information for the given UIC.  If D no UIC is given, display disk usage information for the process UIC.L This command is performed by using the DCL SHOW QUOTA command (SHOW QUOTA or SHOW QUOTA/USER=@i<uic>).   G HELP@\Display the help message describing the server commands which are 
 available.  H HOST @i<DCL command>@\Perform the given DCL command.  The command shouldK not perform any action which will require more input.  Any output resulting / from the command will be typed on the terminal.   F RENAME @i<filespec>@\Change the name of the specified file.  Kermit-32I will prompt for the new name on the next line.  This command is performed J by using the DCL RENAME command (RENAME/LOG @i<old-file> @i<new-file>), soF any options which are valid on the DCL RENAME command may be included.  G SEND_MESSAGE @i<terminal-name>@\Send a single line message to the given I terminal.  Kermit-32 will prompt for the message on the next line.  Since 5 this command is performed using the DCL REPLY command 8 @example(REPLY/TERMINAL=@i<terminal-name> "@i<message>")) OPER privileges are needed to perform it.   @ TYPE @i<filespec>@\Display the contents of the specified file or files at your terminal. 9 Each file will be preceded by its name in angle brackets.  @end<description>     @Subsection<The CONNECT Command>  ' Syntax: @q<CONNECT [@i{terminal-name}]>   L Establish a terminal connection to the system connected to the terminal lineH specified here or in the most recent SET LINE command, using full duplexO echoing and no parity unless otherwise specified in previous SET commands.  Get O back to Kermit-32 by typing the escape character followed by the letter C.  The E escape character is Control-Close-Square-Bracket (@q<^]>) by default. G When you type the escape character, several single-@|character commands 
 are possible:   5 @Begin(Description,leftmargin +6,indent -4, spread 0) 4 @q<C>@\Close the connection and return to Kermit-32.  < @q<Q>@\If a session log is active, temporarily Quit logging.  ) @q<R>@\Resume logging to the session log.   % @q<S>@\Show status of the connection.    @q<0>@\Send a null character.   8 @q<?>@\List all the possible single-character arguments.  I @q<^]> (or whatever you have set the escape character to be):@\Typing the B escape character twice sends one copy of it to the connected host. @End(Description) N You can use the SET ESCAPE command to define a different escape character, and. SET PARITY, and SET LOCAL_ECHO to change those+ communication-@|line-@|oriented parameters. * Type the SHOW LINE command for information* about your current communication settings.  N Kermit-32 does not have any special autodialer interface.  It assumes that the9 connection has already been made and the line assigned.     & @Subsection<The SET and SHOW Commands>   @Heading<The SET Command>   6 Syntax: @q<SET @i{parameter} [@i{option} [@i{value}]]>  D Establish or modify various parameters for file transfer or terminalO connection.  You can examine their values with the SHOW command.  The following  parameters may be SET: @Begin(Format,spread 0)  @tabclear()@tabset(2.0inches) ; @>BLOCK_CHECK@\  Packet transmission error detection method = @>DEBUGGING@\  Record or display state transitions or packets 3 @>DELAY@\  How long to wait before starting to send - @>ESCAPE@\  Character for terminal connection 4 @>FILE@\  For setting file parameters like file typeE @>HANDSHAKE@\  For establishing half duplex line turnaround handshake 5 @>IBM_MODE@\  For communicating with an IBM mainframe 7 @>INCOMPLETE_FILE@\  What to do with an incomplete file ; @>LINE@\  Terminal line to use for file transfer or CONNECT 2 @>LOCAL_ECHO@\  For terminal connection, ON or OFF< @>MESSAGE@\  The type of typeout to be done during transfers# @>PARITY@\  Character parity to use / @>PROMPT@\  Change the program's command prompt 3 @>RECEIVE@\  Various parameters for receiving files 8 @>REPEAT_QUOTE@\ Character to use for repeat compression< @>RETRY@\  How many times to retry a packet before giving up. @>SEND@\  Various parameters for sending files5 @>TRANSMIT@\  Control TRANSMIT command echo and delay  @end(Format)  L Those SET commands which differ from the "ideal" Kermit are now described in detail.    @Subheading<SET DEBUGGING> @Index<Debugging> % Syntax: @q<SET DEBUGGING @i{options}>   F Record the packet traffic, either on your terminal or in a file.  SomeI reasons for doing this would be to debug a version of Kermit that you are K working on, to record a transaction in which an error occurred for evidence G when reporting bugs, or simply to vary the display you get when running & Kermit-32 in local mode.  Options are: @Begin(Description) 8 ON@\Display each incoming and outgoing packet (lengthy).  M OFF@\Don't display or record debugging information (this is the normal mode). ( If debugging was in effect, turn it off. @End(Description) N The debugging information is recorded in the file specified by the most recent LOG DEBUGGING command.   @Subheading<SET ESCAPE> $ @Index<Escape Character for CONNECT> @q<SET ESCAPE @i{octal-number}>   E Specify the control character you want to use to "escape" from remote M connections back to Kermit-32.  The default is 35 (Control-]).  The number is N the octal value of the ASCII control character, 1 to 37 (or 177), for instanceM 2 is Control-B.  After you type the escape character, you must follow it by a N one of the single-@|character "arguments" described under the CONNECT command, above.   @Subheading<SET FILE> * Syntax: @q<SET FILE @i{parameter keyword}>  " Establish file-related parameters:+ @Begin(Description,leftmargin +8,indent -8) H TYPE @i<keyword>@\@Index<File Type>Type of file for VAX/VMS file output.( The choices are ASCII, BINARY, or FIXED.+ @Begin(Description,leftmargin +8,indent -8) I ASCII@\Store the file as a standard VAX/VMS text file.  Any file received N is stored as variable length records with carriage return, line feed sequencesO implied between records.  This is the format preferred by most utility programs L under VAX/VMS.  An error will occur if any line is more than 4096 charactersH long.  Note that lines are only terminated by carriage return, line feedK sequences.  A carriage return that is not followed by a line feed or a line M feed that is not preceded by a carriage return is not considered the end of a 2 line, and is included within the body of a record.  H BINARY@\Store the file as a binary file.  Any file received is stored asK variable length records with no record attributes.  Kermit-32 actually will L write 510 bytes in each record except the last.  This makes each record takeH up one disk block (510 data bytes plus two bytes of record length).  TheM last record is written containing only as much data is left to the end of the O file.  Any file which is just a stream of bytes can be stored as a BINARY file, G and recovered intact later.  This is the preferred file type for use in  archiving files.  J FIXED@\Store the file as a fixed length binary file.  Any file received isK stored as fixed length 512 byte records with no record attributes.  This is K the format used for binary files such as VAX/VMS "EXE" files and RSX-11M/M+ H "TSK" files.  Since even the last record of the file is written with 512K bytes (even if it is not filled), this format does not necessarily maintain H the correct length of a file.  It should normally only be used for filesJ which are coming from a VAX/VMS system which are currently stored in fixed 512 byte records.  @End(Description)   " @Index<Normal Form for File Names>H NAMING @i<keyword>@\Determine the form of names to be sent with outgoingE files and determine the translation performed on incoming file names. 3 The choices are FULL, NORMAL_FORM and UNTRANSLATED. + @Begin(Description,leftmargin +8,indent -8) G FULL@\Kermit-32 will send full file names (including device, directory, K file name, file type and version number).  When receiving a file, Kermit-32 G will perform no translation of the file name (which must therefore be a " legal VAX/VMS file specification).  G NORMAL_FORM@\Kermit-32 will send only the file name and file type. When K receiving a file, Kermit-32 will convert the file specification received to J contain only uppercase letters, digits, and at most one period.  Any otherM characters will be translated to "@q<X>".  There will be at most 9 characters M before the period (if any), and at most 3 characters afterwards.  This forces K the file name to be a valid VAX/VMS file specification.  Note that standard J VAX/VMS file names and types are already normal form, and therefore do not' need translation.  This is the default.   H UNTRANSLATED@\Kermit-32 will send only the file name and file type. WhenC receiving a file, Kermit-32 will not perform any conversions on the O file specification, which therefore must be a legal VAX/VMS file specification.  @End(Description)  @End(Description)    @subheading<SET HANDSHAKE> @index<Handshake>  Syntax: @q<SET HANDSHAKE @i(o)>   E Sets the half duplex line turnaround handshake character to the ASCII J character whose octal value is @i(o).  Normally required for communication- with half duplex systems like IBM mainframes.    @subheading<SET IBM_MODE>  @index<IBM> & Syntax: @q<SET IBM_MODE ON @i(or) OFF>  M When IBM_MODE is set to ON, Kermit-32 will override the parity and local echo G settings and use odd parity, local echo on, and also enable a handshake M character of XON (control-Q, ASCII 021 octal).  This feature allows Kermit-32 I to talk with certain systems (notably some IBM mainframes), which require & waiting for a XON before sending data.  L The various features selected by this command can be overridden subsequently: by SET PARITY, SET LOCAL_ECHO, and SET HANDSHAKE commands.   @Subheading<SET LINE> ( Syntax: @q<SET LINE [@i(terminal-name)]>  B Specify the terminal name to use for file transfer or CONNECT; the2 @i<terminal-name> can be up to 16 characters long.K If you issue this command using other than your job's controlling terminal, 2 you will be running Kermit-32 @i<locally>, and youH must log in to the remote system and run Kermit on that side in order toO transfer a file.  If you don't issue this command, Kermit-32 determines whether G it is to run locally or @i<remotely> based on the default terminal line K found when Kermit-32 is started.  Kermit-32 uses a list of logical names to K determine which terminal should be the default terminal line.  The first of H these names which translates to a terminal which is available (i.e., notL allocated by some other process) is used.  The logical names Kermit-32 triesH are KER$COMM, SYS$INPUT, SYS$$OUTPUT, and SYS$COMMAND.  If none of theseJ translate to an available terminal, Kermit-32 is running @i<detached>, andG a terminal must be specified by the SET LINE command before any actions G can be performed.  If a terminal is found, Kermit-32 is running locally M if this is a terminal other than the one controlling the job (i.e., different ; from SYS$COMMAND), otherwise Kermit-32 is running remotely. = You can also select the line directly in the CONNECT command; 3 the command @example(CONNECT TTA0) is equivalent to  @begin<example> 
 SET LINE TTA0  CONNECT 
 @end<example>   E If you type SET LINE with no argument, you will deassign any previous ( assigned line and revert to remote mode.   @subheading<SET SERVER_TIMEOUT> % Syntax: SET SERVER_TIMEOUT @i<number>   , This specifies the number of seconds betweenN timeouts during server command wait, 0 specifies that no timeouts should occurK during server command wait.  When a Kermit server times out, it sends a NAK O packet.  Some systems cannot clear piled-@|up NAKs from their input buffers; if J you're using such a system to communicate with a Kermit-32 server, and youM expect to be leaving the server idle for long periods of time, you should use 8 this command to turn off server command-@|wait timeouts.   @subheading<SET TRANSMIT> @ Syntax: SET TRANSMIT DELAY @i<integer>, SET TRANSMIT ECHO ON/OFF  H It is possible to set a few parameters associated with the raw TRANSMIT O command that vary both what the user sees on the screen as well as the speed of 
 the transmit.    SET TRANSMIT DELAY  K This parameter is the amount of time to delay after each carriage return is N transmitted.  Valid delay values range between 0 (the default) and 9 tenths ofA a second.  The format of the command is: SET TRANSMIT DELAY @i<d> F Where @i<d> is a single decimal digit representing tenths of a second.  F Some remote hosts may not be able to receive the characters as fast asG Kermit-32 can send them.  The TRANSMIT DELAY can be used to slow up the : transfer by adding a slight delay after each line is sent.  O The transfer also runs slower if the transmit echo is on, and the remote system O is echoing the characters as it receives them.  If the transmit delay is set to K 9 tenths of a second, the remote system is echoing characters, the transmit K echo is on, and the remote system still cannot keep up, then the connection % should be made at a slower baud rate.   N Conversely, the file transfer speed can be increased by: setting the delay to N 0 and the echo off, stopping the remote system from echoing the characters it . receives, and connecting at higher baud rates.   SET TRANSMIT ECHO   F This command controls what the user sees on the screen during the fileD transfer.  The format of the command is SET TRANSMIT ECHO ON or OFF.  N By default, the transmit echo is left off and the user sees the number of eachJ line after it has been transmitted.  With transmit echo on, the user sees M whatever the remote system would normally echo back to him while he is typing L in a file.  Note that turning the echo on typically slows the file transfer  down.    @Heading<The SHOW Command> @Index<SHOW> Syntax: @q<SHOW> [@i<option>]   . The SHOW command displays various information: @Begin(Description,spread 0.5) ALL@\All parameters.  7 BLOCK_CHECK_TYPE@\The block check type being requested.   E COMMUNICATIONS@\Parameters affecting the terminal line being used for  communication.  , DEBUGGING@\Debugging mode in effect, if any.  K DELAY@\The number of seconds Kermit-32 will delay before starting a SEND or $ RECEIVE command when in remote mode.  @ ESCAPE@\The current escape character for the CONNECT processing.  I FILE_PARAMETERS@\File type, file naming, and incomplete file disposition.   K INCOMPLETE_FILE_DISPOSITION@\The action to take when a transfer is aborted.    LINE@\Terminal line in use.   G LOCAL_ECHO@\Whether characters should be echoed locally when CONNECTed.   * PACKET@\For incoming and outbound packets.   PARITY@\The parity type in use.    RECEIVE@\For inbound packets.   7 RETRY@\The number of retries to be done on bad packets.    SEND@\For outbound packets.   * TRANSMIT@\Parameters for TRANSMIT command.  1 VERSION@\The program version number of Kermit-32.  @End(Description)   ( @subsection<Program Management Commands> @Heading<The HELP Command>  , Syntax: @q<HELP [@i{topic} {@i<subtopic>}]>   G Typing HELP alone prints a brief summary of Kermit-20 and its commands.  You can also type  @Begin(Example)  HELP @i<command>
 @End(Example) L for any Kermit-20 command, e.g. "help send" or "help set parity" to get more. detailed information about a specific command.  $ @Heading<The EXIT and QUIT Commands>- @Index<EXIT>@Index<CONTINUE>@Index<Control-C>  Syntax: @q<EXIT>   Exit from Kermit-32.H You can also exit from the Kermit-32 when it is waiting for a command byH typing a control-Z.  When Kermit-32 is running remotely, two control-Y'sF will abort the transfer, bringing Kermit-32 back to command mode.  TheK two control-Y's must be typed together, as if a timeout occurs between them I the first is ignored.  When Kermit-32 is running locally, two control-Y's H will stop Kermit-32 and return you to DCL.  You will be able to CONTINUEG if you do not perform any command which runs a program.  However, after I continuing, control-A, control-X and control-Z will no longer be accepted  as commands.   @Index<QUIT> @q<QUIT> is a synonym for EXIT.    @Heading<The LOG Command>   + Syntax: @q<LOG> [@i<option> [@i<filespec>]]   / Log the specified option to the specified file:  @begin<description> * SESSION@\During CONNECT log all charactersM that appear on the screen to the specified file.  During CONNECT, the session I log can be temporarily turned off during the remote session by typing the I escape character followed by Q (for Quit logging), and turned on again by ? typing the escape character followed by R (for Resume logging).   B TRANSACTIONS@\During file transfer, log the progress of each file.L Transaction logging is recommended for long or unattended file transfers, soL that you don't have to watch the screen.  The log may be inspected after theK transfer is complete to see what files were transferred and what errors may  have occurred.  4 DEBUGGING@\Log debugging info to the specified file.J If no SET DEBUGGING command was previously issued, the file will be openedF and no information written.  If DEBUGGING is turned on (either via theI SET DEBUGGING command or by typed control-D during a local transfer), the 9 packet debugging information will be written to the file. 
 Packet format / is described in the @i<Kermit Protocol Manual>.    @end<description>  Any log 3 files are closed when you EXIT or QUIT from Kermit. 1 You may explicitly close a log file and terminate > logging by using the LOG command without a file specification.   @Heading<The STATUS Command>   Syntax: @q<STATUS>  L The current status of Kermit-32 will be displayed.  This includes the numberK of characters that have been sent and received from the remote Kermit. Also H included is an estimate of the effective baud rate of the transfer. ThisK number is not intended to be exact, but only an indication of what range of  throughput has been provided.   ! @Section<Raw Upload and Download>    @heading<The TRANSMIT Command>  " Syntax: @q(TRANSMIT @i<file-spec>)  E The TRANSMIT command allows you to upload files "raw" to systems that O don't have a Kermit program available.  Note that there is no error checking or 1 packets involved in this method of file transfer.   K This command does a raw transmit of an ASCII file, one character at a time, O with carriage returns (no line-feeds) at the end of each line.  It is used with H Kermit-32 in local mode.  The user must first prepare the remote host toN receive the file by starting an edit session in input mode.  Then the user canO escape back to Kermit-32 and issue the TRANSMIT command.  After the transmit is K finished, the user then CONNECTs back to the remote host again and ends the 
 edit session.   N During a file transmit, the following control characters can be used to affect the transfer in progress:  @begin<description>  CTRL-C@\Abort the transmit  2 CTRL-X@\Abort the file currently being transmitted  8 CTRL-Z@\Abort the file group currently being transmitted @end<description>   C See SET TRANSMIT for information about controlling echo and delays.   ! @heading<The LOG SESSION Command>   % Syntax: @q(LOG SESSION @i<file-spec>)    @index<Raw Download>L "Raw Download" is the term commonly used to describe the capture of a remoteL file on the local system, without any kind of error detection or correction.L This allows you to obtain files from remote systems that do not have Kermit,0 but with the risk of loss or corruption of data.  M Kermit-32 provides raw downloading via the LOG SESSION command during CONNECT H to a remote system.  The session log is described above.  To use session logging to capture a file: @begin<enumerate> ! Run Kermit on the VAX/VMS system.   O SET LINE to the terminal line through which you will be connected to the remote  system.   L Perform any required SET commands to condition Kermit for communication with the remote system.  ( CONNECT to the remote system and log in.  D Condition your job on the remote system not to pause at the end of aK screenful of text, and give whatever commands may be necessary to achieve a M "clean" terminal listing -- for instance, disable messages from the system or  other users.  F Type the appropriate command to have the desired file displayed at theG terminal, @i<but do not type the terminating carriage return>.  On most 9 systems, the command would be "type", on Unix it's "cat".   G Escape back to Kermit-32 and give the LOG SESSION command with the file / specification where you wish to store the data.   O CONNECT back to the remote system and type a carriage return.  The file will be > displayed on your screen and recorded in the session log file.  H Escape back to Kermit-32 and give the LOG SESSION command without a file specification. @end<enumerate> M The file you specified will contain everything that was typed on your screen.  You will probably findK that some editing necessary to remove extraneous prompts, messages, padding 4 characters, or terminal escape sequences, or to fill in lost or garbled characters.  + Use the TRANSMIT command for raw uploading.    @section<Control Characters>          # @section<Installation of Kermit-32>   B Kermit-32 may be installed either by rebuilding the entire programJ from the sources, or by making use of the distributed copy of the program.F When being built from sources, it may be built using either a BLISS-32( compiler or just the MACRO-32 assembler.   @Heading<Files> E Kermit-32 is built from a number of BLISS-32 sources and one MACRO-32 C source.  In order to make it possible for sites without BLISS-32 to G build, MACRO-32 sources generated by BLISS-32 are also included for all F of the BLISS modules.  In the normal distribution of Kermit-32, all ofD the files start with the prefix "VMS".  This will need to be changedE to "KER" in order to build the program properly.  The following files % are distributed as part of Kermit-32:  @Begin<Description> H @q<VMSTT.BLI>@\Common BLISS source for the terminal text output support.  : @q<VMSGLB.BLI>@\Common BLISS source for the global storage for @q<VMSMSG.BLI>.   4 @q<VMSMSG.BLI>@\Common BLISS source for the protocol handling module.  F @q<VMSCOM.REQ>@\Common BLISS require file which defines various common0 parameters.  This is required by @q<VMSMSG.BLI>., This file must be renamed to @q<KERCOM.REQ>.  7 @q<VMSMIT.BWR>@\"Beware File" for Kermit-32 (read it!).   / @q<VMSMIT.BLI>@\BLISS-32 source for the command ( parser, and some basic support routines.  1 @q<VMSFIL.BLI>@\BLISS-32 source for the file I/O.   0 @q<VMSTRM.BLI>@\BLISS-32 source for the terminalL processing.  This handles the driving of the terminal line for the transfers# and the connect command processing.   8 @q<VMSSYS.BLI>@\System interface routines for the Kermit generic command processing.   E @q<VMSGEN.MAR>@\Macro-32 source file that contains the REMOTE command  text that is given to VMS.J Sites desiring to change what DCL commands are used to process the variousD generic server commands can make those changes in this source.  ThisF also contains the text of the help message returned in response to the server generic help command.  I @q<VMSERR.MSG>@\MESSAGE source for error messages used by VAX/VMS Kermit.   I @q<VMSERR.REQ>@\BLISS-32 require file which defines the error codes. This $ is REQUIREd by the BLISS-32 sources.  F @q<VMSMIT.MSS>@\SCRIBE source file for @q<VMSMIT.DOC> (this document).  O @q<VMSMIT.RNH>@\RUNOFF source for the help files for VAX/VMS Kermit.  When this B is run through RUNOFF with /VARIANT=SYSTEM, it produces a @q<.HLP>I (@q<VMSSYS.HLP>) file suitable for inserting into the system help library H (@q<SYS$HELP:HELPLIB.HLB>) to provide a KERMIT topic for the system HELPL command.  When run through RUNOFF without the /VARIANT=SYSTEM, it produces aK @q<.HLP> file (@q<VMSUSR.HLP>) to be stored on @q<SYS$HELP:> for use by the  Kermit HELP command.  ? @q<VMSSYS.HLP>@\RUNOFF output file for system wide Kermit HELP.   = @q<VMSUSR.HLP>@\RUNOFF output file for Kermit's HELP command.   A @q<VMSINS.COM>@\Command file to build and install VAX/VMS Kermit.   E @q<VMSMIT.EXE>@\The executable (binary) file of VAX/VMS Kermit.  Note C that this is only included when it is possible.  This may be either I a copy of the @q<.EXE> file which was transferred to a TOPS-10 or TOPS-20 G system using Kermit with Kermit-10 (or -20) using FILE BYTE-SIZE 8-BIT, < or a direct copy of the @q<.EXE> file (if the file is either= on a native VAX/VMS tape or is residing on a VAX/VMS system).   N @q<VMSMIT.HEX>@\A hexified version of @q<.EXE> file for VMS Kermit.  This fileH can be dehexified using the supplied program.  In the hexified form, theF file should be transferable over any medium which handles normal text.G This is the most reliable copy of the executable version of VMS Kermit.   I @q<VMSHEX.MAR>@\Source for the hexification program.  This is the program I which was used to produce @q<VMSMIT.HEX>.  It can also be used to produce D hexified version of any (or at least almost any) Files-11 file.  TheE dehexification program should then be able to reproduce a copy of the 5 original file with the file parameters correctly set. G Note that the format used for the hexified files is basically Intel hex K format.  There are some additional records used to store the record format, F etc.  Also, the file name as typed to the prompt from VMSHEX is storedJ in the hexified version of the file for use by the dehexification program.E By doing this, it is possible to store more than one binary file with  a single hexified file.   6 @q<VMSDEH.MAR>@\Source for the dehexification program.  E @q<VMSV31.*>Version 3.1 of VMS Kermit, the last version that will run 9 under release 3.x of VMS.  Versions 3.2 and later require  VMS release 4.0 or later.   N @q<VMSV3x.MEM>@\Documentation on the changes between releases 3.1 and 3.1, andB 3.2 and 3.3 of Kermit-32, and additional installation information. @End<Description>   H As distributed, Kermit-32 should work on any VAX/VMS system (version 4.0K and later).  Customization is possible with or without a BLISS-32 compiler. C Default parameter values may be changed by changing the appropriate F LITERALs in the BLISS-32 source for VMSMSG, or the actual values whichE are stored in the routine MSG_INIT in the MACRO-32 source for VMSMSG.   G Sites can also easily change the commands which are used for processing H the generic server functions (REMOTE commands when running as a server).E The text which makes up these commands is in the file @q<VMSGEN.MAR>, F along with the text of the REMOTE HELP message.  This allows a site toG make use of local programs for performing some of the commands (perhaps / using FINGER to perform the WHO command, etc.).   ) @Heading<Building Kermit-32 from sources> A A command file is included which will build Kermit-32 from either D the BLISS-32 or MACRO-32 sources and optionally install Kermit-32 onH the system.  This file (@q<VMSINS.COM>) has not been extensively tested,E however it should work on most systems.  It is also a good example of G what needs to be done to compile each file and load the entire program. I It also contains the commands necessary to install a version of Kermit-32 A on the system once the @q<.EXE> and @q<.HLP> files are generated.   < @Heading<Using Kermit-32 to install a new version of itself>G If you already have a version of Kermit-32 running on a VAX/VMS system, ? you can use it to transfer a new version of itself from another E system.  If you have no need to build Kermit-32 from sources (because N you have no local modifications), you can just transfer the new @q<VMSMIT.EXE>: (or @q<VMSMIT.HEX>), and the new help file @q<VMSMIT.RNH>.   If you have J access to a system which has a copy of @q<VMSMIT.EXE>, you can transfer itG simply by setting the FILE TYPE to FIXED on the receiving Kermit.  Make J sure that the sending Kermit is willing to send the file as a binary file.E If the sending Kermit is another copy of Kermit-32, you don't need to H do anything.  If the sending Kermit is Kermit-10 or Kermit-20, make sureM the file will be sent as an eight-bit binary file by using SET FILE BYTE-SIZE F EIGHT.  If some other Kermit is sending the file, make sure to give itF whatever command is necessary to ensure that it sends eight-bit binaryF data from the file.  Also, if the originating system is not a VAX/VMS,E TOPS-10 or TOPS-20 system, make sure that the file was stored on that K system correctly to start out with.  Normally, the file @q<VMSMIT.EXE> will < only be available from a VAX/VMS, TOPS-10 or TOPS-20 system.  N If you only have access to a copy of @q<VMSMIT.HEX>, you will need to transferF that file (as a normal ASCII text file).  You will also need a copy ofD @q<VMSDEH.MAR>.  After you have obtained both files, you can produceF a copy of the @q<.EXE> file as follows.  First compile VMSDEH by usingD the command @q<MACRO VMSDEH>.  Then load it by @q<LINK VMSDEH>.  NowA run VMSDEH and when it asks for a file name, type @q<VMSMIT.HEX>. D The program will run for a short time and produce the @q<.EXE> file.  G The system wide and user help files are produced from @q<VMSMIT.RNH> by H RUNOFF.  To produce the user help file (the one used by Kermit-32's HELP command), type:  @Begin<example> % $ RUNOFF VMSMIT.RNH/OUTPUT=KERUSR.HLP 4 $ LIBRARY/CREATE/HELP SYS$HELP:KERMIT.HLB KERUSR.HLP
 @End<example> N To produce the system wide help file and install it in the system help library type:  @Begin<example> 4 $ RUNOFF VMSMIT.RNH/OUTPUT=KERSYS.HLP/VARIANT=SYSTEM6 $ LIBRARY/REPLACE/HELP SYS$HELP:HELPLIB.HLB KERSYS.HLP
 @End<example> E This allows the DCL HELP command to provide information on Kermit-32. 