P          MACRO                                                          00000010P &CSECT   PLIANF &DSALEN                                                 00000020P .*********************************************************************  00000030P .*    THIS MACRO GENERATES PROLOGUE AND RETURN CODE FOR A               00000040P .*    REENTRANT ASSEMBLER SUBROUTINE CALLED BY A PL/I ROUTINE.          00000050P .*                                                                      00000060P .*  PARAMETERS:                                                         00000070P .*    &CSECT  : CSECTNAME FOR THE ASSEMBLER SUBROUTINE.                 00000080P .*    &DSALEN : LENGTH OF THE DSA ADDRESSED BY REGISTER 13,             00000090P .*                IN EXCESS OF 88, MUST BE A MULTIPLE OF 8.             00000100P .*                                                                      00000110P .*  CONVENTIONS:                                                        00000120P .*    START LABEL FOR THE EXECUTABLE CODE MUST BE "START".              00000130P .*    RETURN TO THE CALLLER:   "     B     RETURN ".                    00000140P .*    NAME OF THE DSA DSECT:   "PLIDSA" .                               00000150P .*    BASE REGISTER :  REGISTER 3.                                      00000160P .*********************************************************************  00000170P          LCLA  &IND,&LEN                                                00000180P &IND     SETA  &SYSNDX                                                  00000190P &LEN     SETA  K'&CSECT                                                 00000200P &CSECT.1 CSECT                                                          00000210P          DC    CL7' '                                                   00000220P          ORG   *-&LEN                                                   00000230P          DC    C'&CSECT'                                                00000240P          DC    AL1(&LEN)                                                00000250P          SPACE 3                                                        00000260P R0       EQU   0                                                        00000270P R1       EQU   1                                                        00000280P R2       EQU   2                                                        00000290P R3       EQU   3              BASE REG, POINTS TO ENTRY                 00000300P R4       EQU   4                                                        00000310P R5       EQU   5                                                        00000320P R6       EQU   6                                                        00000330P R7       EQU   7                                                        00000340P R8       EQU   8                                                        00000350P R9       EQU   9                                                        00000360P R10      EQU   10                                                       00000370P R11      EQU   11                                                       00000380P R12      EQU   12             DO NOT ALTER REGISTER 12                  00000390P R13      EQU   13             BASE FOR PLIDSA DSECT                     00000400P R14      EQU   14                                                       00000410P R15      EQU   15                                                       00000420P          SPACE 3                                                        00000430P PLIDSA   DSECT                                                          00000440P PLIFLAGS DS    H                                                        00000450P PLIOFFS  DS    H                                                        00000460P PLIHSA   DS    F                                                        00000470P PLILSA   DS    F                                                        00000480P PLIREG14 DS    F                                                        00000490P PLIREG15 DS    F                                                        00000500P PLIREG0  DS    F                                                        00000510P PLIREG1  DS    F                                                        00000520P PLIREG2  DS    F                                                        00000530P PLIREG3  DS    F                                                        00000540P PLIREG4  DS    F                                                        00000550P PLIREG5  DS    F                                                        00000560P PLIREG6  DS    F                                                        00000570P PLIREG7  DS    F                                                        00000580P PLIREG8  DS    F                                                        00000590P PLIREG9  DS    F                                                        00000600P PLIREG10 DS    F                                                        00000610P PLIREG11 DS    F                                                        00000620P PLIREG12 DS    F                                                        00000630P PLILWS   DS    A                                                        00000640P PLINAB   DS    A                                                        00000650P PLIPNAB  DS    A                                                        00000660P PLIENABC DS    F                                                        00000670P          EJECT                                                          00000680P &CSECT.1 CSECT                                                          00000690P          ENTRY &CSECT                                                   00000700P &CSECT   DS    0H                                                       00000710P          STM   R14,R12,12(R13)                                          00000720P          LR    R3,R15         R3 : BASE REGISTER                        00000730P          USING &CSECT,R3                                                00000740P          USING PLIDSA,R13                                               00000750P          LA    R0,88+&DSALEN                                            00000760P          L     R1,PLINAB      R1 : NEXT AVAILABLE BYTE                  00000770P          ALR   R0,R1                                                    00000780P          CL    R0,12(R12)     ENOUGH STORAGE ?                          00000790P          BNH   ENGH&IND                                                 00000800P          L     R15,116(R12)   NO,                                       00000810P          BALR  R14,R15           BRANCH TO PL/I OVERFLOW ROUTINE        00000820P ENGH&IND EQU   *                                                        00000830P          ST    R0,76(R1)      RESET NAB                                 00000840P          ST    R0,80(R1)      RESET PROLOGUE NAB                        00000850P          ST    13,4(R1)       STORE BACK-CHAIN                          00000860P          MVC   72(4,R1),PLILWS     COPY LWS ADDRESS                     00000870P          LR    R13,R1         R13 : BASE OF PLIDSA DSECT                00000880P          MVI   PLIFLAGS,X'80'     SET PL/I                              00000890P          MVI   PLIFLAGS+1,X'00'     FLAGS                               00000900P          MVI   PLIENABC+2,X'91'   INITIALIZE CURRENT                    00000910P          MVI   PLIENABC+3,X'C0'     ENABLE CELLS                        00000920P          L     R1,PLIHSA      GET BACK                                  00000930P          L     R1,24(R1)        PARAMETER REGISTER                      00000940P          B     START          BRANCH TO USER'S CODE                     00000950P          SPACE 3                                                        00000960P RETURN   EQU   *                                                        00000970P          LR    R0,R13                                                   00000980P          L     R13,PLIHSA                                               00000990P          L     R14,PLIREG14                                             00001000P          LM    R2,R12,PLIREG2                                           00001010P          BALR  R1,R14                                                   00001020P          EJECT                                                          00001030P          MEND                                                           00001040P                                                                         00001050P PLNK     TITLE 'PL/I - LINK INTERFACE'                                  00001060P **********************************************************************  00001070P *   PL/I INTERFACE TO LINK SVC                                          00001080P *                                                                       00001090P *  DECLARATION :                                                        00001100P *      DCL PLILINK ENTRY(CHAR(8),...)                                   00001200P *                  OPTIONS(ASM INTER RETCODE);                          00001300P *                                                                       00001400P *  USE :  CALL PLILINK(EPNAME,PARMS);                                   00001500P *                                                                       00001600P *  PARAMETERS :                                                         00001700P *         EPNAME : NAME OF ENTRY POINT.                                 00001800P *         PARMS  : PARAMETERS TO BE PASSED.                             00001900P *                                                                       00002000P *  RETURN CODE :  PASSED FROM LINKED PROGRAM                            00002100P *                                                                       00002200P *  MACRO USED : PLIANF                                                  00002300P **********************************************************************  00002400P          SPACE 3                                                        00002500P PLILINK  PLIANF DSALEN                                                  00002600P START    EQU   *                                                        00002700P          L     R4,0(R1)       GET EPNAME                                00002800P          LA    R1,4(R1)       CUT FIRST PARAMETER                       00002900P          MVC   LINKLIST(INITLEN),LISTINIT   INITIALIZE WORKSTORAGE      00003000P          LA    R13,0(R13)     CLEAR R13 (ERROR IN MVS XA SVC 6) WS      00003100P LINK     LINK  EPLOC=(4),MF=(E,(1)),SF=(E,LINKLIST)                     00003200P          B     RETURN                                                   00003300P          SPACE                                                          00003400P LISTINIT DS    0F                                                       00003500P LINKINIT LINK  EPLOC=*-*,SF=L                                           00003600P INITLEN  EQU   *-LISTINIT                                               00003700P          SPACE 2                                                        00003800P PLIDSA   DSECT                                                          00003900P LINKLIST LINK  EPLOC=*-*,SF=L                                           00004000P          DS    0D                                                       00004100P DSALEN   EQU   *-LINKLIST                                               00004200P          END                                                            00004300P                                                                         00004400P PSVC     TITLE 'PL/I - SVC INTERFACE'                                   00004500P **********************************************************************  00004600P *   PL/I INTERFACE TO GENERAL SVC                                       00004700P *                                                                       00004800P *  DECLARATION :                                                        00004900P *      DCL PLISVC ENTRY(BIN(15,0),BIN(31,0),BIN(31,0),BIN(31,0));       00005000P *                                                                       00005100P *  USE :  CALL PLISVC(SVCNR,REG0,REG1,REG15);                           00005200P *                                                                       00005300P *  PARAMETERS :                                                         00005400P *         SVCNR : NUMBER OF SVC TO BE EXECUTED                          00005500P *         REG0,REG1,REG15 : VALUES TO BE LOADED INTO REGISTERS          00005600P *                0,1,15 RESPECTIVELY ON ENTRY TO SVC.                   00005700P *               THEY ARE RESTORED ON RETURN FROM SVC.                   00005800P *                                                                       00005900P *  MACRO USED : PLIANF                                                  00006000P **********************************************************************  00006100P          SPACE 3                                                        00006200P PLISVC   PLIANF 0                                                       00006300P START    EQU   *                                                        00006400P          LM    R4,R7,0(R1)    GET PARAMETERS                            00006500P          LH    R8,0(R4)       GET SVCNR                                 00006600P          L     R0,0(R5)       LOAD REGISTER 0 VALUE                     00006700P          L     R1,0(R6)       LOAD REGISTER 1 VALUE                     00006800P          L     R15,0(R7)      LOAD REGISTER 15 VALUE                    00006900P          EX    R8,SVC         EXECUTE SVC                               00007000P          ST    R0,0(R5)       RESTORE REGISTER 0 VALUE                  00007100P          ST    R1,0(R6)       RESTORE REGISTER 1 VALUE                  00007200P          ST    R15,0(R7)      RESTORE REGISTER 15 VALUE                 00007300P          B     RETURN         RETURN                                    00007400P          SPACE 2                                                        00007500P SVC      SVC   0              MODEL SVC INSTRUCTION                     00007600P          END                                                            00007700P                                                                         00007800P PTSR     TITLE 'PL/I - INTERFACE TO TSO SERVICE ROUTINES'               00007900P **********************************************************************  00008000P *   PL/I INTERFACE TO TSO SERVICE ROUTINES                              00008100P *                                                                       00008200P *  DECLARATION :                                                        00008300P *      DCL PLITSSR ENTRY(CHAR(8),...)                                   00008400P *                  OPTIONS(ASM INTER RETCODE);                          00008500P *                                                                       00008600P *  USE :  CALL PLITSSR(EPNAME,PARMS);                                   00008700P *                                                                       00008800P *  PARAMETERS :                                                         00008900P *         EPNAME : NAME OF ENTRY POINT.                                 00009000P *         PARMS  : PARAMETERS TO BE PASSED.                             00009100P *                                                                       00009200P *  RETURN CODE :  PASSED FROM TSO SERVICE ROUTINE                       00009300P *                                                                       00009400P *  MACRO USED : PLIANF                                                  00009500P **********************************************************************  00009600P          SPACE 3                                                        00009700P PLITSSR  PLIANF DSALEN                                                  00009800P START    EQU   *                                                        00009900P          L     R4,0(R1)       GET EPNAME                                00010000P          LA    R1,4(R1)       CUT FIRST PARAMETER                       00010100P          LA    R5,TSSRTAB-LENENTRY                                      00010200P          LA    R6,LENENTRY                                              00010300P          LA    R7,TABEND-LENENTRY                                       00010400P TSSRLOOP BXH   R5,R6,NOTFOUND                                           00010500P          CLC   0(LENNAME,R3),0(R5)                                      00010600P          BNE   TSSRLOOP                                                 00010700P FOUND    EQU   *                                                        00010800P          L     R15,16              GET CVT ADDRESS                      00010900P          AL    R15,(LENNAME)(R5)   ADD OFFSET FROM LIST ENTRY           00011000P          TM    0(R15),X'80'        TEST IF ADDRESS VALID                00011100P          BNO   NOTFOUND            NO, DO NORMAL LINK                   00011200P          L     R15,0(R15)          GET SERVICE ROUTINE ADDRESS          00011300P          BALR  R14,R15             OFF TO SERVICE ROUTINE               00011400P          B     RETURN                                                   00011500P NOTFOUND EQU   *                                                        00011600P          MVC   LINKLIST(INITLEN),LISTINIT   INITIALIZE WORKSTORAGE      00011700P LINK     LINK  EPLOC=(4),MF=(E,(1)),SF=(E,LINKLIST)                     00011800P          B     RETURN                                                   00011900P          SPACE                                                          00012000P LISTINIT DS    0F                                                       00012100P LINKINIT LINK  EPLOC=*-*,SF=L                                           00012200P INITLEN  EQU   *-LISTINIT                                               00012300P          SPACE 2                                                        00012400P *  TABLE OF MVS TSO SERVICE ROUTINE ADDRESSES IN CVT                    00012500P          SPACE                                                          00012600P *  TO ACTIVATE TABLE FOR MVS, REMOVE STARS ON EACH ENTRY                00012700P *  AND ON CVT DSECT=YES AND REASSEMBLE.                                 00012800P          SPACE                                                          00012900P TSSRTAB  DS    0F                                                       00013000P LENNAME  EQU   8                                                        00013100P LENENTRY EQU   12                                                       00013200P GETL     DC    CL(LENNAME)'IKJGETL',A(CVTGETL-CVT)                      00013300P PUTL     DC    CL(LENNAME)'IKJPUTL',A(CVTPUTL-CVT)                      00013400P PTGT     DC    CL(LENNAME)'IKJPTGT',A(CVTPTGT-CVT)                      00013500P STCK     DC    CL(LENNAME)'IKJSTCK',A(CVTSTCK-CVT)                      00013600P SCAN     DC    CL(LENNAME)'IKJSCAN',A(CVTSCAN-CVT)                      00013700P PARS     DC    CL(LENNAME)'IKJPARS',A(CVTPARS-CVT)                      00013800P DAIR     DC    CL(LENNAME)'IKJDAIR',A(CVTDAIR-CVT)                      00013900P EHDEF    DC    CL(LENNAME)'IKJEHDEF',A(CVTEHDEF-CVT)                    00014000P EHCIR    DC    CL(LENNAME)'IKJEHCIR',A(CVTEHCIR-CVT)                    00014100P EFF02    DC    CL(LENNAME)'IKJEFF02',A(CVTEFF02-CVT)                    00014200P TABEND   EQU   *                                                        00014300P          SPACE 2                                                        00014400P          CVT   DSECT=YES                                                00014500P          SPACE 3                                                        00014600P PLIDSA   DSECT                                                          00014700P LINKLIST LINK  EPLOC=*-*,SF=L                                           00014800P          DS    0D                                                       00014900P DSALEN   EQU   *-LINKLIST                                               00015000P          END                                                            00015100