# File MSVRB1.MAK.
#
# Makefile for MS-DOS Kermit on DEC Rainbow 100.
# For use Microsoft's Make version 4.00.
# Usage: "make msvrb1.mak" with all source files in current directory.
#
# Written by Joe R. Doupnik.
# Blank lines are mandatory.

# The inference macro below calls MASM to create .obj modules.
.asm.obj:
        MASM $*.asm;

# These are the dependency relations (.obj depends on .asm and .h):
# First, the system independent files for Kermit-MS.

# Make this     using MASM on these two files if either has changed

msscmd.obj:     msscmd.asm mssdef.h

msscom.obj:     msscom.asm mssdef.h

mssfil.obj:     mssfil.asm mssdef.h

mssker.obj:     mssker.asm mssdef.h

mssrcv.obj:     mssrcv.asm mssdef.h

mssscp.obj:     mssscp.asm mssdef.h

msssen.obj:     msssen.asm mssdef.h

mssser.obj:     mssser.asm mssdef.h

mssset.obj:     mssset.asm mssdef.h

msster.obj:     msster.asm mssdef.h

mssfin.obj:     mssfin.asm mssdef.h

# These are the system dependent modules for the DEC Rainbow. Use with the
# appropriate Link command file msvibm.lnk.

msurb1.obj:     msurb1.asm mssdef.h

msxrb1.obj:     msxrb1.asm mssdef.h

msvrb1.exe:     msscmd.obj msscom.obj mssfil.obj mssker.obj mssrcv.obj\
                mssscp.obj msssen.obj mssser.obj mssset.obj msster.obj\
                msurb1.obj msxrb1.obj mssfin.obj
        LINK @msvrb1.lnk

msvrb1.boo:     msvrb1.exe
        msbmkb msvrb1.exe msvrb1.boo

# Do the items above when Kermit is rebuilt.  Notice the use of a command
# file for Link because the list of object files is too long for one line.
# A sample command file MSVRB.LNK is (MSSFIN must be LAST):
#
# msscmd+msscom+mssfil+mssker+mssrcv+mssscp+msssen+mssser+
# mssset+msster+msurb1+msxrb1+mssfin
# msvrb1;
#
# End of Kermit Make file for DEC Rainbow 100.
