The C programs hex.c and unhex.c translate between 8-bit binary files
and straight hex files, in which every pair of hexadecimal digits corresponds
to a single 8-bit byte.  Certain files in the Kermit distribution are in
this format.  You can recognize them because they contain only the characters
0-9 and A-F -- no colons or other characters.

---------------

/*  UNHEX.C - Program to translate a hex file from standard input
 *  into an 8-bit binary file on standard output.
 *  Usage: unhex < foo.hex > foo.exe
 *  Christine M. Gianone, CUCCA, October 1986.
 */

#include <stdio.h>                    /* Include this for EOF symbol */

char a, b;                            /* High and low hex nibbles */

/* Main program reads each hex digit pair and outputs the 8-bit byte. */

main() {
    while ((a = getchar()) != EOF) {  /* Read first hex digit */
        if (a == '\n')                /* Ignore line terminators */
          continue;
        if ((b = getchar()) == EOF)   /* Read second hex digit */
          break;
        putchar( ((decode(a) * 16) & 0xF0) + (decode(b) & 0xF) );
    }
    exit(0);                          /* Done */
}

decode(x) char x; {                   /* Function to decode a hex character */
    if (x >= '0' && x <= '9')         /* 0-9 is offset by hex 30 */
      return (x - 0x30);
    else if (x >= 'A' && x <= 'F')    /* A-F offset by hex 37 */
      return(x - 0x37);
    else {                            /* Otherwise, an illegal hex digit */
        fprintf(stderr,"Input is not in legal hex format\n");
        exit(1);
    }
}

---------------

/* HEX.C translates the standard input into hexadecimal notation and sends
 * the result to standard output.
 * Usage: hex < foo.exe > foo.hex
 * Christine M. Gianone, CUCCA, October 1986
 */

#include <stdio.h>

char h[16] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
int a, b, c, ctr = 0;

main() {

    while ((c = getchar()) != EOF) {	/* For each character in file... */
	b = c & 0xF;			/* Get low 4 bits */
	a = c / 16;			/* and high 4 bits */
	putchar(h[a]);			/* Hexify and output them */
        putchar(h[b]);
	ctr += 2;			/* Break lines every 72 characters */
	if (ctr == 72) {
	    putchar('\n');
	    ctr = 0;
        }
    }
    putchar('\n');			/* Terminate final line */
}

---------------

Warning - HEX.C doesn't work under Microsoft C on the IBM PC family:
getchar() returns EOF (-1) whenever it reads a 0xFF byte from the input file.
Seems like a bug in MSC...  Since everything is an int, there shouldn't
be any sign extension going on.  Boo.  Testing with feof() wouldn't help
either, because getchar() buffers ahead.  Maybe use single-character read()?

---------------
