H /*  C K U U S 2  --  "User Interface" STRINGS module for Unix Kermit  */    /*&  Author: Frank da Cruz (SY.FDC@CU20B),C  Columbia University Center for Computing Activities, January 1985. M  Copyright (C) 1985, Trustees of Columbia University in the City of New York. H  Permission is granted to any individual or institution to use, copy, orO  redistribute this software so long as it is not sold for profit, provided this   copyright notice is retained.   */   O /*  This module separates long strings from the body of the ckuser module. */       #include "ckcdeb.h"  #include <stdio.h> #include <ctype.h> #include "ckcker.h"  #include "ckucmd.h"  #include "ckuusr.h"    : extern CHAR mystch, stchr, eol, seol, padch, mypadc, ctlq;& extern CHAR data[], *rdatap, ttname[];E extern char cmdbuf[], line[], debfil[], pktfil[], sesfil[], trafil[]; K extern int nrmt, nprm, dfloc, deblog, seslog, speed, local, parity, duplex; L extern int turn, turnch, pktlog, tralog, mdmtyp, flow, cmask, timef, spsizf;4 extern int rtimo, timint, npad, mypadn, bctr, delay;> extern int maxtry, spsiz, urpsiz, maxsps, maxrps, ebqflg, ebq;I extern int rptflg, rptq, fncnv, binary, pktlog, warn, quiet, fmask, keep; F extern int tsecs, bctu, len, atcapu, lpcapu, swcapu, wsize, sq, rpsiz; extern int capas; 5 extern long filcnt, tfc, tlci, tlco, ffc, flci, flco; % extern char *dftty, *versio, *ckxsys;  extern struct keytab prmtab[]; extern struct keytab remcmd[];    static char *hlp1[] = { "\n", 2 "  Usage: kermit [-x arg [-x arg]...[-yyy]..]]\n",O "   x is an option that requires an argument, y an option with no argument:\n", 7 "     actions (* options also require -l and -b) --\n", = "       -s file(s)   send (use '-s -' to send from stdin)\n",   "       -r           receive\n",* "       -k           receive to stdout\n",I "     * -g file(s)   get remote file(s) from server (quote wildcards)\n", = "       -a name      alternate name, used with -s, -r, -g\n", * "       -x           enter server mode\n",- "     * -f           finish remote server\n", 3 "     * -c           connect before transaction\n", 2 "     * -n           connect after transaction\n", "     settings --\n", 2 "       -l line      communication line device\n",. "       -b baud      line speed, e.g. 1200\n",F "       -i           binary file or Unix-to-Unix (text by default)\n",6 "       -p x         parity, x is one of e,o,m,s,n\n",E "       -t           line turnaround handshake = xon, half duplex\n", ; "       -w           don't write over preexisting files\n", 6 "       -q           be quiet during file transfer\n",8 "       -d           log debugging info to debug.log\n",9 "       -e length    (extended) receive packet length\n", A " If no action command is included, enter interactive dialog.\n",  "" };    /*  U S A G E */   	 usage() {      conola(hlp1);  }       /*  Help string definitions  */     static char *tophlp[] = { "\n\B Type ? for a list of commands, type 'help x' for any command x.\n\A While typing commands, use the following special characters:\n\n\ K  DEL, RUBOUT, BACKSPACE, CTRL-H: Delete the most recent character typed.\n\ /  CTRL-W: Delete the most recent word typed.\n",     "\$  CTRL-U: Delete the current line.\n\'  CTRL-R: Redisplay the current line.\n\ I  ?       (question mark) display help on the current command or field.\n\ G  ESC     (Escape or Altmode) Attempt to complete the current field.\n",     "\E  \\       (backslash) include the following character literally.\n\n\ I From system level, type 'kermit -h' to get help about command line args.\  \n", "" };     static char *hmxxbye = "\ . Shut down and log out a remote Kermit server";    static char *hmxxclo = "\ # Close one of the following logs:\n\ J  session, transaction, packet, debugging -- 'help log' for further info.";    static char *hmxxcon = "\ = Connect to a remote system via the tty device given in the\n\   most recent 'set line' command";    static char *hmxxget = "\ K Format: 'get filespec'.  Tell the remote Kermit server to send the named\n\ K files.  If filespec is omitted, then you are prompted for the remote and\n\  local filenames separately.";     static char *hmxxlg[] = { "\& Record information in a log file:\n\n\C  debugging             Debugging information, to help track down\n\ 9   (default debug.log)  bugs in the C-Kermit program.\n\n\ O  packets               Kermit packets, to help track down protocol problems.\n\    (packet.log)\n\n",   D " session               Terminal session, during CONNECT command.\n\   (session.log)\n\n\G  transactions          Names and statistics about files transferred.\n\    (transact.log)\n", "" } ;      static char *hmxxlogi[] = { "\ Syntax: script text\n\n", H "Login to a remote system using the text provided.  The login script\n",@ "is intended to operate similarly to uucp \"L.sys\" entries.\n",0 "A login script is a sequence of the form:\n\n",' "	expect send [expect send] . . .\n\n", O "where 'expect' is a prompt or message to be issued by the remote site, and\n", L "'send' is the names, numbers, etc, to return.  The send may also be the\n",K "keyword EOT, to send control-d, or BREAK, to send a break.  Letters in\n", F "send may be prefixed by ~ to send special characters.  These are:\n",F "~b backspace, ~s space, ~q '?', ~n linefeed, ~r return, ~c don\'t\n",K "append a return, and ~o[o[o]] for octal of a character.  As with some \n", M "uucp systems, sent strings are followed by ~r unless they end with ~c.\n\n", K "Only the last 7 characters in each expect are matched.  A null expect,\n", I "e.g. ~0 or two adjacent dashes, causes a short delay.  If you expect\n", J "that a sequence might not arrive, as with uucp, conditional sequences\n",$ "may be expressed in the form:\n\n",' "	-send-expect[-send-expect[...]]\n\n", J "where dashed sequences are followed as long as previous expects fail.\n", "" };     static char *hmxxrc[] = { "\J Format: 'receive [filespec]'.  Wait for a file to arrive from the other\n\N Kermit, which must be given a 'send' command.  If the optional filespec is\n",   N "given, the (first) incoming file will be stored under that name, otherwise\n\3 it will be stored under the name it arrives with.",  "" } ;    static char *hmxxsen = "\ N Format: 'send file1 [file2]'.  File1 may contain wildcard characters '*' or\n\M '?'.  If no wildcards, then file2 may be used to specify the name file1 is\n\ D sent under; if file2 is omitted, file1 is sent under its own name.";    static char *hmxxser = "\ J Enter server mode on the currently selected line.  All further commands\n\= will be taken in packet form from the other Kermit program.";     static char *hmhset[] = { "\H The 'set' command is used to establish various communication or file\n",I "parameters.  The 'show' command can be used to display the values of\n", H "'set' parameters.  Help is available for each individual parameter;\n",/ "type 'help set ?' to see what's available.\n",  "" } ;    static char *hmxychkt[] = { "\J Type of packet block check to be used for error detection, 1, 2, or 3.\n",M "Type 1 is standard, and catches most errors.  Types 2 and 3 specify more\n", O "rigorous checking at the cost of higher overhead.  Not all Kermit programs\n",  "support types 2 and 3.\n",  "" } ;     I static char *hmxyf[] = { "\set file: names, type, warning, display.\n\n", K "'names' are normally 'converted', which means file names are converted\n", H "to 'common form' during transmission; 'literal' means use filenames\n",/ "literally (useful between like systems).\n\n", H "'type' is normally 'text', in which conversion is done between Unix\n",K "newlines and CRLF line delimiters; 'binary' means to do no conversion.\n", ; "Use 'binary' for executable programs or binary data.\n\n", M "'warning' is 'on' or 'off', normally off.  When off, incoming files will\n", K "overwrite existing files of the same name.  When on, new names will be\n", H "given to incoming files whose names are the same as existing files.\n", "\n\N 'display' is normally 'on', causing file transfer progress to be displayed\n",H "on your screen when in local mode.  'set display off' is useful for\n",< "allowing file transfers to proceed in the background.\n\n", "" } ;  Y static char *hmhrmt[] = { "\J The 'remote' command is used to send file management instructions to a\n",N "remote Kermit server.  There should already be a Kermit running in server\n",N "mode on the other end of the currently selected line.  Type 'remote ?' to\n",J "see a list of available remote commands.  Type 'help remote x' to get\n",? "further information about a particular remote command 'x'.\n",h "" } ; h  k* /*  D O H L P  --  Give a help message  */  i dohlp(xx) int xx; {c     int x,y;  i     if (xx < 0) return(xx);"     switch (xx) {e  k case XXBYE:      return(hmsg(hmxxbye));    case XXCLO:m     return(hmsg(hmxxclo));  ] case XXCON:n     return(hmsg(hmxxcon));  i case XXCWD:]
 #ifdef vms     return(hmsg("\C Change Working Directory, equivalent to VMS SET DEFAULT command"));  #else  #ifdef datageneralM     return(hmsg("Change Working Directory, equivalent to DG 'dir' command"));i #elsepN     return(hmsg("Change Working Directory, equivalent to Unix 'cd' command")); #endif #endif  t case XXDEL:,1     return(hmsg("Delete a local file or files"));   e case XXDIAL:9     return(hmsg("Dial a number using modem autodialer"));n  t case XXDIR:e7     return(hmsg("Display a directory of local files"));n  a case XXECH:rD     return(hmsg("Display the rest of the command on the terminal,\n\ useful in command files."));  ] case XXEXI:  case XXQUI:mI     return(hmsg("Exit from the Kermit program, closing any open logs."));r  e case XXFIN:o     return(hmsg("\C Tell the remote Kermit server to shut down without logging out."));   s case XXGET:n     return(hmsg(hmxxget));  n case XXHLP:      return(hmsga(tophlp));    case XXLOG:      return(hmsga(hmxxlg));    case XXLOGI:     return(hmsga(hmxxlogi));  q case XXREC:s     return(hmsga(hmxxrc)); t  a case XXREM: F     if ((y = cmkey(remcmd,nrmt,"Remote command","")) == -2) return(y);     if (y == -1) return(y);s%     if (x = (cmcfm()) < 0) return(x);t     return(dohrmt(y));    case XXSEN:      return(hmsg(hmxxsen));  n case XXSER:t     return(hmsg(hmxxser));    case XXSET:iA     if ((y = cmkey(prmtab,nprm,"Parameter","")) == -2) return(y);      if (y == -2) return(y);i%     if (x = (cmcfm()) < 0) return(x);,     return(dohset(y));  t case XXSHE:f
 #ifdef vms     return(hmsg("\5 Issue a command to VMS (space required after '!')"));  #else  #ifdef AMIGA     return(hmsg("\5 Issue a command to CLI (space required after '!')"));g #elser #ifdef datageneral     return(hmsg("\9 Issue a command to the CLI (space required after '!')"));d #elsev     return(hmsg("\@ Issue a command to the Unix shell (space required after '!')")); #endif #endif #endif    case XXSHO:g     return(hmsg("\J Display current values of 'set' parameters; 'show version' will display\n\A program version information for each of the C-Kermit modules."));c  a case XXSPA:l #ifdef datageneral     return(hmsg("\3 Display disk usage in current device, directory,\n\-6 or return space for a specified device, directory.")); #else D     return(hmsg("Display disk usage in current device, directory")); #endif  C case XXSTA:lG     return(hmsg("Display statistics about most recent file transfer"));r  t case XXTAK:i     return(hmsg("\F Take Kermit commands from the named file.  Kermit command files may\n\L themselves contain 'take' commands, up to a reasonable depth of nesting."));  e default:%     if (x = (cmcfm()) < 0) return(x);n.     printf("Not available yet - %s\n",cmdbuf);
     break;     }d     return(0); }e e  rC /*  H M S G  --  Get confirmation, then print the given message  */i  l hmsg(s) char *s; {
     int x;%     if ((x = cmcfm()) < 0) return(x);r     puts(s);     return(0); }x  n; hmsga(s) char *s[]; {			/* Same function, but for arrays */n
     int x, i;r&     if ( x = (cmcfm()) < 0) return(x);3     for ( i = 0; *s[i] ; i++ ) fputs(s[i], stdout);      fputc( '\n', stdout);d     return(0); }e    f2 /*  D O H S E T  --  Give help for SET command  */  e dohset(xx) int xx; {     (     if (xx == -3) return(hmsga(hmhset));     if (xx < 0) return(xx);      switch (xx) {b  i case XYCHKT:     return(hmsga(hmxychkt));  r
 case XYDELA:       puts("\gN Number of seconds to wait before sending first packet after 'send' command.");     return(0);  w case XYDUPL:     puts("\ O During 'connect': 'full' means remote host echoes, 'half' means this program");c"     puts("does its own echoing.");     return(0);    case XYESC:a     printf("%s","\I Decimal ASCII value for escape character during 'connect', normally 28\n\g (Control-\\)\n");      return(0);    case XYFILE:     return(hmsga(hmxyf));p  i case XYFLOW:     puts("\ G Type of flow control to be used.  Choices are 'xon/xoff' and 'none'.");n     puts("normally xon/xoff.");:     return(0);  n case XYHAND:     puts("\ K Decimal ASCII value for character to use for half duplex line turnaround");\;     puts("handshake.  Normally, handshaking is not done.");d     return(0); , case XYLINE:
     printf("\oB Device name of communication line to use.  Normally %s.\n",dftty);     if (!dfloc) {e
 	printf("\< If you set the line to other than %s, then Kermit\n",dftty);
 	printf("\J will be in 'local' mode; 'set line' will reset Kermit to remote mode.\n");     puts("\eJ If the line has a modem, and if the modem-dialer is set to direct, this");     puts("\OL command causes waiting for a carrier detect (e.g. on a hayes type modem).");     puts("\ / This can be used to wait for incoming calls.");p     puts("\aN To use the modem to dial out, first set modem-dialer (e.g., to hayes), then");H     puts("set line, next issue the dial command, and finally connect.");     }s     return(0);  o case XYMODM:     puts("\eN Type of modem for dialing remote connections.  Needed to indicate modem can");     puts("\iK be commanded to dial without 'carrier detect' from modem.  Many recently");'     puts("\ L manufactured modems use 'hayes' protocol.  Type 'set modem ?' to see what");     puts("\a1 types of modems are supported by this program.");a     return(0);  "    case XYPARI:H     puts("Parity to use during terminal connection and file transfer:");=     puts("even, odd, mark, space, or none.  Normally none.");e     return(0);  e case XYPROM:B     puts("Prompt string for this program, normally 'C-Kermit>'.");     return(0);    case XYRETR:     puts("\ D How many times to retransmit a particular packet before giving up");     return(0);    case XYSPEE:     puts("\eJ Communication line speed for external tty line specified in most recent"); #ifdef AMIGA     puts("\cJ 'set line' command.  Any baud rate between 110 and 292000, although you");L     puts(" will receive a warning if you do not use a standard baud rate:");     puts("\eI 110, 150, 300, 600, 1200, 1800, 2400, 4800, 9600, 19200, 38400, 57600.");c #elseh #ifdef datageneral     puts("\b5 'set line' command.  Any of the common baud rates:");n>     puts(" 0, 50, 75, 110, 134, 150, 300, 600, 1200, 1800, ");9     puts(" 2400, 3600, 7200, 4800, 9600, 19200, 38400.");r #elsea     puts("\e5 'set line' command.  Any of the common baud rates:");;B     puts(" 0, 110, 150, 300, 600, 1200, 1800, 2400, 4800, 9600."); #endif #endif     return(0); a case XYRECV:     puts("\s* Specify parameters for inbound packets:");     puts("\t= End-Of-Packet (ASCII value), Packet-Length (1000 or less),");f     puts("\k= Padding (amount, 94 or less), Pad-Character (ASCII value),");s     puts("\eC Start-Of-Packet (ASCII value), and Timeout (94 seconds or less),");      puts("\i$ all specified as decimal numbers.");     return(0);    case XYSEND:     puts("\ + Specify parameters for outbound packets:");i     puts("\\= End-Of-Packet (ASCII value), Packet-Length (2000 or less),");      puts("\\= Padding (amount, 94 or less), Pad-Character (ASCII value),");t     puts("\,C Start-Of-Packet (ASCII value), and Timeout (94 seconds or less),");      puts("\n$ all specified as decimal numbers.");     return(0);  ' default:3     printf("%s","Not available yet - %s\n",cmdbuf);b     return(0);     }; }Y t  c7 /*  D O H R M T  --  Give help about REMOTE command  */e  f dohrmt(xx) int xx; {
     int x;(     if (xx == -3) return(hmsga(hmhrmt));     if (xx < 0) return(xx);      switch (xx) {n  e case XZCWD:      return(hmsg("\= Ask remote Kermit server to change its working directory."));t  o case XZDEL:      return(hmsg("\9 Ask remote Kermit server to delete the named file(s)."));a  ' case XZDIR:}     return(hmsg("\O Ask remote Kermit server to provide directory listing of the named file(s)."));   f case XZHLP:u     return(hmsg("\C Ask remote Kermit server to tell you what services it provides."));O    case XZHOS:s     return(hmsg("\B Send a command to the remote system in its own command language\n\% through the remote Kermit server."));r  o case XZSPA:t     return(hmsg("\B Ask the remote Kermit server to tell you about its disk space."));  n case XZTYP:e     return(hmsg("\J Ask the remote Kermit server to type the named file(s) on your screen."));  o case XZWHO:m     return(hmsg("\O Ask the remote Kermit server to list who's logged in, or to give information\n\a about the specified user."));a    default:%     if (x = (cmcfm()) < 0) return(x);R1     printf("%s","not working yet - %s\n",cmdbuf);i     return(-2);e     }r }  eN /*** The following functions moved here from ckuusr.c because that module ***/" /*** got too big for PDP-11s. ***/  Q) /*  D O L O G  --  Do the log command  */   g dolog(x) int x; {e     int y; char *s;e  F     switch (x) {  ( 	case LOGD:r #ifdef DEBUG< 	    y = cmofi("Name of debugging log file","debug.log",&s); #elsee     	    y = -2; s = "";7 	    printf("%s","- Sorry, debug log not available\n");  #endif 	    break;x  ) 	case LOGP:X: 	    y = cmofi("Name of packet log file","packet.log",&s); 	    break;h  r 	case LOGS: < 	    y = cmofi("Name of session log file","session.log",&s); 	    break;e  n 	case LOGT:( #ifdef TLOGrA 	    y = cmofi("Name of transaction log file","transact.log",&s);) #else      	    y = -2; s = "";= 	    printf("%s","- Sorry, transaction log not available\n");  #endif 	    break;f  y	 	default:m5 	    printf("\n?Unexpected log designator - %d\n",x);  	    return(-2);     }f     if (y < 0) return(y);(  ,     strcpy(line,s);)
     s = line;S%     if ((y = cmcfm()) < 0) return(y);s    /* cont'd... */( c /* ...dolog, cont'd */     s     switch (x) {    	case LOGD:\  	    return(deblog = debopn(s));  r 	case LOGP:" 	    zclose(ZPFILE); 	    y = zopeno(ZPFILE,s);6 	    if (y > 0) strcpy(pktfil,s); else *pktfil = '\0'; 	    return(pktlog = y);  s 	case LOGS:  	    zclose(ZSFILE); 	    y = zopeno(ZSFILE,s);6 	    if (y > 0) strcpy(sesfil,s); else *sesfil = '\0'; 	    return(seslog = y);    	case LOGT:t 	    zclose(ZTFILE); 	    tralog = zopeno(ZTFILE,s);e 	    if (tralog > 0) { 		strcpy(trafil,s);d* 		tlog(F110,"Transaction Log:",versio,0l); 		tlog(F100,ckxsys,"",0);i 		ztime(&s); 		tlog(F100,s,"",0l);i
     	    } 	    else *trafil = '\0';c 	    return(tralog);  )	 	default:  	    return(-2);     }d }   g  n. /*  D E B O P N  --  Open a debugging file  */  S debopn(s) char *s; { #ifdef DEBUG
     char *tp;t     zclose(ZDFILE);"     deblog = zopeno(ZDFILE,s);     if (deblog > 0) {  	strcpy(debfil,s);# 	debug(F110,"Debug Log ",versio,0);\ 	debug(F100,ckxsys,"",0);  	ztime(&tp); 	debug(F100,tp,"",0);      } else *debfil = '\0';     return(deblog);  #elset     return(0); #endif }v a( /*  S H O P A R  --  Show Parameters  */   
 shopar() {   
     int i;3     extern struct keytab mdmtab[]; extern int nmdm;e  e'     printf("\n%s,%s, ",versio,ckxsys); n'     puts("Communications Parameters:");)8     printf(" Line: %s, speed: %d, mode: ",ttname,speed);6     if (local) printf("local"); else printf("remote");  r      for (i = 0; i < nmdm; i++) { 	if (mdmtab[i].val == mdmtyp) {i0 	    printf(", modem-dialer: %s",mdmtab[i].kwd); 	    break;u 	}     } +     printf("\n Bits: %d",(parity) ? 7 : 8);T     printf(", parity: ");)     switch (parity) {f" 	case 'e': printf("even");  break;" 	case 'o': printf("odd");   break;" 	case 'm': printf("mark");  break;" 	case 's': printf("space"); break;" 	case 0:   printf("none");  break;0 	default:  printf("invalid - %d",parity); break;     }		a     printf(", duplex: "); 8     if (duplex) printf("half, "); else printf("full, ");     printf("flow: ");a&     if (flow == 1) printf("xon/xoff");$ 	else if (flow == 0) printf("none"); 	else printf("%d",flow);     printf(", handshake: ");;     if (turn) printf("%d\n",turnch); else printf("none\n");CE     printf("Terminal emulation: %d bits\n", (cmask == 0177) ? 7 : 8);x  )7     printf("\nProtocol Parameters:   Send    Receive");t6     if (timef || spsizf) printf("    (* = override)");7     printf("\n Timeout:      %11d%9d", rtimo,  timint);H     if (timef) printf("*");S7     printf("\n Padding:      %11d%9d", npad,   mypadn);r.     printf("        Block Check: %6d\n",bctr);7     printf(  " Pad Character:%11d%9d", padch,  mypadc); /     printf("        Delay:       %6d\n",delay); 6     printf(  " Packet Start: %11d%9d", mystch, stchr);0     printf("        Max Retries: %6d\n",maxtry);4     printf(  " Packet End:   %11d%9d", seol,   eol);     if (ebqflg)i1       printf("        8th-Bit Prefix: '%c'",ebq); -     printf(  "\n Packet Length:%11d", spsiz);r9     printf( spsizf ? "*" : " " ); printf("%8d",  urpsiz);i/     printf( (urpsiz > 94) ? " (94)" : "     ");o     if (rptflg)s-       printf("   Repeat Prefix:  '%c'",rptq);l;     printf(  "\n Length Limit: %11d%9d\n", maxsps, maxrps);   e2     printf("\nFile parameters:\n File Names:   ");K     if (fncnv) printf("%-12s","converted"); else printf("%-12s","literal");0 #ifdef DEBUG$     printf("   Debugging Log:    ");9     if (deblog) printf("%s",debfil); else printf("none");" #endif      printf("\n File Type:    ");F     if (binary) printf("%-12s","binary"); else printf("%-12s","text");$     printf("   Packet Log:       ");4     if (pktlog) printf(pktfil); else printf("none");      printf("\n File Warning: ");?     if (warn) printf("%-12s","on"); else printf("%-12s","off");i$     printf("   Session Log:      ");4     if (seslog) printf(sesfil); else printf("none");      printf("\n File Display: ");@     if (quiet) printf("%-12s","off"); else printf("%-12s","on"); #ifdef TLOGl$     printf("   Transaction Log:  ");4     if (tralog) printf(trafil); else printf("none"); #endif=     printf("\n\nFile Byte Size: %d",(fmask == 0177) ? 7 : 8);X.     printf(", Incomplete File Disposition: ");5     if (keep) printf("keep"); else printf("discard");f #ifdef KERMRC    c%     printf(", Init file: %s",KERMRC);t #endif     puts("\n");o }  ": /*  D O S T A T  --  Display file transfer statistics.  */  a
 dostat() {-     printf("\nMost recent transaction --\n");8#     printf(" files: %ld\n",filcnt);72     printf(" total file characters  : %ld\n",tfc);3     printf(" communication line in  : %ld\n",tlci);n3     printf(" communication line out : %ld\n",tlco);,7     printf(" elapsed time           : %d sec\n",tsecs);0     if (filcnt > 0) {  	if (tsecs > 0) {n
 	    long lx;y 	    lx = (tfc * 10l) / tsecs;2 	    printf(" effective baud rate    : %ld\n",lx); 	    if (speed > 0) {  		lx = (lx * 100l) / speed;a2 		printf(" efficiency             : %ld %%\n",lx); 	    } 	}> 	printf(" packet length          : %d (send), %d (receive)\n", 	       spsiz,urpsiz);/ 	printf(" block check type used  : %d\n",bctu);c& 	printf(" compression            : ");< 	if (rptflg) printf("yes [%c]\n",rptq); else printf("no\n");& 	printf(" 8th bit prefixing      : ");= 	if (ebqflg) printf("yes [%c]\n",ebq); else printf("no\n\n");      } else printf("\n");     return(0); }i  B /*  F S T A T S  --  Record file statistics in transaction log  */  )
 fstats() {$     tlog(F100," end of file","",0l);2     tlog(F101,"  file characters        ","",ffc);3     tlog(F101,"  communication line in  ","",flci);e3     tlog(F101,"  communication line out ","",flco);e }"      = /*  T S T A T S  --  Record statistics in transaction log  */%  "
 tstats() {     char *tp; int x;  Y'     ztime(&tp);				/* Get time stamp */a;     tlog(F110,"End of transaction",tp,0l);  /* Record it */;   5     if (filcnt < 1) return;		/* If no files, done. */   u> /* If multiple files, record character totals for all files */        if (filcnt > 1) {r 	tlog(F101," files","",filcnt);"/ 	tlog(F101," total file characters   ","",tfc);e0 	tlog(F101," communication line in   ","",tlci);0 	tlog(F101," communication line out  ","",tlco);     }i  e. /* Record timing info for one or more files */  (;     tlog(F101," elapsed time (seconds)  ","",(long) tsecs);r     if (tsecs > 0) { 	x = (tfc / tsecs) * 10;- 	tlog(F101," effective baud rate     ","",x);e 	if (speed > 0) {  	    x = (x * 100) / speed;a1 	    tlog(F101," efficiency (percent)    ","",x);) 	}     }e2     tlog(F100,"","",0);			/* Leave a blank line */ }v t: /*  S D E B U  -- Record spar results in debugging log  */  u sdebu(len) int len; {o(     debug(F111,"spar: data",rdatap,len);$     debug(F101," spsiz ","", spsiz);$     debug(F101," timint","",timint);$     debug(F101," npad  ","",  npad);$     debug(F101," padch ","", padch);$     debug(F101," seol  ","",  seol);$     debug(F101," ctlq  ","",  ctlq);$     debug(F101," ebq   ","",   ebq);$     debug(F101," ebqflg","",ebqflg);$     debug(F101," bctr  ","",  bctr);$     debug(F101," rptq  ","",  rptq);$     debug(F101," rptflg","",rptflg);$     debug(F101," atcapu","",atcapu);$     debug(F101," lpcapu","",lpcapu);$     debug(F101," swcapu","",swcapu);$     debug(F101," wsize ","", wsize); }B7 /*  R D E B U -- Debugging display of rpar() values  */g  s rdebu(len) int len; {=(     debug(F111,"spar: data",rdatap,len);.     debug(F101," rpsiz ","",xunchar(data[1]));$     debug(F101," rtimo ","", rtimo);$     debug(F101," mypadn","",mypadn);$     debug(F101," mypadc","",mypadc);$     debug(F101," eol   ","",   eol);$     debug(F101," ctlq  ","",  ctlq);$     debug(F101," sq    ","",    sq);$     debug(F101," ebq   ","",   ebq);$     debug(F101," ebqflg","",ebqflg);$     debug(F101," bctr  ","",  bctr);%     debug(F101," rptq  ","",data[9]);n$     debug(F101," rptflg","",rptflg);#     debug(F101," capas ","",capas);d)     debug(F101," bits  ","",data[capas]); $     debug(F101," atcapu","",atcapu);$     debug(F101," lpcapu","",lpcapu);$     debug(F101," swcapu","",swcapu);$     debug(F101," wsize ","", wsize);,     debug(F101," rpsiz(extended)","",rpsiz); } 