 @Part(CKUNIX,root="KER:KUSER")! @string(-ckversion="@q<4E(067)>") $ @define(exx=example,above 2,below 1) @Chapter<UNIX KERMIT>     @case(device,file="********@* F This document is formatted as an ordinary, plain text ASCII disk file.C Typeset copies are available in the Kermit User Guide from Columbia > University.  Changes should be made to CKUKER.MSS.@*********")   6 @Begin<Description,Leftmargin +12,Indent -12,spread 0>B @i(Program:)@\Frank da Cruz, Bill Catchings, Jeff Damens, ColumbiaB University; Herm Fischer, Encino CA; contributions by many others.    @i(Language:)@\C   / @i(Documentation:)@\Frank da Cruz, Herm Fischer      @i(Version:)@\@value(-ckversion)    @i(Date: )@\August 5, 1987 @end<Description>    > C-Kermit is an implementation of Kermit, written modularly andF transportably in C.  The protocol state transition table is written in> @i'wart', a (non-@|proprietary) lex-@|like preprocessor for C.L System-@|dependent primitive functions are isolated into separately compiledL modules so that the program should be easily portable among Unix systems andM also to non-@|Unix systems that have C compilers, such as the Apple Macintosh J and the Commodore Amiga.  This document applies to Unix implementations ofC C-Kermit, and in most ways also to the VMS, Data General, and other  implementations.   2 @subheading<Unix Kermit Capabilities At A Glance:>, @begin<format,leftmargin +2,above 1,below 1>' @tabclear()@tabset(3.5inches,4.0inches)  Local operation:@\Yes  Remote operation:@\Yes  Login scripts:@\Yes (UUCP style) Transfer text files:@\Yes  Transfer binary files:@\Yes  Wildcard send:@\Yes   File transfer interruption:@\Yes" Filename collision avoidance:@\Yes Can time out:@\Yes 8th-bit prefixing:@\Yes  Repeat count prefixing:@\Yes Alternate block checks:@\Yes Terminal emulation:@\Yes Communication settings:@\Yes Transmit BREAK:@\Yes  Support for dialout modems:@\Yes! IBM mainframe communication:@\Yes  Transaction logging:@\Yes  Session logging:@\Yes  Debug logging:@\Yes  Packet logging:@\Yes Act as server:@\Yes  Talk to server:@\Yes Advanced server functions:@\Yes  Local file management:@\Yes  Command/Init files:@\Yes% UUCP and multiuser line locking:@\Yes  Long packets:@\Yes Sliding Windows:@\No File attributes packets:@\No Command macros:@\No  Raw file transmit:@\No @end<format>   E @i(All numbers in the C-Kermit documentation are decimal unless noted  otherwise.)    # @index(C-Kermit)@index(Unix Kermit) D C-Kermit provides traditional Unix command line operation as well asF interactive command prompting and execution.  The command line options@ provide access to a basic subset of C-Kermit's capabilities; the& interactive command set is far richer.   H On systems with dialout modems, C-Kermit's command file and login scriptH facilities provide a counterpart to UUCP for file transfer with non-UNIXO operating systems, including the use of scheduled (e.g@. late night) unattended 
 operation.    @section(The Unix File System)   M Consult your Unix manual for details about the file system under your version I of Unix.  In general, Unix files generally have lowercase names, possibly N containing one or more dots or other special characters.  Unix directories areD tree-@|structured.  Directory levels are separated by slash (@qq[/]) characters.  For example,  @example(/usr/foo/bar)D denotes the file @q(bar) in the directory @q(/usr/foo).  Wildcard or@ "meta" characters allow groups of files to be specified.  @qq(*)8 matches any string; @qq(?) matches any single character.   J When C-Kermit is invoked with file arguments specified on the Unix commandK line, the Unix shell (Bourne Shell, C-Shell, K-Shell, etc) expands the meta O characters itself, and in this case a wider variety is available.  For example, M @example(kermit -s ~/ck[uvm]*.{upd,bwr}]) is expanded by the Berkeley C-Shell M into a list of all the files in the user's home directory (@q[~/]) that start O with the characters "@q(ck)", followed by a single character @qq(u), @qq(v), or O @qq(m), followed by zero or more characters, followed by a dot, followed by one M of the strings @qq(upd) or @qq(bwr).  Internally, the C-Kermit program itself 3 expands only the @qq(*) and @qq(?) meta characters.    N Unix files are linear (sequential) streams of 8-bit bytes.  Text files consistG of 7-bit ASCII characters, with the high-@|order bit off (0), and lines J separated by the Unix newline character, which is linefeed (LF, ASCII 10).M This distinguishes Unix text files from those on most other ASCII systems, in O which lines are separated by a carriage-@|return linefeed sequence (CRLF, ASCII N 13 followed by ASCII 10).  Binary files are likely to contain data in the highH bits of the file bytes, and have no particular line or record structure.   F When transferring files, C-Kermit will convert between upper and lowerF case filenames and between LF and CRLF line terminators automatically,H unless told to do otherwise.  When binary files must be transferred, theK program must be instructed not to perform LF/CRLF conversion (@q[-i] on the A command line or "set file type binary" interactively; see below).     @section(File Transfer)    K If C-Kermit is in local mode, the screen (stdout) is continously updated to L show the progress of the file transer.  A dot is printed for every four data) packets, other packets are shown by type: 6 @begin(description,leftmargin +6, indent -2, spread 0)! I@\Exchange Parameter Information     R@\Receive Initiate     S@\Send Initiate    F@\File Header    G@\Generic Server Command     C@\Remote Host Command   ! N@\Negative Acknowledgement (NAK)     E@\Fatal Error    T@\Indicates a timeout occurred    A Q@\Indicates a damaged, undesired, or illegal packet was received    + @q<%>@\Indicates a packet was retransmitted  @end(description) ? You may type certain "interrupt" commands during file transfer: 6 @begin(description,leftmargin +16,indent -12,spread 0)G Control-F:@\Interrupt the current File, and go on to the next (if any).    K Control-B:@\Interrupt the entire Batch of files, terminate the transaction.    % Control-R:@\Resend the current packet    @ Control-A:@\Display a status report for the current transaction. @end(description) D These interrupt characters differ from the ones used in other KermitI implementations to avoid conflict with commonly used Unix shell interrupt H characters.  With Version 7, System III, and System V implementations ofL Unix, interrupt commands must be preceeded by the 'connect' escape characterG (e.g. normally-@q[\]).  Ctrl-F and Ctrl-B are effective only during the M transfer of data (D) packets, and cannot be used to interrupt a transfer that  has not yet reached that stage.     @begin(quotation) / @i(CAUTION:)@index(Warning)@index<File Warning> >  If Control-F or Control-B is used to cancel an incoming file,J and a file of the same name previously existed, @i(and) the "file warning"J feature is not enabled, then the previous copy of the file will disappear. @end(quotation)    ) @i(EMERGENCY EXIT:)@index<Emergency Exit> G When running Unix Kermit in remote mode, if you have started a protocol K operation (sending or receiving a file, server command wait, etc), you will J not be able to regain control of the terminal until the protocol operationL has run its course (completed or timed out).  In particular, you cannot stopF the protocol by typing the normal Unix interrupt characters, since theK terminal has been put in "raw mode".  If you need to regain control quickly N -- for instance, because the protocol is stuck -- you can type two Control-C'sC directly to the Unix Kermit program ("connect" first if necessary):  @display<Control-C Control-C> G This will cause the program to exit and restore the terminal to normal.      @section(Command Line Operation)   N The C-Kermit command line syntax conforms to the @ux(Proposed Syntax StandardsL for Unix System Commands) put forth by Kathy Hemenway and Helene Armitage ofL AT&T Bell Laboratories in @i(Unix/World), Vol.1, No.3, 1984.  The rules that
 apply are:    @begin(itemize,spread 0)A Command names must be between 2 and 9 characters ("kermit" is 6).(  )> Command names must include lower case letters and digits only.   % An option name is a single character.s  c! Options are delimited by '@q(-)'.p  nH Options with no arguments may be grouped (bundled) behind one delimiter.   $ Option-arguments cannot be optional.  l> Arguments immediately follow options, separated by whitespace.  r% The order of options does not matter.m  \A '@q(-)' preceded and followed by whitespace means standard input.e
 @end(itemize)iG A group of bundled options may end with an option that has an argument.n  i7 The following notation is used in command descriptions:l+ @begin(description,leftmargin +8,indent -8)7E @i(fn)@\A Unix file specification, possibly containing the "wildcard"tM characters `@q[*]' or `@q[?]' (`@q[*]' matches all character strings, `@q[?]'r matches any single character).  eL @i(fn1)@\A Unix file specification which may not contain `@q[*]' or `@q[?]'.  iM @i(rfn)@\A remote file specification in the remote system's own syntax, whichp- may denote a single file or a group of files.n  sM @i(rfn1)@\A remote file specification which should denote only a single file.m  .) @i(n)@\A decimal number between 0 and 94.i   F @i(c)@\A decimal number between 0 and 127 representing the value of an ASCII character.   ? @i(cc)@\A decimal number between 0 and 31, or else exactly 127,a5 representing the value of an ASCII control character.5  h0 @q([ ])@\Any field in square braces is optional.  i5 @q({x,y,z})@\Alternatives are listed in curly braces.x @end(description)n  rI C-Kermit command line options may specify either actions or settings.  IfsJ C-Kermit is invoked with a command line that specifies no actions, then it1 will issue a prompt and begin interactive dialog.cK Action options specify either protocol transactions or terminal connection.m  B+ @begin<description,leftmargin +8,indent -8> D @q(-s )@i(fn)@\Send the specified file or files.  If @i(fn) containsM wildcard (meta) characters, the Unix shell expands it into a list.  If @i(fn)e< is '@q[-]' then kermit sends from standard input, which must come from a file:: @example(kermit -s - < foo.bar)  or a parallel process:- @example(ls -l | grep christin | kermit -s -)d% You cannot use this mechanism to send H terminal typein.  If you want to send a file whose actual name is @qq(-)* you can precede it with a path name, as in @example(kermit -s ./-)s   E @q(-r)@\Receive a file or files.  Wait passively for files to arrive.a  nE @q(-k)@\Receive (passively) a file or files, sending them to standard 1 output.  This option can be used in several ways:s+ @begin(description,leftmargin +4,indent -4);J @q(kermit -k)@\Displays the incoming files on your screen; to be used only in "local mode" (see below).   L @q(kermit -k > )@i(fn1)@\Sends the incoming file or files to the named file,F @i(fn1).  If more than one file arrives, all are concatenated together into the single file @i(fn1).    D @q(kermit -k | command)@\Pipes the incoming data (single or multiple& files) to the indicated command, as in) @example'kermit -k | sort > sorted.stuff'r @end(description)   eJ @q(-a )@i(fn1)@\If you have specified a file transfer option, you may giveG an alternate name for a single file with the @q(-a) ("as") option.  Forl example, @example'kermit -s foo -a bar'E sends the file @q(foo) telling the receiver that its name is @q(bar).s@ If more than one file arrives or is sent, only the first file is affected by the @q(-a) option: @example'kermit -ra baz'6 stores the first incoming file under the name @q(baz).  eL @q(-x)@\Begin server operation.  May be used in either local or remote mode. @end(description)t  eC Before proceeding, a few words about remote and local operation are J necessary.  C-Kermit is "local" if it is running on PC or workstation thatE you are using directly, or if it is running on a multiuser system andsH transferring files over an external communication line -- not your job'sJ controlling terminal or console.  C-Kermit is remote if it is running on aK multiuser system and transferring files over its own controlling terminal'sdC communication line (normally @q</dev/tty>), connected to your PC ory workstation.  qD If you are running C-Kermit on a PC, it is in local mode by default,J with the "back port" designated for file transfer and terminal connection.F If you are running C-Kermit on a multiuser (timesharing) system, it isE in remote mode unless you explicitly point it at an external line forlA file transfer or terminal connection.  The following command setsa C-Kermit's "mode":  e+ @begin(description,leftmargin +8,indent -8)o@ @q(-l )@i(dev)@\Line  -- Specify a terminal line to use for file' transfer and terminal connection, as in  @example'kermit -l /dev/ttyi5' @end(description)s  rH When an external line is being used, you might also need some additional< options for successful communication with the remote system:  l+ @begin(description,leftmargin +8,indent -8) F @q(-b )@i(n)@\Baud  -- Specify the baud rate for the line given in the @q(-l) option, as in& @example'kermit -l /dev/ttyi5 -b 9600'G This option should always be included with the @q(-l) option, since thei= speed of an external line is not necessarily what you expect.t   O @q(-p )@i(x)@\Parity -- e,o,m,s,n (even, odd, mark, space, or none).  If parityk@ is other than none, then the 8th-bit prefixing mechanism will be> used for transferring 8-bit binary data, provided the opposite+ Kermit agrees.  The default parity is none.a   H @q(-t)@\Specifies half duplex, line turnaround with XON as the handshake
 character. @end(description)g  nF The following commands may be used only with a C-Kermit which is localC either by default or else because the -l option has been specified.   q+ @begin(description,leftmargin +8,indent -8)eG @q(-g )@i(rfn)@\Actively request a remote server to send the named filerN or files; @i(rfn) is a file specification in the remote host's own syntax.  IfL @i(fn) happens to contain any special shell characters, like space, '@q(*)',) '@q([)', etc, these must be quoted, as ine @example'kermit -g x\*.\?' or" @example'kermit -g "profile exec"'  t3 @q(-f)@\Send a 'finish' command to a remote server.a  oE @q(-c)@\Establish a terminal connection over the specified or default @ communication line, before any protocol transaction takes place.; Get back to the local system by typing the escape characterS8 (normally Control-Backslash) followed by the letter 'c'.  oF @q(-n)@\Like @q(-c), but @i(after) a protocol transaction takes place;J @q(-c) and @q(-n) may both be used in the same command.  The use of @q(-n)  and @q(-c) is illustrated below. @end(description)nO If the other Kermit is on a remote system, the @q(-l) and @q(-b) options should)< also be included with the @q(-r), @q(-k), or @q(-s) options.  i0 Several other command-line options are provided:+ @begin(description,leftmargin +8,indent -8) O @q(-i)@\Specifies that files should be sent or received exactly "as is" with noiM conversions.  This option is necessary for transmitting binary files.  It maynI also be used in Unix-to-Unix transfers (it must be given to @i<both> UnixtO Kermit programs), where it will improve performance by circumventing the normallK text-file conversions, and will allow mixture of text and binary files in a  single file group.  mF @q(-w)@\Write-Protect -- Avoid filename collisions for incoming files.   K @q(-e @i<n>)@\Extended packet length -- Specify that C-Kermit is allowed tofJ receive packets up to length @i<n>, where @i<n> may be between 10 and someM large number, like 1000, depending on the system.  The default maximum length"L for received packets is 90.  Packets longer than 94 will be used only if the; other Kermit includes the "long packet" protocol extension.   sJ @q(-q)@\Quiet -- Suppress screen update during file transfer, for instance6 to allow a file transfer to proceed in the background.  mK @q(-d)@\Debug -- Record debugging information in the file @q(debug.log) in iB the current directory.  Use this option if you believe the program8 is misbehaving, and show the resulting log to your local kermit maintainer.  (E @q(-h)@\Help -- Display a brief synopsis of the command line options.  @end(description)nE The command line may contain no more than one protocol action option.-  pM Files are sent with their own names, except that lowercase letters are raised O to upper, pathnames are stripped off, certain special characters like (`@q[~]')sH and (`@q[#]') are changed to `@q(X)', and if the file name begins with aJ period, an `@q(X)' is inserted before it.  Incoming files are stored underM their own names except that uppercase letters are lowered, and, if @q(-w) wastK specified, a "generation number" is appended to the name if it has the samerM name as an existing file which would otherwise be overwritten.  If the @q(-a)oH option is included, then the same rules apply to its argument.  The fileD transfer display shows any transformations performed upon filenames.  12 During transmission, files are encoded as follows: @begin(itemize).8 Control characters are converted to prefixed printables.  eD Sequences of repeated characters are collapsed via repeat counts, ifE the other Kermit is also capable of repeated-@|character compression.s  lH If parity is being used on the communication line, data characters with I the 8th (parity) bit on are specially prefixed, provided the other Kermit.E is capable of 8th-bit prefixing; if not, 8-bit binary files cannot be  successfully transferred.n  CJ Conversion is done between Unix newlines and carriage-@|return-@|linefeed 1 sequences unless the @q(-i) option was specified. 
 @end(itemize)d  r# @subheading(Command Line Examples:)p  n) @exx(kermit -l /dev/ttyi5 -b 1200 -cn -r)IH This command connects you to the system on the other end of @q(ttyi5) atC 1200 baud, where you presumably log in and run Kermit with a 'send'oH command.  After you escape back, C-Kermit waits for a file (or files) toD arrive.  When the file transfer is completed, you are reconnected to) the remote system so that you can logout.i  a4 @exx(kermit -l /dev/ttyi4 -b 1800 -cntp m -r -a foo)H This command is like the preceding one, except the remote system in thisE case uses half duplex communication with mark parity.  The first filel. that arrives is stored under the name @q(foo).  i+ @exx(kermit -l /dev/ttyi6 -b 9600 -c | tek)nF This example uses Kermit to connect your terminal to the system at theB other end of @q(ttyi6).  The C-Kermit terminal connection does notH provide any particular terminal emulation, so C-Kermit's standard i/o isG piped through a (hypothetical) program called tek, which performs (say)o Tektronix emulation.   & @exx(kermit -l /dev/ttyi6 -b 9600 -nf)H This command would be used to shut down a remote server and then connectG to the remote system, in order to log out or to make further use of it..M The @q(-n) option is invoked @i(after) @q(-f) (@q[-c] would have been invokedl before).   / @exx(kermit -l /dev/ttyi6 -b 9600 -qg foo.\* &)eM This command causes C-Kermit to be invoked in the background, getting a grouptN of files from a remote server (note the quoting of the `@q[*]' character).  NoA display occurs on the screen, and the keyboard is not sampled forqD interruption commands.  This allows other work to be done while file$ transfers proceed in the background.  iD @exx(kermit -l /dev/ttyi6 -b 9600 -g foo.\* > foo.log < /dev/null &)K This command is like the previous one, except the file transfer display hassO been redirected to the file @q(foo.log).  Standard input is also redirected, toh< prevent C-Kermit from sampling it for interruption commands.  m @exx(kermit -iwx)nK This command starts up C-Kermit as a server.  Files are transmitted with nolG newline/@|carriage-@|return-@|linefeed conversion; the @q(-i) option isaG necessary for binary file transfer and recommended for Unix-@|to-@|UnixiO transfers.  Incoming files that have the same names as existing files are givenn new, unique names.   " @exx(kermit -l /dev/ttyi6 -b 9600)G This command sets the communication line and speed.  Since no action islI specified, C-Kermit issues a prompt and enters an interactive dialog withrG you.  Any settings given on the command line remain in force during thel" dialog, unless explicitly changed.  o @exx(kermit)F This command starts up Kermit interactively with all default settings.  ,F The next example shows how Unix Kermit might be used to send an entireH directory tree from one Unix system to another, using the tar program asO Kermit's standard input and output.  On the orginating system, in this case thet* remote, type (for instance):@label(-uxtar)  c& @exx(tar cf - /usr/fdc | kermit -is -)M This causes tar to send the directory @q(/usr/fdc) (and all its files and alltM its subdirectories and all their files...) to standard output instead of to aeK tape; kermit receives this as standard input and sends it as a binary file.gI On the receiving system, in this case the local one, type (for instance):a  n1 @exx(kermit -il /dev/ttyi5 -b 9600 -k | tar xf -)fL Kermit receives the tar archive, and sends it via standard output to its ownM copy of tar, which extracts from it a replica of the original directory tree.   sK A final example shows how a Unix compression utility might be used to speedf up Kermit file transfers:c @begin(example) - compress file | kermit -is -     (@i(sender)) / kermit -ik | uncompress          (@i(receiver))s @end(example)	  h @subheading(Exit Status Codes:)m  lH Unix Kermit returns an exit status of zero, except when a fatal error isB encountered, where the exit status is set to one.  With backgroundL operation (e.g., `@q(&)' at end of invoking command line) driven by scriptedC interactive commands (redirected standard input and/or take files),cF any failed interactive command (such as failed dial or script attempt) causes the fatal error exit.  l  m @section(Interactive Operation)f  \N C-Kermit's interactive command prompt is "@q(C-Kermit>)".  In response to thisJ prompt, you may type any valid command.  C-Kermit executes the command andF then prompts you for another command.  The process continues until you" instruct the program to terminate.  eM Commands begin with a keyword, normally an English verb, such as "send".  You'E may omit trailing characters from any keyword, so long as you specifycL sufficient characters to distinguish it from any other keyword valid in thatO field.  Certain commonly-@|used keywords (such as "send", "receive", "connect")hE also have special non-@|unique abbreviations ("s" for "send", "r" for  "receive", "c" for "connect").  aF Certain characters have special functions during typein of interactive	 commands:c+ @Begin(Description,leftmargin +8,indent -4)uE @q(?)@\Question mark, typed at any point in a command, will produce asL message explaining what is possible or expected at that point.  Depending onM the context, the message may be a brief phrase, a menu of keywords, or a liste	 of files.d  rI @q(ESC)@\(The Escape or Altmode key) -- Request completion of the currentnK keyword or filename, or insertion of a default value.  The result will be ay& beep if the requested operation fails.  lM @q(DEL)@\(The Delete or Rubout key) -- Delete the previous character from thetG command.  You may also use BS (Backspace, Control-H) for this function.l  eF @q(^W)@\(Control-W) -- Erase the rightmost word from the command line.   0 @q(^U)@\(Control-U) -- Erase the entire command.  d5 @q(^R)@\(Control-R) -- Redisplay the current command.n  \H @q(SP)@\(Space) -- Delimits fields (keywords, filenames, numbers) withinB a command.  HT (Horizontal Tab) may also be used for this purpose.   M @q(CR)@\(Carriage Return) -- Enters the command for execution.  LF (Linefeed)e3 or FF (formfeed) may also be used for this purpose.   dI @q(\)@\(Backslash) -- Enter any of the above characters into the command, I literally.  To enter a backslash, type two backslashes in a row (@q[\\]).nK A backslash at the end of a command line causes the next line to be treated H as a continuation line; this is useful for readability in command files,# especially in the 'script' command.b @End(Description) I You may type the editing characters (@q[DEL], @q[^W], etc) repeatedly, to.M delete all the way back to the prompt.  No action will be performed until theeL command is entered by typing carriage return, linefeed, or formfeed.  If youJ make any mistakes, you will receive an informative error message and a newJ prompt -- make liberal use of `@q[?]' and ESC to feel your way through theN commands.  One important command is "help" -- you should use it the first time you run C-Kermit.   iE A command line beginning with a percent sign @qq(%) is ignored.  Such O lines may be used to include illustrative commentary in Kermit command dialogs.p  fD Interactive C-Kermit accepts commands from files as well as from theB keyboard.  When you start C-Kermit, the program looks for the fileI @q(.kermrc) in your home or current directory (first it looks in the home.M directory, then in the current one) and executes any commands it finds there..L These commands must be in interactive format, not Unix command-@|line formatG (the initialization file is @i<not> processed if you invoke Kermit withrH command-@|line action arguments, such that it does not enter interactiveI dialog).  A "take" command is also provided for use at any time during angO interactive session, to allow interactive-format commands to be executed from ar: file; command files may be nested to any reasonable depth.   6 Here is a brief list of C-Kermit interactive commands: @begin(format,spread 0)d1 @tabclear()@tabset(1.5inches,2.0inches,2.5inches)d @>%@\  Comment6 @>!@\  Execute a Unix shell command, or start a shell.6 @>bye@\  Terminate and log out a remote Kermit server. @>close@\  Close a log file.@ @>connect@\  Establish a terminal connection to a remote system." @>cwd@\  Change Working Directory." @>dial@\  Dial a telephone number.+ @>directory@\  Display a directory listing..& @>echo@\  Display arguments literally.8 @>exit@\  Exit from the program, closing any open files.E @>finish@\  Instruct a remote Kermit server to exit, but not log out. / @>get@\  Get files from a remote Kermit server.c5 @>help@\  Display a help message for a given command.eD @>log@\  Open a log file -- debugging, packet, session, transaction. @>quit@\  Same as 'exit'.r0 @>receive@\  Passively wait for files to arrive.E @>remote@\  Issue file management commands to a remote Kermit server.u8 @>script@\  Execute a login script with a remote system. @>send@\  Send files. # @>server@\  Begin server operation.s  @>set@\  Set various parameters.- @>show@\  Display values of 'set' parameters.i, @>space@\  Display current disk space usage.A @>statistics@\  Display statistics about most recent transaction./' @>take@\  Execute commands from a file.d @end(format)  d The 'set' parameters are:n @begin(format,spread 0)y1 @tabclear()@tabset(1.5inches,2.0inches,2.5inches) 1 @>block-check@\  Level of packet error detection. 8 @>delay@\  How long to wait before sending first packet.7 @>duplex@\  Specify which side echoes during 'connect'.eD @>escape-character@\  Prefix for "escape commands" during 'connect'.& @>file@\  Set various file parameters.> @>flow-control@\  Communication line full-duplex flow control.C @>handshake@\  Communication line half-duplex turnaround character.w< @>incomplete@\  Disposition for incompletely received files.) @>line@\  Communication line device name.b= @>modem-dialer@\  Type of modem-dialer on communication line.t0 @>parity@\  Communication line character parity.> @>prompt@\  The C-Kermit program's interactive command prompt., @>receive@\  Parameters for inbound packets.' @>retry@\  Packet retransmission limit.m* @>send@\  Parameters for outbound packets.$ @>speed@\  Communication line speed." @>terminal@\  Terminal parameters. @end(format)  e The 'remote' commands are: @begin(format,spread 0)i1 @tabclear()@tabset(1.5inches,2.0inches,2.5inches)U) @>cwd@\  Change remote working directory.t  @>delete@\  Delete remote files.6 @>directory@\  Display a listing of remote file names., @>help@\  Request help from a remote server.C @>host@\  A command to the remote host in its own command language.a= @>space@\  Display current disk space usage on remote system.n/ @>type@\  Display a remote file on your screen.nB @>who@\  Display who's logged in, or get information about a user. @end(format)  KO Most of these commands are described adequately in the Kermit User Guide or theiK Kermit book.  Special aspects of certain Unix Kermit commands are described  below.    @heading<The 'send' command>  sO Syntax:  @q<send >@i(fn)@q<@ @ - >@i<or>@q< -@ @ >@q<send >@i(fn1)@q< >@i<rfn1>   eM Send the file or files denoted by @i(fn) to the other Kermit, which should besO running as a server, or which should be given the 'receive' command.  Each fileuK is sent under its own name (as described above, or as specified by the 'seteM file names' command).  If the second form of the 'send' command is used, i.e.eM with @i(fn1) denoting a single Unix file, @i(rfn1) may be specified as a namekL to send it under.  The 'send' command may be abbreviated to 's', even thoughB 's' is not a unique abbreviation for a top-level C-Kermit command.  tN The wildcard (meta) characters `@q[*]' and `@q[?]' are accepted in @i(fn).  IfI `@q[?]' is to be included, it must be prefixed by `@q[\]' to override itssO normal function of providing help.  `@q[*]' matches any string, `@q[?]' matches-O any single character.  Other notations for file groups, like `@q([a-z]og)', areaM not available in interactive commands (though of course they are available onaM the command line).  When @i(fn) contains `@q[*]' or `@q[?]' characters, there O is a limit to the number of files that can be matched, which varies from systemeM to system.  If you get the message "Too many files match" then you'll have tot; make a more judicious selection.  If @i(fn) was of the forms( @example(usr/longname/anotherlongname/*)I then C-Kermit's string space will fill up rapidly -- try doing a cwd (seeC9 below) to the path in question and reissuing the command.v  dL @i<Note> -- C-Kermit sends only from the current or specified directory.  ItD does not traverse directory trees.  If the source directory containsK subdirectories, they will be skipped.  By the same token, C-Kermit does noteL create directories when receiving files.  If you have a need to do this, you> can pipe tar through C-Kermit, as shown in the example on page> @pageref(-uxtar), or under System III/V Unix you can use cpio.  aK @i<Another Note> -- The 'send' command does not skip over "invisible" filessO that match the file specification; Unix systems usually treat files whose namessM start with a dot (like @q(.login), @q(.cshrc), and @q(.kermrc)) as invisible.p? Similarly for "temporary" files whose names start with "@q(#)".y  i @heading<The 'receive' command>   s9 Syntax:  @q<receive@ @ - >@i<or>@q< -@ @ receive >@i<fn1>   eM Passively wait for files to arrive from the other Kermit, which must be givenrO the 'send' command -- the 'receive' command does not work in conjunction with aiO server (use 'get' for that).  If @i(fn1) is specified, store the first incomingsG file under that name.  The 'receive' command may be abbreviated to 'r'.   e  o @heading<The 'get' command:>  o Syntax:@q<  get >@i<rfn> @begin(example)l     @i<or>: geta             @i(rfn)i             @i(fn1)^
 @end(example) H Request a remote Kermit server to send the named file or files.  Since aH remote file specification (or list) might contain spaces, which normallyI delimit fields of a C-Kermit command, an alternate form of the command iseK provided to allow the inbound file to be given a new name: type 'get' alone G on a line, and you will be prompted separately for the remote and localo  file specifications, for example @Begin(Example)e C-Kermit>@ux(get) -  Remote file specification: @ux(profile exec)o0  Local name to store it under: @ux(profile.exec)
 @End(Example)hI As with 'receive', if more than one file arrives as a result of the 'get'mH command, only the first will be stored under the alternate name given byN @i(fn1); the remaining files will be stored under their own names if possible.I If a `@q[?]' is to be included in the remote file specification, you must]I prefix it with `@q[\]' to suppress its normal function of providing help.i  bF If you have started a multiline 'get' command, you may escape from itsL lower-@|level prompts by typing a carriage return in response to the prompt, e.g. @Begin(Example)n C-Kermit>@ux(get)l$  Remote file specification: @ux(foo)@  Local name to store it under: @i<(Type a carriage return here)> (cancelled)u	 C-Kermit>i
 @End(Example)u  - @heading(The 'server' command:)n  gO The 'server' command places C-Kermit in "server mode" on the currently selectedsM communication line.  All further commands must arrive as valid Kermit packetssI from the Kermit on the other end of the line.  The Unix Kermit server cant" respond to the following commands:' @begin(format,spread 0,above 1,below 1)r @tabclear()@tabset(2.25inches)! @u<Command>@\@ux<Server Response>    get@\  Sends files   send@\  Receives files#   bye@\  Attempts to log itself outm4   finish@\  Exits to level from which it was invoked,   remote directory@\  Sends directory lising    remote delete@\  Removes files)   remote cwd@\  Changes working directoryc+   remote type@\  Sends files to your screeni.   remote space@\  Reports about its disk usage%   remote who@\  Shows who's logged inm.   remote host@\  Executes a Unix shell command)   remote help@\  Lists these capabilities  @end(format)G The Unix Kermit server cannot always respond properly to a BYE command.bC It will attempt to do so using "@q<kill()>", but this will not work I on all systems or under all conditions because of the complicated processg) structures that can be set up under Unix.o  aC If the Kermit server is directed at an external line (i.e. it is insE "local mode") then the console may be used for other work if you haven8 'set file display off'; normally the program expects theH console to be used to observe file transfers and enter status queries orN interruption commands.  The way to get C-Kermit into background operation fromM interactive command level varies from system to system (e.g. on Berkeley Unix O you would halt the program with @q(^Z) and then use the C-Shell 'bg' command toe7 continue it in the background).  The more common methodeK is to invoke the program with the desired command line arguments, includingn) "@q(-q)", and with a terminating "@q(&)".c  tL When the Unix Kermit server is given a 'remote host' command, it executes itI using the shell invoked upon login, e.g. the Bourne shell or the Berkeley\ C-Shell.  u5 @Heading(The 'remote', 'bye', and 'finish' commands:)s  pE C-Kermit may itself request services from a remote Kermit server.  IncJ addition to 'send' and 'get', the following commands may also be sent from C-Kermit to a Kermit server:  ,+ @begin(description,leftmargin +8,indent -4)nM remote cwd [@i(directory)]@\If the optional remote directory specification is L included, you will be prompted on a separate line for a password, which will not echo as you type it. @end(description)r? @begin(description,leftmargin +28, indent -24,spread 0,above 1) / remote delete rfn@\delete remote file or files.n  t> remote directory [@i(rfn)]@\directory listing of remote files.  nG remote host @i(command)@\command in remote host's own command language.o  e1 remote space@\disk usage report from remote host.d  cB remote type [@i(rfn)]@\display remote file or files on the screen.  tA remote who [@i(user)]@\display information about who's logged in.   e2 remote help@\display remote server's capabilities. @end(description) + @begin(description,leftmargin +8,indent -4)sM bye @i(and) finish:@\When connected to a remote Kermit server, these commandsiM cause the remote server to terminate; 'finish' returns it to Kermit or systemtO command level (depending on the implementation or how the program was invoked);s) 'bye' also requests it to log itself out.g @end(description)e) @heading(The 'log' and 'close' commands:)D  lG Syntax: @q<log {debugging, packets, session, transactions} >[ @i(fn1) ]s  eE C-Kermit's progress may be logged in various ways.  The 'log' commandaG opens a log, the 'close' command closes it.  In addition, all open logs\J are closed by the 'exit' and 'quit' commands.  A name may be specified forF a log file; if the name is omitted, the file is created with a default name as shown below.  l+ @begin(description,leftmargin +4,indent -4)oI log debugging@\This produces a voluminous log of the internal workings of O C-Kermit, of use to Kermit developers or maintainers in tracking down suspected N bugs in the C-Kermit program.  Use of this feature dramatically slows down the. Kermit protocol.  Default name: @q(debug.log).  sL log packets@\This produces a record of all the packets that go in and out ofI the communication port.  This log is of use to Kermit maintainers who areeE tracking down protocol problems in either C-Kermit or any Kermit thate9 C-Kermit is connected to.  Default name:  @q(packet.log).b  pN log session@\This log will contain a copy of everything you see on your screenK during the 'connect' command, except for local messages or interaction witho7 local escape commands.  Default name:  @q(session.log).q  'L log transactions@\The transaction log is a record of all the files that wereK sent or received while transaction logging was in effect.  It includes timeeC stamps and statistics, filename transformations, and records of anysF errors that may have occurred.  The transaction log allows you to haveC long unattended file transfer sessions without fear of missing some.7 vital screen message.  Default name:  @q(transact.log).r @end(description)h@ The 'close' command explicitly closes a log, e.g. 'close debug'.  sM @i<Note:>  Debug and Transaction logs are a compile-time option; C-Kermit mayeI be compiled without these logs, in which case it will run faster, it willnJ take up less space on the disk, and the commands relating to them will not be present.c  () @Heading(Local File Management Commands:)i  iH Unix Kermit allows some degree of local file management from interactive command level:+ @begin(description,leftmargin +4,indent -4)  directory [@i(fn)]@\A Displays a listing of the names, modes, sizes, and dates of filesnH matching @i(fn) (which defaults to `@q[*]').  Equivalent to `@q(ls -l)'.    cwd [directory-name]@\> Changes Kermit's working directory to the one given, or to theN default directory if the directory name is omitted.  This command affects only@ the Kermit process and any processes it may subsequently create.  m space@\f@ Display information about disk space and/or quota in the current directory and device.@  l @q(! )[@i(command)]@\@O The command is executed by the Unix shell.  If no command is specified, then anhN interactive shell is started; exiting from the shell, e.g. by typing Control-DN or 'exit', will return you to C-Kermit command level.  Use the `@q(!)' commandH to provide file management or other functions not explicitly provided byB C-Kermit commands.  The `@q(!)' command has certain peculiarities: @begin(itemize,spread 0)	fA C-Kermit attempts to use your preferred, customary (login) shell.'  m@ At least one space must separate the '!' from the shell command.  >M A 'cd' (change directory) command executed in this manner will have no effect + -- use the C-Kermit 'cwd' command instead.  
 @end(itemize)o @end(description)   d( @heading(The 'set' and 'show' Commands:)  lG Since Kermit is designed to allow diverse systems to communicate, it isiK often necessary to issue special instructions to allow the program to adapt H to peculiarities of the another system or the communication path.  TheseK instructions are accomplished by the 'set' command.  The 'show' command mayiJ be used to display current settings.  Here is a brief synopsis of settings- available in the current release of C-Kermit:s  e+ @begin(description,leftmargin +4,indent -4) K block-check {1, 2, 3}@\ Determines the level of per-packet error detection.oO "1" is a single-@|character 6-bit checksum, folded to include the values of alltK bits from each character.  "2" is a 2-character, 12-bit checksum.  "3" is aqO 3-character, 16-bit cyclic redundancy check (CRC).  The higher the block check,hJ the better the error detection and correction and the higher the resultingF overhead.  Type 1 is most commonly used; it is supported by all KermitN implementations, and it has proven adequate in most circumstances.  Types 2 orL 3 would be used to advantage when transferring 8-bit binary files over noisy lines.  eM delay @i(n)@\How many seconds to wait before sending the first packet after aaL 'send' command.  Used in remote mode to give you time to escape back to your@ local Kermit and issue a 'receive' command.  Normally 5 seconds.  iM duplex {full, half}@\For use during 'connect'.  Specifies which side is doing I the echoing; 'full' means the other side, 'half' means C-Kermit must echof typein itself.   N escape-character @i(cc)@\For use during 'connect' to get C-Kermit's attention.M The escape character acts as a prefix to an 'escape command', for instance to B close the connection and return to C-Kermit or Unix command level.6 The normal escape character is Control-Backslash (28).A The escape character is also used in System III/V implementationse3 to prefix interrupt commands during file transfers.   r& file {display, names, type, warning}@\* Establish various file-related parameters:+ @begin(description,leftmargin +4,indent -4)xN display {on, off}@\Normally 'on'; when in local mode, display progress of fileD transfers on the screen (stdout), and listen to the keyboard (stdin)? for interruptions.  If off (-q on command line) none of this is C done, and the file transfer may proceed in the background obliviousr< to any other work concurrently done at the console terminal.  r names {converted, literal}@\A Normally converted, which means that outbound filenames have path ; specifications stripped, lowercase letters raised to upper,m= tildes and extra periods changed to X's, and an X inserted ine? front of any name that starts with period.  Incoming files haveh< uppercase letters lowered.  Literal means that none of theseB conversions are done; therefore, any directory path appearing in a? received file specification must exist and be write-accessible.lA When literal naming is being used, the sender should not use pathnB names in the file specification unless the same path exists on the target system and is writable.  i @begin<multiple>N type {binary, text} [{7, 8}]@\The file type is normally text, which means that: conversion is done between Unix newline characters and theL carriage-@|return/@|linefeed sequences required by the canonical Kermit fileN transmission format, and in common use on non-@|Unix systems.  Binary means toL transmit file contents without conversion.  Binary (`@q(-i)' in command lineN notation) is necessary for binary files, and desirable in all Unix-@|to-@|Unix% transactions to cut down on overhead.]  fL The optional trailing parameter tells the bytesize for file transfer.  It isN 8 by default.  If you specify 7, the high order bit will be stripped from eachL byte of sent and received files.  This is useful for transferring text filesO that may have extraneous high order bits set in their disk representation (e.g.n* Wordstar or similar word processor files). @end<multiple>  aN warning {on, off}@\Normally off, which means that incoming files will silentlyN overwrite existing files of the same name.  When on (`@q(-w)' on command line)N Kermit will check if an arriving file would overwrite an existing file; if so,N it will construct a new name for the arriving file, of the form @q(foo~)@i(n),O where foo is the name they share and @i(n) is a "generation number"; if @i(foo) M exists, then the new file will be called @q(foo~1).  If @q(foo) and @q(foo~1)oK exist, the new file will be @q(foo~2), and so on.  If the new name would begO longer than the maximum length for a filename, then characters would be deletedtM from the end first, for instance, @q(thelongestname) on a system with a limit:0 of 14 characters would become @q(thelongestn~1). @begin(quotation) K @i(CAUTION:)  If Control-F or Control-B is used to cancel an incoming file, J and a file of the same name previously existed, @i(and) the "file warning"J feature is not enabled, then the previous copy of the file will disappear. @end(quotation)e @end(description)i  dN flow-control {none, xon/xoff}@\Normally xon/xoff for full duplex flow control.O Should be set to 'none' if the other system cannot do xon/xoff flow control, oreG if you have issued a 'set handshake' command.  If set to xon/xoff, theneK handshake should be set to none.  This setting applies during both terminalaK connection and file transfer.  @i<Warning:> This command may have no effectgF on certain Unix systems, where Kermit puts the communication line into. 'rawmode', and rawmode precludes flow control.  oH incomplete {discard, keep}@\Disposition for incompletely received files.F If an incoming file is interrupted or an error occurs during transfer,E the part that was received so far is normally discarded.  If you "setf7 incomplete keep" then such file fragments will be kept.c  aJ handshake {xon, xoff, cr, lf, bell, esc, none}@\Normally none.  Otherwise,O half-duplex communication line turnaround handshaking is done, which means UnixrO Kermit will not reply to a packet until it has received the indicated handshakeiM character or has timed out waiting for it; the handshake setting applies onlyaI during file transfer.  If you set handshake to other than none, then flowo should be set to none.  n line [device-name]@\K The device name for the communication line to be used for file transfer andtH terminal connection, e.g. @q(/dev/ttyi3).  If you specify a device name,H Kermit will be in local mode, and you should remember to issue any otherL necessary 'set' commands, such as 'set speed'.  If you omit the device name,D Kermit will revert to its default mode of operation.  If you specifyJ @q(/dev/tty), Kermit will enter remote mode (useful when logged in throughM the "back port" of a system normally used as a local-mode workstation).  WhennM Unix Kermit enters local mode, it attempts to synchronize with other programsnF (like uucp) that use external communication lines so as to prevent twoM programs using the same line at once; before attempting to lock the specifiedeL line, it will close and unlock any external line that was previously in use.M The method used for locking is the "uucp lock file", explained in more detaili later.   I modem-dialer {direct, hayes, racalvadic, ventel, ...}@\ The type of modemtH dialer on the communication line.  "Direct" indicates either there is noK dialout modem, or that if the line requires carrier detection to open, thenmN 'set line' will hang waiting for an incoming call.  "Hayes", "Ventel", and theG others indicate that 'set line' (or the -l argument) will prepare for a K subsequent 'dial' command for the given dialer.  Support for new dialers isdL added from time to time, so type 'set modem ?' for a list of those supportedB in your copy of Kermit.  See the description of the 'dial' command  nJ parity {even, odd, mark, space, none}@\Specify character parity for use inM packets and terminal connection, normally none.  If other than none, C-KermitnN will seek to use the 8th-bit prefixing mechanism for transferring 8-bit binaryM data, which can be used successfully only if the other Kermit agrees; if not,r5 8-bit binary data cannot be successfully transferred.    L prompt [string]@\The given string will be substituted for "@q(C-Kermit)>" asK this program's prompt.  If the string is omitted, the prompt will revert topL "@q(C-Kermit>)".  If the string is enclosed in doublequotes, the quotes willA be stripped and any leading and trailing blanks will be retained.i  e send @i<parameter>@\J Establish parameters to use when sending packets.  These will be in effectK only for the initial packet sent, since the other Kermit may override thesecG parameters during the protocol parameter exchange (unless noted below). + @begin(description,leftmargin +4,indent -4)oI end-of-packet @i(cc)@\Specifies the control character needed by the otherhN Kermit to recognize the end of a packet.  C-Kermit sends this character at theE end of each packet.  Normally 13 (carriage return), which most KermitaK implementations require.  Other Kermits require no terminator at all, stilly> others may require a different terminator, like linefeed (10).  rM packet-length @i(n)@\Specify the maximum packet length to send.  Normally 90.wM Shorter packet lengths can be useful on noisy lines, or with systems or frontnM ends or networks that have small buffers.  The shorter the packet, the highereL the overhead, but the lower the chance of a packet being corrupted by noise,J and the less time to retransmit corrupted packets.  This command overridesM the value requested by the other Kermit during protocol initiation unless the ' other Kermit requests a shorter length.t  hG pad-character @i(cc)@\Designate a character to send before each packet. D Normally, none is sent.  Outbound padding is sometimes necessary forJ communicating with slow half duplex systems that provide no other means ofH line turnaround control.  It can also be used to send special charactersD to communications equipment that needs to be put in "transparent" orH "no echo" mode, when this can be accomplished in by feeding it a certain control character.   ; padding @i(n)@\How many pad characters to send, normally 0.n  sN start-of-packet @i(cc)@\The normal Kermit packet prefix is Control-A (1); thisG command changes the prefix C-Kermit puts on outbound packets.  The only O reasons this should ever be changed would be: Some piece of equipment somewhereoK between the two Kermit programs will not pass through a Control-A; or, someiK piece of of equipment similarly placed is echoing its input.  In the lattereM case, the recipient of such an echo can change the packet prefix for outboundeI packets to be different from that of arriving packets, so that the echoed M packets will be ignored.  The opposite Kermit must also be told to change them prefix for its inbound packets.i  fH timeout @i(n)@\Specifies the number of seconds you want the other KermitH to wait for a packet before timing it out and requesting retransmission. @end(description)o  u receive @i<parameter>@\eM Establish parameters to request the other Kermit to use when sending packets.a+ @begin(description,leftmargin +4,indent -4) M end-of-packet @i(cc)@\Requests the other Kermit to terminate its packets with{ the specified character.  iK packet-length @i(n)@\Specify the maximum packet length to that you want theeM other Kermit to send, normally 90.  If you specify a length of 95 or greater,eI then it will be used if the other Kermit supports, and agrees to use, thexM Kermit protocol extension for long packets.  In this case, the maximum length(L depends upon the systems involved, but there would normally be no reason forC packets to be more than about 1000 characters in length.  The 'showfK parameters' command displays C-Kermit's current and maximum packet lengths.s   N pad-character @i(cc)@\C-Kermit normally does not need to have incoming packetsJ preceded with pad characters.  This command allows C-Kermit to request theO other Kermit to use @i(cc) as a pad character.  Default @i(cc) is NUL, ASCII 0.   d> padding @i(n)@\How many pad characters to ask for, normally 0.   G start-of-packet @i(cc)@\Change the prefix C-Kermit looks for on inboundv< packets to correspond with what the other Kermit is sending.  mM timeout @i(n)@\Normally, each Kermit partner sets its packet timeout intervaliG based on what the opposite Kermit requests.  This command allows you torO override the normal procedure and specify a timeout interval for Unix Kermit tobN use when waiting for packets from the other Kermit.  If you specify 0, then noN timeouts will occur, and Unix Kermit will wait forever for expected packets to arrive.d @end(description)h  aN speed {0, 110, 150, 300, 600, 1200, 1800, 2400, 4800, 9600}@\The baud rate forK the external communication line.  This command cannot be used to change theeO speed of your own console terminal.  Many Unix systems are set up in such a wayFM that you must give this command after a 'set line' command before you can use 3 the line.  'set baud' is a synomym for 'set speed'.r  sL terminal@\Used for specifying terminal parameters.  Currently, 'bytesize' isM the only parameter provided, and it can be set to 7 or 8.  It's 7 by default.f @end(description)   t @heading(The 'show' Command:)f  e' Syntax: @q<show {parameters, versions}>t  ,E The "show" command with the default argument of "parameters" displays,D the values of all the 'set' parameters described above.  If you typeC "show versions", then C-Kermit will display the version numbers andaF dates of all its internal modules.  You should use the "show versions"H command to ascertain the vintage of your Kermit program before reporting problems to Kermit maintainers.p  t# @heading(The 'statistics' Command:)   aH The statistics command displays information about the most recent KermitG protocol transaction, including file and communication line i/o, timingeH and efficiency, as well as what encoding options were in effect (such as/ 8th-bit prefixing, repeat-@|count compression).w  ,) @heading(The 'take' and 'echo' Commands:)   d Syntax: @q<take >@i<fn1>@** @ @ @ @ @ @q<echo >@i<[text to be echoed]>   H The 'take' command instructs C-Kermit to execute commands from the namedH file.  The file may contain any interactive C-Kermit commands, includingG 'take'; command files may be nested to any reasonable depth, but it may L not contain text to be sent to a remote system during the 'connect' command.) This means that a command file like this:o @begin(example)t set line /dev/tty17  set speed 9600 connectl login myuserid
 mypassword @i<etc>m
 @end(example)aH will not send "login myserid" or any of the following text to the remoteI system.  To carry on a canned dialog, use the 'script' command, describeds later.  /K The '@q(%)' command is useful for including comments in take-command files.b/ It may only be used at the beginning of a line.d  oG The 'echo' command may be used within command files to issue greetings,nN announce progress, ring the terminal bell, etc.  The 'echo' command should notL be confused with the Unix 'echo' command, which can be used to show how metaO characters would be expanded.  The Kermit echo command simply displays its textvK argument (almost) literally at the terminal; the argument may contain octaldM escapes of the form @qq(\ooo), where @q(o) is an octal digit (0-7), and there.N may be 1, 2, or 3 such digits, whose value specify an ASCII character, such asM @qq(\007) (or @qq(\07) or just @qq(\7)) for beep, @qq(\012) for newline, etc.oM Of course, each backslash must be must be entered twice in order for it to be"> passed along to the echo command by the Kermit command parser.  nJ Take-command files are in exactly the same syntax as interactive commands.J Note that this implies that if you want to include special characters likeK question mark or backslash that you would have to quote with backslash whenhI typing interactive commands, you must quote these characters the same waytK in command files.  Long lines may be continued by ending them with a singlee
 backslash.  KH Command files may be used in lieu of command macros, which have not beenG implemented in this version of C-Kermit.  For instance, if you commonlyiG connect to a system called 'B' that is connected to ttyh7 at 4800 baud, < you could create a file called @q(b) containing the commands @begin(example) > % C-Kermit command file to connect to System B thru /dev/ttyh7 set line /dev/ttyh7( set speed 4800 % Beep and give messagen# echo \\007Connecting to System B...r connect 
 @end(example) J and then simply type 'take b' (or 't b' since no other commands begin withC the letter 't') whenever you wish to connect to system B.  Note ther< comment lines and the beep inserted into the 'echo' command.  s @index<IBM>sJ For connecting to IBM mainframes, a number of 'set' commands are required;H these, too, are conveniently collected into a 'take' file like this one: @begin(example)d5 % Sample C-Kermit command file to set up current linee! % for IBM mainframe communicationt %e set parity markk set handshake xona set flow-control noneo set duplex halfm
 @end(example)r   J Note that no single command is available to wipe out all of these settingsL and return C-Kermit to its default startup state; to do that, you can eitherL restart the program, or else make a command file that executes the necessary 'set' commands:e @begin(example)s9 % Sample C-Kermit command file to restore normal settingss %t set parity nonee set handshake none set flow-control xon/xoffe set duplex fullg
 @end(example)o  ,O An implicit 'take' command is executed upon your @q(.kermrc) file when C-Kermit O starts up, upon either interactive or command-line invocation.  The @q(.kermrc) K file should contain 'set' or other commands you want to be in effect at allrN times.  For instance, you might want override the default action when incomingL files have the same names as existing files -- in that case, put the command @example(set file warning on)rJ in your @q(.kermrc) file.  On some non-Unix systems that run C-Kermit, theH initialization file might have a different name, such as @q<kermit.ini>.  hN Errors encountered during execution of take files (such as failure to completeN dial or script operations) cause termination of the current take file, poppingJ to the level that invoked it (take file, interactive level, or the shell).L When kermit is executed in the background, errors during execution of a take file are fatal.n   G Under Unix, you may also use the shell's redirection mechanism to causer) C-Kermit to execute commands from a file:s @example(kermit < cmdfile)6 or you can even pipe commands in from another process: @example(cmdprocess | kermit)e     @heading(The 'connect' Command:)  oG The 'connect' command ('c' is an acceptable non-unique abbreviation foreH 'connect') links your terminal to another computer as if it were a localO terminal to that computer, through the device specified in the most recent 'setnF line' command, or through the default device if your system is a PC orG workstation.  All characters you type at your keyboard are sent out theeM communication line (and if you have 'set duplex half', also displayed on yourhO screen), and all characters arriving at the communication port are displayed on N the screen.  Current settings of speed, parity, duplex, and flow-@|control areI honored, and the data connection is 7 bits wide unless you have given thehO command 'set terminal bytesize 8'.  If you have issued a 'log session' command,9L everything you see on your screen will also be recorded to your session log.J This provides a way to "capture" files from remote systems that don't have Kermit programs available.  tL To get back to your own system, you must type the escape character, which isM Control-@|Backslash (@q[^\]) unless you have changed it with the 'set escape'pI command, followed by a single-@|character command, such as 'c' for "closec2 connection".  Single-@|character commands include:6 @begin(description,leftmargin +8,indent -6,spread 0.4) c@\Close the connectiont    b@\Send a BREAK signal  a 0@\(zero) send a nulla   , s@\Give a status report about the connection  m h@\Hangup the phone    D @q[^\]@\Send Control-Backslash itself (whatever you have defined theC escape character to be, typed twice in a row sends one copy of it).e @end(description)mF Uppercase and control equivalents for (most of) these letters are alsoJ accepted.  A space typed after the escape character is ignored.  Any other character will produce a beep.  rM The connect command simply displays incoming characters on the screen.  It iseL assumed any screen control sequences sent by the host will be handled by theK firmware or emulation software in your terminal or PC.  If special terminalpJ emulation is desired, then the 'connect' command can invoked from the UnixK command line (@q(-c) or @q(-n)), piped through a terminal emulation filter,  e.g.- @example(kermit -l /dev/acu -b 1200 -c | tek)M    @heading(The 'dial' command:)   a, Syntax: @q(dial )@i(telephone-number-string)  l$ @index<Modems>@index<Dialout Modems>K This command controls dialout modems; you should have already issued a "setiI line" and "set speed" command to identify the terminal device, and a "setoL modem" command to identify the type of modem to be used for dialing.  In theN "dial" command, you supply the phone number and the Kermit program feeds it toO the modem in the appropriate format and then interprets dialer return codes and @ modem signals to inform you whether the call was completed.  TheN telephone-@|number-@|string may contain imbedded modem-@|dialer commands, suchM as comma for Hayes pause, or `@q(&)' for Ventel dialtone wait and `@q(%)' fora5 Ventel pause (consult your modem manual for details).   bJ At the time of this writing, support is included for the following modems: @begin(itemize,spread 0) Cermetek Info-Mate 212Ah  o DEC DF03-ACm    DEC DF100 Series    DEC DF200 Series  m General DataComm 212A/ED   % Hayes Smartmodem 1200 and compatiblesg  t Penril  n Racal Vadic     US Robotics 212A  p Ventel
 @end(itemize))E Support for new modems is added to the program from time to time; you 7 can check the current list by typing "@q<set modem ?>".   hK The device used for dialing out is the one selected in the most recent "set M line" command (or on a workstation, the default line if no "set line" commandmM was given).  The "dial" command calls locks the path (see the section on linetN locking below) and establishes a call on an exclusive basis.  If it is desiredL to dial a call and then return to the shell (such as to do kermit activitiesN depending on standard in/out redirection), it is necessary to place the dialedN call under one device name (say, "@q</dev/cua0>") and then escape to the shellK @i<within Kermit> on a linked device which is separate from the dialed line)J (say, "@q</dev/cul0>").  This is the same technique used by uucp (to allow: locks to be placed separately for dialing and conversing).  dO Because modem dialers have strict requirements to override the carrier-@|detecthO signal most Unix implementations expect, the sequence for dialing is more rigide$ than most other C-Kermit procedures.  o Example one: @begin(example)a  @ux<kermit -l /dev/cul0 -b 1200>A C-Kermit>@ux<set modem-dialer hayes>	@i(hint: abbreviate) set m h; C-Kermit>@ux<dial 9,5551212>
 Connected!. C-Kermit>@ux<connect>			@i(hint: abbreviate) c& @i(logon, request remote server, etc.) @ux<^\c>				@i(escape back)e
 C-Kermit> ...h+ C-Kermit>@ux<quit>			@i(hint: abbreviate) qu
 @end(example) ) this disconnects modem, and unlocks line.s  e Example two: @begin(example)n
 @u(kermit)% C-Kermit>@ux(set modem-dialer ventel)   C-Kermit>@ux(set line /dev/cul0) C-Kermit>@ux(dial 9&5551212%)f
 Connected!
 C-Kermit> ...e
 @end(example)r Example three: @begin(example)i kermit$ C-Kermit>@ux(take my-dial-procedure)
 Connected!  u @i(file my-dial-procedure):  set modem hayes  set line /dev/tty99w dial 5551212 connecte
 @end(example)mN In general, C-Kermit requires that the modem provide the "carrier detect" (CD)G signal when a call is in progress, and remove that signal when the call M completes or the line drops.  If a modem switch setting is available to forcesO CD, it should normally not be in that setting.  C-Kermit also requires (on mosttH systems) that the modem track the computer's "data terminal ready" (DTR)M signal.  If a switch setting is available to simulate DTR asserted within theeK modem, then it should normally not be in that setting.  Otherwise the modemaN will be unable to hang up at the end of a call or when interrupts are received
 by Kermit.  lO For Hayes @index<Hayes Modem> dialers, two important switch settings are #1 andnN #6.  Switch #1 should be normally be UP so that the modem can act according toO your computer's DTR signal.  But if your computer, or particular implementationsN of Kermit, cannot control DTR, then switch 1 should be DOWN.  Switch #6 shouldM normally be UP so carrier-@|detect functions properly (but put it DOWN if younM have trouble with the UP position).  Switches #2 (English versus digit resultiF codes) and #4 (Hayes echoes modem commands) may be in either position.  dJ If you want to interrupt a dial command in progress (for instance, becauseH you just realize that you gave it the wrong number), type a Control-C to get back to command level.    @heading(The 'script' Command:)i  t6 Syntax: @q(script )@i(expect send [expect send] . . .)  eD "expect" has the syntax: @i(expect[-send-expect[-send-expect[...]]])  aJ The 'script' command carries on a "canned dialog" with a remote system, inO which data is sent according to the remote system's responses.  The typical use)3 is for logging in to a remote system automatically.i  oH C-Kermit's script facility operates in a manner similar to that commonlyI used by the Unix UUCP system's "@q(L.sys)" file entries.  A login script   is a sequence of the form:- @example(@i<expect send [expect send] . . .>)aL where @i(expect) is a prompt or message to be issued by the remote site, andG @i(send) is the string (names, numbers, etc) to return, and expects areKN separated from sends by spaces.  The send may also be the keyword EOT, to sendN Control-D, or BREAK, to send a break signal.  Letters in sends may be prefixed1 by `@q[~]' to send special characters, including:i4 @begin(description,leftmargin +8,indent -4,spread 0) @q(~b)@\backspacef  ,
 @q(~s)@\spacev   8 @q(~q)@\`@q[?]'(trapped by Kermit's command interpreter)  r @q(~n)@\linefeed  o @q(~r)@\carriage returnn    @q(~t)@\tab     @q(~')@\single quote  r
 @q(~~)@\tildea  m @q(~")@\double quote  x @q(~x)@\XON (Control-Q)e   & @q(~c)@\don't append a carriage return   & @q(~)@i(o[o[o]])@ @ an octal character  a+ @q(~d)@\delay approx 1/3 second during send'  nH @q(~w)@i([d[d]])@ @ wait specified interval during expect, then time out @end(description) O As with some UUCP systems, sent strings are followed by @q(~r) unless they havel	 a @q(~c).m  eJ Only the last 7 characters in each expect are matched.  A null @i(expect),J e.g. @q(~0) or two adjacent dashes, causes a short delay before proceeding: to the next send sequence.  A null expect always succeeds.  oF As with UUCP, if the expect string does not arrive, the script attemptF fails.  If you expect that a sequence might not arrive, as with UUCP, 3 conditional sequences may be expressed in the form: - @example(@i<-send-expect[-send-expect[...]]>)eE where dashed sequences are followed as long as previous expects fail.tB Timeouts for expects can be specified using @q(~w); @q(~w) with no arguments waits 15 seconds.s  eA @i(Expect/send) transactions can be easily be debugged by loggingoD transactions.  This records all exchanges, both expected and actual.G The script execution will also be logged in the session log, if that isc
 activated.   G Note that `@q[\]' characters in login scripts, as in any other C-Kermit E interactive commands, must be doubled up.  A line may be ended with a'  single `@q[\]' for continuation.  c Example one:   I Using a modem, dial a UNIX host site.  Expect "login" (...gin), and if ittD doesn't come, simply send a null string with a @q(~r).  (Some UnixesH require either an EOT or a BREAK instead of the null sequence, dependingD on the particular site's "logger" program.)  After providing user idF and password, respond "x" to a question-mark prompt, expect the BourneH shell "@q($)" prompt (and send return if it doesn't arrive).  Then cd toC directory kermit, and run the program called "wermit", entering ther1 interactive connect state after wermit is loaded.e @begin(example)  set modem ventel set line /dev/tty77g
 set baud 1200t dial 9&5551212: script gin:--gin:--gin: smith ssword: mysecret ~q x $--$ \  cd~skermit $ wermit connecto
 @end(example)tD Note that 'set line' is issued @i<after> 'set modem', but @i<before>. 'set baud' or other line-@|related parameters.    Example two:  e @index(TELENET))L Using a modem, dial the Telenet network.  This network expects three returnsM with slight delays between them.  These are sent following null expects.  The O single return is here sent as a null string, with a return appended by default.aI Four returns are sent to be safe before looking for the prompt.  Then thenN Telenet id and password are entered.  Then Telenet is instructed to connect toL a host site (c 12345).  The host has a data switch that asks "which system";N the script responds "myhost" (if the "which system" prompt doesn't appear, theM Telenet connect command is reissued).  The script waits for an @qq"@@" promptnL from the host, then sends the user ID ("joe") and password ("secret"), looksO for another @qq<@@> prompt, runs Kermit, and in response to the Kermit's prompteJ (which ends in @qq[>]), gives the commands "set parity even" and "server".D Files are then exchanged.  The commands are in a take file; note theI continuation of the 'script' command onto several lines using the `@q[\]'m terminator.e @begin(example)F set modem hayesF set line /dev/acu  set speed 1200 set parity markm dial 9,5551212D script ~0 ~0 ~0 ~0 ~0 ~0 ~0 ~0 @@--@@--@@ id~saa001122 = 002211 @@ \C     c~s12345 ystem-c~s12345-ystem myhost @@ joe~ssecret @@ kermit \s      > set~sparity~seven > server send some.stuffa get some.otherstuffi bye  quit
 @end(example)?D Since these commands may be executed totally in the background, theyH can also be scheduled.  A typical shell script, which might be scheduled9 by cron, would be as follows (csh used for this example):l  o @begin(example)  # @ #keep trying to dial and log onto remote host and exchange files8 #wait 10 minutes before retrying if dial or script fail. #  cd someplace while ( 1 )o.         kermit < /tonight.cmd >> nightly.log &         if ( ! $status ) break         sleep 600  endu
 @end(example) I File @q(tonight.cmd) might have two takes in it, for example, one to take D a file with the set modem, set line, set baud, dial, and script, andE a second take of a file with send/get commands for the remote server. = The last lines of @q(tonight.cmd) should be a bye and a quit.s  o @heading(The 'help' Command:)m  s @begin(example,leftmargin 0) @r(Syntax:) help @ @ @ @i(or): help @i(keyword), @ @ @ @i(or): help {set, remote} @i(keyword)
 @end(example)t  oH Brief help messages or menus are always available at interactive commandK level by typing a question mark at any point.  A slightly more verbose formeI of help is available through the 'help' command.  The 'help' command witheG no arguments prints a brief summary of how to enter commands and how toaJ get further help.  'help' may be followed by one of the top-level C-KermitI command keywords, such as 'send', to request information about a command.nK Commands such as 'set' and 'remote' have a further level of help.  Thus yousF may type 'help', 'help set', or 'help set parity'; each will provide a) successively more detailed level of help.g  e  p) @heading(The 'exit' and 'quit' Commands:)c  rA These two commands are identical.  Both of them do the following:     @begin(itemize,spread 0): Attempt to insure that the terminal is returned to normal.  hD Relinquish access to any communication line assigned via 'set line'.  pC Relinquish any uucp and multiuser locks on the communications line.   pK Hang up the modem, if the communications line supports data terminal ready.n  b# Close any open logs or other files.u
 @end(itemize) I After exit from C-Kermit, your default directory will be the same as wheniJ you started the program.  The 'exit' command is issued implicitly wheneverO C-Kermit halts normally, e.g. after a command line invocation, or after certaini kinds of interruptions.t  e @section(UUCP Lock Files)r  tE Unix has no standard way of obtaining exclusive access to an externaltO communication line.  When you issue the 'set line' command to Unix Kermit, Unix I would normally grant you access to the line even if some other process is I making use of it.  The method adopted by most Unix systems to handle this,L situation is the "UUCP lock file".  UUCP, the Unix-@|to-@|Unix Copy program,M creates a file in its directory (usually @q(/usr/spool/uucp), on some systemssI @q</etc/locks>) with a name like @q(LCK..)@i(name), where @i(name) is theh$ device name, for instance @q(tty07).  tG Unix Kermit uses UUCP lock files in order to avoid conflicts with UUCP,cI tip, or other programs that follow this convention.  Whenever you attempttJ to access an external line using the 'set line' command or `@q(-l)' on the command line, Kermit looksH in the UUCP directory for a lock file corresponding to that device.  ForE instance, if you 'set line /dev/ttyi6' then Kermit looks for the filec$ @example(/usr/spool/uucp/LCK..ttyi6)D If it finds this file, it gives you an error message and a directory= listing of the file so that you can see who is using it, e.g.y @begin(example)sB -r--r--r--  1 fdc        4 May  7 13:02 /usr/spool/uucp/LCK..ttyi6
 @end(example)CF In this case, you would look up user fdc to find out how soon the line will become free.e  <E This convention requires that the uucp directory be publicly readablesJ and writable.  If it is not, the program will issue an appropriate warningH message, but will allow you to proceed at your own risk (and the risk of3 anyone else who might also be using the same line).-  oN If no lock file is found, Unix Kermit will attempt create one, thus preventingN anyone who subsequently tries to run Kermit, UUCP, tip, or similar programs onN the same line from gaining access until you release the line.  If Kermit couldD not create the lock file (for instance because the uucp directory isO write-@|protected), then you will receive a warning message but will be allowed J to proceed at your -- and everyone else's -- risk.  When Kermit terminates$ normally, your lock file is removed.  ]L Even when the lock directory is writable and readable, the locking mechanismL depends upon all users using the same name for the same device.  If a deviceM has more than one path associated with it, then a lock can be circumvented by) using an alias.l   N When a lock-@|creating program abruptly terminates, e.g. because it crashes orI is killed via shell command, the lock file remains in the uucp directory,rL spuriously indicating that the line is in use.  If the lock file is owned byL yourself, you may remove it.  Otherwise, you'll have to get the owner or theJ system manager to remove it, or else wait for a system task to do so; uucpM supports a function (uuclean) which removes these files after a predetermined.E age -- uucp sites tend to run this function periodically via crontab.   lG Locking is not needed, or used, if communications occur over the user'sr, login terminal line (normally @q[/dev/tty]).  rO It may be seen that line locking is fraught with peril.  It is included in Unix K Kermit only because other Unix communication programs rely on it.  While itdG is naturally desirable to assure exclusive access to a line, it is alsocM undesirable to refuse access to a vacant line only because of a spurious lock C file, or because the uucp directory is not appropriately protected.t  .7 @section(C-Kermit under Berkeley or System III/V Unix:)i   N C-Kermit may be interrupted at command level or during file transfer by typingL Control-C.  The program will perform its normal exit function, restoring theO terminal and releasing any lock.  If a protocol transaction was in progress, aniI error packet will be sent to the opposite Kermit so that it can terminate  cleanly.   K C-Kermit may be invoked in the background ("@q(&)" on shell commmand line). C If a background process is "killed", the user will have to manuallyvI remove any lock file and may need to restore the modem.  This is because l@ the kill signal (@q<kill(@i[x],9)>) cannot be trapped by Kermit.  gO During execution of a system command ('directory', 'cwd', or `@q(!)'), C-KermitdK can often be returned to command level by typing a single Control-C.  (WithrM System III/V, the usual interrupt function (often the DEL key) is replaced byx Control-C.)    O Under Berkeley Unix only: C-Kermit may also be interrupted by @q(^Z) to put thehK process in the background.  In this case the terminal is not restored.  YourM will have to type Control-J followed by "reset" followed by another Control-Jr$ to get your terminal back to normal.   J Control-C, Control-Z, and Control-@q(\) lose their normal functions duringJ terminal connection and also during file transfer when the controlling tty" line is being used for packet i/o.  cC If you are running C-Kermit in "quiet mode" in the foreground, thentI interrupting the program with a console interrupt like Control-C will notpI restore the terminal to normal conversational operation.  This is because"K the system call to enable console interrupt traps will cause the program tomI block if it's running in the background, and the primary reason for quietaJ mode is to allow the program to run in the background without blocking, so- that you can do other work in the foreground.t  eG If C-Kermit is run in the background ("&" on shell commmand line), then C the interrupt signal (Control-C) (and System III/V quit signal) are5E ignored.  This prevents an interrupt signal intended for a foreground J job (say a compilation) from being trapped by a background Kermit session.     e> @section(C-Kermit on the DEC Pro-3xx with Pro/Venix Version 1)  yN The DEC Professional 300 series are PDP-11/23 based personal computers.  VenixH Version 1 is a Unix v7 derivative.  It should not be confused with VenixH Version 2, which is based on ATT System V; these comments apply to VenixL Version 1 only.  C-Kermit runs in local mode on the Pro-3@i(xx) when invokedN from the console; the default device is @q(/dev/com1.dout).  When connected toK a remote system (using C-Kermit's 'connect' command), Pro/Venix itself (not L Kermit) provides VT52 terminal emulation.  Terminal operation at high speedsO (like 9600 baud) requires xon/xoff flow control, which unfortunately interfereshG with applications such as the EMACS that use Control-Q and Control-S asa	 commands.s  /J When logging in to a Pro-3xx (or any workstation) through the "back port",K it may be necessary to give the command "set line /dev/tty" in order to getpG C-Kermit to function correctly in remote mode (on a system in which it  0 normally expects to be operating in local mode).  t  @section(C-Kermit under VAX/VMS)  eC C-Kermit can be built using VAX-11 C to run under VMS.  Most of themM descriptions in this manual hold true, but it should be noted that as of thistI writing the VMS support is not thoroughly tested, and no explicit supportu? exists for the various types of VMS files and their attributes.e   8 The C-Kermit init file for VMS is called @q<KERMIT.INI>.  w  s5 @section(C-Kermit on the Macintosh and other Systems)d   N The "protocol kernel" of C-Kermit is also used by Columbia's Macintosh Kermit.H The user and system interface is entirely different, and is covered in a separate document.  lI There is also a Kermit for the Commodore Amiga based on C-Kermit, as wells< as versions for MS-DOS, Data General operating systems, etc.   . @section(C-Kermit Restrictions and Known Bugs)  t @begin(enumerate)r @ux(Editing characters):L The program's interactive command interrupt, delete, and kill characters areH Control-C, Delete (or Backspace), and Control-U, respectively.  There isI currently no way to change them to suit your taste or match those used bys( your shell, in case those are different.  e @ux(Flow control):J C-Kermit attempts to use XON/XOFF flow control during protocol operations,I but it also puts the communication line into "rawmode".  On many systems,nO rawmode disables flow control, so even though you may have "set flow xon/xoff",uE no flow control will be done.  This is highly system and Unix-versiono
 dependent.  l @ux(High baud rates):rF There's no way to specify baud rates higher than 9600 baud.  Most UnixK systems don't supply symbols for them (unless you use EXTA, EXTB), and evenrI when they do, the program has no way of knowing whether a specific port's + serial i/o controller supports those rates.e    @ux(Modem controls):E If a connection is made over a communication line (rather than on theoH controlling terminal line), and that line has modem controls, (e.g. dataL terminal ready and carrier detection implementation), returning to the shellE level will disconnect the conversation.  In that case, one should use,I interactive mode commands, and avoid use of piped shell-@|level operationa2 (also see 'set modem-dialer' and 'dial' commands.)  `E @ux(Login Scripts):  The present login scripts implementation follows G the Unix conventions of uucp's "@q(L.sys)" file, rather than the normal/ Kermit "INPUT/@|OUTPUT" style.  e. @ux(Dial-out vs dial-in communications lines):I C-Kermit requires a dial-out or dedicated line for the "set line" or "-l" N options.  Most systems have some lines dedicated to dial-in, which they enableH "loggers" on, and some lines available for dial-out.  Recent releases ofJ Unix (ATT & Berkeley) have mechanisms for changing the directionality of a line.c    @begin(multiple)+ @ux(Using C-Kermit on Local Area Networks): F C-Kermit can successfully operate at speeds up to 9600 baud over LANs,J provided the network buffers are big enough to accommodate Kermit packets.   C When computers are connected to LAN's through asynchronous terminal-H interfaces, then the connection should be configured to do XON/XOFF flowK control between the network interface and the computer, rather than passingrG these signals through transparently.  This can help prevent Kermit fromeM overrunning the LAN's buffers if they are small (or if the LAN is congested),eK and will can also prevent the LAN from overrunning a slow Kermit's buffers.l   H If the network hardware cannot accept 100 characters at a time, and flowJ control cannot be done between the network and the computer, then Kermit'sL "set send/receive packet-length" command can be used to shorten the packets. @end(multiple)  eI @ux(Resetting terminal after abnormal termination or kill): When C-Kermiti2 terminates abnormally (say, for example, by a killN command issued by the operator) the user may need to reset the terminal state.? If commands do not seem to be accepted at the shell prompt, tryh? Control-J "stty sane" Control-J (use "reset" on Berkeley Unix)..F That should take the terminal out of "raw mode" if it was stuck there.  u; @ux(Remote host commands may time-out on lengthy activity):,B Using "remote host" to instruct the C-Kermit server to invoke UnixO functions (like "make") that might take a long time to produce output can caused timeout conditions.   i @ux(XOFF deadlocks):H When connecting back to C-Kermit after a transaction, or after finishingG the server, it may be necessary to type a Control-Q to clear up an XOFFa< deadlock.  There's not much the program can do about this... @end(enumerate)a   1 @section(How to Build C-Kermit for a Unix System)e  dK The C-Kermit files, as distributed from Columbia, all begin with the prefixnH "ck".  You should make a directory for these files and then cd to it.  AJ makefile is provided to build C-Kermit for various Unix systems (there areL separate makefiles for VMS and the Macintosh).  As distributed, the makefileO has the name "@q(ckuker.mak)".  You should rename it to "@q(makefile)" and then L type "make xxx", where xxx is the symbol for your system, for instance "makeL bsd" to make C-Kermit for 4.x BSD Unix.  The result will be a program calledO "wermit".  You should test this to make sure it works; if it does, then you caneM rename it to "kermit" and install it for general use.  See the makefile for abE list of the systems supported and the corresponding "make" arguments.a  l, @section(Adapting C-Kermit to Other Systems)   L C-Kermit is designed for portability.  The level of portability is indicatedG in parentheses after the module name: "C" means any system that has a C'L compiler that conforms to the description in "The C Programming Language" byF Kernighan & Ritchie (Prentice-Hall, 1978).  "Cf" is like "C", but alsoJ requires "standard" features like printf and fprintf, argument passing viaL argv/argc, and so on, as described in Kernighan & Ritchie.  "Unix" means theK module should be useful under any Unix implementation; it requires featureslL such as fork() and pipes.  Anything else means that the module is particular> to the indicated system.  C-Kermit file names are of the form:  a' @q[ck<@i(system)><@i(what)>.<@i(type)>]n  lI where the part before the dot is no more than 6 characters long, the partc2 after the dot no more than 3 characters long, and:  e  @q[<@i(type)>] is the file type:4 @begin(description,leftmargin +8,indent -6,spread 0) c:@\C language source    % h:@\Header file for C language sourcet  .G w:@\Wart preprocessor source, converted by Wart (or Lex) to a C programl  u& nr:@\Nroff/Troff text formatter source  n" mss:@\Scribe text formatter source    doc:@\Documentationo  l hlp:@\Help text    + bld:@\Instructions for building the programy  c* bwr:@\A "beware" file - list of known bugs  K upd:@\Program update log  d mak:@\Makefile @end(description)   hO @q[<@i(system)>] is a single character to tell what system the file applies to:s4 @begin(description,leftmargin +8,indent -6,spread 0)' a:@\Descriptive material, documentationa  d  c:@\All systems with C compilers    d:@\Data General    h:@\Harris computers (reserved)   s i:@\Commodore Amiga (Intuition)3  s
 m:@\Macintosh1    p:@\IBM PC, PC-DOS (reserved)x  e u:@\Unix  U v:@\VAX/VMSt  . w:@\Wart @end(description)i  VG @q[<@i(what)>] is mnemonic (up to 3 characters) for what's in the file:V4 @begin(description,leftmargin +8,indent -6,spread 0)% aaa:@\A "read-me" file, like this onec  o cmd:@\Command parsingi  q con:@\Connect command   n- deb:@\Debug/Transaction Log formats, Typedefsn  t dia:@\Modem/Dialer control  o  fio:@\System-depdendent File I/O  u  fns:@\Protocol support functions  p% fn2:@\More protocol support functionsf  o> ker:@\General C-Kermit definitions, information, documentation  a mai:@\Main program  n pro:@\Protocol  S scr:@\Script command  nC tio:@\System-dependent terminal i/o & control and interrupt handing,  t usr:@\User interface    us2:@\More user interfacet    us3:@\Still more user interfacec @end(description)e  e	 Examples:   t @begin(description,spread 0) @q(ckufio.c)@\File i/o for Unixe   ( @q(ckmtio.c)@\Terminal i/o for Macintosh  e? @q(ckuker.mss)@\Scribe source for for Kermit User Guide chapter   c; @q(ckuker.nr)@\Nroff source file for Unix C-Kermit man paget @end(description)n  hF The following material discusses each of the C-Kermit modules briefly., @begin(description,leftmargin +4, indent -4)N @q<ckcmai.c, ckcker.h, ckcdeb.h (Cf)>:@\This is the main program.  It contains& declarations for global variables and J a small amount of code to initialize some variables and invoke the commandL parser.  In its distributed form, it assumes that command line arguments areK passed to it via argc and argv.  Since this portion of code is only severaleH lines long, it should be easy to replace for systems that have differentL styles of user interaction.  The header files define symbols and macros usedI by the various modules of C-Kermit.  @q(ckcdeb.h) is the only header fileeI that is included by all the C-Kermit modules, so it contains not only thetE debug format definitions, but also any compiler-@|dependent typedefs.w  tG @q<ckwart.c (Cf), ckcpro.w (C)>:@\The ckcpro module embodies the KermitcO protocol state table and the code to accomplish state switching.  It is writtenFI in "wart", a language which may be regarded as a subset of the Unix "lex"iN lexical analyzer generator.  Wart implements enough of lex to allow the ckprotG module to function.  Lex itself was not used because it is proprietary.e7 The protocol module @q(ckcpro.w) is read by wart, and alL system-@|independent C program is produced.  The syntax of a Wart program is@ illustrated by @q(ckcpro.w), and is described in @q(ckwart.doc).   F @q<ckcfns.c (C)>:@\The module contains all the Kermit protocol supportK functions -- packet formation, encoding, decoding, block check calculation, N filename and data conversion, protocol parameter negotiation, and high-@|levelN interaction with the communication line and file system.  To accommodate smallN systems, this module has been split into two -- @q(ckcfns.c) and @q(ckcfn2.c).  sI @q(ckutio.c):@\This module contains the system-@|dependent primitives for,J communication line i/o, timers, and interrupts for the various versions ofN Unix.  Certain important variables are defined in this module, which determineN whether C-Kermit is by default remote or local, what the default communicationN device is, and so forth.  The tio module maintains its own private database ofI file descriptors and modes for the console terminal and the file transfertM communication line so that other modules (like ckcfns or the terminal connecteC module) need not be concerned with them.  The variations among UnixeL implementations with respect to terminal control and timers are accommodated via conditional compilation.  cM @q(ckufio.c):@\This module contains system-dependent primitives for file i/o,NL wildcard (meta character) expansion, file existence and access checking, andK system command execution for the various versions of Unix.  It maintains antN internal database of i/o "channels" (file pointers in this case) for the filesJ C-Kermit cares about -- the input file (the file which is being sent), theK output file (the file being received), the various logs, the screen, and sosK forth.  This module varies little among Unix implementations except for thenL wildcard expansion code; the directory structure of 4.2bsd Unix is differentH from that of other Unix systems.  Again, variation among Unix systems is' selected using conditional compilation.0  h @begin(multiple)E @q(ckuusr.h, ckuusr.c, ckuus2.c, ckuus3.c) (Unix):@\This is the "user,9 interface" for C-Kermit.  It includes the command parser,nF the screen output functions, and console input functions.  The commandG parser comes in two pieces -- the traditional Unix command line decoderrF (which is quite small and compact), and the interactive keyword parserK (which is rather large).  This module is fully replacable; its interface toeJ the other modules is very simple, and is explained at the beginning of theJ source file.  The ckuusr module also includes code to execute any commandsJ directly which don't require the Kermit protocol -- local file management,G etc.  The module is rated "Unix" because it makes occasional use of thex @q[system()] function.  hM Note that while @q(ckuusr) is logically one module, it has been split up intoiN three C source files, plus a header file for the symbols they share in common.D This is to accommodate small systems that cannot handle big modules.M @q(ckuusr.c) has the command line and top-@|level interactive command parser;.E @q(ckuus2.c) has the help command and strings; @q(ckuus3) has the settN and remote commands along with the logging, screen, and "interrupt" functions. @end(multiple)  sL @q(ckucmd.c, ckucmd.h) (Cf):@\This is an interactive command parsing packageJ developed for C-Kermit.  It is written portably enough to be usable on anyK system that has a C compiler that supports functions like printf.  The fileqK name parsing functions depend upon primitives defined in the fio module; ifxK these primitives cannot be supplied for a certain system, then the filenameeJ parsing functions can be deleted, and the package will still be useful forN parsing keywords, numbers, arbitrary text strings, and so forth.  The style of: interaction is the same as that found on the DECSYSTEM-20.   I @q(ckucon.c) (Unix):@\This is the connect module.  As supplied, it shouldsM operate in any Unix environment, or any C-based environment that provides thefM fork() function.  The module requires access to global variables that specifyeM line speed, parity, duplex, flow control, etc, and invokes functions from the M tio module to accomplish the desired settings and input/output, and functionsaI from the fio module to perform session logging.  No terminal emulation isrL performed, but since standard i/o is used for the console, this may be pipedI through a terminal emulation filter.  The ckucon function may be entirelynL replaced, so long as the global settings are honored by its replacement.  PCO implementations of C-Kermit may require the ck?con module to do screen control, O escape sequence interpretation, etc, and may also wish to write special code toh" get the best possible performance.   I @q(ckudia.c) (Unix):@\This is the dialer module.  As supplied, it handlesn= Hayes, Ventel, Penril, Racal-Vadic, and several other modems.f  rO @q(ckuscr.c) (Unix):@\This is the login script module.  As supplied, it handlesg uucp-@|style scripts.  @end(description)r   ( Moving C-Kermit to a new system entails: @begin(enumerate)oI Creating a new @q<ck?tio> module in C, assembler, or whatever language is\I most appropriate for system programming on the new system.  If the systemhM is Unix-like, then support may be added within the @q<ckutio.c> module itselfp using conditional compilation.  d+ Creating a new @q<ck?fio> module, as above.e  aM If the system is not Unix-like, then a new @q<ckuusr> module may be required, 8 as well as a different invocation of it from @q<ckcmai>.  oG If the distributed connect module doesn't work or performs poorly, thenaJ it may be replaced.  For instance, interrupt-@|driven i/o may be required,, especially if the system doesn't have forks. @end(enumerate) G Those who favor a different style of user/program interaction from thatmM provided in @q(ckuusr.c) may replace the entire module, for instance with oneiJ that provides a mouse/@|window/@|icon environment, a menu/@|function-@|key environment, etc.q  o< A few guidelines should be followed to maintain portability: @begin(itemize)iD Keep variable and function names to 6 characters or less.  Don't useF identifiers that are distinguished from one another only by alphabetic case.   :F Keep modules small.  For instance, on a PDP-11 it is necessary to keepF the code segment of each module below 8K in order to allow the segmentH mapping to occur which is necessary to run programs larger than 64K on a non-@|I-and-D-@|space machine.  eH Keep strings short; many compilers have restrictive maximum lengths; 128H is the smallest maximum string constant length we've encountered so far.   H Keep (f,s)printf formats short.  If these exceed some compiler dependentK maximum (say, 128) memory will be overwritten and the program will probablyf
 core dump.  tG Do not introduce system dependencies into @q(ckcpro.w) or @q(ckcfn*.c).   tF If a variable is a character, declare as CHAR, not int, to prevent theK various sign extension and byte swapping foulups that occur when characterst  are placed in integer variables.  eL Remember that different systems may use different length words for different? things.  Don't assume an integer can be used as a pointer, etc.i  aJ Don't declare static functions; these can wreak havoc with systems that do segment mapping.   K In conditional compilations expressions, use @q(#ifdef) and @q(#ifndef) and K not @q(#if), which is not supported by some compilers.  Also, don't use anyrF operators in these expressions; many compilers will fail to understandK expressions like @w<@q(#ifdef FOO | BAR)>.  Also, don't put trailing tokenso< on @q<#else>'s or @q<#endif>'s (use @q</*> comments @q<*/>).  t Don't define multiline macros.
 @End(Itemize)mH In general, remember that this program will have to be compilable by old( compilers and runnable on small systems.