2 char *dialv = "Dial Command, V2.0(009) 14 Sep 87";   G /*  C K U D I A  --  Dialing program for connection to remote system */     /*)  Author: Herm Fischer (HFISCHER@USC-ECLB) >  Contributed to Columbia University for inclusion in C-Kermit.H  Copyright (C) 1985, Herman Fischer, 16400 Ventura Blvd, Encino CA 91436H  Permission is granted to any individual or institution to use, copy, orO  redistribute this software so long as it is not sold for profit, provided this   copyright notice is retained.       ------    I  This module should work under all versions of Unix.  It calls externally J  defined system-depended functions for i/o, but depends upon the existence$  of various modem control functions.   H  This module, and the supporting routines in the ckutio.c module, assumeI  that the computer and modem properly utilize the following data communi- E  cations signals (that means one should prepare the modem to use, not   circumvent, these signals):   B      Data Terminal Ready:  This signal is asserted by the computerA      when Kermit is about to ask the modem to dial a call, and is A      removed when Kermit wishes to have the modem hang up a call. A      The signal is asserted both while Kermit is asking the modem B      to dial a specific number, and after connection, while Kermit"      is in a data exchange mode.     D      Carrier detect:  This signal must be asserted by the modem whenB      a carrier is detected from a remote modem on a communications?      circuit.  It must be removed by the modem when the circuit A      disconnects or is hung up.  (Carrier detect is ignored while B      Kermit is asking the modem to dial the call, because there is@      no consistant usage of this signal during the dialing phase*      among different modem manufacturers.)    */    /*  * Modifications:   *?  *	21-Jul-85	Fixed failure returns hanging on no carrier signal 3  *			Requires tthang change too (ckutio.c revision)   *							-- Herm Fischer  *@  *	28-Jun-85	Fixed bug with defaulting the modem-failure message
  *			in lbuf.   *							-- Dan Schullman   *:  *	27-Jun-85	Merged in code from Joe Orost at Berkeley for5  *			supporting the US Robotics modem, which included 2  *			changing the single characters in MDMINF into3  *			multi-character strings and modifying waitFor.   *							-- Dan Schullman   *:  *	26-Jun-85	Allow interrupts to be used to abort dialing,1  *			and ring the bell when a connection is made. 5  *			Reorganized some of the failure paths to use the 3  *			same code, and now close the line on failures. 3  *			Allow use of stored numbers with the DF100 and 3  *			DF200 modems.  Handlers now declared after the   *			call to setjmp.  *							-- Dan Schullman   *B  *	24-May-85	DF03, DF100-series, DF200-series, and "unknown" modem7  *			support added.  Also restructured the various data 8  *			tables, fixed some bugs related to missing data and:  *			missing case labels, and modified the failure message0  *			to display the "reason" given by the modem.  *							-- Dan Schullman   */     /*6  * To add support for another modem, do the following:  *@  *	Define a modem number symbol (n_XXX) for it, keeping the listB  *	in alphabetical and numerical order, and renumbering the values  *	as necessary.  *H  *	Create a MDMINF structure for it, again keeping the list alphabetical  *	for sanity's sake.   *E  *	Add the address of the MDMINF structure to the ptrtab array, again '  *	in alphabetical and numerical order.   *F  *	Add the "user visible" modem name and corresponding modem number to1  *	the mdmtab array, again in alphabetical order.   *F  *	Read through the code and add modem-specific sections as necessary.  */     /*L  * The intent of the "unknown" modem is hopefully to allow KERMIT to supportF  * unknown modems by having the user type the entire autodial sequenceG  * (possibly including control characters, etc.) as the "phone number". H  * The only reason that the CONNECT command cannot be used to do this isJ  * that a remote line cannot normally be opened unless carrier is present.  *I  * The protocol and other characteristics of this modem are unknown, with K  * some "reasonable" values being chosen for some of them.  The only way to A  * detect if a connection is made is to look for carrier present.   *G  * SUPPORT IS CURRENTLY ONLY PARTIALLY SKETCHED OUT FOR THIS.  ALSO, IT H  * SHOULD PERHAPS BE HANDLED MUCH EARLIER, SIMPLY READING USER INPUT ANDH  * SENDING IT TO THE MODEM AND ECHOING MODEM RESPONSES BACK TO THE USER,I  * ALL THE TIME LOOKING FOR CARRIER.  OF COURSE, THE PROBLEM THEN BECOMES G  * ONE OF ALLOWING THE USER TO ABORT THE DIALING.  WE COULD CHOOSE SOME L  * PHRASE THAT WOULD PRESUMABLY NEVER BE A PART OF A VALID AUTODIAL SEQUENCE#  * (E.G., "QUIT" and "quit"). -- DS   */  #include "ckcdeb.h"  #include <stdio.h> #include <ctype.h> #include <signal.h>  #include "ckcker.h"  #include "ckucmd.h"    
 #ifndef ZILOG % #include <setjmp.h>			/* Longjumps */  #else  #include <setret.h>  #endif   = extern int flow, local, mdmtyp, quiet, speed, parity, seslog;  extern char ttname[], sesfil[];    #define	MDMINF	struct mdminf   6 MDMINF		/* structure for modem-specific information */     { >     int		dial_time;	/* time modem allows for dialing (secs) */@     char	*pause_chars;	/* character(s) to tell modem to pause */B     int		pause_time;	/* time associated with pause chars (secs) */B     char	*wake_str;	/* string to wakeup modem & put in cmd mode */C     int		wake_rate;	/* delay between wake_str characters (msecs) */ 9     char	*wake_prompt;	/* string prompt after wake_str */ >     char	*dmode_str;	/* string to put modem in dialing mode */<     char	*dmode_prompt;	/* string prompt for dialing mode */>     char	*dial_str;	/* dialing string, with "%s" for number */B     int		dial_rate;	/* delay between dialing characters (msecs) */     };    /*!  * Define symbolic modem numbers.   *9  * The numbers MUST correspond to the ordering of entries 1  * within the ptrtab array, and start at one (1).   *7  * It is assumed that there are relatively few of these 7  * values, and that the high(er) bytes of the value may /  * be used for modem-specific mode information.   *9  * REMEMBER that only the first eight characters of these %  * names are guaranteed to be unique.   */     #define		n_CERMETEK	 1 #define		n_DF03		 2  #define		n_DF100		 3 #define		n_DF200		 4 #define		n_GDC		 5 #define		n_HAYES		 6 #define		n_PENRIL	 7 #define		n_RACAL		 8 #define		n_UNKNOWN	 9  #define		n_USROBOT	10  #define		n_VENTEL	11" #define         n_CONCORD       12    /*G  * Declare modem "variant" numbers for any of the above for which it is E  * necessary to note various operational modes, using the second byte   * of a modem number.   *D  * It is assumed that such modem modes share the same modem-specificK  * information (see MDMINF structure) but may differ in some of the actions   * that are performed.  */ ) #define		n_HAYESNV	( n_HAYES + ( 1<<8 ) )    /*<  * Declare structures containing modem-specific information.  *9  * REMEMBER that only the first SEVEN characters of these %  * names are guaranteed to be unique.   */     staticH MDMINF CERMETEK =	/* information for "Cermetek Info-Mate 212 A" modem */     {      20,			/* dial_time */       "BbPpTt",		/* pause_chars *//     0,			/* pause_time */	/** unknown -- DS **/ !     "  XY\016R\r",	/* wake_str */      200,		/* wake_rate */      "",			/* wake_prompt */      "",			/* dmode_str */      "",			/* dmode_prompt */"     "\016D '%s'\r",	/* dial_str */     200			/* dial_rate */      };    static8 MDMINF DF03 =		/* information for "DEC DF03-AC" modem */     {      27,			/* dial_time */ ;     "=",		/* pause_chars */	/* wait for second dial tone */      15,			/* pause_time */     "\001\002",		/* wake_str */      0,			/* wake_rate */     "",			/* wake_prompt */      "",			/* dmode_str */      "",			/* dmode_prompt */     "%s",		/* dial_str */      0			/* dial_rate */      };    static> MDMINF DF100 =		/* information for "DEC DF100-series" modem */ 			/* 9 			 * The telephone "number" can include "P"s and/or "T"so6 			 * within it to indicate that subsequent digits are4 			 * to be dialed using pulse or tone dialing.  The6 			 * modem defaults to pulse dialing.  You may modify5 			 * the dial string below to explicitly default all.5 			 * dialing to pulse or tone, but doing so preventsv7 			 * the use of phone numbers that you may have storedu 			 * in the modem's memory. 			 */     {b     30,			/* dial_time */s;     "=",		/* pause_chars */	/* wait for second dial tone */      15,			/* pause_time */     "\001",		/* wake_str */k     0,			/* wake_rate */     "",			/* wake_prompt */f     "",			/* dmode_str */o     "",			/* dmode_prompt */     "%s#",		/* dial_str */     0			/* dial_rate */      };  u static> MDMINF DF200 =		/* information for "DEC DF200-series" modem */ 			/*t9 			 * The telephone "number" can include "P"s and/or "T"s 6 			 * within it to indicate that subsequent digits are4 			 * to be dialed using pulse or tone dialing.  The6 			 * modem defaults to pulse dialing.  You may modify5 			 * the dial string below to explicitly default alli5 			 * dialing to pulse or tone, but doing so preventsh7 			 * the use of phone numbers that you may have storede 			 * in the modem's memory. 			 */     {      30,			/* dial_time */ <     "=W",		/* pause_chars */	/* =: second tone; W: 5 secs */+     15,			/* pause_time */	/* worst case */a<     "\002",		/* wake_str */		/* allow stored number usage */     0,			/* wake_rate */     "",			/* wake_prompt */t     "",			/* dmode_str */e     "",			/* dmode_prompt */     "%s!",		/* dial_str */     0			/* dial_rate */e     };    staticC MDMINF GDC =		/* information for "GeneralDataComm 212A/ED" modem */s     {u     32,			/* dial_time */t     "%",		/* pause_chars */d     3,			/* pause_time */s     "\r\r",		/* wake_str */c     500,		/* wake_rate */F     "$",		/* wake_prompt */o     "D\r",		/* dmode_str */q     ":",		/* dmode_prompt */     "T%s\r",		/* dial_str */     0			/* dial_rate */-     };  g static3 MDMINF HAYES =		/* information for "Hayes" modem */*     {-     35,			/* dial_time */-     ",",		/* pause_chars */e     2,			/* pause_time */	     "AT\r",		/* wake_str */o     0,			/* wake_rate */     "",			/* wake_prompt */r     "",			/* dmode_str */i     "",			/* dmode_prompt */     "AT D %s\r",	/* dial_str */u     0			/* dial_rate */A     };  u static5 MDMINF PENRIL =		/* information for "Penril" modem */      {i     50,			/* dial_time */z1     "",			/* pause_chars */	/** unknown -- HF **/      0,			/* pause_time */e     "\r\r",		/* wake_str */e     300,		/* wake_rate */      ">",		/* wake_prompt */.     "k\r",		/* dmode_str */      ":",		/* dmode_prompt */     "%s\r",		/* dial_str */      0			/* dial_rate */s     };  0 static9 MDMINF RACAL =		/* information for "Racal Vadic" modem */d     {r     35,			/* dial_time */x     "Kk",		/* pause_chars */     5,			/* pause_time */s     "\005\r",		/* wake_str */u     50,			/* wake_rate */      "*",		/* wake_prompt */e     "D\r",		/* dmode_str */      "?",		/* dmode_prompt */     "%s\r",		/* dial_str */      0			/* dial_rate */      };  b static6 MDMINF UNKNOWN =	/* information for "Unknown" modem */     {r     30,			/* dial_time */      "",			/* pause_chars */      0,			/* pause_time */c     "",			/* wake_str */     0,			/* wake_rate */     "",			/* wake_prompt */A     "",			/* dmode_str */F     "",			/* dmode_prompt */     "%s\r",		/* dial_str */a     0			/* dial_rate */      };  " static? MDMINF USROBOT =	/* information for "US Robotics 212A" modem */      {a     30,			/* dial_time */      ",",		/* pause_chars */e     2,			/* pause_time */t     "ATS2=01\r",	/* wake_str */      0,			/* wake_rate */     "OK\r",		/* wake_prompt */     "",			/* dmode_str */o     "",			/* dmode_prompt */     "ATTD%s\r",		/* dial_str */      0			/* dial_rate */n     };  t static5 MDMINF VENTEL =		/* information for "Ventel" modem */      {      20,			/* dial_time */o     "%",		/* pause_chars */n     5,			/* pause_time */      "\r\r\r",		/* wake_str */      300,		/* wake_rate */h     "$",		/* wake_prompt */r     "",			/* dmode_str */r     "",			/* dmode_prompt */     "<K%s\r>",		/* dial_str */     0			/* dial_rate */e     };  d static: MDMINF CONCORD =	/* Info for Condor CDS 220 2400b modem */     {L     35,			/* dial_time */A     ",",		/* pause_chars */E     2,			/* pause_time */L     "\r\r",		/* wake_str */S     20,			/* wake_rate */E     "CDS >",		/* wake_prompt */E     "",			/* dmode_str */K     "",			/* dmode_prompt */     "<D M%s\r>",	/* dial_str */O     0			/* dial_rate */O     }; I /*F  * Declare table for converting modem numbers to information pointers.  *F  * The entries MUST be in ascending order by modem number, without any4  * "gaps" in the numbers, and starting from one (1).  *I  * This table should NOT include entries for the "variant" modem numbers,nI  * since it is assumed that they share the same information as the normalt	  * value.f  */  static MDMINF *ptrtab[] =     {e     &CERMETEK,
     &DF03,     &DF100,t     &DF200,l	     &GDC,d     &HAYES,s     &PENRIL,     &RACAL,*
     &UNKNOWN,m
     &USROBOT,n     &VENTEL,     &CONCORD     };  e /*B  * Declare modem names and associated numbers for command parsing,1  * and also for doing number-to-name translation.u  *;  * The entries MUST be in alphabetical order by modem name.*  */s struct keytab mdmtab[] =     {u     "cermetek",		n_CERMETEK,	0,a*     "concord",          n_CONCORD,      0,     "df03-ac",		n_DF03,		0,p     "df100-series",	n_DF100,	0,r     "df200-series",	n_DF200,	0,i     "direct",		0,		0,i     "gendatacomm",	n_GDC,		0,m     "hayes",		n_HAYES,	0,a     "penril",		n_PENRIL,	0,s     "racalvadic",	n_RACAL,	0,"     "unknown",		n_UNKNOWN,	0,a$     "usrobotics-212a",	n_USROBOT,	0,     "ventel",		n_VENTEL,	0     };   K int nmdm = (sizeof(mdmtab) / sizeof(struct keytab));	/* number of modems */o n, #define DIALING 4		/* for ttpkt parameter */ #define CONNECT 5*   0 #define CONNECTED 1		/* for completion status */ #define FAILED	  2  h /*3  * Failure reasons for use with the 'longjmp' exit.s  */i #define	F_time		1	/* timeout */M  #define F_int		2	/* interrupt *// #define	F_modem		3	/* modem-detected failure */n0 #define	F_minit		4	/* cannot initialize modem */  D static9 char *F_reason[5] = { 		/* failure reasons for message */C@     "Unknown",  "Timeout", "Interrupt", "Modem", "Initialize" };  8 static int tries = 0;   d #define LBUFL 100  static char lbuf[LBUFL];  n static jmp_buf sjbuf;   2: static SIGTYP (*savAlrm)();	/* for saving alarm handler */= static SIGTYP (*savInt)();	/* for saving interrupt handler */l  d, dialtime() {			/* timer interrupt handler */     longjmp( sjbuf, F_time );  }h  d( dialint()			/* user-interrupt handler */     {a     longjmp( sjbuf, F_int );     }i  r staticG ttolSlow(s,millisec) char *s; int millisec; {  /* output s-l-o-w-l-y */Y     for (; *s; s++) {*
 	ttoc(*s); 	msleep(millisec); 	}     }e  i /*#  * Wait for a string of characters.   *G  * The characters are waited for individually, and other characters may H  * be received "in between".  This merely guarantees that the characters,  * ARE received, and in the order specified.  */  static waitFor(s) char *s;r     {      CHAR c;s>     while ( c = *s++ )			/* while more characters remain... */B 	while ( ( ttinc(0) & 0177 ) != c ) ;	/* wait for the character */     }*  o staticC didWeGet(s,r) char *s, *r; {	/* Looks in string s for response r */ C     int lr = strlen(r);		/*  0 means not found, 1 means found it */o
     int i;'     for (i = strlen(s)-lr; i >= 0; i--)	?     	if ( s[i] == r[0] ) if ( !strncmp(s+i,r,lr) ) return( 1 );d     return( 0 );	    	 }p  e  m. /* R E S E T -- Reset alarms, etc. on exit. */    static reset ()     {*
     alarm(0); 9     signal(SIGALRM,savAlrm);		/* restore alarm handler */ ;     signal(SIGINT,savInt);		/* restore interrupt handler */      }t    I  D- /*  D I A L  --  Dial up the remote system */o    dial(telnbr) char *telnbr; {  n     char c;c     char *i, *j;     int waitct, status;i     char errmsg[50], *erp;9     MDMINF *pmdminf;	/* pointer to modem-specific info */eF     int augmdmtyp;	/* "augmented" modem type, to handle modem modes */5     int mdmEcho = 0;	/* assume modem does not echo */      int n, n1;+     char *pc;		/* pointer to a character */o  n 	if (!mdmtyp) {a3 	    printf("Sorry, you must 'set modem' first\n");  	    return(-2); 	} 	if (!local) {2 	    printf("Sorry, you must 'set line' first\n"); 	    return(-2); 	} 	if (speed < 0) {\3 	    printf("Sorry, you must 'set speed' first\n");  	    return(-2);	         } G 	if (ttopen(ttname,&local,mdmtyp) < 0) {/* Open, no wait for carrier */_ 	    erp = errmsg;0 	    sprintf(erp,"Sorry, can't open %s",ttname); 	    perror(errmsg); 	    return(-2);     	}= 	pmdminf = ptrtab[mdmtyp-1];	/* set pointer to modem info */ "= 	augmdmtyp = mdmtyp;		/* initialize "augmented" modem type */  /* cont'd... */i p  e) 					/* interdigit waits for tone dial */s /* ...dial, cont'd */      iB 	waitct = 1*strlen(telnbr) ;	/* compute time to dial worst case */E 	waitct += pmdminf->dial_time;	/* dialtone + completion wait times */n< 	for (i=telnbr; *i; i++) 	/* add in pause characters time */* 	    for (j=pmdminf->pause_chars; *j; j++) 		if (*i == *j) {s% 		    waitct += pmdminf->pause_time;   		    break; 		    }t   O        printf("Dialing thru %s, speed %d, number %s.\r\n",ttname,speed,telnbr);/O        printf("The timeout for completing the call is %d seconds.\r\n",waitct);*I        printf("Type the interrupt character to cancel the dialing.\r\n");a  a5 /* Hang up the modem (in case it wasn't "on hook") */n  r 	if ( tthang() < 0 ) {/ 	    printf("Sorry, Can't hang up tty line\n");  	    return(-2); 	    }   < /* Condition console terminal and communication line */	    0 				/* place line into "clocal" dialing state */* 	if ( ttpkt(speed,DIALING,parity) < 0 )  {; 	    printf("Sorry, Can't condition communication line\n");d 	    return(-2);     	}  t /*4  * Establish jump vector, or handle "failure" jumps.  */-   D     if ( n = setjmp(sjbuf) )		/* if a "failure jump" was taken... */ 	{& 	alarm ( 0 );			/* disable timeouts */? 	if ( n1 = setjmp(sjbuf) )	/* failure while handling failure */	 	    {G 	    printf ( "%s failure while handling failure.\r\n", F_reason[n1] );  	    }/ 	else				/* first (i.e., non-nested) failure */I 	    {A 	    signal ( SIGALRM, dialtime );	/* be sure to catch signals */*2 	    if ( signal ( SIGINT, SIG_IGN ) != SIG_IGN )  		signal ( SIGINT, dialint ); ; 	    alarm ( 5 );		/* be sure to get out of this section */ 1 	    ttclos ();			/* hangup and close the line */* 	    }% 	switch ( n )			/* type of failure *// 	    {" 	    case F_time:		/* timed out */ 		{ @ 		printf ( "No connection made within the allotted time.\r\n" ); 		break; 		} , 	    case F_int:			/* dialing interrupted */ 		{ ( 		printf ( "Dialing interrupted.\r\n" ); 		break; 		}r2 	    case F_modem:		/* modem detected a failure */ 		{t 		printf ( "Failed (\"" ); 		for ( pc=lbuf; *pc; pc++ ) 		    if ( isprint(*pc) )l0 			putchar(*pc);	/* display printable reason */  		printf ( "\").\r\n" ); 		break; 		} 1 	    case F_minit:		/* cannot initialize modem */* 		{ , 		printf ( "Cannot initialize modem.\r\n" ); 		break; 		}" 	    }% 	reset ();			/* reset alarms, etc. */ . 	return ( -2 );			/* exit with failure code */ 	}    /*$  * Set timer and interrupt handlers.  */i  s?     savAlrm = signal(SIGALRM,dialtime);	/* set alarm handler */B=     if ( ( savInt = signal ( SIGINT, SIG_IGN ) ) != SIG_IGN ) A 	signal ( SIGINT, dialint );	/* set int handler if not ignored */ 7     alarm(10);			/* give modem 10 seconds to wake up */	   /     ttflui();			/* flush input buffer if any */  	 /*  * Put modem in command mode.o  */o   5 #define OKAY 1			/* modem attention attempt status */a #define IGNORE 2 #define GOT_O -2 #define GOT_A -3  o switch (augmdmtyp) {     case n_HAYES:	     case n_HAYESNV:  	while(tries++ < 4) {*A 	    ttol( HAYES.wake_str, strlen(HAYES.wake_str) );	/* wakeup */  	    status = 0; 	    while ( status <= 0 ) { 		switch (ttinc(0) & 0177) {' 		    case 'A':			/* echoing, ignore */% 			status = GOT_A;	 			break;	 		    case 'T':  			if (status == GOT_A) {C. 			    mdmEcho = 1;	/* expect echoing later */ 			    status = 0;
 			    break;* 			} 			status = IGNORE;s	 			break;, 		    case '\n': 		    case '\r': 			status = 0;	 			break;*+ 		    case '0':			/* numeric result code */*6 			augmdmtyp = n_HAYESNV;	/* nonverbal result codes */ 			status = OKAY;>	 			break;s0 		    case 'O':			/* maybe English result code*/ 			status = GOT_O;	 			break;  		    case 'K':i 			if (status == GOT_O) {* 			    augmdmtyp = n_HAYES;d 			    status = OKAY;e
 			    break; $ 			}			/* else its default anyway */ 		    default: 			status = IGNORE;u	 			break;u 		    }s 		}t 	    if (status == OKAY) break;s$ 	    if (status == IGNORE) ttflui();* 	    sleep(1);		/* wait before retrying */ 	}         if (status != 0) break; > 	longjmp( sjbuf, F_minit );	/* modem-initialization failure */  G /* cont'd... */s  ) 					/* interdigit waits for tone dial */  /* ...dial, cont'd */E   2     default:			/* place modem into command mode */1 	ttolSlow(pmdminf->wake_str, pmdminf->wake_rate);d 	waitFor(pmdminf->wake_prompt);a 	break;u     }*$     alarm(0);			/* turn off alarm */1     msleep(500);		/* give things settling time */=/     alarm(10);			/* alarm on dialing prompts */c  o 		 /* Dial the number */   ,% 				/* put modem into dialing mode */16     ttolSlow(pmdminf->dmode_str, pmdminf->dial_rate);	G     if (pmdminf->dmode_prompt) {	/* wait for prompt, if any expected */	  	waitFor(pmdminf->dmode_prompt);
 	msleep(300);r 	}  i7     alarm(0);			/* turn off alarm on dialing prompts */r6     alarm(waitct);		/* time to allow for connecting */:     ttflui();			/* clear out stuff from waking modem up */G     sprintf(lbuf, pmdminf->dial_str, telnbr); /* form dialing string */e@     ttolSlow(lbuf,pmdminf->dial_rate);	/* send dialing string */  nL     if (augmdmtyp == n_RACAL) {	/* acknowledge printout of dialing string */
 	sleep(3);
 	ttflui(); 	ttoc('\r'); 	}  m /* cont'd... */  n  2) 					/* interdigit waits for tone dial */e /* ...dial, cont'd */   f  	 /* Check for connection */    /*H  * I believe we also need to look for carrier in order to determine if aL  * connection has been made.  In fact, for many we may only want to look forI  * the "failure" responses in order to short-circuit the timeout, and lettL  * carrier be the determination of whether a connection has been made. -- DS  *//  t     status = 0;I>     strcpy(lbuf,"No Connection");	/* default failure reason */     while (status == 0) {/       switch (augmdmtyp) {	 	default:d: 	    for (n=0; n < LBUFL; n++) {	/* accumulate response */ 		lbuf[n] = (ttinc(0) & 0177);  2 		if ( lbuf[n] == '\r' || lbuf[n] == '\n' ) break; 		} 9 	    lbuf[n] = '\0';		/* terminate response from modem */ 7 	    if (n) {			/* if one or more characters present */i 		switch (augmdmtyp) { 		  case n_CERMETEK:$ 		    if (didWeGet(lbuf,"\016A")) {	 			status = CONNECTED;3 			ttolSlow("\016U 1\r",200);	/* make transparent*/h 			} 		    break;? 		  case n_DF100:      /* DF100 won't generate some of these */  		  case n_DF200:H8 		    if (didWeGet(lbuf,"Attached")) status = CONNECTED; 		    /*; 		     * The DF100 will respond with "Attached" even if DTRr; 		     * and/or carrier are not present.  Another reason to ! 		     * (also) wait for carrier? 	 		     */r1 		    if (didWeGet(lbuf,"Busy")) status = FAILED; 9 		    if (didWeGet(lbuf,"Disconnected")) status = FAILED;	2 		    if (didWeGet(lbuf,"Error")) status = FAILED;6 		    if (didWeGet(lbuf,"No answer")) status = FAILED;9 		    if (didWeGet(lbuf,"No dial tone")) status = FAILED;e3 		    if (didWeGet(lbuf,"Speed:")) status = FAILED;l 		    /*@ 		     * It appears that the "Speed:..." response comes after an> 		     * "Attached" response, so this is never seen.  HOWEVER,> 		     * it would be very handy to detect this and temporarily; 		     * reset the speed, since it's a nuiscance otherwise. > 		     * If we wait for some more input from the modem, how do; 		     * we know if it's from the remote host or the modem?y; 		     * Carrier reportedly doesn't get set until after them? 		     * "Speed:..." response (if any) is sent.  Another reason $ 		     * to (also) wait for carrier.	 		     */i 		    break; 		  case n_GDC:'7 		    if (didWeGet(lbuf,"ON LINE")) status = CONNECTED;p7 		    if (didWeGet(lbuf,"NO CONNECT")) status = FAILED;( 		    break; 		  case n_HAYES:  		  case n_USROBOT:u7 		    if (didWeGet(lbuf,"CONNECT")) status = CONNECTED; 7 		    if (didWeGet(lbuf,"NO CARRIER")) status = FAILED;f 		    break; 		  case n_PENRIL:2 		    if (didWeGet(lbuf,"OK")) status = CONNECTED;1 		    if (didWeGet(lbuf,"BUSY")) status = FAILED;d4 		    if (didWeGet(lbuf,"NO RING")) status = FAILED; 		    break; 		  case n_RACAL:i7 		    if (didWeGet(lbuf,"ON LINE")) status = CONNECTED; 8 		    if (didWeGet(lbuf,"FAILED CALL")) status = FAILED; 		    break; 		  case n_VENTEL:7 		    if (didWeGet(lbuf,"ONLINE!")) status = CONNECTED;w1 		    if (didWeGet(lbuf,"BUSY")) status = FAILED;o7 		    if (didWeGet(lbuf,"DEAD PHONE")) status = FAILED;s 		    break; 		  case n_CONCORD:m: 		    if (didWeGet(lbuf,"INITIATING")) status = CONNECTED;1 		    if (didWeGet(lbuf,"BUSY")) status = FAILED;t8 		    if (didWeGet(lbuf,"CALL FAILED")) status = FAILED; 		    break; 		}t 	    } 	    break;t  T5 	case n_DF03:			/* because response lacks CR or NL */w 	    c = ttinc(0) & 0177;p( 	    if ( c == 'A' ) status = CONNECTED;% 	    if ( c == 'B' ) status = FAILED;m 	    break;w  ' 	case n_HAYESNV: 	    c = ttinc(0) & 0177; 3 	    if (mdmEcho) {		/* sponge up dialing string */ 1 		mdmEcho = c!='\r';	/* until return is echoed */i 		break; 		}c& 	    if (c == '1') status = CONNECTED;# 	    if (c == '3') status = FAILED;t& 	    if (c == '5') status = CONNECTED; 	    break;y  a 	case n_UNKNOWN:5 	    /** SHOULD WAIT FOR CARRIER OR TIMEOUT -- DS **/  	    break;j 	}				/* switch (augmdmtyp) */!     }					/* while status == 0 */m  j  )3     alarm(0);				/* turn off alarm on connecting */m<     if ( status != CONNECTED )		/* modem-detected failure */< 	longjmp( sjbuf, F_modem );	/* exit (with reason in lbuf) */4     alarm(3);				/* precaution in case of trouble */A     ttpkt(speed,CONNECT,parity);	/* cancel dialing state ioctl */{)     reset ();				/* reset alarms, etc. */s     if ( ! quiet )% 	printf ( "Call completed.\07\r\n" );N8     return ( 0 );			/* return, and presumably connect */ }(