C     This Fortran program should be run on the mainframe in conjunction
C     with a Basic program (MSBPCB.BAS) on the PC to transfer
C     MSKERMIT.BOO to the PC and translate it into KERMIT.EXE.  This
C     program uses a very rudimentary technique to try to insure that
C     the characters it sends arrive correctly.  It just sends a count
C     of the number of characters sent after each line.  In this way any
C     errors of character loss or insertion will be caught.  If a
C     character is just corrupted it will not be caught.  Hopefully if
C     this happens it will be in a non-critical part of the KERMIT.EXE
C     file.  The reason a simple checksum was not used was so that this
C     program could run on machines using either EBCDIC or ASCII
C     characters.  This program should take about thirty minutes to run.
C
C     This program assumes that 5 and 6 are directed to the terminal and
C     7 is directed to the file MSKERMIT.BOO.
C
C     Bill Catchings, Columbia University Center for Computing Activities
C     June 1984 (Revised September 1984)
C
      INTEGER LINE(77), ACK(4), CHECK, OK, SPACE, COMMA

      WRITE(6,100)
100   FORMAT(' Ready to transfer data, now run MSPCBOOT.BAS on the PC.')

C     Get characters for constants (character constants are rough in
C     some FORTRANs).
      READ (5,200) OK, SPACE, COMMA, ACK
200   FORMAT(4A1)
      GO TO 20

C     Get terminal handshake.
10    READ (5,200)ACK

C     Did the other side like it?  (Did they send OK?)
      IF (ACK(1) .NE. OK) GO TO 50

C     Yes, get new line from file.
20    READ (7,300,END=99)LINE
300   FORMAT(77A1)

C     Count the characters as some rudimentary check for noise.
      I = 1
30    IF (LINE(I) .EQ. SPACE) GO TO 40
      I = I + 1
      GO TO 30

C     Put in a comma followed by the count.
40    LINE(I) = COMMA

C     Write to TTY.
50    WRITE (6,400)LINE,I-1
400   FORMAT(' ',77A1,I2)
      GOTO 10

C     Send good-bye message.
99    WRITE (6,500)
500   FORMAT(' ',10('&'),',10')

      STOP
      END
