! @Part(CPMKERMIT,root="KER:KUSER")  @string(-cp4version="@q<4.05>")  @Chapter<CP/M-80 KERMIT>6 @Begin<Description,Leftmargin +12,Indent -12,spread 0>2 @i(Program:)@\Bill Catchings, Columbia University,/ with contributions from Charles Carvalho (ACC), ( Bernie Eiben (DEC), Nick Bush (Stevens),E John Bray (University of Tennessee), Bruce Tanner (Cerritos College), 2 Greg Small (University of California at Berkeley),E Kimmo Laaksonen (Helskini University of Technology), and many others.   & @i(Language:)@\8080 Assembler or MAC80  ! @i(Version:)@\@value(-cp4version)    @i(Date:)@\February 1985  B @i(Documentation:)@\Charles Carvalho, ACC; Frank da Cruz, Columbia @end<Description>  @label<-k80>  ' @i<KERMIT-80 Capabilities At A Glance:>  @begin<format,leftmargin +2>' @tabclear()@tabset(3.5inches,4.0inches)  Local operation:@\Yes  Remote operation:@\No  Transfers text files:@\Yes Transfers binary files:@\Yes Wildcard send:@\Yes  @q<^X/^Z> interruption:@\Yes" Filename collision avoidance:@\Yes Can time out:@\Yes   8th-bit prefixing:@\Yes  Repeat count prefixing:@\No  Alternate block checks:@\Yes) Terminal emulation:@\Yes, VT52 and others , Communication settings:@\Yes; duplex, parity# Transmit BREAK:@\Yes; some versions  IBM communication:@\Yes  Transaction logging:@\No$ Session logging (raw download):@\Yes Raw upload:@\Yes Act as server:@\No) Talk to server:@\Yes; SEND, GET, FIN, BYE " Advanced commands for servers:@\No7 Local file management:@\Yes; DIR, ERA, SET DEFAULT disk  Handle file attributes:@\No  Command/init files:@\No  Printer control:@\Yes, limited   @end<format>   @Section<Summary of CP/M>    CP/M-80 (version 2@q<.>2) > has only five built-in commands, and they all deal with files;. other functions are done by invoking programs.   CP/M file specifications are of $ the form @q(DEV:XXXXXXXX.YYY), where @begin<description>    @q(DEV:)@\is a @i<device name>,E normally the A:@ or B:@ floppy.  If omitted, the device name defaults  to your connected diskette.   6 @q(XXXXXXXX)@\is a @i<filename> of up to 8 characters.  2 @q(YYY)@\is the @i<file type>, up to 3 characters.  @end<description>@  File names and file types may contain letters, digits, and someD special characters, including dash, dollar sign, and underscore, butA no imbedded spaces.  Upper and lower case letters are equivalent.   C  "Wildcard" file-@|group specifications are permitted in file names H and file types (but not device names) within certain contexts; a "@q(*)"G matches a whole field, a "@q(?)"  matches a single character, including G space.  Examples: "@q(*.F??)" specifies all files whose @i<types> start C with F and are 1, 2, or 3 characters long; "@q(F?.*)" specifies all B files whose names start with F and are no more than two characters" long (before the trailing spaces).   The five CP/M commands are:   @Begin<Description>> DIR @i<file>@\Lists the the names of the specified files.  TheE default file specification is "*.*".  Example: @w<"@q(DIR B:*.FOR)">.   H ERA @i<file>@\Erases (deletes) the specified file(s); wildcards allowed.  O REN @i<new> @i<old>@\Changes the name of a file from @i<old> to @i<new>, e.g.@*  @w<"@q(REN NEW.FOR=OLD.FOR)">.  > SAVE@\Saves the specified number of memory blocks into a file.  ; TYPE @i<file>@\Types the specified file on the screen, e.g.  @w<"@q(TYPE FOO.TXT)">.   @End<Description>  The most important programs are:  @Begin<Description>? STAT@\Gives statistics on disk usage; sets and displays IOBYTE.   C PIP@\@u<P>eripheral @u<I>nterchange @u<P>rogram.  Copies files.  In : response to the "@q(*)" prompt, give a command of the form#  @example<disk:outfile=disk:infile> L  Wildcards ("@q(*)" for a whole field or "@q(?)"  for a letter) can be used.K Examples: "@q(A:=B:*.*)" to copy a whole disk, "@q(A:=B:*.FOR)" to copy all F the Fortran programs from disk B to disk A.  If the disk specificationE is omitted, your "connected" disk is assumed.  Command line arguments + are also accepted, e.g. "@q(PIP A:=B:*.*)".  @End<Description> E For further information on CP/M, consult your microcomputer manual or  a CP/M handbook.   @Section<Kermit-80 Description>   J Since Kermit-80 runs on a standalone micro, it is always in control of theI screen -- it is always @i<local>@index<Local>.  Thus, it always keeps the K screen updated with the file name and the packet number, whether sending or 
 receiving. @index<Timeout> = Kermit-80 is capable of an imprecise or "fuzzy" timeout on an M input request, and can break deadlocks automatically.  In most cases, this is J not important, because the KERMIT on the other side is most likely able toK handle the timeouts.  The timeouts done by Kermit-80 are fuzzy because they I depend on the speed of the processor and other factors that can vary from  system to system.   L If despite the timeout capability, the transmission appears to be stuck (andN you can tell that this has happened if the screen fails to change for a while)N you can type carriage return to have the micro do what it would have done on aN @Index[Timeout] timeout, namely NAK@Index[NAK] the expected packet to cause toM foreign host to send it again (or, if the micro is sending, to retransmit the O last packet).  Micro/@|micro or micro/@|IBM-@|mainframe transfers could require ! this kind of manual intervention.   2 File transfers may be interrupted in several ways. @begin<description> O Control-C@\This will return you to Kermit-80 command level immediately, so that L you can connect back to the remote system, or take any other desired action.  N Control-X@\When sending a file, this will terminate the sending of the currentL file with a signal to the KERMIT on the other side to discard what it got soO far.  If there are more files to be sent, KERMIT-80 will go on to the next one. K When receiving a file, KERMIT-80 will send a signal to the remote KERMIT to N stop sending this file.  If the remote KERMIT understands this signal (not allK implementations of KERMIT do), it will comply, otherwise the file will keep J coming.  In any case, the remote KERMIT will go on to the next file in the group, if any.  L Control-Z@\Like Control-X, except if a file group is being transmitted, thisO will stop the transmission of the entire group.  If only a single file is being - transmitted, it works exactly like Control-X.   H Carriage Return@\If you type a carriage return Kermit-80 will resend theI current packet.  You may do this repeatedly, up to the packet retry limit ; (somewhere between 5 and 16 times) for a particular packet.  @end<description>    @heading<Kermit-80 Commands>  M KERMIT-80 uses the DECSYSTEM-20 keyword style command language.  Each keyword O may be abbreviated to its minumum unique length.  "?" may be typed to request a N menu of the available options for the current field at any point in a command.M ESC may be typed at any point in a command to fill out the current keyword or N filename; if sufficient characters have not been typed to identify the currentO field uniquely, KERMIT-80 will sound a beep and allow you to continue from that  point.+ @begin<description,leftmargin +8,indent -8> ? @Index[Virtual Terminal]@Index[Escape Character]@Index[Connect] J CONNECT@\Establish a "virtual terminal" connection to any host that may beJ connected to the serial port, i.e.@ pass all typein to the serial port andO display all input from the serial port on the screen.  Also, emulate a DEC VT52 L to allow cursor control, screen clearing, etc., if VT52-EMULATION is ON (seeO below), in which case you should also set your terminal type on the remote host H to VT52.  (Some versions emulate other terminals.)  The escape characterO differs from micro to micro; when you issue the CONNECT command, the micro will N print a message telling you how to get back.  The escape sequence is generally> an uncommonly-@|used control character, like CTRL-backslash or9 CTRL-rightbracket, followed by a single letter "command". 6  @begin<description,spread 0,leftmargin +4, indent -4>< C@\Close Connection, return to @q(Kermit-80>) command level.  @ S@\Display Status of connection, but maintain remote connection.  0 @q<?>@\List available single-character commands.  $ 0@\(zero) Send a null (0) character.  A B@\Send a BREAK signal.  Only some systems provide this function.   F @q<^]>@\(or whatever - a second copy of the escape character) Send the+ escape character itself to the remote host.   @end<description>  H @Index[SEND]SEND @i<filespec>@\Send file(s) specified by @i<filespec> to@ the remote Kermit.  The @i<filespec> may contain CP/M wildcards.  # @Index[RECEIVE]@Index[File-Warning] ( RECEIVE@\Receive file(s) from the remoteL Kermit.  Store them under the names provided in the file headers supplied byN the remote host.  If the names aren't legal, use as many legal characters fromI the name as possible (see the description of SET FILE-WARNING below).  If L there's a conflict, and FILE-WARNING is ON, warn the user and try to build aB unique name for the file by adding "@q<&>" characters to the name.  L @Index<GET>GET @i<filespec>@\When Kermit-80 is talking to a Kermit Server onF the host, you should use the GET command to request the server to send files to you, for example: @example<get hlp:k*.hlp>L Limitation: If you request an alternate block check type using the SET BLOCKN command, the GET command will not communicate it to the remote server.  If youN want to have type 2 or 3 block checks done when getting files from the server,O you have to issue the appropriate SET BLOCK command to the remote KERMIT before  putting it in server mode.  L @Index[LOG]LOG @i<filespec>@\When CONNECTed to a foreign host as a terminal,L log the terminal session to the specified diskette file.  This functionality9 depends to some extent on the remote host's ability to do H @Index[XON/XOFF]XON/XOFF flow control, and does not guarantee a completeM transcript (after all, that's what the KERMIT protocol is for).  The log file O is closed when the connection is closed by typing the escape character followed & by the single-@|character command "C".  O @Index[TRANSMIT]TRANSMIT @i<filespec>@\Send the specified file to the system on N the other end of the connection as though it were being typed at the terminal,O one line at a time.  No KERMIT protocol is involved.  You must manually confirm I each line.  This is useful for sending files to systems that don't have a G KERMIT program.  During transmission, you may type the escape character 5 followed by one of these single-@|character commands: 5 @begin<description,spread 0,leftmargin +4, indent -4>  C@\Cease transmission     R@\Re-transmit the previous line @end<description>   D BYE@\When talking to a remote Kermit Server, this command shuts downI the server and logs it out, and also exits from Kermit-80 to CP/M command  level.@Index[BYE]   J @Index[LOGOUT]LOGOUT@\Like BYE, but leaves you at Kermit-80 command level.  K @Index[FINISH]FINISH@\Like LOGOUT, but shuts down the remote server without J logging it out.  Leaves you at Kermit-80 command level; subsequent CONNECT8 commands will put you back at host system command level.  O @Index[VERSION]VERSION@\Show the name, edit number, and edit date of several of # the modules that make up Kermit-80.   H @Index[SET]SET @i<parameter> [@i<value>]@\Set the specified parameter to( the specified value.  Possible settings:+ @begin<description,leftmargin +8,indent -8> H @Index[Warning]WARNING ON (or OFF)@\Warn user of filename conflicts whenJ receiving files from remote host, and attempt to generate a unique name by< adding "@q<&>" characters to the given name.  ON by default.  D @Index[VT52]VT52-EMULATION ON (or OFF)@\When connected as a terminal@ to a foreign host, controls whether the micro emulates a VT52 orI runs in "native mode".  VT52 emulation is ON by default, except on micros L that already have terminal functionality built in, such as the DEC VT180 andK DECmate (these act as @index<VT100>VT100-@|series terminals).  Some systems C emulate other terminals, like the ADM3A; see table @ref<-cp4terms>.   F @Index[Local-Echo]LOCAL-ECHO ON (or OFF)@\When you CONNECT to a remoteE host, you must set LOCAL-@|ECHO ON if the host is half duplex, OFF if  full duplex.  OFF by default.   ? @Index[Escape Character]ESCAPE@\Change the escape character for D virtual terminal connections.  Kermit-80 will prompt you for the new, escape character, which you enter literally.  M @Index[Baud]BAUD-RATE@\Change the baud rate of the communications port.  This G command only works on some systems.  @i<value> is the numeric baud rate E (300, 9600, etc.) desired.  Type SET BAUD followed by a question mark # for a list of supported baud rates. B On systems that do not support this command, you must set the portB baud rate from CP/M or other setup mechanism outside of KERMIT-80.  G @Index[Parity]PARITY@\Sets parity for outgoing characters to one of the N following: NONE, SPACE, MARK, EVEN, or ODD.  On input, if parity is NONE, thenI the 8th bit is kept (as data), otherwise it is stripped and ignored.  The E parity setting applies to both terminal connection and file transfer. L If you set parity to anything other than none, KERMIT-80 will attempt to use @Index<Eighth-Bit Prefix> J "8th bit prefixing" to transfer binary files.  If the other KERMIT is alsoB capable of 8th bit prefixing, then binary files can be transferredN successfully; if not, the 8th bit of each data byte will be lost (you will see* a warning on your screen if this happens).  O @Index[TIMER]TIMER ON (or OFF)@\Enable or disable the "fuzzy timer".  The timer O is off by default, because in the normal case KERMIT-80 is communicating with a L mainframe KERMIT that has its own timer.  Mainframe KERMIT timers tend to beM more precise or adaptable to changing conditions.  You should SET TIMER ON if O you are communicating with a KERMIT that does not have a timer.  You should SET C TIMER OFF if you are communicating over a network with long delays.   J @Index[IBM]IBM ON (or OFF)@\Allow the transfer of files to and from an IBMO mainframe computer.  This makes Kermit-80 wait for the IBM turnaround character N (XON), ignore parity on input, add appropriate parity to output, and use localK echoing during CONNECT.  As distributed, KERMIT-80 uses MARK parity for IBM K communication.  If you don't give this command, IBM mode is OFF.  Since IBM L VM/CMS KERMIT does not have timeout capability, SET IBM ON also turns on the "fuzzy timer" automatically.  5 @Index[Block Check]BLOCK-CHECK-TYPE@\The options are: 4 @begin<description,spread 0,leftmargin +8,indent -8>? 1-CHARACTER-CHECKSUM@\Normal, default, standard 6-bit checksum.   B 2-CHARACTER-CHECKSUM@\A 12-bit checksum encoded as two characters.  M 3-CHARACTER-CRC-CCITT@\A 16-bit CCITT-format Cyclic Redundancy Check, encoded  as 3 characters.   @end<description> M The 2 and 3 character options should only be used under conditions of extreme M line noise.  Many implementations of KERMIT only support the single character 	 checksum.   N FILE-MODE@\Tells KERMIT-80 what kind of file it is sending, so that KERMIT canO correctly determine the end of the file.  SET FILE BINARY means to send all the L 128-@|byte blocks of the file, including the last block in its entirety; SETH FILE ASCII is used for text files, and transmission stops when the firstN Control-Z is encountered anywhere in the file (this is the CP/M convention for  marking the end of a text file).F SET FILE DEFAULT tells Kermit to attempt to determine the file type byH examining the file being transmitted.  If a Control-Z appears before theF last block of the file, it is assumed to be BINARY; if, when the firstN Control-Z is encountered, the remainder of the file contains only control-Z's,J it is assumed to be a text file.  Unfortunately, not all programs fill theO remainder of the last record of a text file with Control-Z's, so this algorithm  is not always successful. ( If binary transmission is used on a textM file, some extraneous characters (up to 127 of them) may appear at the end of O the file on the target system.  If ASCII transmission is used on a binary file, M the entire file will not be sent if it happens to contain any data bytes that  correspond to Control-Z.  O DEFAULT-DISK@\This allows you to set the default disk as source and destination M of file transfers.  In addition, issuing this command causes you to switch to 2 the specified disk and log it in, write-@|enabled.1 The colon must be included in the disk name (A:).  The selected disk appears > in your KERMIT-80 prompt, for instance @example[Kermit-80 A:>]  O PORT@\Allows you to switch between different communication ports.  This command I is not available on all systems.  Type @q<SET PORT ?> for a list of valid  options for your system.  L PRINTER@\ON or OFF.  Turns copying of CONNECT session to printer on and off.N No attempt is made to do buffering or flow control; Kermit assumes the printer can keep up.  N DEBUG@\ON or OFF.  Enables/disables displaying of packets on the screen during file transfer. @end<description>   D DIRECTORY@\This provides a directory listing of the specified files. If no files are K specified, all files on the default disk are listed.  File sizes, in K, are M included.  You may interrupt the listing at any time by typing any character. K The listing (even if interrupted) concludes with a display of the amount of  free storage left on the disk.  C ERASE@\This executes the CP/M ERA command on the specified file(s). 6 The names of the files being erased are not displayed. @end<description>    @section<Kermit-80 Flavors>   N Many of the systems supported use an external terminal, rather than a built-inH console.  Kermit may be further customized for these systems by defining1 (at assembly time) the terminal type to be used.  F If the terminal type is unknown or does not match any of the existing J terminal options, the generic "CRT" option may be selected.  In this case,O Kermit cannot do fancy screen control during file transfer; it simply types the H file names, packet numbers, and messages in sequence across and down theL screen.  This works best if you can put your micro or terminal in "autowrap"L mode; otherwise the packet numbers will pile up in the rightmost column; theA filenames and messages will always appear on a new line, however. K If no specific terminal has been selected, Kermit cannot do VT52 emulation; 
 it can actO as a "dumb terminal" (sometimes called a "glass TTY"), or else its own built in M terminal firmware provides cursor control functions independent of the Kermit  program.   @subsection<Generic Kermit-80>N @index<Generic Kermit-80>@index<8080> "Generic Kermit-80" is an implementationJ of Kermit that should run on any 8080-@|compatible CP/M 2.2 system with no modificationM at all, or perhaps only a minor one.  Unlike other Kermit-80 implementations, B it contains no system-@|dependent manipulation of the serial port.N All I/O is done with standard CP/M BIOS@index<BIOS> calls, and I/O redirectionG is done using the CP/M IOBYTE function, which, according to the Digital H Research @i<CP/M Operating System Manual>, is an optional feature of anyK particular CP/M implementation.  If your system does not provide the IOBYTE L function, Generic Kermit-80 will not work; furthermore, not all systems that' implement IOBYTE do so in the same way. K The SET PORT command may be used to select the devices to be used for input M and output.   Table @ref<-cp4ports> lists the options to the SET PORT command  and their effects.  " @begin<table,use example,centered> @bar() @blankspace(1)< @ux(SET PORT @i<xxx>)    @ux(input from)      @ux(output to)'     CRT            CRT:            CRT: '     PTR            PTR:            PTP: '     TTY            TTY:            TTY: '     UC1            UC1:            UC1: '     UR1            UR1:            UP1: '     UR2            UR2:            UP2: $ @caption<Kermit-80 SET PORT Options> @tag<-cp4ports>  @bar() @end<table>    The default is SET PORT PTR.G In all cases, the console (CON:) and list (LST:) devices used are those   selected when Kermit is started.  0  The reason all Kermit-80 implementations aren'tO generic is that a good deal of speed is sacrificed by getting all services from O the operating system.  While a specific implementation of Kermit-80 may be able N to operate at 4800, 9600, or even 19200 baud, Generic Kermit will fail to workM on some systems at speeds in excess of 1200 baud.  In addition, many features M of Kermit require more specific knowledge of the hardware involved -- Generic ; Kermit cannot send a BREAK signal, or change the baud rate.    @subsection<CP/M 3 Kermit>  I CP/M 3 Kermit should run on most CP/M 3 (CP/M-Plus) systems.  It uses the I auxilliary port (AUX:) to communicate to the remote Kermit.  The SET BAUD A and SET PORT commands are not supported; nor can a BREAK be sent. A Like Generic Kermit, a terminal may be selected at assembly time.   % @subsection<System-Specific Versions>   G There are also many versions of Kermit-80 tailored to specific systems. K Most of these operate uniformly, but some of them take advantage (or suffer K limitations) of the specific system.  Here are some of the special features  for particular systems:     @ux<Apple II> -- two variations:+ @begin<description,leftmargin +8,indent -4> < APMMDM:@\Apple with Z80 Softcard and Micromodem II in slot 2D Dialout capability provided in connect command; user is prompted for= phone number if carrier is not present.  During connect mode, F @q(^]D) drops carrier.  BYE command also causes carrier to be dropped.  ? AP6551:@\Apple with Z80 Softcard, and one of several 6551-based @ communication cards; the slot number is a compile-time parameterC (default is slot 2).  SET BAUD-RATE supported; speeds are 110-19200  baud.  @end<description>   + @begin<description,leftmargin +4,indent -4> M @ux<BigBoard II>:@\Uses serial port A.  To use port B, change mnport, mnprts, I and baudrt and reassemble.  Can generate BREAK.  SET BAUD-RATE supported;  speeds are 300-38400 baud.  M @ux<Digicomp Delphi 100>:@\SET BAUD-RATE supported; speeds are 50-19200 baud.   M @ux<CPT-85xx word processors>:@\Can generate BREAK.  SET BAUD-RATE supported;  speeds are 50-9600 baud.  H @ux<DEC DECmate II word processor (with Z80 card)>:@\Can generate BREAK.  K @ux<DEC VT180 (Robin)>:@\Three output ports, referred to as COMMUNICATIONS, * GENERAL, and PRINTER.  Can generate BREAK.  M @ux<Intertec SuperBrain>:  SET BAUD-RATE supported; speeds are 50-19200 baud.   H @ux<Kaypro:>@\Should work on most Kaypro models, as well as some relatedN systems (Ferguson BigBoard I, Xerox 820).  For the newer Kaypros with multipleJ ports, Kermit uses the one labeled "serial data"; it cannot use the serialO printer or internal modem ports (but it should be possible to modify the values O for mnport, mnprts, and baudrt to do this).  Can generate BREAK.  SET BAUD-RATE $ supported; speeds are 50-19200 baud.  O @ux<Morrow Decision I>:@\Uses the Multi-I/O board.  Port 1 is the console, port K 3 is the communications line.  SET BAUD-RATE supported; speeds are 75-56000  baud.    @ux<Nokia MicroMikko>:@\> Will not echo control-O (which locks keyboard).  SET BAUD-RATE# supported; speeds are 75-9600 baud.   3 @ux<Ohio Scientific>:@\Doesn't have screen control.   N @ux<Osborne 1>:Uses serial line, not internal modem.  Left-arrow key generatesJ <DEL> ("delete" or "rubout" character) during connect mode.  SET BAUD-RATE( supported; speeds are 300 and 1200 baud.  O @ux<TRS-80>: Two versions, one for Lifeboat CP/M, one for Pickles & Trout CP/M.  @end<description>   # @section<Installation of Kermit-80> ? Kermit-80 was written originally for the Intertec SuperBrain in F lowest-@|common-@|denominator @Index[8080] 8080 code with the standardN assembler, ASM (single source module, no macros, no advanced instructions), soG that it could be assembled on any CP/M-80 system (the 8080 assembler is M distributed as a standard part of CP/M-80, whereas the fancier Z80@Index[Z80] I or macro assemblers are normally commercial products).  It has since been O modified to run on many other systems as well.  Kermit-80 should be able to run M on any 8080-, 8085- or Z80-@|based microcomputer under @Index[CP/M] CP/M with L appropriate minor changes to reflect the port i/o and screen control for the system (see below).   M The proliferation of new systems supported by Kermit-80 made the program grow N so large and complicated that it had to be broken up into system-@|independentI and system-@|dependent modules, as of version 4 (this was done by Charles O Carvalho of ACC).  Each module is composed of multiple files.  This has reduced K the time and disk space necessary for assembly; Kermit-80 may once again be L assembled on a CP/M system with roughly 150Kbytes of space.  The majority ofA the code does not need to be reassembled to support a new system. I Unfortunately, it can no longer be assembled with ASM, since ASM does not N support multiple input files.  To allow it to be assembled on any CP/M system,O the public-domain assembler LASM is included in the distribution kit; Kermit-80 M may also be assembled with Microsoft's M80 (not supplied), or cross-assembled M on a DEC-10 or DEC-20 with MAC80 (also supplied in the distribution kit).  In M theory, any 8080 assembler supporting the INCLUDE directive ought to work, as  well.   J All versions of Kermit-80 are assembled from the same set of sources, withL system dependencies taken care of by assembly-@|time conditionals within theI system-@|dependent module (eventually, the system-@|dependent module will H itself be broken up into multiple files, one for each system).  The mostK important system dependencies are terminal emulation (when CONNECTed to the O remote host) and screen handling, which are dependent on the individual micro's K escape codes (these features are table driven and easily modified for other N CP/M systems), and the lowest level i/o routines for the serial communicationsM port.  The port routines are best done only with BDOS calls, but some systems K do not allow this, primarily because the BDOS routines strip the parity bit M during port i/o, and the parity bit is used for data when transmitting binary  files.  J Kermit-80's I/O routines must check the port status and go elsewhere if noI input is available; this allows for virtual terminal connection, keyboard N interruption of stuck transmissions, etc.  On systems that fully implement I/OF redirection via the optional CP/M IOBYTE facility, this may be done byI switching the IOBYTE definition.  On others, however, IN/OUT instructions > explicitly referencing the port device registers must be used.   @index<Timeout> K CP/M-80 KERMIT versions 3.8 and later include a "fuzzy timer" that allows a O timeout to occur after an interval ranging from 5 to 20 seconds (depending upon J the speed of the processor and the operating system routines) during whichI expected input does not appear at the port.  In this case, retransmission I occurs automatically.  In any case, you may type a carriage return during I transmission to simulate a timeout when the transfer appears to be stuck.   & @subsection<Organization of Kermit-80>K Kermit-80 consists of two modules, each of which is generated from multiple G source files.  The first module contains the system-@|independent code; G the second module is configured for a particular system and merged with B the system-@|independent module to produce a customized Kermit-80.   The distribution kit contains: @begin<itemize,spread 0>0 the system-@|independent module, @q<CP4KER.HEX>;  K the system-@|dependent modules, @q<CP4*.HEX> (see table @ref<-cp4systems>);    the source files, @q(CP4*.ASM),   K the DEC-10/DEC-20 cross-assembler and linker, @q<MAC80.*> and @q<LINK80.*>,   - the public-domain CP/M assembler, @q<LASM.*>,   6 the public-domain CP/M load/patch utility, @q<MLOAD.*>
 @end<itemize>   ( @begin<table,use verbatim,leftmargin +0> @bar() @blankspace(1) @u(Symbol  Filename System)  @blankspace(0.25) I AP6551  CP4APL  @r<Apple II, Z80 Softcard, 6551 ACIA in serial interface> C APMMDM  CP4APM  @r<Apple II, Z80 Softcard, Micromodem II in slot 2> 3 BBII    CP4BB2  @r<BigBoard II (terminal required)> ( BRAIN   CP4BRN  @r<Intertec SuperBrain.>L CPM3    CP4CP3  "@r<generic": CP/M 3.0 (CP/M Plus) systems (terminal req'd)>; DELPHI  CP4DEL  @r<Digicomp Delphi 100 (terminal required)> / DMII    CP4DM2  @r<DECmate II with CP/M option> O GENER   CP4GEN  @r<"Generic": CPM 2@q(.)2 systems with IOBYTE (terminal req'd)> % HEATH   CP4H89  @r<Heath/Zenith H89.> K KPII    CP4KPR  @r<Kaypro-II (and 4; probably supports all Kaypro systems)> 9 MDI     CP4MDI  @r<Morrow Decision I (terminal required)>  MIKKO   CP4MIK  @r<MikroMikko>? MMDI    CP4UDI  @r<Morrow Micro Decision I (terminal required)>  OSBRN1  CP4OSB  @r<Osborne 1> # OSI     CP4OSI  @r<Ohio Scientific>  ROBIN   CP4ROB  @r<DEC VT180> ) TELCON  CP4TEL  @r<TELCON Zorba portable> H TRS80LB CP4TLB  @r<TRS-80 model II with Lifeboat 2@q(.)25C CP/M Display>E TRS80PT CP4TPT  @r<TRS-80 model II with Pickles + Trout CP/M Display> $ VECTOR  CP4VEC  @r<Vector Graphics.>' Z100    CP4Z00  @r<Z-100 under CP/M-85>  @begin<text,facecode R,above 1> K "symbol" is the symbol used to select the target system, in @q<CP4TYP.ASM>; N "filename" is the name under which the module is supplied in the distribution.
 @end<text>( @caption<Systems supported by Kermit-80> @bar() @tag<-cp4systems>  @end<table>   " @subsection<Downloading Kermit-80>  M You'll need either a pre-configured @q<.COM> file or the system-@|independent I module, @q<CP4KER>, in binary (@q<.COM>) or hex (@q<.HEX>) format and the N system-@|dependent overlay for your system (from table @ref<-cp4systems>).  IfN your system is not listed in the table, get the generic CP/M 2@q(.)2 Kermit orK the generic CP/M 3 Kermit.  If you already have a version of Kermit on your O micro and you want to install a new version, simply use your present version to G get the new files.  Transfer the files to your system and skip ahead to  "merging the modules".  J If you do not have a copy of Kermit on your micro, and you cannot borrow aO Kermit floppy but you do have access to a mainframe computer with a copy of the 5 Kermit-80 distribution, you should read this section.   N @Index[Bootstrap]@index<Downloading> There are several ways to get Kermit from a host system to your micro.* The easiest is to "download" the necessaryB "hex" files into your micro's memory and then save it on the disk.K If you have a terminal emulator program on your micro which can save a copy K of the session to disk, connect to your host, and type the necessary files. K Exit from the emulator, saving the session log, and edit the session log to : extract the hex files.  Skip ahead to "merging the files".  > The following is a procedure which, though far from foolproof, should allow you to K get a version of Kermit to your CP/M based micro.  It depends upon the host F prompt, or at least the first character of the host prompt, being someN character that cannot appear in a hex file (the valid characters for hex filesM are the digits 0-9, the upper case letters A-F, the colon ``@q<:>'', carriage I return, and line feed).  As soon the prompt character is encountered, the H transfer will terminate.  If your host does not issue a prompt that willB accommodate this scheme, you can achieve the same effect by addingK an atsign ``@@'' to the very end of the hex file before sending it from the K host.  The program below looks for an atsign (the normal DEC-20 prompt, hex 6 40).  DECSYSTEM-10 users would look for a dot, hex 2E.   @Begin <Enumerate>B On your micro, connect to a floppy disk with plenty of free space.G Run DDT and type in the following (the comments should not be typed in; 2 they are there just to tell you what's happening): @Begin <Example,Free> % -a100			;Begin assembling code at 100 ( 0100	LXI H,2FE	;Where to store in memory! 0103	SHLD 200	;Keep pointer there  0106	MVI E,D		;Get a CR - 0108	MVI C,4		;Output to PUNCH {send to HOST}  010A	CALL 5 1 010D	MVI C,3		;Input from READER {read from HOST}  010F	CALL 5  0112	ANI 7F		;Strip parity bit 0114	PUSH PSW	;save a and flags & 0115	MOV E,A		;move char to e for echo 0116	MVI C,2		;Output to screen  0118	CALL 5 " 011B	POP PSW		;restore a and flags& 011C	CPI 40		;Is it our DEC-20 prompt?, 011E	JZ 127		;Yes, have whole file in memory& 0121	CALL 17A	;no , store another byte  0124	JMP 10D		;read another byte. 0127	MVI A,1A	;Get a Control-Z {CP/M EOF mark}! 0129	CALL 17A	;store it in memory " 012C	LXI H,300	;Get memory pointer# 012F	SHLD 202	;Store as DMA pointer . 0132	LDA 201		;Get 'HI' byte of memory pointer' 0135	STA 200		;and store it as 'LO' one 
 0138	XRA A) 0139	STA 201		;Zero 'HI' byte {slow *256}  013C	MVI C,16	;Make NEW file 013E	LXI D,5C	;With FCB1 0141	CALL 5 ' 0144	CALL 15E	;Write 128 bytes {sector} # 0147	CALL 15E	;Write another sector ' 014A	LXI H,FFFF	;Get a 16-bit Minus One  014D	XCHG		;into DE # 014E	LHLD 200	;Get 256-byte counter  0151	DAD D		;decrement 0152	SHLD 200	;and store back  0155	MVI A,2		;Check if - 0157	CMP L		; 256-byte counter down to offset  0158	JZ 183		;Yes, wer'e done  015B	JMP 144		;Keep writing..  015E	LHLD 202	;Get file-pointer  0161	XCHG		;into DE  0162	MVI C,1A	;Set DMA-address 0164	CALL 5 ' 0167	MVI C,15	;Write sector {128 bytes}  0169	LXI D,5C	;using FCB1  016C	CALL 5  016F	LHLD 202	;Get file-pointer  0172	LXI D,80	;128-bytes" 0175	DAD D		;added to file-pointer 0176	SHLD 202	;and save  0179	RET		;and return ! 017A	LHLD 200	;Get Memory-pointer  017D	MOV M,A		;store character 017E	INX H		;Increment Pointer 017F	SHLD 200	;and save  0182	RET		;and return  0183	MVI C,10	;CLOSE file  0185	LXI D,5C	;using FCB1  0188	CALL 5  018B	JMP 0		;Force WARM BOOT
 @End<Example>   O Connect to your host using a terminal or a terminal emulation facility.  Ensure O that your host does not have your terminal in "page mode".  E.g. on the DEC-20, 8 give the Exec command @q<TERMINAL NO PAUSE END-OF-PAGE>.  K Tell the host to display the first hex file (the system-independent module) & at your terminal.  E.g. on the DEC-20,G give the Exec command @q<TYPE CP4KER.HEX>, @i<@u(without) a terminating  carriage return>.    Return to your micro. L Make sure your IOBYTE is set so that @q<RDR:> and @q<PUN:> correspond to theI I/O port that is connected to the DEC-20 (this would normally be the case 9 unless you have done something special to change things). N Load the program you entered in the first step with DDT, and use it to capture the first hex file:  @Begin<Example,Free>
 DDT FETCH.COM 7 -icp4ker.hex            ;Setup FCB for file CP4KER.HEX. - -g100,179               ;Execute the program. 
 @End<Example> B  Now there should be a file @q<CP4KER.HEX> on your connected disk.  C Return to the host, and tell it to display the second hex file (the J system-@|dependent module for your configuration).  Again, do not type the terminating carraige return.  8 Return to your micro, and run the capture program again: @Begin<Example,Free>
 DDT FETCH.COM 7 -icp4ovl.hex            ;Setup FCB to create CP4OVL.HEX - -g100,179               ;Execute the program. 
 @End<Example> B  Now there should be a file @q<CP4OVL.HEX> on your connected disk. @end<enumerate>  Merging the files: @begin<enumerate> N For purposes of illustration, we will assume the system-@|dependent overlay isN called "cp4ovl@q<.>hex".  The two hex files may be combined with MLOAD or DDT.L If you already have a running Kermit, you can transfer @q<MLOAD.HEX> to yourI system and create @q<MLOAD.COM> by running LOAD.  If you're bootstrapping L Kermit, you could transfer @q<MLOAD.HEX> to your system the same way you gotI the other two @q<.HEX> files, but it's probably simpler to use DDT to get 3 Kermit running, and get MLOAD later if you need it.   1 Using MLOAD, the two pieces may be easily merged:  @begin<example> # A>@ux(mload kermit40=cp4ker,cp4ovl) ( [some messages about program size, etc.] A>
 @end<example>   9 If you don't have MLOAD running, it's a bit more complex:  @begin<example>  A>@ux<ddt cp4ker.hex>  NEXT  PC	 3500 0100  -@ux<icp4ovl.hex>  -@ux<r>  NEXT  PC	 xxxx 0000  -@ux<^C> A>@ux<save @i(dd) kermit40.com> 
 @end<example> J The page count ("dd") used in the SAVE command is calculated from the lastM address ("xxxx") given by DDT in response to the R command: drop the last two O digits and add 1 if they were not zero, then convert from hexadecimal (base 16) O to decimal (base 10): 384F becomes 39 hex, which is 57 decimal (3 times 16 plus O 9) -- but 3700 becomes 37 hex, or 55 decimal (consult an introductory computing 5 book if you don't understand number base conversion).   H Note that CP/M hex files have checksums on each line.  If there were anyN transmission errors during the downloading process, MLOAD or DDT will notice aL bad checksum and will report an error (something like "Illegal Format").  IfJ you get any errors during loading, either fix the hex file locally with an editor, or repeat the transfer.    @End<Enumerate>   L You now should have a running version of Kermit-80, called @q<KERMIT40.COM>.  J Test your new Kermit by running it.  If it gives you a prompt, it might beK OK. (don't delete your old one yet...).  Instead of a prompt, you could get M one of two messages indicating that the configuration information is invalid: = @example<?Kermit has not been configured for a target system>  or4 @example<?Consistency check on configuration failed>L Of course, neither of these messages should appear if you're building KermitL from the distribution kit.  The first message indicates that the overlay wasM not found where the system-@|independent module expected to find it, probably O because the overlay address is incorrect; the second indicates that the version H of CP4LNK used in the system-@|dependent module is incompatible with the system-@|independent module.  L Once you are satisfied that KERMIT40 works correctly, you should rename yourF old @q<KERMIT.COM> to something else, like @q<OKERMIT.COM>, and rename# @q<KERMIT40.COM> to @q(KERMIT.COM).   2 @subsection<Assembling Kermit-80 from the sources>  = Kermit-80 is built in two pieces from the following 12 files:  @begin<description,spread 0>! @i(The system-independent files:)    @q<@ @ CP4KER.ASM>@\header file   : @q<@ @ CP4DEF.ASM>@\definitions for both KERMIT and KERSYS  E @q<@ @ CP4MIT.ASM>@\initialization, main loop, miscellaneous commands 0 (BYE, EXIT, LOG, SET, SHOW, STATUS, and VERSION)  G @q<@ @ CP4PKT.ASM>@\the KERMIT protocol handler (SEND, RECEIVE, LOGOUT,  and FINISH commands)  @ @q<@ @ CP4TT.ASM>@\ the transparent commands (TRANSMIT, CONNECT)  , @q<@ @ CP4CPM.ASM>@\CP/M commands (DIR, ERA)  ( @q<@ @ CP4WLD.ASM>@\the wildcard handler  & @q<@ @ CP4CMD.ASM>@\the command parser  - @q<@ @ CP4UTL.ASM>@\utility routines and data   , @q<@ @ CP4LNK.ASM>@\linkage area description   @blankspace(1) @i(The system-dependent files:)   $ @q<@ @ CP4TYP.ASM>@\system selection  ( @q<@ @ CP4SYS.ASM>@\system-specific code @end<description>   N The system-@|independent module contains all of the system-@|independent filesI except for @q(CP4LNK.ASM), which is assembled into the system-@|dependent G module to provide the structures needed to connect the two modules.  As M distributed, the system-@|independent module is named @q(CP4KER.HEX).  If you @ have a copy of @q(CP4KER.HEX), you do not need to reassemble the@ system-@|independent module to configure Kermit for your system.  I The system-@|dependent module consists of @Q(CP4TYP.ASM), @Q(CP4DEF.ASM), N @Q(CP4LNK.ASM), and @Q(CP4SYS.ASM).  One copy of the system-@|dependent moduleL is supplied already assembled for each supported system; the filename may be& obtained from table @ref<-cp4systems>.  I After assembling the two pieces separately, they are combined with DDT or & MLOAD into a system-@|specific Kermit.  K If you want to rebuild the system-@|independent module, the only change you J may need to make is to select the assembler to be used, in @Q(CP4KER.ASM).H Define one of MAC80, M80, or LASM to TRUE to select it as the assembler;# the others should be defined FALSE.   I Assuming you have the Microsoft Macro Assembler package (M80/L80), you'll  need to do the following:  @begin<example>  A>@ux(m80 cp4ker=cp4ker.asm)# A>@ux(l80 /p:100,cp4ker,cp4ker/n/e) 
 @end<example> ! This will produce @Q(CP4KER.COM).   ' If you are using LASM instead, do this:  @example(A>@ux<lasm cp4ker>)M LASM will generate @Q(CP4KER.HEX) and @Q(CP4KER.PRN).  LASM allows options to L be specified in the same way as the standard assembler, ASM, so the command   @example[A>@ux(lasm cp4ker.abz)]K will read the source files from drive A, send the @q(.HEX) file to drive B,  and suppress the listing file.  I If you have access to a TOPS-10 or TOPS-20 system, you can cross-assemble . Kermit there with MAC80, producing CP4KER.HEX: @begin<example>  .@ux(run mac80)  *@ux(=cp4ker.asm) 
 @end<example>   M If you want to generate a system-@|dependent overlay for a particular system, M or want to change the terminal supported, you'll need to check three areas in  @Q(CP4TYP.ASM):   H First, the overlay start ADDRESS.  The symbol "ovladr" is EQUated to theO address of "LNKFLG" in the system-@|independent module, as the starting address L of the overlay (3400H for version @value(-cp4version)).  You'll need to knowK this value if you're building the overlay with M80/L80.  You won't normally  need to change this value.  L Second, the assembler being used.  Again, define one of MAC80, M80, and LASML to be TRUE to select it, and define the others to be FALSE.  The two modulesN (system-@|independent and system-@|dependent) do not need to be built with the same assembler.   = Third, the system configuration.  Locate your system in table O @ref<-cp4systems>, then define the appropriate symbol TRUE, and the rest FALSE. L If the system comes with a builtin console terminal, define all the terminalO switches FALSE.  If the system uses an external terminal as the console, locate M the terminal in table @ref<-cp4terms> and define the appropriate symbol TRUE, @ and the remainder FALSE.  If the terminal is not listed in tableH @ref<-cp4terms>, use the CRT switch; in this case, VT52 emulation is not
 supported.  L In addition, there are a few general and system-@|specific symbols which may be altered to fit your system:   @begin<description> L APSLOT@\For Apple with 6551 ACIA, defines the slot number of the serial card  L CPUSPD@\Processor speed in units of 100KHz (currently used only for bbII and         kpII for timing loops)  G TAC@\For users connecting through ARPAnet TACs: set to TRUE if you wish I         the default TACTRAP status to be ON. (This may be overridden with J         the SET TACTRAP command).  If you're not connecting through a TAC,+         set tac to FALSE and ignore tacval.   J TACVAL@\For ARPANET TAC users: defines the default TAC intercept character8         (may be overridden with the SET TACTRAP command) @end<description>   I If you are just assembling an existing configuration, you'll need to edit L @Q(CP4TYP.ASM) only.  If you are adding support for a new system, you shouldM not modify @Q(CP4DEF.ASM) or @Q(CP4LNK.ASM); if you do, you'll have to change J the system-@| independent module also.  Eventually, @Q(CP4SYS.ASM) will beJ split into separate files, each of which will generate one or more relatedO systems.  When this happens, you'll want to pick the one closest to your system  to use as a starting point.   K After editing @q<CP4TYP.ASM> as necessary, assemble and link the overlay as 	 follows:   @begin<itemize> G With M80 (where "xxxx" is the hex value of ovladr from @q<CP4LNK.ASM>):  @begin<example>  A>@ux<m80 cp4typ=cp4typ.asm>& A>@ux<l80 /p:xxxx,cp4typ,cp4typ/n/x/e>
 @end<example>   
 With LASM: @begin<example>  A>@ux<lasm cp4typ>
 @end<example>    With MAC80 on TOPS-10: @begin<example>  .@ux<run mac80>  *@ux<=cp4typ.asm> 
 @end<example>    With MAC80 on TOPS-20: @begin<example>  @@@ux<run mac80> *@ux<=cp4typ.asm> 
 @end<example> 
 @end<itemize>   M The overlay (@Q(cp4typ.hex)) may then be merged with the system-@|independent K module as described above (creating a runnable Kermit from the distribution  kit).   B If you have a TOPS-10 or TOPS-20 system and already have a runningM Kermit-80 v3.9 or later, you can merge the two @q<.HEX> files into a @q<.COM> O file with LINK80, and transfer the new @q<.COM> file to your micro with Kermit:  @begin<itemize>  Tops-10: @begin<example> + .@ux<copy kernew.hex=cp4ker.hex,cp4typ.hex>  .@ux<link80 kernew> 
 @end<example>    Tops-20: @begin<example> 3 @@@ux<append cp4ker.hex,cp4typ.hex (to) kernew.hex>  @@@ux<link80 kernew>
 @end<example> 
 @end<itemize> K producing @Q(KERNEW.COM).  If LINK80 says "?Data overlaid", you have an old L version of LINK80, and will have to transfer the @Q(.HEX) files to the micro and merge them there.   & @begin<table,leftmargin +0,use format> @tabclear()@tabset(1.5in)  @bar() @blankspace(1)% @u(Symbol)@\@ux<Terminal description> % crt@\Basic CRT, no cursor positioning ! adm3a@\ADM3A Display or lookalike  smrtvd@\Netronics Smartvid-80  tvi925@\TVI925, Freedom 100 8 vt52@\VT52 or VT52 emulator such as Heath H19, H29, etc.: vt100@\VT100 or emulator (most ANSI terminals should work)& @caption<Terminals known to Kermit-80> @tag<-cp4terms>  @bar() @end<table>   ) @section<Adding Support For A New System> L Kermit-80 is built from a common set of source files; the system-@|dependentI module makes heavy use of conditional assembly (this complication will be L removed in future releases).  The system dependencies arise from attempts to answer some questions: @begin<enumerate> - @i<What kind of terminal is to be supported?>  @blankspace(1)C For many micros, the console is an integral part of the system, but B others can use an external terminal.  In either case, the commandsE to manipulate the screen (position the curser, erase the screen, etc)  must be defined.  $ @i<How is the serial line accessed?> @blankspace(1)D For systems supporting the IOBYTE function, this is straightforward;# the symbol "IOBYT" is defined TRUE. ? If the serial line is accessed with IN and OUT instructions, it G may be possible to use the simple I/O routines provided.  In this case, E the symbol "INOUT" is defined TRUE, the MNPORT and MNPRTS are defined E to be the data and control addresses, respectively, and bit masks for D testing for "input data available" and "output buffer empty" must be defined.D If the interface is strange, leave IOBYT and INOUT set to FALSE, and provide the I/O routines.   % @i<What initialization is necessary?>  @blankspace(1)A You may wish to set the baud rate or configure the serial line at 7 startup.  Examples for a number of devices are present.   . @i<What special features are to be supported?> @blankspace(1)? You may want to provide the capability to select one of several A serial lines with the SET PORT command, or to change the speed of C the serial line with the SET BAUD-RATE command.  To do this, you'll B need to build a command table, using the systems already supported as examples.A The ability to send a BREAK signal is desirable.  Again, examples > for several different interfaces (ACIA, SIO, etc) are present. @end<enumerate>   6 @section<Notes on New Features in Kermit-80 Version 4>   @i(Debugging aids:) N SET DEBUG ON will add two fields to the SEND/RECEIVE display, labelled "Spack"O and "Rpack".  These display the last packet sent and received.  Of course, this K slows down the transfer, especially if the console is an external terminal. # SET DEBUG OFF removes these fields. L The VERSION command displays the name, edit number, and edit date of several# of the modules that make up Kermit.    @index<ARPAnet>@index<TAC>6 @index<Attention Character>@index<Intercept Character>K @i(TAC support:) ARPAnet TACs (and many other communication devices such as I terminal concentrators, modems, port contention units, network PADs, etc) . use a printing character (normally "@@") as anL intercept character, to allow commands to be issued to the TAC.  In order toN send this character to the host, it must be typed twice.  The command "SET TACM CHARACTER" to Kermit enables the TACtrap and asks the user to specify the TAC J intercept character.  This character will be automatically doubled when itM appears in Kermit protocol messages (sent by the SEND or RECEIVE commands) or J when it appears in a file being sent with the TRANSMIT command.  It is notK automatically doubled when typed by the user in CONNECT mode.  "SET TAC ON" M enables the TACtrap but does not change the TAC intercept character, which is K initially "@@".  "SET TAC OFF" disables the TACtrap.  (These comments apply M equally to any communication device that uses a printable attention character ' which it will pass through if doubled.)    @i(File buffering:) M Previous versions of Kermit-80 buffered only one sector (128 bytes) at a time J during file transfer operations.  This version buffers 16Kbytes at a time,K reducing the number of times the floppy drive must be spun up and down, and N increasing the effective throughput of the link.  If the disk transfer rate isN too slow, howver, the remote Kermit may time out and retransmit packets.  ThisM will show up on the screen in the "Retries:" field; if this occurs after disk M activity, you may want to increase the timeout value on the remote Kermit, or L reassemble Kermit with a smaller value for MAXSEC (in @Q(CP4SYS.ASM)).  ThisL buffer is also used by the TRANSMIT command; the log file enabled by the LOG, command is still written a sector at a time.   @section<Future Work>   7 Work that needs to be done in future releases includes:  @begin<itemize> G Merge in support for additional CP/M-80 systems, particularly those for ? which support was recently added to the monolithic v3.x source.   D Break up @q<CP4SYS> into discrete source files, one for each system.G These source files should serve as simple models for adding support for J new systems to Kermit-80 -- only the very basic screen definitions, flags,C i/o primitives, initializations, and so forth should appear in each  system-@|dependent file.  F Make the file-stepping mechanism faster (buffer the FCB's in chunks ofJ 16 or 32 or 64).  Currently, to access the @i<n>@+(th) file in a directory requires n(n+1)/2 lookups...  I Addition of missing features -- compression of repeated characters during K packet transmission, transmission of file attributes (particularly size, so K that "percent done" can be displayed for both incoming and outbound files), I advanced commands for servers (REMOTE DIRECTORY, etc), command macros and O initialization files, login scripts, remote operation and server mode, etc etc. 
 @end<itemize> 