M /* Version 0.8(7) - Jim Noble at Planning Research Corporation, June 1987. */ 4 /* Ported to Megamax native Macintosh C compiler. */   /*  * CKMKEY.C   *H  * Key-Config is a keyboard configurator program for use with Columbia's
  * MacKermit.   *  * Bill Schilit, April 1985   *  *E  * Copyright (C) 1985, Trustees of Columbia University in the City of G  * New York.  Permission is granted to any individual or institution to E  * use, copy, or redistribute this software so long as it is not sold :  * for profit, provided this copyright notice is retained.  *  */    #include "ckcsym.h"    #if MEGAMAX  #include <control.h> #include <dialog.h>  #include <event.h> #include <file.h>  #include <mem.h> #include <menu.h>  #include <pack.h>  #include <qdvars.h>  #include <res.h> #endif  
 #ifdef SUMACC 3 #include "mac/quickdraw.h"		/* order does matter */ , #include "mac/osintf.h"			/*  on these... */ #include "mac/toolintf.h"  #include "mac/packintf.h"  #endif  9 #include "ckmsys.h"			/* Compiler specific definitions */  #include "ckmkey.h"  #include "ckmkkc.h"    KSHDL kshdl; SFReply sfr;				/* global... */   / char kermtype[] = "KERM";		/* Used as OsType */ / char texttype[] = "TEXT";		/* Used as OsType */ 	 int quit;    MenuHandle menus[MAX_MENU+1];    char MSET_TYPE[] = "MSET",      FSET_TYPE[] = "FSET",      KSET_TYPE[] = "KSET",+      *FSET_NAME = {"Kermit function keys"}, -      *MSET_NAME = {"Kermit meta key prefix"}, "      *KSET_NAME = {"Kermit Keys"};  4 BOOLEAN modified;				/* if changes have been made */    : /* gethdl - return a control handle given a resource ID */   Handle gethdl(item,dp)
 DialogPtr dp;  {   INTEGER itype;   Rect ibox; 
  Handle ihdl;   &  GetDItem(dp,item,&itype,&ihdl,&ibox);  return(ihdl); }        E /* mapkey - accepts a scan code plus modifier bits and translate this B  *    	    into an 8 bit ascii character using the KSET in ourkey.  */   + #define LC_IDX 0			/* use lower case map */ + #define UC_IDX 1			/* use upper case map */   % CHAR mapkey(scode,mods,ismeta,isfkey)  CHAR scode; 
 INTEGER mods;  BOOLEAN *ismeta,*isfkey; { *  CHAR c;				/* returned char (unsigned) *//  int casidx = LC_IDX;			/* assume lower case */   $  if (scode < 0 || scode > MAX_SCODE)-   printerr("Scan code not in range: ",scode);   .  if (mods & shiftKey)			/* shift depressed? */8   casidx = UC_IDX;			/* yes, select an upper case map */  /  if (mods & (*kshdl)->ctrlmods)		/* control? */ E    c = (*kshdl)->ctrlmap[casidx][scode];	/* yes, use control table */   else >    if (mods & (*kshdl)->caplmods)		/* else is it caps lock? */J      c = (*kshdl)->caplmap[casidx][scode]; /*  yes, use caps lock table */    else O      c = (*kshdl)->normmap[casidx][scode]; /*  else it is a normal character */   ?  *ismeta = (mods & (*kshdl)->metamods) ? 	/* tell about meta */        	    TRUE : FALSE;		;  *isfkey = (c & FKEYBIT) ? 		/* tell about function keys */        	    TRUE : FALSE;		7  return(c & ~FKEYBIT);			/* and return the character */  }      F /* setmapkey - given a scan code, modifiers, and an 8 bit value, storeF  *    	       the value in the appropriate cell of our KSET (ourkset).  */    setmapkey(val,scode,mods) , CHAR val,scode;				/* 8-bit unsigned char */
 INTEGER mods;  {   int casidx = LC_IDX;   $  if (scode < 0 || scode > MAX_SCODE)-   printerr("Scan code not in range: ",scode);   .  if (mods & shiftKey)			/* shift depressed? */8   casidx = UC_IDX;			/* yes, select an upper case map */  /  if (mods & (*kshdl)->ctrlmods)		/* control? */ G    (*kshdl)->ctrlmap[casidx][scode] = val; /* yes, use control table */   else >    if (mods & (*kshdl)->caplmods)		/* else is it caps lock? */L      (*kshdl)->caplmap[casidx][scode] = val; /*  yes, use caps lock table */    else Q      (*kshdl)->normmap[casidx][scode] = val; /*  else it is a normal character */  }   
 printerr(s,n)  char *s;
 INTEGER n; {   char num[10];    if (n != 0)  {   NumToString((LONGINT) n,num);    ParamText(s,num,"","");   }  else    ParamText(s,"","","");   CautionAlert(OUR_ALRT,NILPROC); }        
 fatal(s,n) char *s; {    printerr(s,n);   ExitToShell(); }     . /* support routines for modifier key dialog */  $ #define NILCLS 0			/* classes...  */# #define OPTCLS 1			/*  optionKey */   #define CMDCLS 2			/*  cmdKey */# #define KLKCLS 3			/*  alphaLock */    INTEGER 
     normjunk, 
     caplbits, 
     ctrlbits, 
     metabits;   + /* restb - table for table driven dialog */    struct restb {	   INTEGER      rid;   int      rclass;				/* class */	   INTEGER '     *rcell,				/* location of "home" */ .     rbitv;				/* bit value (alphaKey, etc.) */   ControlHandle )     rhdl;				/* handle to this control */  } rsmktb[] = { 2   {RSMK_OPTNORM, OPTCLS, &normjunk, 0,		NILCTRL}, 9   {RSMK_OPTCTRL, OPTCLS, &ctrlbits, optionKey,	NILCTRL},  9   {RSMK_OPTCAPS, OPTCLS, &caplbits, optionKey,	NILCTRL},  9   {RSMK_OPTMETA, NILCLS, &metabits, optionKey,	NILCTRL},  2   {RSMK_CMDNORM, CMDCLS, &normjunk, 0,		NILCTRL}, 6   {RSMK_CMDCTRL, CMDCLS, &ctrlbits, cmdKey,	NILCTRL}, 6   {RSMK_CMDCAPS, CMDCLS, &caplbits, cmdKey,	NILCTRL}, 6   {RSMK_CMDMETA, NILCLS, &metabits, cmdKey,	NILCTRL}, 2   {RSMK_KLKNORM, KLKCLS, &normjunk, 0,		NILCTRL}, 9   {RSMK_KLKCTRL, KLKCLS, &ctrlbits, alphaLock,	NILCTRL},  9   {RSMK_KLKCAPS, KLKCLS, &caplbits, alphaLock,	NILCTRL},  7   {RSMK_KLKMETA, NILCLS, &metabits, alphaLock,	NILCTRL}  };  4 #define RSMKZ (sizeof (rsmktb)/sizeof(struct restb))   Handle getdlghdl(dp,rid)
 DialogPtr dp;  {   INTEGER itemtype;  Rect itembox;  Handle itemhdl;    .  GetDItem(dp,rid,&itemtype,&itemhdl,&itembox);  return(itemhdl);  }     @ /* rmskinit - initialize "set modifier key" dialog, find control<  *    	      handles for each item, hilite "normal" for each:  *    	      class and then re-hilite any actual settings.  */    rsmkinit(dp)
 DialogPtr dp;  {   int r;      caplbits = (*kshdl)->caplmods;   metabits = (*kshdl)->metamods;   ctrlbits = (*kshdl)->ctrlmods;      for (r=0; r < RSMKZ; r++)?   rsmktb[r].rhdl = (ControlHandle) getdlghdl(dp,rsmktb[r].rid);     rsmksetcls(RSMK_OPTNORM);  rsmksetcls(RSMK_KLKNORM);  rsmksetcls(RSMK_CMDNORM);    for (r=0; r < RSMKZ; r++))   if (rsmktb[r].rbitv & *rsmktb[r].rcell)     rsmksetcls(rsmktb[r].rid);  }   C /* rsmkfinish - finish up "set modifier key" dialog.  Store results   *    	      	into cells  */    rsmkfinish() {   int r;   $  metabits = caplbits = ctrlbits = 0;    for (r=0; r < RSMKZ; r++)"   if (GetCtlValue(rsmktb[r].rhdl))=    *rsmktb[r].rcell |= rsmktb[r].rbitv;	/* turn on the bit */     (*kshdl)->metamods = metabits;   (*kshdl)->caplmods = caplbits;   (*kshdl)->ctrlmods = ctrlbits;  }     rsmksetcls(item)
 INTEGER item;  {   int r,cls;   0  for (r=0; r < RSMKZ; r++)		/* find the class */   if (rsmktb[r].rid == item)   {     cls = rsmktb[r].rclass;    %    if (cls == NILCLS)			/* toggle? */ =     SetCtlValue(rsmktb[r].rhdl,!GetCtlValue(rsmktb[r].rhdl));     else &     SetCtlValue(rsmktb[r].rhdl,btnOn);	    break;    }      ;  if (cls != NILCLS)			/* if there is a class (skip meta) */    for (r=0; r < RSMKZ; r++) 8    if (rsmktb[r].rid != item && rsmktb[r].rclass == cls)'     SetCtlValue(rsmktb[r].rhdl,btnOff);  }    metaradios(use8,dlg)
 BOOLEAN use8;  DialogPtr dlg; { A   SetCtlValue(getctlhdl(RSMK_M8BIT,dlg),(use8) ? btnOn : btnOff); A   SetCtlValue(getctlhdl(RSMK_MPREF,dlg),(use8) ? btnOff : btnOn);  }    BOOLEAN metafinish(use8,dlg)
 BOOLEAN use8;  DialogPtr dlg; {    char mtxt[256];    Handle mhdl;   LONGINT l;   INTEGER sb,se;  C   GetIText(gethdl(RSMK_METXT,dlg),mtxt); /* get meta text itself */    '   if (use8)				/* want to use 8 bit? */ 8     l = mtxt[0] = 0;			/* yes, use zero length string */*   else {				/* else check out meta text */@     if (!chkcodestr(mtxt,&sb,&se)) {  	/* error in backslash? */E       SelIText(dlg,RSMK_METXT,sb,se); 	/* yes, set selection range */ #       SysBeep(2);			/* tell them */ 1       return(FALSE);			/* and indicate failure */      } ;     l = decodestr(mtxt);		/* decode in place, get length */    }    :   (*kshdl)->meta8bit = use8;		/* update boolean */        ;   mhdl = (*kshdl)->metahdl;		/* get old meta text handle */ 2   DisposHandle(mhdl);			/* rid old handle */      :   mhdl = NewHandle(l+1);		/* string size plus size byte */3   BlockMove(mtxt,*mhdl,l+1);		/* copy the string */ &   return(TRUE);				/* and return ok */ }     dosetmkdialog()  {   INTEGER itemhit;   BOOLEAN m8bit;   DialogPtr dlg; 
  Handle mhdl;   char *mstr,*encodestr();   5  dlg = GetNewDialog(DLOG_RSMK,NILPTR,(WindowPtr) -1);   1  mhdl = (*kshdl)->metahdl;		/* get meta string */ '  HLock(mhdl);				/* prevent movement */ *  mstr = encodestr(*mhdl);		/* encode it */   HUnlock(mhdl);				/* unlock */ 4  SetIText(gethdl(RSMK_METXT,dlg),mstr); /* set it */+  DisposPtr(mstr);			/* no longer needed */    &  rsmkinit(dlg);				/* init settings */   9  m8bit = (*kshdl)->meta8bit;		/* get 8 bit quote value */ 0  metaradios(m8bit,dlg);			/* init radio items */     ShowWindow(dlg);    for (;;) {"     ModalDialog(NILPROC,&itemhit);     switch (itemhit) {      case RSMK_OK:6        if (!metafinish(m8bit,dlg))	/* do meta stuff */(          break;				/* format error... */3        modified = TRUE;			/* things have changed */ )        rsmkfinish();			/* store values */         case RSMK_CANCEL:        DisposDialog(dlg);         return;               case RSMK_M8BIT:       case RSMK_MPREF: &       m8bit = (itemhit == RSMK_M8BIT);       metaradios(m8bit,dlg);       break;  
      default: .        rsmksetcls(itemhit);		/* set buttons */
        break;      }    }  }     > /* privrsrc - return a private copy of a resource.  The handle7  *    	      returned is relocatable but non purgeable.   *  */    Handle privrsrc(type,id,name)  ResType *type; char *name;  {    Handle rhdl,phdl;    char errbuf[256];    LONGINT l;  7   rhdl = GetResource(type,id);		/* load the resource */ +   if (rhdl == (Handle) NIL)		/* nothing? */    { #     strcpy(errbuf,"There are no ");      strcat(errbuf,name);9     strcat(errbuf," of the known version in this file.");      printerr(errbuf,0); 9     return((Handle) NIL);		/* then return now with NIL */    }   3   HLock(rhdl);				/* make sure rsrc stays around */ K   phdl = NewHandle(l = SizeResource(rhdl)); /* get new relocatable block */ +   HLock(phdl);				/* lock new block also */ B   BlockMove(*rhdl,*phdl,l);		/* copy from resource to new block */3   HUnlock(rhdl);			/* rsrc lock no longer needed */ 8   ReleaseResource(rhdl);		/* rsrc completely gone now */2   HNoPurge(phdl);			/* keep new block in memory */,   HUnlock(phdl);			/* but can move around */!   return(phdl);				/* all done */    SYM(PRIVRESOURCE); }    KSHDL loadkset() {   Handle fhdl,mhdl;  KSHDL khdl;  4  khdl = (KSHDL) privrsrc(KSET_TYPE,KSVER,KSET_NAME);  if (khdl == (KSHDL) NIL)    return((KSHDL) NIL);  ,  fhdl = privrsrc(FSET_TYPE,KSVER,FSET_NAME);  if (fhdl == (Handle) NIL)   return((KSHDL) NIL);  A  (*khdl)->fcnshdl = fhdl;		/* save handle to relocatable block */    ,  mhdl = privrsrc(MSET_TYPE,KSVER,MSET_NAME);  if (mhdl == (Handle) NIL)   return((KSHDL) NIL);   ,  (*khdl)->metahdl = mhdl;		/* save handle */  .  return(khdl);				/* return the KSET handle */  SYM(LOADKSET);  }    /*#  * initmenus - create the menu bar.   *    */    initmenus()  {    int i;  :   for (i=MIN_MENU; i<=MAX_MENU; i++)  	/* For all menus */   { =     menus[i] = GetMenu(i);		/* Fetch it from resource file */ 6     InsertMenu(menus[i],0);		/* Put it on menu line */   } 8   DrawMenuBar();			/* Finish up by displaying the bar */	   return;    SYM(INITMENUS);  }      addrsrc(type,id,hdl,str) ResType *type;
 char *str; Handle hdl;  {    Handle rhdl;  9   rhdl = GetResource(type,id);		/* check for old value */ .   if (rhdl != NULL) {			/* something there? */3     RmveResource(rhdl);			/* yes, then delete it */      if (ResError() != noErr)"       return(!syserr(ResError()));   }       AddResource(hdl,type,id,str); 7   return(!syserr(ResError()));		/* return TRUE if ok */  }      < /* kfilefilter - match creator "KERM" from sfgetfile call */   #if MEGAMAX  pascal BOOLEAN kfilefilter(PB)  FILEPARAM *PB; #endif  
 #ifdef SUMACC 
 kfilefilter()  #endif   {  #if MEGAMAX   BOOLEAN RETVAL; #endif  
 #ifdef SUMACC /  FILEPARAM *pb;				/* args from SFGetFile... */   BOOLEAN *retval;    #define PB		pb #define RETVAL		*retval    8  retval = (BOOLEAN *) getpargs(&pb,sizeof(FILEPARAM *)); #endif  ;  RETVAL = (strncmp(			/* compare creator's... and return */ E       TYPE_ADDR PB->IOFLFNDRINFO.fdCreator, /* TRUE if not a match */ =       kermtype,4) != 0);		/* FALSE otherwise for inclusion */  #if MEGAMAX   return RETVAL;  #endif  SYM(KFILEFILTER);       }    savevals(fname,fvol) char *fname;
 INTEGER fvol;  {    INTEGER rfnum;  )   SetVol(NILPTR,fvol);			/* set volume */   .   rfnum = OpenResFile(fname);	/* open it up */%   if (rfnum == -1)			/* could not? */    { ,     syserr(ResError());			/* handle error */     return;				/* and return */    }   ;   if (addrsrc(MSET_TYPE,KSVER,(*kshdl)->metahdl,MSET_NAME)) =     if (addrsrc(FSET_TYPE,KSVER,(*kshdl)->fcnshdl,FSET_NAME)) :       (addrsrc(KSET_TYPE,KSVER,(Handle) kshdl,KSET_NAME));      CloseResFile(rfnum);.   if (syserr(ResError()))		/* error occured */
    return;     0   FlushVol(NILPTR,fvol);		/* flush the volume */   5   rfnum = OpenResFile(fname); 		/* reopen the file */ "   if (rfnum == -1)			/* unable? */   {      syserr(ResError());      return;    } 0   kshdl = loadkset();			/* load in files KSET */-   CloseResFile(rfnum);			/* close the file */ $   if (kshdl == NIL)			/* problems */)    fatal("Unable to reload key defs!",0);    .   modified = FALSE;			/* no longer modified */	   return;    SYM(SAVEVALS); }       
 loadvals() {    Point where;   INTEGER rfnum;     SetPt(&where,75,115); *   SFGetFile(&where,"Load variables from:",0       	    kfilefilter,1,texttype,NILPROC,&sfr);-   if (!sfr.good)			/* did they hit cancel? */ ,    return(FALSE);			/* yes, so return now */  
 #ifdef SUMACC    PTOCSTR (sfr.fName); #endif   1   SetVol(NILPTR,sfr.vRefNum);		/* setup volume */ 8   rfnum = OpenResFile(sfr.fName); /* open up the file */"   if (rfnum == -1)			/* unable? */      return(!syserr(ResError()));0   kshdl = loadkset();			/* load in files KSET */-   CloseResFile(rfnum);			/* close the file */    if (kshdl == (KSHDL) NIL)     return(FALSE);    else    return(TRUE);   SYM(LOADVALS); }      /*  C  * aboutme - Display the about KCONFIG dialog box, wait for user to D  *     	     hit the OK button (maybe this should be a mouse click).  *E  * The KCONFIG version string is stored in the resource fork as type  C  * "KERK" ID 0 -- load this resource into memory, and lock it.  The A  * resource is locked so that we won't go off the deep end if the C  * heap gets compacted during the dialog display.  This would cause E  * problems because we are using the de-referenced handle, the actual ;  * location of the string and not a pointer (handle) to it.   *  */   	 aboutme()  {    Handle kversion;6   static char ktype[] = "KERK";		/* Used as ResType */'   DialogPtr kdialog;			/* our dialog */   @   kversion = GetResource(ktype,0);	/* get version information */1   LoadResource(kversion);		/* make sure loaded */ +   HLock(kversion);			/* prevent movement */ 1   PTOCSTR(*kversion);			/* convert to C string */ C   ParamText(*kversion,"","","");	/* set it up for display via ^0 */ 6   CTOPSTR(*kversion);			/* convert to Pascal string */# 					/*  de-reference the handle */ 8   kdialog = GetNewDialog(ABOUTID,NILPTR,(WindowPtr) -1);:   ShowWindow(kdialog);			/* in case hidden or something */.   DrawDialog(kdialog);			/* draw the dialog */,   while (!Button());			/* wait for button */2   DisposDialog(kdialog);		/* dispose dialog box */0   HUnlock(kversion);			/* undo previous HLock */4   ReleaseResource(kversion);		/* no longer needed */ }   ' /* maybesave - enter maybe save dialog.   *D  * Pass the name of the operation which will zap things, for exampleD  * "quitting" or "opening" and we'll tell the user about the pendingD  * doom of changes if they've occured.  We return TRUE if user wants  * to proceed, FALSE otherwise.   *  */    BOOLEAN maybesave(op) 	 char *op;  {   if (!modified) (   return (TRUE);			/* no changes made */  :   ParamText(sfr.fName,op,"","");	/* set name, operation */&   switch (Alert(MAYBE_ALRT,NILPROC)) {     case YES_MAYBE: 7       savevals(sfr.fName,sfr.vRefNum);	/* YES: do it */      case NO_MAYBE:'       return(TRUE);			/* NO: proceed */    } +   return(FALSE);			/* Cancel or other... */  }      parser() {    EventRecord ev;    WindowPtr evw;     for (quit = FALSE; !quit;) {     SystemTask(); !     GetNextEvent(everyEvent,&ev);      if (ev.what == mouseDown) {        +       switch (FindWindow(&ev.where,&evw)) {  	  	case inMenuBar:% 	  menuparser(MenuSelect(&ev.where)); * 	  HiliteMenu(0);		/* done so un-hilite */	 	  break;  	    	case inSysWindow: 	  SystemClick(&ev,evw);	 	  break;          }      }    }      }      alterofferings(savok)  { *   int (*fcn)(),EnableItem(),DisableItem();   char savbuf[256];    +   fcn = (savok) ? EnableItem : DisableItem;  	     <   (*fcn)(menus[SETK_MENU],0);		/* enable/disable SET menu */D   (*fcn)(menus[FILE_MENU],SAVE_FILE);	/* enable/disable SAVE item */H   (*fcn)(menus[FILE_MENU],DECOM_FILE);	/* enable/disable DECOMPILE... */5   strcpy(savbuf,"Save ");		/* initial text of save */ !   if (savok)				/* ok to save? */ 7     strcat(savbuf,sfr.fName);		/* yes... put in name */      <   SetItem(menus[FILE_MENU],SAVE_FILE,savbuf); /* set item */4   HiliteMenu(0);			/* de-hilite, prevents oddness */6   DrawMenuBar();			/* disable/enable menu bar items */ }    menuparser(mitem)  LONGINT mitem; { 	   INTEGER      menu = HiWord(mitem),      item = LoWord(mitem);      switch (menu) {      case APPL_MENU:        switch (item) {  	case ABOU_APPL:
 	  aboutme(); 	 	  break; 	 	default: 	 	  break;        }        break;       case FILE_MENU:        switch (item) {  	case OPEN_FILE:2 	  if (maybesave("opening"))	/* if they want... */A 	    alterofferings(loadvals());	/* do it and alter menu items */ 	 	  break;            case DECOM_FILE: 	  decomdialog(sfr.fName);	 	  break;    	case SAVE_FILE:	     / 	  savevals(sfr.fName,sfr.vRefNum); /* do it */ 	 	  break;  	    	case QUIT_FILE:: 	  if (maybesave("quitting"))	/* if they really want to */& 	    quit = TRUE;		/* then let them */	 	  break;        }        break;       case SETK_MENU:        switch (item) {  	case SKEY_SETK:9 	  ScrDmpEnb = scrdmpdisabled;	/* disable special keys */  	  setkeydialog();: 	  ScrDmpEnb = scrdmpenabled;	/* enable special keys */	  	 	  break;  	case SMOD_SETK: 	  dosetmkdialog(); 	 	  break;  	case FCNK_SETK: 	  setfkeydialog(); 	 	  break;        }        break;    } }     I /* checks for system error, returns FALSE if noErr, else puts up an error .  * message with an understandable text string.  *  */    struct {
   int errnum;    char *errstr;    } ioerrs[] = {'     {resNotFound,"Resource not found"}, -     {resFNotFound,"Resource file not found"}, (     {addResFailed,"AddResource failed"},$     {dirFulErr,"Directory is full"},     {dskFulErr,"Disk is full"}, +     {wPrErr,"Diskette is write protected"}, )     {fLckdErr,"File is software locked"}, +     {vLckdErr,"Volume is software locked"},      {fBsyErr,"File is busy"}, ;     {opWrErr,"File is already open with write permission"},      {0,NILPTR}     };   syserr(err)  {    int e;     if (err == noErr)     return(FALSE);   '   for (e = 0; ioerrs[e].errnum != 0 &&  +       	      ioerrs[e].errnum != err; e++);   7   if (ioerrs[e].errstr == NILPTR)	/* anything there? */ &    printerr("Unknown IO error: ",err);   else     printerr(ioerrs[e].errstr,0);        return(TRUE);      SYM(SYSERR); }      main()   { 
 #ifdef SUMACC    QD = &QDVar; #endif     InitGraf(&THEPORT);    InitWindows();   InitFonts();   InitDialogs(NILPROC);    InitMenus();   TEInit();    InitCursor();      initmenus();2   alterofferings(FALSE);		/* disable menu items */(   modified = FALSE;			/* not modified */   parser();    ExitToShell();   SYM(MAIN); }   